/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.IExtendedInfo;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.ConfigurazionePortaHandler;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MessageSecurityFlow;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlow;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaDelegataServizio;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegataSoggettoErogatore;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletrace;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaCacheDigestQueryParameter;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBTracciamentoLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBTrasformazioniLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_dumpLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_genericPropertiesDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_handlerLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_serviziApplicativiLIB;
import org.openspcoop2.core.constants.CRUDType;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_porteDelegateLIB {
    public static long CRUDPortaDelegata(int type, PortaDelegata aPD, Connection con, IDriverBYOK driverBYOK) throws DriverConfigurazioneException {
        PortaDelegataServizio servizio;
        long idServizioPD;
        long idSoggettoErogatore;
        long idSoggettoProprietario;
        if (aPD == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Porta Delegata non valida.");
        }
        String nomePorta = aPD.getNome();
        String nomeProprietario = aPD.getNomeSoggettoProprietario();
        String tipoProprietario = aPD.getTipoSoggettoProprietario();
        if (nomePorta == null || nomePorta.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome della Porta Delegata non valido.");
        }
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome proprietario Porta Delegata non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Tipo proprietario della Porta Delegata non valido.");
        }
        PreparedStatement stm = null;
        ResultSet rs = null;
        String autenticazione = aPD.getAutenticazione();
        String autorizzazione = aPD.getAutorizzazione();
        String autorizzazioneXacmlPolicy = aPD.getXacmlPolicy();
        String autorizzazioneContenuto = aPD.getAutorizzazioneContenuto();
        String descrizione = aPD.getDescrizione();
        GestioneToken gestioneToken = aPD.getGestioneToken();
        PortaDelegataAzione azione = aPD.getAzione();
        long idAzione = azione != null && azione.getId() != null ? azione.getId() : -1L;
        try {
            idSoggettoProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
        }
        catch (Exception e1) {
            throw new DriverConfigurazioneException(e1);
        }
        long idPortaDelegata = -1L;
        PortaDelegataSoggettoErogatore soggErogatore = aPD.getSoggettoErogatore();
        long l = idSoggettoErogatore = soggErogatore != null && soggErogatore.getId() != null ? soggErogatore.getId() : -1L;
        if (soggErogatore != null && soggErogatore.getTipo() != null && soggErogatore.getNome() != null) {
            try {
                idSoggettoErogatore = DBUtils.getIdSoggetto(soggErogatore.getNome(), soggErogatore.getTipo(), con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
            }
            catch (Exception e1) {
                DriverConfigurazioneDBLib.logDebug(e1.getMessage(), e1);
            }
        }
        long l2 = idServizioPD = (servizio = aPD.getServizio()) != null && servizio.getId() != null ? servizio.getId() : -1L;
        if (idSoggettoErogatore > 0L && servizio != null && servizio.getTipo() != null && servizio.getNome() != null && servizio.getVersione() != null && servizio.getVersione() > 0) {
            try {
                idServizioPD = DBUtils.getIdServizio(servizio.getNome(), servizio.getTipo(), servizio.getVersione(), idSoggettoErogatore, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
            }
            catch (Exception e1) {
                DriverConfigurazioneDBLib.logDebug(e1.getMessage(), e1);
            }
        }
        MtomProcessor mtomProcessor = aPD.getMtomProcessor();
        MTOMProcessorType mtomModeRequest = null;
        MTOMProcessorType mtomModeResponse = null;
        if (mtomProcessor != null) {
            if (mtomProcessor.getRequestFlow() != null) {
                mtomModeRequest = mtomProcessor.getRequestFlow().getMode();
            }
            if (mtomProcessor.getResponseFlow() != null) {
                mtomModeResponse = mtomProcessor.getResponseFlow().getMode();
            }
        }
        MessageSecurity messageSecurity = aPD.getMessageSecurity();
        String messageSecurityStatus = aPD.getStatoMessageSecurity();
        StatoFunzionalita messageSecurityApplyMtomRequest = null;
        StatoFunzionalita messageSecurityApplyMtomResponse = null;
        String securityRequestMode = null;
        String securityResponseMode = null;
        if (messageSecurity != null) {
            if (messageSecurity.getRequestFlow() != null) {
                messageSecurityApplyMtomRequest = messageSecurity.getRequestFlow().getApplyToMtom();
                securityRequestMode = messageSecurity.getRequestFlow().getMode();
            }
            if (messageSecurity.getResponseFlow() != null) {
                messageSecurityApplyMtomResponse = messageSecurity.getResponseFlow().getApplyToMtom();
                securityResponseMode = messageSecurity.getResponseFlow().getMode();
            }
        }
        CorrelazioneApplicativa corrApp = aPD.getCorrelazioneApplicativa();
        CorrelazioneApplicativaRisposta corrAppRisposta = aPD.getCorrelazioneApplicativaRisposta();
        String msgDiagSeverita = null;
        String tracciamentoStato = null;
        String tracciamentoEsiti = null;
        String transazioniTempiElaborazione = null;
        String transazioniToken = null;
        TracciamentoConfigurazione tracciamentoDatabase = null;
        TracciamentoConfigurazione tracciamentoFiletrace = null;
        TracciamentoConfigurazioneFiletrace tracciamentoFiletraceDetails = null;
        if (aPD.getTracciamento() != null) {
            msgDiagSeverita = DriverConfigurazioneDBLib.getValue(aPD.getTracciamento().getSeverita());
            tracciamentoStato = DriverConfigurazioneDBLib.getValue(aPD.getTracciamento().getStato());
            tracciamentoEsiti = aPD.getTracciamento().getEsiti();
            if (aPD.getTracciamento().getTransazioni() != null) {
                transazioniTempiElaborazione = DriverConfigurazioneDBLib.getValue(aPD.getTracciamento().getTransazioni().getTempiElaborazione());
                transazioniToken = DriverConfigurazioneDBLib.getValue(aPD.getTracciamento().getTransazioni().getToken());
            }
            tracciamentoDatabase = aPD.getTracciamento().getDatabase();
            tracciamentoFiletrace = aPD.getTracciamento().getFiletrace();
            tracciamentoFiletraceDetails = aPD.getTracciamento().getFiletraceConfig();
        }
        CorsConfigurazione corsConfigurazione = aPD.getGestioneCors();
        String corsStato = null;
        String corsTipo = null;
        String corsAllAllowOrigins = null;
        String corsAllAllowMethods = null;
        String corsAllAllowHeaders = null;
        String corsAllowCredentials = null;
        int corsAllowMaxAge = 0;
        Integer corsAllowMaxAgeSeconds = null;
        String corsAllowOrigins = null;
        String corsAllowHeaders = null;
        String corsAllowMethods = null;
        String corsAllowExposeHeaders = null;
        if (corsConfigurazione != null) {
            int i;
            StringBuilder bf;
            corsStato = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getStato());
            corsTipo = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getTipo());
            corsAllAllowOrigins = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllAllowOrigins());
            corsAllAllowMethods = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllAllowMethods());
            corsAllAllowHeaders = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllAllowHeaders());
            corsAllowCredentials = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllowCredentials());
            if (corsConfigurazione.getAccessControlMaxAge() != null) {
                corsAllowMaxAge = 1;
                corsAllowMaxAgeSeconds = corsConfigurazione.getAccessControlMaxAge();
            }
            if (corsConfigurazione.getAccessControlAllowOrigins() != null && corsConfigurazione.getAccessControlAllowOrigins().sizeOriginList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlAllowOrigins().sizeOriginList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlAllowOrigins().getOrigin(i));
                }
                corsAllowOrigins = bf.toString();
            }
            if (corsConfigurazione.getAccessControlAllowHeaders() != null && corsConfigurazione.getAccessControlAllowHeaders().sizeHeaderList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlAllowHeaders().sizeHeaderList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlAllowHeaders().getHeader(i));
                }
                corsAllowHeaders = bf.toString();
            }
            if (corsConfigurazione.getAccessControlAllowMethods() != null && corsConfigurazione.getAccessControlAllowMethods().sizeMethodList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlAllowMethods().sizeMethodList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlAllowMethods().getMethod(i));
                }
                corsAllowMethods = bf.toString();
            }
            if (corsConfigurazione.getAccessControlExposeHeaders() != null && corsConfigurazione.getAccessControlExposeHeaders().sizeHeaderList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlExposeHeaders().sizeHeaderList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlExposeHeaders().getHeader(i));
                }
                corsAllowExposeHeaders = bf.toString();
            }
        }
        ResponseCachingConfigurazione responseCachingConfigurazone = aPD.getResponseCaching();
        String responseCacheStato = null;
        Integer responseCacheSeconds = null;
        Long responseCacheMaxMsgSize = null;
        String responseCacheHashUrl = null;
        String responseCacheHashQuery = null;
        String responseCacheHashQueryList = null;
        String responseCacheHashHeaders = null;
        String responseCacheHashHeadersList = null;
        String responseCacheHashPayload = null;
        boolean responseCacheNoCache = true;
        boolean responseCacheMaxAge = true;
        boolean responseCacheNoStore = true;
        List<ResponseCachingConfigurazioneRegola> responseCacheRegole = null;
        if (responseCachingConfigurazone != null) {
            responseCacheStato = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getStato());
            responseCacheSeconds = responseCachingConfigurazone.getCacheTimeoutSeconds();
            responseCacheMaxMsgSize = responseCachingConfigurazone.getMaxMessageSize();
            if (responseCachingConfigurazone.getControl() != null) {
                responseCacheNoCache = responseCachingConfigurazone.getControl().getNoCache();
                responseCacheMaxAge = responseCachingConfigurazone.getControl().getMaxAge();
                responseCacheNoStore = responseCachingConfigurazone.getControl().getNoStore();
            }
            if (responseCachingConfigurazone.getHashGenerator() != null) {
                int i;
                StringBuilder bf;
                responseCacheHashUrl = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getRequestUri());
                responseCacheHashQuery = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getQueryParameters());
                if (StatoFunzionalitaCacheDigestQueryParameter.SELEZIONE_PUNTUALE.equals(responseCachingConfigurazone.getHashGenerator().getQueryParameters()) && responseCachingConfigurazone.getHashGenerator().getQueryParameterList() != null && responseCachingConfigurazone.getHashGenerator().sizeQueryParameterList() > 0) {
                    bf = new StringBuilder();
                    for (i = 0; i < responseCachingConfigurazone.getHashGenerator().sizeQueryParameterList(); ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(responseCachingConfigurazone.getHashGenerator().getQueryParameter(i));
                    }
                    responseCacheHashQueryList = bf.toString();
                }
                responseCacheHashHeaders = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getHeaders());
                if (StatoFunzionalita.ABILITATO.equals(responseCachingConfigurazone.getHashGenerator().getHeaders()) && responseCachingConfigurazone.getHashGenerator().getHeaderList() != null && responseCachingConfigurazone.getHashGenerator().sizeHeaderList() > 0) {
                    bf = new StringBuilder();
                    for (i = 0; i < responseCachingConfigurazone.getHashGenerator().sizeHeaderList(); ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(responseCachingConfigurazone.getHashGenerator().getHeader(i));
                    }
                    responseCacheHashHeadersList = bf.toString();
                }
                responseCacheHashPayload = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getPayload());
            }
            responseCacheRegole = responseCachingConfigurazone.getRegolaList();
        }
        ConfigurazionePortaHandler configHandlers = aPD.getConfigurazioneHandler();
        ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
        IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoPortaDelegata();
        try {
            int n = 0;
            int i = 0;
            switch (type) {
                case 1: {
                    Ruolo ruolo;
                    String plainValueP;
                    Proprieta propProtocollo;
                    String nomeProprietarioSA;
                    String nomeSA;
                    BaseBeanWithId cae;
                    BaseBeanWithId flow;
                    BaseBeanWithId resParam;
                    BaseBeanWithId flow2;
                    BaseBeanWithId reqParam;
                    PortaDelegataAzioneIdentificazione modeAzione;
                    Integer versioneServizio;
                    String nomeSoggErogatore;
                    String tipoSoggErogatore = soggErogatore != null ? soggErogatore.getTipo() : null;
                    String string = nomeSoggErogatore = soggErogatore != null ? soggErogatore.getNome() : null;
                    if (tipoSoggErogatore == null || tipoSoggErogatore.equals("")) {
                        throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                    }
                    if (nomeSoggErogatore == null || nomeSoggErogatore.equals("")) {
                        throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                    }
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String nomeServizio = servizio != null ? servizio.getNome() : null;
                    Integer n2 = versioneServizio = servizio != null ? servizio.getVersione() : null;
                    if (tipoServizio == null || tipoServizio.equals("")) {
                        throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                    }
                    if (nomeServizio == null || nomeServizio.equals("")) {
                        throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                    }
                    if (versioneServizio == null) {
                        throw new DriverConfigurazioneException("Versione Servizio non impostato.");
                    }
                    String nomeAzione = azione != null ? azione.getNome() : null;
                    String patternAzione = azione != null ? azione.getPattern() : null;
                    String nomePortaDeleganteAzione = azione != null ? azione.getNomePortaDelegante() : null;
                    StatoFunzionalita forceInterfaceBased = azione != null ? azione.getForceInterfaceBased() : null;
                    PortaDelegataAzioneIdentificazione portaDelegataAzioneIdentificazione = modeAzione = azione != null ? azione.getIdentificazione() : null;
                    if (azione != null) {
                        if (modeAzione == null || modeAzione.equals("")) {
                            modeAzione = PortaDelegataAzioneIdentificazione.STATIC;
                        }
                        switch (modeAzione) {
                            case CONTENT_BASED: 
                            case URL_BASED: 
                            case HEADER_BASED: {
                                if (patternAzione == null || patternAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case DELEGATED_BY: {
                                if (nomePortaDeleganteAzione == null || nomePortaDeleganteAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Porta Delegante Azione non impostata.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case INPUT_BASED: 
                            case SOAP_ACTION_BASED: 
                            case INTERFACE_BASED: {
                                break;
                            }
                            case STATIC: {
                                if (idAzione <= 0L && (nomeAzione == null || nomeAzione.equals(""))) {
                                    throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                }
                                patternAzione = null;
                                break;
                            }
                        }
                    }
                    String utenteRichiedente = null;
                    utenteRichiedente = aPD.getProprietaOggetto() != null && aPD.getProprietaOggetto().getUtenteRichiedente() != null ? aPD.getProprietaOggetto().getUtenteRichiedente() : DBUtils.getSuperUserServizioSafe(DriverConfigurazioneDBLib.log, "CRUDPortaApplicativa", idServizioPD, con, DriverConfigurazioneDBLib.tipoDB);
                    Timestamp dataCreazione = null;
                    dataCreazione = aPD.getProprietaOggetto() != null && aPD.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(aPD.getProprietaOggetto().getDataCreazione().getTime()) : (aPD.getOraRegistrazione() != null ? new Timestamp(aPD.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("porte_delegate");
                    sqlQueryObject.addInsertField("nome_porta", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("id_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("tipo_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("nome_soggetto_erogatore", "?");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("tipo_servizio", "?");
                    sqlQueryObject.addInsertField("nome_servizio", "?");
                    sqlQueryObject.addInsertField("versione_servizio", "?");
                    sqlQueryObject.addInsertField("id_azione", "?");
                    sqlQueryObject.addInsertField("nome_azione", "?");
                    sqlQueryObject.addInsertField("mode_azione", "?");
                    sqlQueryObject.addInsertField("pattern_azione", "?");
                    sqlQueryObject.addInsertField("nome_porta_delegante_azione", "?");
                    sqlQueryObject.addInsertField("force_interface_based_azione", "?");
                    sqlQueryObject.addInsertField("autenticazione", "?");
                    sqlQueryObject.addInsertField("autenticazione_opzionale", "?");
                    sqlQueryObject.addInsertField("token_policy", "?");
                    sqlQueryObject.addInsertField("token_opzionale", "?");
                    sqlQueryObject.addInsertField("token_validazione", "?");
                    sqlQueryObject.addInsertField("token_introspection", "?");
                    sqlQueryObject.addInsertField("token_user_info", "?");
                    sqlQueryObject.addInsertField("token_forward", "?");
                    sqlQueryObject.addInsertField("token_options", "?");
                    sqlQueryObject.addInsertField("token_authn_issuer", "?");
                    sqlQueryObject.addInsertField("token_authn_client_id", "?");
                    sqlQueryObject.addInsertField("token_authn_subject", "?");
                    sqlQueryObject.addInsertField("token_authn_username", "?");
                    sqlQueryObject.addInsertField("token_authn_email", "?");
                    sqlQueryObject.addInsertField("autorizzazione", "?");
                    sqlQueryObject.addInsertField("autorizzazione_xacml", "?");
                    sqlQueryObject.addInsertField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addInsertField("mtom_request_mode", "?");
                    sqlQueryObject.addInsertField("mtom_response_mode", "?");
                    sqlQueryObject.addInsertField("security", "?");
                    sqlQueryObject.addInsertField("security_mtom_req", "?");
                    sqlQueryObject.addInsertField("security_mtom_res", "?");
                    sqlQueryObject.addInsertField("security_request_mode", "?");
                    sqlQueryObject.addInsertField("security_response_mode", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addInsertField("integrazione", "?");
                    sqlQueryObject.addInsertField("scadenza_correlazione_appl", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addInsertField("allega_body", "?");
                    sqlQueryObject.addInsertField("scarta_body", "?");
                    sqlQueryObject.addInsertField("gestione_manifest", "?");
                    sqlQueryObject.addInsertField("stateless", "?");
                    sqlQueryObject.addInsertField("local_forward", "?");
                    sqlQueryObject.addInsertField("local_forward_pa", "?");
                    sqlQueryObject.addInsertField("ruoli_match", "?");
                    sqlQueryObject.addInsertField("token_sa_stato", "?");
                    sqlQueryObject.addInsertField("token_ruoli_stato", "?");
                    sqlQueryObject.addInsertField("token_ruoli_match", "?");
                    sqlQueryObject.addInsertField("token_ruoli_tipologia", "?");
                    sqlQueryObject.addInsertField("scope_stato", "?");
                    sqlQueryObject.addInsertField("scope_match", "?");
                    sqlQueryObject.addInsertField("ricerca_porta_azione_delegata", "?");
                    sqlQueryObject.addInsertField("msg_diag_severita", "?");
                    sqlQueryObject.addInsertField("tracciamento_stato", "?");
                    sqlQueryObject.addInsertField("tracciamento_esiti", "?");
                    sqlQueryObject.addInsertField("transazioni_tempi", "?");
                    sqlQueryObject.addInsertField("transazioni_token", "?");
                    sqlQueryObject.addInsertField("stato", "?");
                    sqlQueryObject.addInsertField("cors_stato", "?");
                    sqlQueryObject.addInsertField("cors_tipo", "?");
                    sqlQueryObject.addInsertField("cors_all_allow_origins", "?");
                    sqlQueryObject.addInsertField("cors_all_allow_methods", "?");
                    sqlQueryObject.addInsertField("cors_all_allow_headers", "?");
                    sqlQueryObject.addInsertField("cors_allow_credentials", "?");
                    sqlQueryObject.addInsertField("cors_allow_max_age", "?");
                    sqlQueryObject.addInsertField("cors_allow_max_age_seconds", "?");
                    sqlQueryObject.addInsertField("cors_allow_origins", "?");
                    sqlQueryObject.addInsertField("cors_allow_headers", "?");
                    sqlQueryObject.addInsertField("cors_allow_methods", "?");
                    sqlQueryObject.addInsertField("cors_allow_expose_headers", "?");
                    sqlQueryObject.addInsertField("response_cache_stato", "?");
                    sqlQueryObject.addInsertField("response_cache_seconds", "?");
                    sqlQueryObject.addInsertField("response_cache_max_msg_size", "?");
                    sqlQueryObject.addInsertField("response_cache_control_nocache", "?");
                    sqlQueryObject.addInsertField("response_cache_control_maxage", "?");
                    sqlQueryObject.addInsertField("response_cache_control_nostore", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_url", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_query", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_query_list", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_headers", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_hdr_list", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_payload", "?");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_port_type", "?");
                    sqlQueryObject.addInsertField("options", "?");
                    sqlQueryObject.addInsertField("canale", "?");
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, descrizione);
                    stm.setLong(index++, idSoggettoErogatore);
                    stm.setString(index++, tipoSoggErogatore);
                    stm.setString(index++, nomeSoggErogatore);
                    stm.setLong(index++, idServizioPD);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setInt(index++, versioneServizio);
                    stm.setLong(index++, idAzione);
                    stm.setString(index++, nomeAzione);
                    if (modeAzione != null) {
                        stm.setString(index++, modeAzione.toString());
                    } else {
                        stm.setString(index++, null);
                    }
                    stm.setString(index++, patternAzione);
                    stm.setString(index++, nomePortaDeleganteAzione);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(forceInterfaceBased));
                    stm.setString(index++, autenticazione);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutenticazioneOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getPolicy() : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getTokenOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getValidazione()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getIntrospection()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getUserInfo()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getForward()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getOptions() : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getIssuer()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getClientId()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getSubject()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getUsername()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getEmail()) : null);
                    stm.setString(index++, autorizzazione);
                    stm.setString(index++, autorizzazioneXacmlPolicy);
                    stm.setString(index++, autorizzazioneContenuto);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeResponse));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomResponse));
                    stm.setString(index++, securityRequestMode);
                    stm.setString(index++, securityResponseMode);
                    stm.setLong(index++, idSoggettoProprietario);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(aPD.getRicevutaAsincronaSimmetrica()));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(aPD.getRicevutaAsincronaAsimmetrica()));
                    stm.setString(index++, aPD.getIntegrazione());
                    stm.setString(index++, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getAllegaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getScartaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getGestioneManifest()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getStateless()) : null);
                    stm.setString(index++, aPD != null && aPD.getLocalForward() != null ? DriverConfigurazioneDBLib.getValue(aPD.getLocalForward().getStato()) : null);
                    stm.setString(index++, aPD != null && aPD.getLocalForward() != null ? aPD.getLocalForward().getPortaApplicativa() : null);
                    stm.setString(index++, aPD != null && aPD.getRuoli() != null && aPD.getRuoli().getMatch() != null ? aPD.getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getAutorizzazioneApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutorizzazioneToken().getAutorizzazioneApplicativi()) : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getAutorizzazioneRuoli() != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutorizzazioneToken().getAutorizzazioneRuoli()) : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getRuoli() != null && aPD.getAutorizzazioneToken().getRuoli().getMatch() != null ? aPD.getAutorizzazioneToken().getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getTipologiaRuoli() != null ? aPD.getAutorizzazioneToken().getTipologiaRuoli().getValue() : null);
                    stm.setString(index++, aPD != null && aPD.getScope() != null && aPD.getScope().getStato() != null ? DriverConfigurazioneDBLib.getValue(aPD.getScope().getStato()) : null);
                    stm.setString(index++, aPD != null && aPD.getScope() != null && aPD.getScope().getMatch() != null ? aPD.getScope().getMatch().getValue() : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getRicercaPortaAzioneDelegata()) : null);
                    stm.setString(index++, msgDiagSeverita);
                    stm.setString(index++, tracciamentoStato);
                    stm.setString(index++, tracciamentoEsiti);
                    stm.setString(index++, transazioniTempiElaborazione);
                    stm.setString(index++, transazioniToken);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getStato()) : null);
                    stm.setString(index++, corsStato);
                    stm.setString(index++, corsTipo);
                    stm.setString(index++, corsAllAllowOrigins);
                    stm.setString(index++, corsAllAllowMethods);
                    stm.setString(index++, corsAllAllowHeaders);
                    stm.setString(index++, corsAllowCredentials);
                    stm.setInt(index++, corsAllowMaxAge);
                    if (corsAllowMaxAgeSeconds != null) {
                        stm.setInt(index++, corsAllowMaxAgeSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, corsAllowOrigins);
                    stm.setString(index++, corsAllowHeaders);
                    stm.setString(index++, corsAllowMethods);
                    stm.setString(index++, corsAllowExposeHeaders);
                    stm.setString(index++, responseCacheStato);
                    if (responseCacheSeconds != null) {
                        stm.setInt(index++, responseCacheSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (responseCacheMaxMsgSize != null) {
                        stm.setLong(index++, responseCacheMaxMsgSize);
                    } else {
                        stm.setNull(index++, -5);
                    }
                    stm.setInt(index++, responseCacheNoCache ? 1 : 0);
                    stm.setInt(index++, responseCacheMaxAge ? 1 : 0);
                    stm.setInt(index++, responseCacheNoStore ? 1 : 0);
                    stm.setString(index++, responseCacheHashUrl);
                    stm.setString(index++, responseCacheHashQuery);
                    stm.setString(index++, responseCacheHashQueryList);
                    stm.setString(index++, responseCacheHashHeaders);
                    stm.setString(index++, responseCacheHashHeadersList);
                    stm.setString(index++, responseCacheHashPayload);
                    stm.setLong(index++, aPD.getIdAccordo() != null ? aPD.getIdAccordo() : -1L);
                    stm.setLong(index++, aPD.getIdPortType() != null ? aPD.getIdPortType() : -1L);
                    stm.setString(index++, aPD.getOptions());
                    stm.setString(index++, aPD.getCanale());
                    if (utenteRichiedente != null) {
                        stm.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        stm.setTimestamp(index++, dataCreazione);
                    }
                    DriverConfigurazioneDBLib.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, nomePorta, descrizione, idSoggettoErogatore, tipoSoggErogatore, nomeSoggErogatore, idServizioPD, tipoServizio, nomeServizio, idAzione, nomeAzione, modeAzione, patternAzione, nomePortaDeleganteAzione, DriverConfigurazioneDBLib.getValue(forceInterfaceBased), autenticazione, aPD.getAutenticazioneOpzionale(), gestioneToken != null ? gestioneToken.getPolicy() : null, gestioneToken != null ? gestioneToken.getTokenOpzionale() : null, gestioneToken != null ? gestioneToken.getValidazione() : null, gestioneToken != null ? gestioneToken.getIntrospection() : null, gestioneToken != null ? gestioneToken.getUserInfo() : null, gestioneToken != null ? gestioneToken.getForward() : null, gestioneToken != null ? gestioneToken.getOptions() : null, gestioneToken != null && gestioneToken.getAutenticazione() != null ? gestioneToken.getAutenticazione().getIssuer() : null, gestioneToken != null && gestioneToken.getAutenticazione() != null ? gestioneToken.getAutenticazione().getClientId() : null, gestioneToken != null && gestioneToken.getAutenticazione() != null ? gestioneToken.getAutenticazione().getSubject() : null, gestioneToken != null && gestioneToken.getAutenticazione() != null ? gestioneToken.getAutenticazione().getUsername() : null, gestioneToken != null && gestioneToken.getAutenticazione() != null ? gestioneToken.getAutenticazione().getEmail() : null, autorizzazione, autorizzazioneXacmlPolicy, autorizzazioneContenuto, mtomModeRequest, mtomModeResponse, messageSecurityStatus, messageSecurityApplyMtomRequest, messageSecurityApplyMtomResponse, securityRequestMode, securityResponseMode, idSoggettoProprietario, aPD.getRicevutaAsincronaSimmetrica(), aPD.getRicevutaAsincronaAsimmetrica(), aPD.getIntegrazione(), aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getStato() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getTipo() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getAcceptMtomMessage() : null, aPD.getAllegaBody(), aPD.getScartaBody(), aPD.getGestioneManifest(), aPD.getStateless(), aPD.getLocalForward(), aPD != null && aPD.getRuoli() != null && aPD.getRuoli().getMatch() != null ? aPD.getRuoli().getMatch().getValue() : null, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getAutorizzazioneApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutorizzazioneToken().getAutorizzazioneApplicativi()) : null, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getAutorizzazioneRuoli() != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutorizzazioneToken().getAutorizzazioneRuoli()) : null, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getRuoli() != null && aPD.getAutorizzazioneToken().getRuoli().getMatch() != null ? aPD.getAutorizzazioneToken().getRuoli().getMatch().getValue() : null, aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getTipologiaRuoli() != null ? aPD.getAutorizzazioneToken().getTipologiaRuoli().getValue() : null, aPD != null && aPD.getScope() != null && aPD.getScope().getStato() != null ? aPD.getScope().getStato() : null, aPD != null && aPD.getScope() != null && aPD.getScope().getMatch() != null ? aPD.getScope().getMatch().getValue() : null, aPD.getRicercaPortaAzioneDelegata(), msgDiagSeverita, tracciamentoStato, tracciamentoEsiti, transazioniTempiElaborazione, transazioniToken, aPD.getStato(), corsStato, corsTipo, corsAllAllowOrigins, corsAllAllowMethods, corsAllAllowHeaders, corsAllowCredentials, corsAllowMaxAge, corsAllowMaxAgeSeconds, corsAllowOrigins, corsAllowHeaders, corsAllowMethods, corsAllowExposeHeaders, responseCacheStato, responseCacheSeconds, responseCacheMaxMsgSize, responseCacheNoCache ? 1 : 0, responseCacheMaxAge ? 1 : 0, responseCacheNoStore ? 1 : 0, responseCacheHashUrl, responseCacheHashQuery, responseCacheHashQueryList, responseCacheHashHeaders, responseCacheHashHeadersList, responseCacheHashPayload, aPD.getIdAccordo(), aPD.getIdPortType(), aPD.getOptions(), aPD.getCanale()));
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inserted " + n + " row(s).");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable("porte_delegate");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("nome_porta = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idSoggettoProprietario);
                    stm.setString(2, nomePorta);
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        rs.close();
                        stm.close();
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(CREATE)] Impossibile recuperare l'ID della PortaDelegata appena create.");
                    }
                    idPortaDelegata = rs.getLong("id");
                    aPD.setId(idPortaDelegata);
                    rs.close();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow2 = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                reqParam = flow2.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom request flow con id=" + idPortaDelegata);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            flow = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom response flow con id=" + idPortaDelegata);
                    }
                    if (messageSecurity != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_security_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow2 = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                BYOKWrappedValue byokValue;
                                reqParam = flow2.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaDelegata);
                                stm.setString(indexSec++, reqParam.getNome());
                                String plainValue = reqParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityRequestMode, reqParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue.getWrappedValue();
                                    plainValue = byokValue.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " request flow con id=" + idPortaDelegata);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_security_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            flow = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                BYOKWrappedValue byokValue;
                                resParam = flow.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaDelegata);
                                stm.setString(indexSec++, resParam.getNome());
                                String plainValue = resParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityResponseMode, resParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue.getWrappedValue();
                                    plainValue = byokValue.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " response flow con id=" + idPortaDelegata);
                    }
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQueryObject.addInsertField("riuso_id", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(cae.getIdentificazioneFallita()));
                            stm.setString(6, DriverConfigurazioneDBLib.getValue(cae.getRiusoIdentificativo()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa con id=" + idPortaDelegata);
                    }
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaDelegata);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("porte_delegate_sa");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPD.sizeServizioApplicativoList(); ++i) {
                        PortaDelegataServizioApplicativo servizioApplicativo = aPD.getServizioApplicativo(i);
                        nomeSA = servizioApplicativo.getNome();
                        nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                        String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        stm.setLong(1, idPortaDelegata);
                        stm.setLong(2, idSA);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " associazioni ServizioApplicativo<->PortaDelegata associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pd_auth_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPD.sizeProprietaAutenticazioneList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPD.getProprietaAutenticazione(i);
                        int indexP = 1;
                        stm.setLong(indexP++, aPD.getId());
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropAutenticazione associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pd_authz_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPD.sizeProprietaAutorizzazioneList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPD.getProprietaAutorizzazione(i);
                        int indexP = 1;
                        stm.setLong(indexP++, aPD.getId());
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropAutorizzazione associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pd_authzc_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPD.sizeProprietaAutorizzazioneContenutoList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPD.getProprietaAutorizzazioneContenuto(i);
                        int indexP = 1;
                        stm.setLong(indexP++, aPD.getId());
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropAutorizzazioneContenuto associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pd_ct_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPD.sizeProprietaRateLimitingList(); ++i) {
                        propProtocollo = aPD.getProprietaRateLimiting(i);
                        stm.setLong(1, aPD.getId());
                        stm.setString(2, propProtocollo.getNome());
                        stm.setString(3, propProtocollo.getValore());
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropRateLimiting associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pd_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPD.sizeProprietaList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPD.getProprieta(i);
                        int indexP = 1;
                        stm.setLong(indexP++, aPD.getId());
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolProp associati alla PortaDelegata[" + idPortaDelegata + "]");
                    n = 0;
                    if (aPD.getRuoli() != null && aPD.getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPD.getRuoli().sizeRuoloList(); ++j) {
                            ruolo = aPD.getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPD.getId());
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli alla PortaDelegata[" + idPortaDelegata + "]");
                    n = 0;
                    if (aPD.getScope() != null && aPD.getScope().sizeScopeList() > 0) {
                        for (int j = 0; j < aPD.getScope().sizeScopeList(); ++j) {
                            Scope scope = aPD.getScope().getScope(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_scope");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("scope", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPD.getId());
                            stm.setString(2, scope.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto scope[" + scope.getNome() + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " scope alla PortaDelegata[" + idPortaDelegata + "]");
                    if (aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getServiziApplicativi() != null && aPD.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_token_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPD.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList(); ++i) {
                            PortaDelegataServizioApplicativo servizioApplicativo = aPD.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(i);
                            nomeSA = servizioApplicativo.getNome();
                            nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                            if (nomeSA == null || nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            stm.setLong(1, idPortaDelegata);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " associazioni ServizioApplicativo<->PortaDelegata (token) associati alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    n = 0;
                    if (aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getRuoli() != null && aPD.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPD.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++j) {
                            ruolo = aPD.getAutorizzazioneToken().getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_token_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPD.getId());
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] (token) alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli (token) alla PortaDelegata[" + idPortaDelegata + "]");
                    n = 0;
                    if (aPD.getAzione() != null && aPD.getAzione().sizeAzioneDelegataList() > 0) {
                        for (int j = 0; j < aPD.getAzione().sizeAzioneDelegataList(); ++j) {
                            String azioneDelegata = aPD.getAzione().getAzioneDelegata(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_azioni");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("azione", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPD.getId());
                            stm.setString(2, azioneDelegata);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto azione delegata [" + azioneDelegata + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " azioni delegate alla PortaDelegata[" + idPortaDelegata + "]");
                    n = 0;
                    if (responseCacheRegole != null && responseCacheRegole.size() > 0) {
                        for (int j = 0; j < responseCacheRegole.size(); ++j) {
                            ResponseCachingConfigurazioneRegola regola = responseCacheRegole.get(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_cache_regole");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                sqlQueryObject.addInsertField("status_min", "?");
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                sqlQueryObject.addInsertField("status_max", "?");
                            }
                            sqlQueryObject.addInsertField("fault", "?");
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                sqlQueryObject.addInsertField("cache_seconds", "?");
                            }
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            int indexCR = 1;
                            stm.setLong(indexCR++, aPD.getId());
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMin());
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMax());
                            }
                            stm.setInt(indexCR++, regola.getFault() ? 1 : 0);
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                stm.setInt(indexCR++, regola.getCacheTimeoutSeconds());
                            }
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta regola di cache alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " regole di cache alla PortaDelegata[" + idPortaDelegata + "]");
                    n = 0;
                    if (aPD.sizeAttributeAuthorityList() > 0) {
                        for (int j = 0; j < aPD.sizeAttributeAuthorityList(); ++j) {
                            AttributeAuthority aa = aPD.getAttributeAuthority(j);
                            String attributi = null;
                            if (aa.sizeAttributoList() > 0) {
                                StringBuilder bf = new StringBuilder();
                                for (int aaI = 0; aaI < aa.sizeAttributoList(); ++aaI) {
                                    if (aaI > 0) {
                                        bf.append(",");
                                    }
                                    bf.append(aa.getAttributo(aaI));
                                }
                                attributi = bf.toString();
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_aa");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("attributi", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPD.getId());
                            stm.setString(2, aa.getNome());
                            stm.setString(3, attributi);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto A.A.[" + aa.getNome() + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " A.A. alla PortaDelegata[" + idPortaDelegata + "]");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoDatabase, aPD.getId(), "pd", "db");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoFiletrace, aPD.getId(), "pd", "filetrace");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(type, con, tracciamentoFiletraceDetails, aPD.getId(), "pd");
                    DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(type, con, aPD.getDump(), aPD.getId(), "pd");
                    DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(type, con, aPD.getTrasformazioni(), aPD.getId(), true);
                    if (configHandlers != null) {
                        if (configHandlers.getRequest() != null) {
                            DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, aPD.getId(), null, true, configHandlers.getRequest());
                        }
                        if (configHandlers.getResponse() != null) {
                            DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, aPD.getId(), null, false, configHandlers.getResponse());
                        }
                    }
                    i = 0;
                    if (aPD.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPD.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, DriverConfigurazioneDBLib.log, aPD, aPD.getExtendedInfo(i), CRUDType.CREATE);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " associazioni ExtendedInfo<->PortaDelegata associati alla PortaDelegata[" + idPortaDelegata + "]");
                    break;
                }
                case 2: {
                    Proprieta propProtocollo;
                    BaseBeanWithId cae;
                    BYOKWrappedValue byokValue;
                    BaseBeanWithId resParam;
                    BaseBeanWithId flow;
                    BaseBeanWithId reqParam;
                    StatoFunzionalita forceInterfaceBased;
                    Integer versioneServizio;
                    String nomeSoggErogatore;
                    String tipoSoggErogatore = soggErogatore != null ? soggErogatore.getTipo() : null;
                    String string = nomeSoggErogatore = soggErogatore != null ? soggErogatore.getNome() : null;
                    if (tipoSoggErogatore == null || tipoSoggErogatore.equals("")) {
                        throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                    }
                    if (nomeSoggErogatore == null || nomeSoggErogatore.equals("")) {
                        throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                    }
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String nomeServizio = servizio != null ? servizio.getNome() : null;
                    Integer n3 = versioneServizio = servizio != null ? servizio.getVersione() : null;
                    if (tipoServizio == null || tipoServizio.equals("")) {
                        throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                    }
                    if (nomeServizio == null || nomeServizio.equals("")) {
                        throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                    }
                    if (versioneServizio == null) {
                        throw new DriverConfigurazioneException("Versione Servizio non impostato.");
                    }
                    String nomeAzione = azione != null ? azione.getNome() : null;
                    String patternAzione = azione != null ? azione.getPattern() : null;
                    PortaDelegataAzioneIdentificazione modeAzione = azione != null ? azione.getIdentificazione() : null;
                    String nomePortaDeleganteAzione = azione != null ? azione.getNomePortaDelegante() : null;
                    StatoFunzionalita statoFunzionalita = forceInterfaceBased = azione != null ? azione.getForceInterfaceBased() : null;
                    if (azione != null) {
                        if (modeAzione == null || modeAzione.equals("")) {
                            modeAzione = PortaDelegataAzioneIdentificazione.STATIC;
                        }
                        switch (modeAzione) {
                            case CONTENT_BASED: 
                            case URL_BASED: 
                            case HEADER_BASED: {
                                if (patternAzione == null || patternAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case DELEGATED_BY: {
                                if (nomePortaDeleganteAzione == null || nomePortaDeleganteAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Porta Delegante Azione non impostata.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case INPUT_BASED: 
                            case SOAP_ACTION_BASED: 
                            case INTERFACE_BASED: {
                                break;
                            }
                            case STATIC: {
                                if (idAzione <= 0L && (nomeAzione == null || nomeAzione.equals(""))) {
                                    throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                }
                                patternAzione = null;
                                break;
                            }
                        }
                    }
                    String oldNomePD = null;
                    if (aPD.getOldIDPortaDelegataForUpdate() != null) {
                        oldNomePD = aPD.getOldIDPortaDelegataForUpdate().getNome();
                    }
                    DriverConfigurazioneDBLib.logDebug("OLD-PD[" + oldNomePD + "] PD[" + nomePorta + "]");
                    if (oldNomePD == null || oldNomePD.equals("")) {
                        DriverConfigurazioneDBLib.logDebug("old nomePD is null, assegno: " + nomePorta);
                        oldNomePD = nomePorta;
                    }
                    if ((idPortaDelegata = DBUtils.getIdPortaDelegata(oldNomePD, con, DriverConfigurazioneDBLib.tipoDB)) <= 0L) {
                        idPortaDelegata = DBUtils.getIdPortaDelegata(oldNomePD, con, DriverConfigurazioneDBLib.tipoDB);
                    }
                    if (idPortaDelegata <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(UPDATE)] id porta delegata non trovato nome[" + oldNomePD + "]");
                    }
                    aPD.setId(idPortaDelegata);
                    String utenteUltimaModifica = null;
                    if (aPD.getProprietaOggetto() != null && aPD.getProprietaOggetto().getUtenteUltimaModifica() != null) {
                        utenteUltimaModifica = aPD.getProprietaOggetto().getUtenteUltimaModifica();
                    }
                    Timestamp dataUltimaModifica = null;
                    dataUltimaModifica = aPD.getProprietaOggetto() != null && aPD.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(aPD.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("porte_delegate");
                    sqlQueryObject.addUpdateField("nome_porta", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("id_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("tipo_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("nome_soggetto_erogatore", "?");
                    sqlQueryObject.addUpdateField("id_servizio", "?");
                    sqlQueryObject.addUpdateField("tipo_servizio", "?");
                    sqlQueryObject.addUpdateField("nome_servizio", "?");
                    sqlQueryObject.addUpdateField("versione_servizio", "?");
                    sqlQueryObject.addUpdateField("id_azione", "?");
                    sqlQueryObject.addUpdateField("nome_azione", "?");
                    sqlQueryObject.addUpdateField("mode_azione", "?");
                    sqlQueryObject.addUpdateField("pattern_azione", "?");
                    sqlQueryObject.addUpdateField("nome_porta_delegante_azione", "?");
                    sqlQueryObject.addUpdateField("force_interface_based_azione", "?");
                    sqlQueryObject.addUpdateField("autenticazione", "?");
                    sqlQueryObject.addUpdateField("autenticazione_opzionale", "?");
                    sqlQueryObject.addUpdateField("token_policy", "?");
                    sqlQueryObject.addUpdateField("token_opzionale", "?");
                    sqlQueryObject.addUpdateField("token_validazione", "?");
                    sqlQueryObject.addUpdateField("token_introspection", "?");
                    sqlQueryObject.addUpdateField("token_user_info", "?");
                    sqlQueryObject.addUpdateField("token_forward", "?");
                    sqlQueryObject.addUpdateField("token_options", "?");
                    sqlQueryObject.addUpdateField("token_authn_issuer", "?");
                    sqlQueryObject.addUpdateField("token_authn_client_id", "?");
                    sqlQueryObject.addUpdateField("token_authn_subject", "?");
                    sqlQueryObject.addUpdateField("token_authn_username", "?");
                    sqlQueryObject.addUpdateField("token_authn_email", "?");
                    sqlQueryObject.addUpdateField("autorizzazione", "?");
                    sqlQueryObject.addUpdateField("autorizzazione_xacml", "?");
                    sqlQueryObject.addUpdateField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addUpdateField("mtom_request_mode", "?");
                    sqlQueryObject.addUpdateField("mtom_response_mode", "?");
                    sqlQueryObject.addUpdateField("security", "?");
                    sqlQueryObject.addUpdateField("security_mtom_req", "?");
                    sqlQueryObject.addUpdateField("security_mtom_res", "?");
                    sqlQueryObject.addUpdateField("security_request_mode", "?");
                    sqlQueryObject.addUpdateField("security_response_mode", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addUpdateField("integrazione", "?");
                    sqlQueryObject.addUpdateField("scadenza_correlazione_appl", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addUpdateField("allega_body", "?");
                    sqlQueryObject.addUpdateField("scarta_body", "?");
                    sqlQueryObject.addUpdateField("gestione_manifest", "?");
                    sqlQueryObject.addUpdateField("stateless", "?");
                    sqlQueryObject.addUpdateField("local_forward", "?");
                    sqlQueryObject.addUpdateField("local_forward_pa", "?");
                    sqlQueryObject.addUpdateField("ruoli_match", "?");
                    sqlQueryObject.addUpdateField("token_sa_stato", "?");
                    sqlQueryObject.addUpdateField("token_ruoli_stato", "?");
                    sqlQueryObject.addUpdateField("token_ruoli_match", "?");
                    sqlQueryObject.addUpdateField("token_ruoli_tipologia", "?");
                    sqlQueryObject.addUpdateField("scope_stato", "?");
                    sqlQueryObject.addUpdateField("scope_match", "?");
                    sqlQueryObject.addUpdateField("ricerca_porta_azione_delegata", "?");
                    sqlQueryObject.addUpdateField("msg_diag_severita", "?");
                    sqlQueryObject.addUpdateField("tracciamento_stato", "?");
                    sqlQueryObject.addUpdateField("tracciamento_esiti", "?");
                    sqlQueryObject.addUpdateField("transazioni_tempi", "?");
                    sqlQueryObject.addUpdateField("transazioni_token", "?");
                    sqlQueryObject.addUpdateField("stato", "?");
                    sqlQueryObject.addUpdateField("cors_stato", "?");
                    sqlQueryObject.addUpdateField("cors_tipo", "?");
                    sqlQueryObject.addUpdateField("cors_all_allow_origins", "?");
                    sqlQueryObject.addUpdateField("cors_all_allow_methods", "?");
                    sqlQueryObject.addUpdateField("cors_all_allow_headers", "?");
                    sqlQueryObject.addUpdateField("cors_allow_credentials", "?");
                    sqlQueryObject.addUpdateField("cors_allow_max_age", "?");
                    sqlQueryObject.addUpdateField("cors_allow_max_age_seconds", "?");
                    sqlQueryObject.addUpdateField("cors_allow_origins", "?");
                    sqlQueryObject.addUpdateField("cors_allow_headers", "?");
                    sqlQueryObject.addUpdateField("cors_allow_methods", "?");
                    sqlQueryObject.addUpdateField("cors_allow_expose_headers", "?");
                    sqlQueryObject.addUpdateField("response_cache_stato", "?");
                    sqlQueryObject.addUpdateField("response_cache_seconds", "?");
                    sqlQueryObject.addUpdateField("response_cache_max_msg_size", "?");
                    sqlQueryObject.addUpdateField("response_cache_control_nocache", "?");
                    sqlQueryObject.addUpdateField("response_cache_control_maxage", "?");
                    sqlQueryObject.addUpdateField("response_cache_control_nostore", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_url", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_query", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_query_list", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_headers", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_hdr_list", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_payload", "?");
                    sqlQueryObject.addUpdateField("id_accordo", "?");
                    sqlQueryObject.addUpdateField("id_port_type", "?");
                    sqlQueryObject.addUpdateField("options", "?");
                    sqlQueryObject.addUpdateField("canale", "?");
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, descrizione);
                    stm.setLong(index++, idSoggettoErogatore);
                    stm.setString(index++, tipoSoggErogatore);
                    stm.setString(index++, nomeSoggErogatore);
                    stm.setLong(index++, idServizioPD);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setInt(index++, versioneServizio);
                    stm.setLong(index++, idAzione);
                    stm.setString(index++, nomeAzione);
                    if (modeAzione != null) {
                        stm.setString(index++, modeAzione.toString());
                    } else {
                        stm.setString(index++, null);
                    }
                    stm.setString(index++, patternAzione);
                    stm.setString(index++, nomePortaDeleganteAzione);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(forceInterfaceBased));
                    stm.setString(index++, autenticazione);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutenticazioneOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getPolicy() : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getTokenOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getValidazione()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getIntrospection()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getUserInfo()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getForward()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getOptions() : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getIssuer()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getClientId()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getSubject()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getUsername()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getEmail()) : null);
                    stm.setString(index++, autorizzazione);
                    stm.setString(index++, autorizzazioneXacmlPolicy);
                    stm.setString(index++, autorizzazioneContenuto);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeResponse));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomResponse));
                    stm.setString(index++, securityRequestMode);
                    stm.setString(index++, securityResponseMode);
                    stm.setLong(index++, idSoggettoProprietario);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(aPD.getRicevutaAsincronaSimmetrica()));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(aPD.getRicevutaAsincronaAsimmetrica()));
                    stm.setString(index++, aPD.getIntegrazione());
                    stm.setString(index++, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPD.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getAllegaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getScartaBody()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getGestioneManifest()) : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getStateless()) : null);
                    stm.setString(index++, aPD != null && aPD.getLocalForward() != null ? DriverConfigurazioneDBLib.getValue(aPD.getLocalForward().getStato()) : null);
                    stm.setString(index++, aPD != null && aPD.getLocalForward() != null ? aPD.getLocalForward().getPortaApplicativa() : null);
                    stm.setString(index++, aPD != null && aPD.getRuoli() != null && aPD.getRuoli().getMatch() != null ? aPD.getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getAutorizzazioneApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutorizzazioneToken().getAutorizzazioneApplicativi()) : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getAutorizzazioneRuoli() != null ? DriverConfigurazioneDBLib.getValue(aPD.getAutorizzazioneToken().getAutorizzazioneRuoli()) : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getRuoli() != null && aPD.getAutorizzazioneToken().getRuoli().getMatch() != null ? aPD.getAutorizzazioneToken().getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPD != null && aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getTipologiaRuoli() != null ? aPD.getAutorizzazioneToken().getTipologiaRuoli().getValue() : null);
                    stm.setString(index++, aPD != null && aPD.getScope() != null && aPD.getScope().getStato() != null ? DriverConfigurazioneDBLib.getValue(aPD.getScope().getStato()) : null);
                    stm.setString(index++, aPD != null && aPD.getScope() != null && aPD.getScope().getMatch() != null ? aPD.getScope().getMatch().getValue() : null);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getRicercaPortaAzioneDelegata()) : null);
                    stm.setString(index++, msgDiagSeverita);
                    stm.setString(index++, tracciamentoStato);
                    stm.setString(index++, tracciamentoEsiti);
                    stm.setString(index++, transazioniTempiElaborazione);
                    stm.setString(index++, transazioniToken);
                    stm.setString(index++, aPD != null ? DriverConfigurazioneDBLib.getValue(aPD.getStato()) : null);
                    stm.setString(index++, corsStato);
                    stm.setString(index++, corsTipo);
                    stm.setString(index++, corsAllAllowOrigins);
                    stm.setString(index++, corsAllAllowMethods);
                    stm.setString(index++, corsAllAllowHeaders);
                    stm.setString(index++, corsAllowCredentials);
                    stm.setInt(index++, corsAllowMaxAge);
                    if (corsAllowMaxAgeSeconds != null) {
                        stm.setInt(index++, corsAllowMaxAgeSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, corsAllowOrigins);
                    stm.setString(index++, corsAllowHeaders);
                    stm.setString(index++, corsAllowMethods);
                    stm.setString(index++, corsAllowExposeHeaders);
                    stm.setString(index++, responseCacheStato);
                    if (responseCacheSeconds != null) {
                        stm.setInt(index++, responseCacheSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (responseCacheMaxMsgSize != null) {
                        stm.setLong(index++, responseCacheMaxMsgSize);
                    } else {
                        stm.setNull(index++, -5);
                    }
                    stm.setInt(index++, responseCacheNoCache ? 1 : 0);
                    stm.setInt(index++, responseCacheMaxAge ? 1 : 0);
                    stm.setInt(index++, responseCacheNoStore ? 1 : 0);
                    stm.setString(index++, responseCacheHashUrl);
                    stm.setString(index++, responseCacheHashQuery);
                    stm.setString(index++, responseCacheHashQueryList);
                    stm.setString(index++, responseCacheHashHeaders);
                    stm.setString(index++, responseCacheHashHeadersList);
                    stm.setString(index++, responseCacheHashPayload);
                    stm.setLong(index++, aPD.getIdAccordo() != null ? aPD.getIdAccordo() : -1L);
                    stm.setLong(index++, aPD.getIdPortType() != null ? aPD.getIdPortType() : -1L);
                    stm.setString(index++, aPD.getOptions());
                    stm.setString(index++, aPD.getCanale());
                    if (utenteUltimaModifica != null) {
                        stm.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        stm.setTimestamp(index++, dataUltimaModifica);
                    }
                    stm.setLong(index++, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Updated " + n + " row(s).");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                reqParam = flow.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom request flow con id=" + idPortaDelegata);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            MtomProcessorFlow flow3 = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow3.sizeParameterList(); ++i) {
                                resParam = flow3.getParameter(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom response flow con id=" + idPortaDelegata);
                    }
                    if (messageSecurity != null) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addDeleteTable("pd_security_request");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.executeUpdate();
                        stm.close();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addDeleteTable("pd_security_response");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.executeUpdate();
                        stm.close();
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_security_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                reqParam = flow.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaDelegata);
                                stm.setString(indexSec++, reqParam.getNome());
                                String plainValue = reqParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityRequestMode, reqParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue.getWrappedValue();
                                    plainValue = byokValue.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " request flow con id=" + idPortaDelegata);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_security_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            MessageSecurityFlow flow4 = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow4.sizeParameterList(); ++i) {
                                BYOKWrappedValue byokValue2;
                                resParam = flow4.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaDelegata);
                                stm.setString(indexSec++, resParam.getNome());
                                String plainValue = resParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityResponseMode, resParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue2 = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue2.getWrappedValue();
                                    plainValue = byokValue2.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " response flow con id=" + idPortaDelegata);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQueryObject.addInsertField("riuso_id", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(cae.getIdentificazioneFallita()));
                            stm.setString(6, DriverConfigurazioneDBLib.getValue(cae.getRiusoIdentificativo()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa con id=" + idPortaDelegata);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    stm.executeUpdate();
                    stm.close();
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaDelegata);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " servizi applicativi associati alla Porta Delegata " + idPortaDelegata);
                    n = 0;
                    for (i = 0; i < aPD.sizeServizioApplicativoList(); ++i) {
                        PortaDelegataServizioApplicativo servizioApplicativo = aPD.getServizioApplicativo(i);
                        String nomeSA = servizioApplicativo.getNome();
                        String nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                        String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("porte_delegate_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.setLong(2, idSA);
                        stm.executeUpdate();
                        stm.close();
                        ++n;
                        DriverConfigurazioneDBLib.logDebug("Aggiunta associazione PortaDelegata<->ServizioApplicativo [" + idPortaDelegata + "]<->[" + idSA + "]");
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " associazioni PortaDelegata<->ServizioApplicativo associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_auth_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di autenticazione associate alla Porta Delegata " + idPortaDelegata);
                    int newProps = 0;
                    for (i = 0; i < aPD.sizeProprietaAutenticazioneList(); ++i) {
                        propProtocollo = aPD.getProprietaAutenticazione(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_auth_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaDelegata);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolProp Autenticazione associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_authz_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di autorizzazione associate alla Porta Delegata " + idPortaDelegata);
                    newProps = 0;
                    for (i = 0; i < aPD.sizeProprietaAutorizzazioneList(); ++i) {
                        propProtocollo = aPD.getProprietaAutorizzazione(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_authz_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaDelegata);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolProp Autorizzazione associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_authzc_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di autorizzazione contenuti associate alla Porta Delegata " + idPortaDelegata);
                    newProps = 0;
                    for (i = 0; i < aPD.sizeProprietaAutorizzazioneContenutoList(); ++i) {
                        propProtocollo = aPD.getProprietaAutorizzazioneContenuto(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_authzc_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaDelegata);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolProp AutorizzazioneContenuto associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ct_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di rate limiting associate alla Porta Delegata " + idPortaDelegata);
                    newProps = 0;
                    for (i = 0; i < aPD.sizeProprietaRateLimitingList(); ++i) {
                        propProtocollo = aPD.getProprietaRateLimiting(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_ct_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.setString(2, propProtocollo.getNome());
                        stm.setString(3, propProtocollo.getValore());
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolPropRateLimiting associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta associate alla Porta Delegata " + idPortaDelegata);
                    newProps = 0;
                    for (i = 0; i < aPD.sizeProprietaList(); ++i) {
                        propProtocollo = aPD.getProprieta(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pd_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaDelegata);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolProp associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli associati alla Porta Delegata " + idPortaDelegata);
                    n = 0;
                    if (aPD.getRuoli() != null && aPD.getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPD.getRuoli().sizeRuoloList(); ++j) {
                            Ruolo ruolo = aPD.getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_scope");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " scope associati alla Porta Delegata " + idPortaDelegata);
                    n = 0;
                    if (aPD.getScope() != null && aPD.getScope().sizeScopeList() > 0) {
                        for (int j = 0; j < aPD.getScope().sizeScopeList(); ++j) {
                            Scope scope = aPD.getScope().getScope(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_scope");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("scope", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, scope.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto scope[" + scope.getNome() + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " scope alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_token_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " servizi applicativi (token) associati alla Porta Delegata " + idPortaDelegata);
                    if (aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getServiziApplicativi() != null && aPD.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        n = 0;
                        for (i = 0; i < aPD.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList(); ++i) {
                            PortaDelegataServizioApplicativo servizioApplicativo = aPD.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(i);
                            String nomeSA = servizioApplicativo.getNome();
                            String nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                            if (nomeSA == null || nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_token_sa");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta associazione PortaDelegata<->ServizioApplicativo (token) [" + idPortaDelegata + "]<->[" + idSA + "]");
                        }
                        DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " associazioni PortaDelegata<->ServizioApplicativo (token) associati alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_token_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli (token) associati alla Porta Delegata " + idPortaDelegata);
                    n = 0;
                    if (aPD.getAutorizzazioneToken() != null && aPD.getAutorizzazioneToken().getRuoli() != null && aPD.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPD.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++j) {
                            Ruolo ruolo = aPD.getAutorizzazioneToken().getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_token_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] (token) alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli (token) alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_azioni");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " azioni delegate associate alla Porta Delegata " + idPortaDelegata);
                    n = 0;
                    if (aPD.getAzione() != null && aPD.getAzione().sizeAzioneDelegataList() > 0) {
                        for (int j = 0; j < aPD.getAzione().sizeAzioneDelegataList(); ++j) {
                            String azioneDelegata = aPD.getAzione().getAzioneDelegata(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_azioni");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("azione", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, azioneDelegata);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta azione delegata [" + azioneDelegata + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " azioni delegate alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_cache_regole");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " regole di cache associate alla Porta Delegata " + idPortaDelegata);
                    n = 0;
                    if (responseCacheRegole != null && responseCacheRegole.size() > 0) {
                        for (int j = 0; j < responseCacheRegole.size(); ++j) {
                            ResponseCachingConfigurazioneRegola regola = responseCacheRegole.get(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_cache_regole");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                sqlQueryObject.addInsertField("status_min", "?");
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                sqlQueryObject.addInsertField("status_max", "?");
                            }
                            sqlQueryObject.addInsertField("fault", "?");
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                sqlQueryObject.addInsertField("cache_seconds", "?");
                            }
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            int indexCR = 1;
                            stm.setLong(indexCR++, idPortaDelegata);
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMin());
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMax());
                            }
                            stm.setInt(indexCR++, regola.getFault() ? 1 : 0);
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                stm.setInt(indexCR++, regola.getCacheTimeoutSeconds());
                            }
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta regola di cache alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " regole di cache alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_aa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellate " + n + " A.A. associate alla Porta Delegata " + idPortaDelegata);
                    n = 0;
                    if (aPD.sizeAttributeAuthorityList() > 0) {
                        for (int j = 0; j < aPD.sizeAttributeAuthorityList(); ++j) {
                            AttributeAuthority aa = aPD.getAttributeAuthority(j);
                            String attributi = null;
                            if (aa.sizeAttributoList() > 0) {
                                StringBuilder bf = new StringBuilder();
                                for (int aaI = 0; aaI < aa.sizeAttributoList(); ++aaI) {
                                    if (aaI > 0) {
                                        bf.append(",");
                                    }
                                    bf.append(aa.getAttributo(aaI));
                                }
                                attributi = bf.toString();
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pd_aa");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("attributi", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.setString(2, aa.getNome());
                            stm.setString(3, attributi);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta A.A.[" + aa.getNome() + "] alla PortaDelegata[" + idPortaDelegata + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " A.A. alla PortaDelegata[" + idPortaDelegata + "]");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoDatabase, idPortaDelegata, "pd", "db");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoFiletrace, idPortaDelegata, "pd", "filetrace");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(type, con, tracciamentoFiletraceDetails, idPortaDelegata, "pd");
                    DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(type, con, aPD.getDump(), idPortaDelegata, "pd");
                    DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(type, con, aPD.getTrasformazioni(), idPortaDelegata, true);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, idPortaDelegata, null, true, configHandlers != null ? configHandlers.getRequest() : null);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, idPortaDelegata, null, false, configHandlers != null ? configHandlers.getResponse() : null);
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, DriverConfigurazioneDBLib.log, aPD, CRUDType.UPDATE);
                    }
                    i = 0;
                    if (aPD.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPD.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, DriverConfigurazioneDBLib.log, aPD, aPD.getExtendedInfo(i), CRUDType.UPDATE);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + i + " associazioni ExtendedInfo<->PortaDelegata associati alla PortaDelegata[" + idPortaDelegata + "]");
                    break;
                }
                case 3: {
                    idPortaDelegata = DBUtils.getIdPortaDelegata(nomePorta, con, DriverConfigurazioneDBLib.tipoDB);
                    if (idPortaDelegata <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(DELETE)] Non e' stato possibile recuperare l'id della Porta Delegata, necessario per effettuare la DELETE.");
                    }
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoDatabase, idPortaDelegata, "pd", "db");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoFiletrace, idPortaDelegata, "pd", "filetrace");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(type, con, tracciamentoFiletraceDetails, idPortaDelegata, "pd");
                    DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(type, con, aPD.getDump(), idPortaDelegata, "pd");
                    DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(type, con, aPD.getTrasformazioni(), idPortaDelegata, true);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, idPortaDelegata, null, true, configHandlers != null ? configHandlers.getRequest() : null);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, idPortaDelegata, null, false, configHandlers != null ? configHandlers.getResponse() : null);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_aa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellate " + n + " A.A. associate alla Porta Delegata " + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_cache_regole");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " regole di cache associate alla Porta Delegata " + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_azioni");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " azioni delegate associate alla Porta Delegata " + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_token_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli (token) associati alla Porta Delegata " + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_token_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " associazioni PortaDelegata<->ServizioApplicativo (token) associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli associati alla Porta Delegata " + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_scope");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " scope associati alla Porta Delegata " + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " request flow con id=" + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " response flow con id=" + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_security_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " request flow con id=" + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_security_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " response flow con id=" + idPortaDelegata);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " associazioni PortaDelegata<->ServizioApplicativo associati alla PortaDelegata[" + idPortaDelegata + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_security_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " security_request flow associate alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_security_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " security_response flow associate alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " correlazione associate alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " correlazione per la rispsota associate alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolProp associati alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_ct_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropRateLimiting associati alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_authzc_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropAutorizzazioneContenuto associati alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_authz_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropAutorizzazione associati alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pd_auth_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropAutenticazione associati alla PortaDelegata[" + idPortaDelegata + "]");
                    }
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, DriverConfigurazioneDBLib.log, aPD, CRUDType.DELETE);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaDelegata);
                    DriverConfigurazioneDBLib.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " row(s).");
                }
            }
            long l3 = idPortaDelegata;
            return l3;
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] SQLException : " + se.getMessage(), se);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante operazione(" + type + ") CRUDPortaDelegata.", e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
        }
    }
}

