/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RouteGateway;
import org.openspcoop2.core.config.RouteRegistro;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDefault;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_routingTableLIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_routingTableDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_routingTableDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RoutingTable getRoutingTable() throws DriverConfigurazioneException {
        RoutingTable routingTable;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stmSearch = null;
        ResultSet rsSearch = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRoutingTable");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            boolean routingEnabled = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query per routing enabled : " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.driver.logDebug("ConfigurazionePresente");
                this.driver.logDebug("Risultato query per routing enabled [" + rs.getString("routing_enabled") + "]");
                routingEnabled = CostantiConfigurazione.ABILITATO.equals(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("routing_enabled")));
            }
            rs.close();
            stm.close();
            this.driver.logDebug("RoutingEnabled: " + routingEnabled);
            RoutingTable rt = new RoutingTable();
            rt.setAbilitata(routingEnabled);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("routing");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query per routing table : " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            String tipo = null;
            String nome = null;
            String tipoRotta = null;
            String tiposoggrotta = null;
            String nomesoggrotta = null;
            long id_registrorotta = 0L;
            boolean is_default = false;
            long idR = 0L;
            RoutingTableDefault rtdefault = null;
            Route route = null;
            RouteGateway routeGateway = null;
            RouteRegistro routeRegistro = null;
            RoutingTableDestinazione rtd = null;
            int nroute = 0;
            this.driver.logDebug("Check esistenza rotte....");
            while (rs.next()) {
                this.driver.logDebug("Nuova rotta....[" + rs.getInt("is_default") + "]");
                ++nroute;
                route = new Route();
                idR = rs.getLong("id");
                tipo = rs.getString("tipo");
                nome = rs.getString("nome");
                tipoRotta = rs.getString("tiporotta");
                nomesoggrotta = rs.getString("nomesoggrotta");
                tiposoggrotta = rs.getString("tiposoggrotta");
                id_registrorotta = rs.getLong("registrorotta");
                is_default = rs.getInt("is_default") == 1;
                if (tipoRotta.equalsIgnoreCase("registro")) {
                    routeRegistro = new RouteRegistro();
                    if (id_registrorotta != 0L) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObject.addFromTable("registri");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id = ?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stmSearch = con.prepareStatement(sqlQuery);
                        stmSearch.setLong(1, id_registrorotta);
                        this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, id_registrorotta));
                        rsSearch = stmSearch.executeQuery();
                        if (rsSearch.next()) {
                            routeRegistro.setNome(rsSearch.getString("nome"));
                        }
                        rsSearch.close();
                        stmSearch.close();
                    }
                    route.setRegistro(routeRegistro);
                } else if (tipoRotta.equalsIgnoreCase("gateway")) {
                    routeGateway = new RouteGateway();
                    routeGateway.setNome(nomesoggrotta);
                    routeGateway.setTipo(tiposoggrotta);
                    route.setGateway(routeGateway);
                }
                route.setId(idR);
                if (is_default) {
                    if (rtdefault == null) {
                        rtdefault = new RoutingTableDefault();
                        rt.setDefault(rtdefault);
                    }
                    rt.getDefault().addRoute(route);
                    continue;
                }
                rtd = new RoutingTableDestinazione();
                rtd.setNome(nome);
                rtd.setTipo(tipo);
                rtd.addRoute(route);
                rt.addDestinazione(rtd);
            }
            this.driver.logDebug("Ci sono " + nroute + " rotte configurate.");
            rs.close();
            stm.close();
            routingTable = rt;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRoutingTable] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRoutingTable] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsSearch, stmSearch);
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(rsSearch, stmSearch);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return routingTable;
    }

    protected void createRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        if (routingTable == null || routingTable.getDefault() == null || routingTable.getDefault().sizeRouteList() == 0) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Parametri non validi.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createRoutingTable");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRoutingTable type = 1");
            DriverConfigurazioneDB_routingTableLIB.CRUDRoutingTable(1, routingTable, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Errore durante la creazione della RoutingTable : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        if (routingTable == null || routingTable.getDefault() == null || routingTable.getDefault().sizeRouteList() == 0) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRoutingTable] Parametri non validi.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateRoutingTable");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRoutingTable type = 2");
            DriverConfigurazioneDB_routingTableLIB.CRUDRoutingTable(2, routingTable, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRoutingTable] Errore durante la update della RoutingTable : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        if (routingTable == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRoutingTable] Parametri non validi.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteRoutingTable");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRoutingTable type = 3");
            DriverConfigurazioneDB_routingTableLIB.CRUDRoutingTable(3, routingTable, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRoutingTable] Errore durante la delete della RoutingTable : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected List<RoutingTableDestinazione> routingList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<RoutingTableDestinazione> arrayList;
        String nomeMetodo = "routingList";
        int idLista = Liste.ROUTING;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<RoutingTableDestinazione> lista = new ArrayList<RoutingTableDestinazione>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("routingList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("is_default = 0");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("is_default = 0");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("tiporotta");
                sqlQueryObject.addSelectField("is_default");
                sqlQueryObject.addWhereCondition("is_default = 0");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("tiporotta");
                sqlQueryObject.addSelectField("is_default");
                sqlQueryObject.addWhereCondition("is_default = 0");
                sqlQueryObject.addOrderBy("tipo");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                RoutingTableDestinazione rtd = new RoutingTableDestinazione();
                rtd.setId(risultato.getLong("id"));
                rtd.setNome(risultato.getString("nome"));
                rtd.setTipo(risultato.getString("tipo"));
                Route tmpR = new Route();
                if ("gateway".equals(risultato.getString("tiporotta"))) {
                    RouteGateway rg = new RouteGateway();
                    tmpR.setGateway(rg);
                } else {
                    RouteRegistro rr = new RouteRegistro();
                    tmpR.setRegistro(rr);
                }
                rtd.addRoute(tmpR);
                lista.add(rtd);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

