/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.utils;

import java.text.SimpleDateFormat;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.RisultatoStato;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.properties.PropertiesUtilities;

public class PolicyUtilities {
    private static final String DISABILITATO_LABEL = "Disabilitato";
    public static final String GLOBALE_PROPERTY = "globale:";
    public static final String ID_ACTIVE_POLICY_PROPERTY = "idActivePolicy:";
    public static final String RUOLO_PORTA_PROPERTY = "ruoloPorta:";
    public static final String NOME_PORTA_PROPERTY = "nomePorta:";

    private PolicyUtilities() {
    }

    public static String toString(Integer statoAllarme) {
        StringBuilder bf = new StringBuilder();
        if (statoAllarme == null) {
            bf.append("N.C.");
        } else if (statoAllarme == 0) {
            bf.append("OK");
        } else if (statoAllarme == 1) {
            bf.append("Warning");
        } else if (statoAllarme == 2) {
            bf.append("Error");
        } else {
            bf.append("N.C.");
        }
        return bf.toString();
    }

    public static String toString(RisultatoStato statoAllarme) {
        SimpleDateFormat dateFormat = DateUtils.getSimpleDateFormatMs();
        StringBuilder bf = new StringBuilder(PolicyUtilities.toString(statoAllarme.getStato()));
        bf.append(", ultimo aggiornamento:").append(dateFormat.format(statoAllarme.getDateCheck())).append(")");
        return bf.toString();
    }

    public static String toStringFilter(AttivazionePolicyFiltro filtro) {
        StringBuilder bf = new StringBuilder("");
        if (filtro.isEnabled()) {
            if (filtro.getRuoloPorta() != null && !RuoloPolicy.ENTRAMBI.equals(filtro.getRuoloPorta())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                if (RuoloPolicy.DELEGATA.equals(filtro.getRuoloPorta())) {
                    bf.append("Ruolo:Fruitore");
                } else if (RuoloPolicy.APPLICATIVA.equals(filtro.getRuoloPorta())) {
                    bf.append("Ruolo:Erogatore");
                }
            }
            if (filtro.getNomePorta() != null && !"".equals(filtro.getNomePorta())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Porta:");
                bf.append(filtro.getNomePorta());
            }
            if (filtro.getProtocollo() != null && !"".equals(filtro.getProtocollo())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Protocollo:");
                bf.append(filtro.getProtocollo());
            }
            if (filtro.getRuoloErogatore() != null && !"".equals(filtro.getRuoloErogatore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("RuoloErogatore:");
                bf.append(filtro.getRuoloErogatore());
            }
            if (filtro.getTipoErogatore() != null && !"".equals(filtro.getTipoErogatore()) && filtro.getNomeErogatore() != null && !"".equals(filtro.getNomeErogatore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Erogatore:");
                bf.append(filtro.getTipoErogatore() + "/" + filtro.getNomeErogatore());
            }
            if (filtro.getTag() != null && !"".equals(filtro.getTag())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Tag:");
                bf.append(filtro.getTag());
            }
            if (filtro.getTipoServizio() != null && !"".equals(filtro.getTipoServizio()) && filtro.getNomeServizio() != null && !"".equals(filtro.getNomeServizio())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Servizio:");
                bf.append(filtro.getTipoServizio() + "/" + filtro.getNomeServizio());
                if (filtro.getVersioneServizio() != null && filtro.getVersioneServizio() > 0) {
                    bf.append("/v").append(filtro.getVersioneServizio());
                }
            }
            if (filtro.getAzione() != null && !"".equals(filtro.getAzione())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Azione:");
                bf.append(filtro.getAzione());
            }
            if (filtro.getServizioApplicativoErogatore() != null && !"".equals(filtro.getServizioApplicativoErogatore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("SAErogatore:");
                bf.append(filtro.getServizioApplicativoErogatore());
            }
            if (filtro.getRuoloFruitore() != null && !"".equals(filtro.getRuoloFruitore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("RuoloFruitore:");
                bf.append(filtro.getRuoloFruitore());
            }
            if (filtro.getTipoFruitore() != null && !"".equals(filtro.getTipoFruitore()) && filtro.getNomeFruitore() != null && !"".equals(filtro.getNomeFruitore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Fruitore:");
                bf.append(filtro.getTipoFruitore() + "/" + filtro.getNomeFruitore());
            }
            if (filtro.getServizioApplicativoFruitore() != null && !"".equals(filtro.getServizioApplicativoFruitore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("SAFruitore:");
                bf.append(filtro.getServizioApplicativoFruitore());
            }
            if (filtro.getTokenClaims() != null) {
                Properties properties = PropertiesUtilities.convertTextToProperties((String)filtro.getTokenClaims());
                PolicyUtilities.addStringFilter(properties, "Token-", bf);
            }
            if (filtro.isInformazioneApplicativaEnabled()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Chiave:");
                bf.append(filtro.getInformazioneApplicativaTipo());
            }
        } else {
            bf.append(DISABILITATO_LABEL);
        }
        return bf.toString();
    }

    private static void addStringFilter(Properties properties, String prefix, StringBuilder bf) {
        if (properties != null && properties.size() > 0) {
            for (Object o : properties.keySet()) {
                if (!(o instanceof String)) continue;
                String key = (String)o;
                String value = properties.getProperty(key);
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append(prefix).append(key).append(":");
                bf.append(value);
            }
        }
    }

    public static String toStringGroupBy(AttivazionePolicyRaggruppamento groupBy, IDUnivocoGroupByPolicy datiGroupBy, boolean printDati) {
        if (printDati) {
            return PolicyUtilities.toStringGroupByWithValues(groupBy, datiGroupBy);
        }
        StringBuilder bf = new StringBuilder("");
        if (groupBy.isEnabled()) {
            if (groupBy.isRuoloPorta()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Tipologia");
            }
            if (groupBy.isProtocollo()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Modalit\u00e0");
            }
            if (groupBy.isErogatore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Erogatore");
            }
            if (groupBy.isServizio()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Servizio");
            }
            if (groupBy.isAzione()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Azione");
            }
            if (groupBy.isServizioApplicativoErogatore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("SAErogatore");
            }
            if (groupBy.isFruitore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Fruitore");
            }
            if (groupBy.isServizioApplicativoFruitore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("SAFruitore");
            }
            if (groupBy.getToken() != null && StringUtils.isNotEmpty((String)groupBy.getToken())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Token: ").append(groupBy.getToken());
            }
            if (groupBy.isInformazioneApplicativaEnabled()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Chiave-Tipo: ");
                bf.append(groupBy.getInformazioneApplicativaTipo());
                if (groupBy.getInformazioneApplicativaNome() != null) {
                    bf.append(", Chiave-Criterio: ");
                    bf.append(groupBy.getInformazioneApplicativaNome());
                }
                if (datiGroupBy != null) {
                    bf.append(", Chiave-Valore: ");
                    bf.append(datiGroupBy.getValoreKey());
                }
            }
        } else {
            bf.append(DISABILITATO_LABEL);
        }
        return bf.toString();
    }

    private static String toStringGroupByWithValues(AttivazionePolicyRaggruppamento groupBy, IDUnivocoGroupByPolicy datiGroupBy) {
        StringBuilder bf = new StringBuilder("");
        if (groupBy.isEnabled()) {
            if (groupBy.isRuoloPorta()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Tipologia: ");
                bf.append(datiGroupBy.getRuoloPorta());
            }
            if (groupBy.isProtocollo()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Protocollo: ");
                bf.append(datiGroupBy.getProtocollo());
            }
            if (groupBy.isErogatore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Erogatore: ");
                bf.append(datiGroupBy.getErogatore());
            }
            if (groupBy.isServizio()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Servizio: ");
                bf.append(datiGroupBy.getServizio());
            }
            if (groupBy.isAzione()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Azione: ");
                bf.append(datiGroupBy.getAzione());
            }
            if (groupBy.isServizioApplicativoErogatore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("SAErogatore: ");
                bf.append(datiGroupBy.getServizioApplicativoErogatore());
            }
            if (groupBy.isFruitore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Fruitore: ");
                bf.append(datiGroupBy.getFruitore());
            }
            if (groupBy.isServizioApplicativoFruitore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("SAFruitore: ");
                bf.append(datiGroupBy.getServizioApplicativoFruitore());
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("ApplicativoToken: ");
                bf.append(datiGroupBy.getServizioApplicativoToken());
            }
            if (groupBy.getToken() != null && StringUtils.isNotEmpty((String)groupBy.getToken())) {
                String[] token = null;
                token = groupBy.getToken().contains(",") ? groupBy.getToken().split(",") : new String[]{groupBy.getToken()};
                if (token != null && token.length > 0) {
                    for (int i = 0; i < token.length; ++i) {
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append(token[i]).append(": ");
                        TipoCredenzialeMittente claim = TipoCredenzialeMittente.toEnumConstant(token[i]);
                        if (claim != null) {
                            switch (claim) {
                                case TOKEN_SUBJECT: {
                                    bf.append(datiGroupBy.getTokenSubject());
                                    break;
                                }
                                case TOKEN_ISSUER: {
                                    bf.append(datiGroupBy.getTokenIssuer());
                                    break;
                                }
                                case TOKEN_CLIENT_ID: {
                                    bf.append(datiGroupBy.getTokenClientId());
                                    break;
                                }
                                case TOKEN_USERNAME: {
                                    bf.append(datiGroupBy.getTokenUsername());
                                    break;
                                }
                                case TOKEN_EMAIL: {
                                    bf.append(datiGroupBy.getTokenEMail());
                                    break;
                                }
                                case PDND_ORGANIZATION_NAME: {
                                    bf.append(datiGroupBy.getPdndOrganizationName());
                                    break;
                                }
                                case PDND_ORGANIZATION_EXTERNAL_ID: {
                                    bf.append(datiGroupBy.getPdndOrganizationExternalId());
                                    break;
                                }
                                case PDND_ORGANIZATION_CONSUMER_ID: {
                                    bf.append(datiGroupBy.getPdndOrganizationConsumerId());
                                    break;
                                }
                                default: {
                                    bf.append("N.D.");
                                    break;
                                }
                            }
                            continue;
                        }
                        bf.append("N.D.");
                    }
                }
            }
            if (groupBy.isInformazioneApplicativaEnabled()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Chiave-Tipo: ");
                bf.append(groupBy.getInformazioneApplicativaTipo());
                if (groupBy.getInformazioneApplicativaNome() != null) {
                    bf.append(", Chiave-Criterio: ");
                    bf.append(groupBy.getInformazioneApplicativaNome());
                }
                bf.append(", Chiave-Valore: ");
                bf.append(datiGroupBy.getValoreKey());
            }
        } else {
            bf.append(DISABILITATO_LABEL);
        }
        return bf.toString();
    }

    public static String buildIdConfigurazioneEventoPerPolicy(ActivePolicy activePolicy, IDUnivocoGroupByPolicy datiGroupBy, String api) {
        AttivazionePolicy attivazionePolicy = activePolicy.getInstanceConfiguration();
        return PolicyUtilities.buildIdConfigurazioneEventoPerPolicy(attivazionePolicy, datiGroupBy, api);
    }

    public static String buildIdConfigurazioneEventoPerPolicy(AttivazionePolicy attivazionePolicy, IDUnivocoGroupByPolicy datiGroupBy, String api) {
        boolean printDati = true;
        Object idPolicyConGruppo = PolicyUtilities.getNomeActivePolicy(attivazionePolicy.getAlias(), attivazionePolicy.getIdActivePolicy());
        if (api != null && !"".equals(api)) {
            idPolicyConGruppo = (String)idPolicyConGruppo + " - API: " + api;
        }
        if (attivazionePolicy.getGroupBy().isEnabled()) {
            String toStringRaggruppamentoConDatiIstanza = PolicyUtilities.toStringGroupBy(attivazionePolicy.getGroupBy(), datiGroupBy, printDati);
            idPolicyConGruppo = (String)idPolicyConGruppo + " - " + toStringRaggruppamentoConDatiIstanza;
        }
        return idPolicyConGruppo;
    }

    public static String buildConfigurazioneEventoPerPolicy(ActivePolicy activePolicy, boolean policyGlobale) {
        AttivazionePolicy attivazionePolicy = activePolicy.getInstanceConfiguration();
        return PolicyUtilities.buildConfigurazioneEventoPerPolicy(attivazionePolicy, policyGlobale);
    }

    public static String buildConfigurazioneEventoPerPolicy(AttivazionePolicy attivazionePolicy, boolean policyGlobale) {
        StringBuilder sb = new StringBuilder();
        sb.append(GLOBALE_PROPERTY).append(policyGlobale);
        sb.append("\n").append(ID_ACTIVE_POLICY_PROPERTY).append(attivazionePolicy.getIdActivePolicy());
        if (!policyGlobale && attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().getNomePorta() != null && StringUtils.isNotEmpty((String)attivazionePolicy.getFiltro().getNomePorta()) && attivazionePolicy.getFiltro().getRuoloPorta() != null) {
            String nomePorta = attivazionePolicy.getFiltro().getNomePorta();
            String ruoloPorta = attivazionePolicy.getFiltro().getRuoloPorta().getValue();
            sb.append("\n").append(RUOLO_PORTA_PROPERTY).append(ruoloPorta);
            sb.append("\n").append(NOME_PORTA_PROPERTY).append(nomePorta);
        }
        return sb.toString();
    }

    public static boolean isConfigurazioneEventoPerPolicy(String configurazione) {
        return configurazione != null && configurazione.startsWith(GLOBALE_PROPERTY);
    }

    public static boolean isConfigurazioneEventoPerPolicy_policyGlobale(String configurazione) {
        String firstLine;
        String[] tmp;
        if (PolicyUtilities.isConfigurazioneEventoPerPolicy(configurazione) && (tmp = configurazione.split("\n")) != null && tmp.length > 0 && (firstLine = tmp[0]) != null && firstLine.startsWith(GLOBALE_PROPERTY) && firstLine.length() > GLOBALE_PROPERTY.length()) {
            String s = firstLine.substring(GLOBALE_PROPERTY.length());
            return Boolean.valueOf(s);
        }
        return false;
    }

    public static String getConfigurazioneEventoPerPolicy_idActivePolicy(String configurazione) {
        String firstLine;
        String[] tmp;
        if (PolicyUtilities.isConfigurazioneEventoPerPolicy(configurazione) && (tmp = configurazione.split("\n")) != null && tmp.length > 1 && (firstLine = tmp[1]) != null && firstLine.startsWith(ID_ACTIVE_POLICY_PROPERTY) && firstLine.length() > ID_ACTIVE_POLICY_PROPERTY.length()) {
            return firstLine.substring(ID_ACTIVE_POLICY_PROPERTY.length());
        }
        return null;
    }

    public static String getConfigurazioneEventoPerPolicy_ruoloPorta(String configurazione) {
        String firstLine;
        String[] tmp;
        if (PolicyUtilities.isConfigurazioneEventoPerPolicy(configurazione) && (tmp = configurazione.split("\n")) != null && tmp.length > 2 && (firstLine = tmp[2]) != null && firstLine.startsWith(RUOLO_PORTA_PROPERTY) && firstLine.length() > RUOLO_PORTA_PROPERTY.length()) {
            return firstLine.substring(RUOLO_PORTA_PROPERTY.length());
        }
        return null;
    }

    public static String getConfigurazioneEventoPerPolicy_nomePorta(String configurazione) {
        String firstLine;
        String[] tmp;
        if (PolicyUtilities.isConfigurazioneEventoPerPolicy(configurazione) && (tmp = configurazione.split("\n")) != null && tmp.length > 3 && (firstLine = tmp[3]) != null && firstLine.startsWith(NOME_PORTA_PROPERTY) && firstLine.length() > NOME_PORTA_PROPERTY.length()) {
            return firstLine.substring(NOME_PORTA_PROPERTY.length());
        }
        return null;
    }

    public static String extractIdPolicyFromIdConfigurazioneEvento(String idConfigurazioneEvento) {
        if (idConfigurazioneEvento.contains(" - ")) {
            return idConfigurazioneEvento.split(" - ")[0];
        }
        return idConfigurazioneEvento;
    }

    public static String extractIDUnivocoGroupByPolicyFromIdConfigurazioneEventoAsString(String idConfigurazioneEvento) {
        String datiGruppo = null;
        if (idConfigurazioneEvento.contains(" - ")) {
            int indexOf = idConfigurazioneEvento.indexOf(" - ");
            datiGruppo = idConfigurazioneEvento.substring(indexOf + " - ".length());
        }
        return datiGruppo;
    }

    public static String getNomeActivePolicy(String alias, String id) {
        if (alias == null || "".equals(alias)) {
            return id.replace(":", "_");
        }
        return alias;
    }
}

