/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.eventi.utils;

import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.utils.UtilsException;

public class SeveritaConverter {
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static final int DEBUG = 4;

    private SeveritaConverter() {
    }

    public static TipoSeverita toSeverita(int intValue) throws UtilsException {
        if (intValue == 0) {
            return TipoSeverita.FATAL;
        }
        if (intValue == 1) {
            return TipoSeverita.ERROR;
        }
        if (intValue == 2) {
            return TipoSeverita.WARN;
        }
        if (intValue == 3) {
            return TipoSeverita.INFO;
        }
        if (intValue == 4) {
            return TipoSeverita.DEBUG;
        }
        throw new UtilsException("Value [" + intValue + "] unknown");
    }

    public static int toIntValue(TipoSeverita severita) throws UtilsException {
        switch (severita) {
            case FATAL: {
                return 0;
            }
            case ERROR: {
                return 1;
            }
            case WARN: {
                return 2;
            }
            case INFO: {
                return 3;
            }
            case DEBUG: {
                return 4;
            }
        }
        throw new UtilsException("Enumeration [" + severita + "] non gestita");
    }
}

