/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.mapping;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.id.IdentificativiErogazione;
import org.openspcoop2.core.id.IdentificativiFruizione;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBMappingUtils {
    public static int countMappingErogazione(Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils._countMappingErogazione(con, tipoDB, "soggetti");
    }

    public static int countMappingErogazione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBMappingUtils._countMappingErogazione(con, tipoDB, tabellaSoggetti);
    }

    private static int _countMappingErogazione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addSelectCountField("id", "mapping_count");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt("mapping_count");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new CoreException("createMappingErogazione error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, ISearch ricerca, boolean ricerca_useOffsetLimit, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, DBUtils.getIdServizio(idServizio.getNome(), idServizio.getTipo(), idServizio.getVersione(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getTipo(), con, tipoDB), ricerca, ricerca_useOffsetLimit, "soggetti", orderByDescrizione);
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, ISearch ricerca, boolean ricerca_useOffsetLimit, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, DBUtils.getIdServizio(idServizio.getNome(), idServizio.getTipo(), idServizio.getVersione(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getTipo(), con, tipoDB), ricerca, ricerca_useOffsetLimit, tabellaSoggetti, orderByDescrizione);
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, DBUtils.getIdServizio(idServizio.getNome(), idServizio.getTipo(), idServizio.getVersione(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getTipo(), con, tipoDB), null, false, "soggetti", orderByDescrizione);
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, DBUtils.getIdServizio(idServizio.getNome(), idServizio.getTipo(), idServizio.getVersione(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getTipo(), con, tipoDB), null, false, tabellaSoggetti, orderByDescrizione);
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, long idServizioAsLong, ISearch ricerca, boolean ricerca_useOffsetLimit, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, idServizioAsLong, ricerca, ricerca_useOffsetLimit, "soggetti", orderByDescrizione);
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, long idServizioAsLong, ISearch ricerca, boolean ricerca_useOffsetLimit, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, idServizioAsLong, ricerca, ricerca_useOffsetLimit, tabellaSoggetti, orderByDescrizione);
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, long idServizioAsLong, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, idServizioAsLong, null, false, "soggetti", orderByDescrizione);
    }

    public static List<MappingErogazionePortaApplicativa> mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, long idServizioAsLong, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingErogazionePortaApplicativaList(con, tipoDB, idServizio, idServizioAsLong, null, false, tabellaSoggetti, orderByDescrizione);
    }

    private static List<MappingErogazionePortaApplicativa> _mappingErogazionePortaApplicativaList(Connection con, String tipoDB, IDServizio idServizio, long idServizioAsLong, ISearch ricerca, boolean ricerca_useOffsetLimit, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        int idLista = Liste.CONFIGURAZIONE_EROGAZIONE;
        int offset = 0;
        int limit = 0;
        String search = "";
        if (ricerca != null) {
            if (ricerca_useOffsetLimit) {
                limit = ricerca.getPageSize(idLista);
                offset = ricerca.getIndexIniziale(idLista);
            }
            search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        }
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MappingErogazionePortaApplicativa> lista = new ArrayList<MappingErogazionePortaApplicativa>();
        try {
            int index;
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (ricerca != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("mapping_erogazione_pa");
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_erogazione = ?");
                sqlQueryObject.addWhereCondition("porte_applicative.id=mapping_erogazione_pa.id_porta");
                if (!search.equals("")) {
                    sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("mapping_erogazione_pa.nome", search, true, true)});
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                index = 1;
                stmt.setLong(index++, idServizioAsLong);
                risultato = stmt.executeQuery();
                if (risultato.next()) {
                    ricerca.setNumEntries(idLista, risultato.getInt(1));
                }
                risultato.close();
                stmt.close();
            }
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("mapping_erogazione_pa.id_erogazione");
            sqlQueryObject.addSelectField("mapping_erogazione_pa.id_porta");
            sqlQueryObject.addSelectField("mapping_erogazione_pa.is_default");
            sqlQueryObject.addSelectAliasField("mapping_erogazione_pa", "nome", "nomeMapping");
            sqlQueryObject.addSelectAliasField("mapping_erogazione_pa", "descrizione", "descrizioneMapping");
            sqlQueryObject.addSelectField("mapping_erogazione_pa.id");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_erogazione = ?");
            sqlQueryObject.addWhereCondition("porte_applicative.id=mapping_erogazione_pa.id_porta");
            if (ricerca != null && !search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("mapping_erogazione_pa.nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("mapping_erogazione_pa.is_default", true);
            if (orderByDescrizione) {
                sqlQueryObject.addOrderBy("descrizioneMapping");
            } else {
                sqlQueryObject.addOrderBy("nomeMapping");
            }
            sqlQueryObject.setSortType(true);
            if (ricerca != null) {
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
            }
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idServizioAsLong);
            risultato = stmt.executeQuery();
            MappingErogazionePortaApplicativa mapping = null;
            while (risultato.next()) {
                mapping = new MappingErogazionePortaApplicativa();
                Long id = risultato.getLong("id");
                String nome = risultato.getString("nomeMapping");
                String descrizione = risultato.getString("descrizioneMapping");
                Integer isDefaultInt = risultato.getInt("is_default");
                boolean isDefault = isDefaultInt > 0;
                mapping.setNome(nome);
                mapping.setDescrizione(descrizione);
                mapping.setTableId(id);
                mapping.setDefault(isDefault);
                mapping.setIdServizio(idServizio);
                IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                String nomePorta = risultato.getString("nome_porta");
                idPortaApplicativa.setNome(nomePorta);
                IdentificativiErogazione identificativiErogazione = new IdentificativiErogazione();
                identificativiErogazione.setIdServizio(idServizio);
                idPortaApplicativa.setIdentificativiErogazione(identificativiErogazione);
                mapping.setIdPortaApplicativa(idPortaApplicativa);
                lista.add(mapping);
            }
        }
        catch (Exception e) {
            throw new CoreException("mappingErogazionePortaApplicativaList error", e);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return lista;
    }

    public static void createMappingErogazione(String nome, String descrizione, boolean isDefault, IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.createMappingErogazione(nome, descrizione, isDefault, idServizio, idPortaApplicativa, con, tipoDB, "soggetti");
    }

    public static void createMappingErogazione(String nome, String descrizione, boolean isDefault, IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._createMappingErogazione(nome, descrizione, isDefault, idServizioLong, idPortaApplicativa, con, tipoDB, tabellaSoggetti);
    }

    private static void _createMappingErogazione(String nome, String descrizione, boolean isDefault, long idServizioLong, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            long idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativa.getNome(), con, tipoDB);
            if (idPA <= 0L) {
                throw new Exception("PortaApplicativa [" + idPortaApplicativa + "] non esistente");
            }
            int isDefaultInt = isDefault ? 1 : 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addInsertTable("mapping_erogazione_pa");
            sqlQueryObject.addInsertField("id_erogazione", "?");
            sqlQueryObject.addInsertField("id_porta", "?");
            sqlQueryObject.addInsertField("nome", "?");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("is_default", "?");
            String queryString = sqlQueryObject.createSQLInsert();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idServizioLong);
            stmt.setLong(index++, idPA);
            stmt.setString(index++, nome);
            stmt.setString(index++, descrizione);
            stmt.setInt(index++, isDefaultInt);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("Creazione Mapping Erogazione fallita: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void updateMappingErogazione(long tableId, String descrizione, Connection con, String tipoDB) throws CoreException {
        Statement stmt = null;
        try {
            if (tableId <= 0L) {
                throw new Exception("TableId non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addUpdateTable("mapping_erogazione_pa");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addWhereCondition("id=?");
            String queryString = sqlQueryObject.createSQLUpdate();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, descrizione);
            stmt.setLong(index++, tableId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("updateMappingErogazione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void deleteMappingErogazione(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, null, con, tipoDB, "soggetti");
    }

    public static void deleteMappingErogazione(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, null, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingErogazione(IDServizio idServizio, boolean deletePorte, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, deletePorte, con, tipoDB, "soggetti");
    }

    public static void deleteMappingErogazione(IDServizio idServizio, boolean deletePorte, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        List<IDPortaApplicativa> list = null;
        if (deletePorte) {
            list = DBMappingUtils.getIDPorteApplicativeAssociate(idServizio, con, tipoDB);
        }
        DBMappingUtils.deleteMappingErogazione(idServizio, null, con, tipoDB, tabellaSoggetti);
        if (list != null && list.size() > 0) {
            for (IDPortaApplicativa idPortaApplicativa : list) {
                Statement stmt = null;
                try {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String queryString = sqlQueryObject.createSQLDelete();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, DBUtils.getIdPortaApplicativa(idPortaApplicativa.getNome(), con, tipoDB));
                    stmt.executeUpdate();
                    stmt.close();
                }
                catch (Exception e) {
                    throw new CoreException("deletePAMappingErogazione error", e);
                }
                finally {
                    try {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void deleteMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, idPortaApplicativa, con, tipoDB, "soggetti");
    }

    public static void deleteMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._deleteMappingErogazione(idServizioLong, idPortaApplicativa, con, tipoDB, tabellaSoggetti);
    }

    private static void _deleteMappingErogazione(long idServizioLong, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            long idPA = -1L;
            if (idPortaApplicativa != null && (idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativa.getNome(), con, tipoDB)) <= 0L) {
                throw new Exception("PortaApplicativa [" + idPortaApplicativa + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("mapping_erogazione_pa");
            sqlQueryObject.addWhereCondition("id_erogazione=?");
            if (idPortaApplicativa != null) {
                sqlQueryObject.addWhereCondition("id_porta=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioLong);
            if (idPortaApplicativa != null) {
                stmt.setLong(2, idPA);
            }
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("deleteMappingErogazione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static IDPortaApplicativa getIDPortaApplicativaAssociataDefault(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaApplicativaAssociataDefault(idServizio, con, tipoDB, "soggetti");
    }

    public static IDPortaApplicativa getIDPortaApplicativaAssociataDefault(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        List<IDPortaApplicativa> l = DBMappingUtils._getIDPorteApplicativeAssociate(idServizioLong, true, null, con, tipoDB, tabellaSoggetti, idServizio);
        if (l != null && l.size() > 0) {
            if (l.size() > 1) {
                throw new CoreException("Esiste pi\u00f9 di un mapping di default per l'erogazione del servizio [" + idServizio.toString() + "]");
            }
            return l.get(0);
        }
        return null;
    }

    public static IDPortaApplicativa getIDPortaApplicativaAssociataAzione(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaApplicativaAssociataAzione(idServizio, con, tipoDB, "soggetti");
    }

    public static IDPortaApplicativa getIDPortaApplicativaAssociataAzione(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        if (idServizio.getAzione() == null) {
            throw new CoreException("Azione non indicata nel parametro 'idServizio'");
        }
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        List<IDPortaApplicativa> l = DBMappingUtils._getIDPorteApplicativeAssociate(idServizioLong, false, idServizio.getAzione(), con, tipoDB, tabellaSoggetti, idServizio);
        if (l != null && l.size() > 0) {
            if (l.size() > 1) {
                throw new CoreException("Esiste pi\u00f9 di un mapping per l'erogazione dell'azione '" + idServizio.getAzione() + "' del servizio [" + idServizio.toString() + "]");
            }
            return l.get(0);
        }
        return null;
    }

    public static List<IDPortaApplicativa> getIDPorteApplicativeAssociate(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPorteApplicativeAssociate(idServizio, con, tipoDB, "soggetti");
    }

    public static List<IDPortaApplicativa> getIDPorteApplicativeAssociate(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getIDPorteApplicativeAssociate(idServizioLong, false, null, con, tipoDB, tabellaSoggetti, idServizio);
    }

    private static List<IDPortaApplicativa> _getIDPorteApplicativeAssociate(long idServizioLong, boolean defaultMapping, String azioneMapping, Connection con, String tipoDB, String tabellaSoggetti, IDServizio idServizio) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ArrayList<IDPortaApplicativa> arrayList;
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.addWhereCondition("id_erogazione = ?");
            if (defaultMapping) {
                sqlQueryObject.addWhereCondition("is_default = ?");
            }
            sqlQueryObject.addWhereCondition("porte_applicative.id=mapping_erogazione_pa.id_porta");
            if (azioneMapping != null) {
                sqlQueryObject.addFromTable("pa_azioni");
                sqlQueryObject.addWhereCondition("porte_applicative.id=pa_azioni.id_porta");
                sqlQueryObject.addWhereCondition("pa_azioni.azione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idServizioLong);
            if (defaultMapping) {
                stm.setInt(indexStmt++, 1);
            }
            if (azioneMapping != null) {
                stm.setString(indexStmt++, azioneMapping);
            }
            rs = stm.executeQuery();
            ArrayList<IDPortaApplicativa> list = new ArrayList<IDPortaApplicativa>();
            while (rs.next()) {
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                String nome = rs.getString("nome_porta");
                idPA.setNome(nome);
                IdentificativiErogazione identificativiErogazione = new IdentificativiErogazione();
                identificativiErogazione.setIdServizio(idServizio);
                idPA.setIdentificativiErogazione(identificativiErogazione);
                list.add(idPA);
            }
            if (list.size() <= 0) {
                arrayList = null;
                return arrayList;
            }
            arrayList = list;
            return arrayList;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("getIDPortaApplicativaAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsIDPortaApplicativaAssociataDefault(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaApplicativaAssociataDefault(idServizio, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaApplicativaAssociataDefault(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        int c = DBMappingUtils._countIDPorteApplicativeAssociate(idServizioLong, true, null, con, tipoDB, tabellaSoggetti);
        if (c <= 0) {
            return false;
        }
        if (c > 1) {
            throw new CoreException("Esiste pi\u00f9 di un mapping di default per l'erogazione del servizio [" + idServizio.toString() + "]");
        }
        return true;
    }

    public static boolean existsIDPortaApplicativaAssociataAzione(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaApplicativaAssociataAzione(idServizio, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaApplicativaAssociataAzione(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        if (idServizio.getAzione() == null) {
            throw new CoreException("Azione non indicata nel parametro 'idServizio'");
        }
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        int c = DBMappingUtils._countIDPorteApplicativeAssociate(idServizioLong, false, idServizio.getAzione(), con, tipoDB, tabellaSoggetti);
        if (c <= 0) {
            return false;
        }
        if (c > 1) {
            throw new CoreException("Esiste pi\u00f9 di un mapping per l'erogazione dell'azione '" + idServizio.getAzione() + "' del servizio [" + idServizio.toString() + "]");
        }
        return true;
    }

    public static boolean existsIDPorteApplicativeAssociate(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPorteApplicativeAssociate(idServizio, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPorteApplicativeAssociate(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._countIDPorteApplicativeAssociate(idServizioLong, false, null, con, tipoDB, tabellaSoggetti) > 0;
    }

    private static int _countIDPorteApplicativeAssociate(long idServizioLong, boolean defaultMapping, String azioneMapping, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addWhereCondition("id_erogazione = ?");
            if (defaultMapping) {
                sqlQueryObject.addWhereCondition("is_default = ?");
            }
            if (azioneMapping != null) {
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("pa_azioni");
                sqlQueryObject.addWhereCondition("porte_applicative.id=mapping_erogazione_pa.id_porta");
                sqlQueryObject.addWhereCondition("porte_applicative.id=pa_azioni.id_porta");
                sqlQueryObject.addWhereCondition("pa_azioni.azione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idServizioLong);
            if (defaultMapping) {
                stm.setInt(indexStmt++, 1);
            }
            if (azioneMapping != null) {
                stm.setString(indexStmt++, azioneMapping);
            }
            rs = stm.executeQuery();
            int c = 0;
            while (rs.next()) {
                ++c;
            }
            int n = c;
            return n;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("existsIDPortaApplicativaAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsMappingErogazione(idServizio, idPortaApplicativa, con, tipoDB, "soggetti");
    }

    public static boolean existsMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        try {
            long id = DBMappingUtils.getTableIdMappingErogazione(idServizio, idPortaApplicativa, con, tipoDB);
            return id > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getTableIdMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getTableIdMappingErogazione(idServizio, idPortaApplicativa, con, tipoDB, "soggetti");
    }

    public static long getTableIdMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getTableIdMappingErogazione(idServizioLong, idPortaApplicativa, con, tipoDB, tabellaSoggetti);
    }

    private static long _getTableIdMappingErogazione(long idServizioLong, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        if (idServizioLong <= 0L) {
            throw new CoreException("IdServizio non fornito");
        }
        long idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativa.getNome(), con, tipoDB);
        if (idPA <= 0L) {
            throw new CoreException("PortaApplicativa [" + idPortaApplicativa + "] non esistente");
        }
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addWhereCondition("id_erogazione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idServizioLong);
            stm.setLong(2, idPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                long l = rs.getLong("id");
                return l;
            }
            try {
                throw new CoreException("Mapping tra PA (id:" + idPA + ") e servizio (id:" + idServizioLong + ") non esistente");
            }
            catch (CoreException de) {
                throw de;
            }
            catch (Exception e) {
                throw new CoreException("getIDPortaApplicativaAssociata error", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean checkMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, boolean isDefault, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.checkMappingErogazione(idServizio, idPortaApplicativa, isDefault, con, tipoDB, "soggetti");
    }

    public static boolean checkMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, boolean isDefault, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._checkMappingErogazione(idServizioLong, idPortaApplicativa, isDefault, con, tipoDB, tabellaSoggetti);
    }

    private static boolean _checkMappingErogazione(long idServizioLong, IDPortaApplicativa idPortaApplicativa, boolean isDefault, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            long idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativa.getNome(), con, tipoDB);
            if (idPA <= 0L) {
                throw new Exception("PortaApplicativa [" + idPortaApplicativa + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addSelectCountField("id", "mapping_count");
            sqlQueryObject.addWhereCondition("id_erogazione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.addWhereCondition("is_default = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idServizioLong);
            stm.setLong(2, idPA);
            stm.setLong(3, isDefault ? 1 : 0);
            rs = stm.executeQuery();
            int found = 0;
            if (rs.next()) {
                found = rs.getInt("mapping_count");
            }
            boolean bl = found > 0;
            return bl;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("_checkIsDefaultMappingErogazione error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static MappingErogazionePortaApplicativa getMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getMappingErogazione(idServizio, idPortaApplicativa, con, tipoDB, "soggetti");
    }

    public static MappingErogazionePortaApplicativa getMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        long idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativa.getNome(), con, tipoDB);
        if (idPA <= 0L) {
            throw new CoreException("PortaApplicativa [" + idPortaApplicativa + "] non esistente");
        }
        MappingErogazionePortaApplicativa mapping = DBMappingUtils._getMappingErogazione(idServizioLong, idPA, con, tipoDB, tabellaSoggetti);
        mapping.setIdPortaApplicativa(idPortaApplicativa);
        mapping.setIdServizio(idServizio);
        return mapping;
    }

    private static MappingErogazionePortaApplicativa _getMappingErogazione(long idServizioLong, long idPA, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addWhereCondition("id_erogazione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idServizioLong);
            stm.setLong(2, idPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                MappingErogazionePortaApplicativa mapping = new MappingErogazionePortaApplicativa();
                int isDefault = rs.getInt("is_default");
                mapping.setDefault(isDefault == 1);
                mapping.setTableId(rs.getLong("id"));
                mapping.setNome(rs.getString("nome"));
                mapping.setDescrizione(rs.getString("descrizione"));
                MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = mapping;
                return mappingErogazionePortaApplicativa;
            }
            try {
                throw new CoreException("Mapping tra PA (id:" + idPA + ") e servizio (id:" + idServizioLong + ") non esistente");
            }
            catch (CoreException de) {
                throw de;
            }
            catch (Exception e) {
                throw new CoreException("getMappingErogazione error", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int countMappingFruizione(Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils._countMappingFruizione(con, tipoDB, "soggetti");
    }

    public static int countMappingFruizione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBMappingUtils._countMappingFruizione(con, tipoDB, tabellaSoggetti);
    }

    private static int _countMappingFruizione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addSelectCountField("id", "mapping_count");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt("mapping_count");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new CoreException("createMappingFruizione error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, long idFruizione, IDSoggetto idSoggettoFruitore, IDServizio idServizio, ISearch ricerca, boolean ricerca_useOffsetLimit, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, idFruizione, idSoggettoFruitore, idServizio, ricerca, ricerca_useOffsetLimit, "soggetti", orderByDescrizione);
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, long idFruizione, IDSoggetto idSoggettoFruitore, IDServizio idServizio, ISearch ricerca, boolean ricerca_useOffsetLimit, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, idFruizione, idSoggettoFruitore, idServizio, ricerca, ricerca_useOffsetLimit, tabellaSoggetti, orderByDescrizione);
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, long idFruizione, IDSoggetto idSoggettoFruitore, IDServizio idServizio, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, idFruizione, idSoggettoFruitore, idServizio, null, false, "soggetti", orderByDescrizione);
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, long idFruizione, IDSoggetto idSoggettoFruitore, IDServizio idServizio, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, idFruizione, idSoggettoFruitore, idServizio, null, false, tabellaSoggetti, orderByDescrizione);
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, IDSoggetto idSoggettoFruitore, IDServizio idServizio, ISearch ricerca, boolean ricerca_useOffsetLimit, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, DBUtils.getIdFruizioneServizio(idServizio, idSoggettoFruitore, con, tipoDB), idSoggettoFruitore, idServizio, ricerca, ricerca_useOffsetLimit, "soggetti", orderByDescrizione);
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, IDSoggetto idSoggettoFruitore, IDServizio idServizio, ISearch ricerca, boolean ricerca_useOffsetLimit, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, DBUtils.getIdFruizioneServizio(idServizio, idSoggettoFruitore, con, tipoDB), idSoggettoFruitore, idServizio, ricerca, ricerca_useOffsetLimit, tabellaSoggetti, orderByDescrizione);
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, IDSoggetto idSoggettoFruitore, IDServizio idServizio, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, DBUtils.getIdFruizioneServizio(idServizio, idSoggettoFruitore, con, tipoDB), idSoggettoFruitore, idServizio, null, false, "soggetti", orderByDescrizione);
    }

    public static List<MappingFruizionePortaDelegata> mappingFruizionePortaDelegataList(Connection con, String tipoDB, IDSoggetto idSoggettoFruitore, IDServizio idServizio, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        return DBMappingUtils._mappingFruizionePortaDelegataList(con, tipoDB, DBUtils.getIdFruizioneServizio(idServizio, idSoggettoFruitore, con, tipoDB), idSoggettoFruitore, idServizio, null, false, tabellaSoggetti, orderByDescrizione);
    }

    private static List<MappingFruizionePortaDelegata> _mappingFruizionePortaDelegataList(Connection con, String tipoDB, long idFruizione, IDSoggetto idSoggettoFruitore, IDServizio idServizio, ISearch ricerca, boolean ricerca_useOffsetLimit, String tabellaSoggetti, boolean orderByDescrizione) throws CoreException {
        int idLista = Liste.CONFIGURAZIONE_FRUIZIONE;
        int offset = 0;
        int limit = 0;
        String search = "";
        if (ricerca != null) {
            if (ricerca_useOffsetLimit) {
                limit = ricerca.getPageSize(idLista);
                offset = ricerca.getIndexIniziale(idLista);
            }
            search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        }
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MappingFruizionePortaDelegata> lista = new ArrayList<MappingFruizionePortaDelegata>();
        try {
            int index;
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (ricerca != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("mapping_fruizione_pd");
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione = ?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=mapping_fruizione_pd.id_porta");
                if (!search.equals("")) {
                    sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("mapping_fruizione_pd.nome", search, true, true)});
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                index = 1;
                stmt.setLong(index++, idFruizione);
                risultato = stmt.executeQuery();
                if (risultato.next()) {
                    ricerca.setNumEntries(idLista, risultato.getInt(1));
                }
                risultato.close();
                stmt.close();
            }
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("mapping_fruizione_pd.id_fruizione");
            sqlQueryObject.addSelectField("mapping_fruizione_pd.id_porta");
            sqlQueryObject.addSelectField("mapping_fruizione_pd.is_default");
            sqlQueryObject.addSelectAliasField("mapping_fruizione_pd", "nome", "nomeMapping");
            sqlQueryObject.addSelectAliasField("mapping_fruizione_pd", "descrizione", "descrizioneMapping");
            sqlQueryObject.addSelectField("mapping_fruizione_pd.id");
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione = ?");
            sqlQueryObject.addWhereCondition("porte_delegate.id=mapping_fruizione_pd.id_porta");
            if (ricerca != null && !search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("mapping_fruizione_pd.nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("mapping_fruizione_pd.is_default", true);
            if (orderByDescrizione) {
                sqlQueryObject.addOrderBy("descrizioneMapping");
            } else {
                sqlQueryObject.addOrderBy("nomeMapping");
            }
            sqlQueryObject.setSortType(true);
            if (ricerca != null) {
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
            }
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idFruizione);
            risultato = stmt.executeQuery();
            MappingFruizionePortaDelegata mapping = null;
            while (risultato.next()) {
                mapping = new MappingFruizionePortaDelegata();
                Long id = risultato.getLong("id");
                String nome = risultato.getString("nomeMapping");
                String descrizione = risultato.getString("descrizioneMapping");
                Integer isDefaultInt = risultato.getInt("is_default");
                boolean isDefault = isDefaultInt > 0;
                mapping.setNome(nome);
                mapping.setDescrizione(descrizione);
                mapping.setTableId(id);
                mapping.setDefault(isDefault);
                mapping.setIdServizio(idServizio);
                mapping.setIdFruitore(idSoggettoFruitore);
                IDPortaDelegata idPortaDelegata = new IDPortaDelegata();
                String nomePorta = risultato.getString("nome_porta");
                idPortaDelegata.setNome(nomePorta);
                IdentificativiFruizione identificativiFruizione = new IdentificativiFruizione();
                identificativiFruizione.setSoggettoFruitore(idSoggettoFruitore);
                identificativiFruizione.setIdServizio(idServizio);
                idPortaDelegata.setIdentificativiFruizione(identificativiFruizione);
                mapping.setIdPortaDelegata(idPortaDelegata);
                lista.add(mapping);
            }
        }
        catch (Exception e) {
            throw new CoreException("mappingFruizionePortaDelegataList error", e);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return lista;
    }

    public static void createMappingFruizione(String nome, String descrizione, boolean isDefault, IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.createMappingFruizione(nome, descrizione, isDefault, idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static void createMappingFruizione(String nome, String descrizione, boolean isDefault, IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._createMappingFruizione(nome, descrizione, isDefault, idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    private static void _createMappingFruizione(String nome, String descrizione, boolean isDefault, long idFruizione, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            long idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getNome(), con, tipoDB);
            if (idPD <= 0L) {
                throw new Exception("PortaDelegata [" + idPortaDelegata + "] non esistente");
            }
            int isDefaultInt = isDefault ? 1 : 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addInsertTable("mapping_fruizione_pd");
            sqlQueryObject.addInsertField("id_fruizione", "?");
            sqlQueryObject.addInsertField("id_porta", "?");
            sqlQueryObject.addInsertField("nome", "?");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("is_default", "?");
            String queryString = sqlQueryObject.createSQLInsert();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idFruizione);
            stmt.setLong(index++, idPD);
            stmt.setString(index++, nome);
            stmt.setString(index++, descrizione);
            stmt.setInt(index++, isDefaultInt);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("Creazione Mapping Fruizione fallita: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void updateMappingFruizione(long tableId, String descrizione, Connection con, String tipoDB) throws CoreException {
        Statement stmt = null;
        try {
            if (tableId <= 0L) {
                throw new Exception("TableId non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addUpdateTable("mapping_fruizione_pd");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addWhereCondition("id=?");
            String queryString = sqlQueryObject.createSQLUpdate();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, descrizione);
            stmt.setLong(index++, tableId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("updateMappingFruizione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, tipoDB, "soggetti");
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, boolean deletePorte, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, deletePorte, con, tipoDB, "soggetti");
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, boolean deletePorte, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        List<IDPortaDelegata> list = null;
        if (deletePorte) {
            list = DBMappingUtils.getIDPorteDelegateAssociate(idServizio, idFruitore, con, tipoDB);
        }
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, tipoDB, tabellaSoggetti);
        if (list != null && list.size() > 0) {
            for (IDPortaDelegata idPortaDelegata : list) {
                Statement stmt = null;
                try {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("porte_delegate");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String queryString = sqlQueryObject.createSQLDelete();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, DBUtils.getIdPortaDelegata(idPortaDelegata.getNome(), con, tipoDB));
                    stmt.executeUpdate();
                    stmt.close();
                }
                catch (Exception e) {
                    throw new CoreException("deletePAMappingErogazione error", e);
                }
                finally {
                    try {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._deleteMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    private static void _deleteMappingFruizione(long idFruizione, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            long idPD = -1L;
            if (idPortaDelegata != null && (idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getNome(), con, tipoDB)) <= 0L) {
                throw new Exception("PortaDelegata [" + idPortaDelegata + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("mapping_fruizione_pd");
            sqlQueryObject.addWhereCondition("id_fruizione=?");
            if (idPortaDelegata != null) {
                sqlQueryObject.addWhereCondition("id_porta=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idFruizione);
            if (idPortaDelegata != null) {
                stmt.setLong(2, idPD);
            }
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("deleteMappingFruizione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static IDPortaDelegata getIDPortaDelegataAssociataDefault(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaDelegataAssociataDefault(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static IDPortaDelegata getIDPortaDelegataAssociataDefault(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        List<IDPortaDelegata> l = DBMappingUtils._getIDPorteDelegateAssociate(idFruizione, true, null, con, tipoDB, tabellaSoggetti, idFruitore, idServizio);
        if (l != null && l.size() > 0) {
            if (l.size() > 1) {
                throw new CoreException("Esiste pi\u00f9 di un mapping di default per la fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "]");
            }
            return l.get(0);
        }
        return null;
    }

    public static IDPortaDelegata getIDPortaDelegataAssociataAzione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaDelegataAssociataAzione(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static IDPortaDelegata getIDPortaDelegataAssociataAzione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        if (idServizio.getAzione() == null) {
            throw new CoreException("Azione non indicata nel parametro 'idServizio'");
        }
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        List<IDPortaDelegata> l = DBMappingUtils._getIDPorteDelegateAssociate(idFruizione, false, idServizio.getAzione(), con, tipoDB, tabellaSoggetti, idFruitore, idServizio);
        if (l != null && l.size() > 0) {
            if (l.size() > 1) {
                throw new CoreException("Esiste pi\u00f9 di un mapping per l'azione '" + idServizio.getAzione() + "' per la fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "]");
            }
            return l.get(0);
        }
        return null;
    }

    public static List<IDPortaDelegata> getIDPorteDelegateAssociate(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPorteDelegateAssociate(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static List<IDPortaDelegata> getIDPorteDelegateAssociate(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getIDPorteDelegateAssociate(idFruizione, false, null, con, tipoDB, tabellaSoggetti, idFruitore, idServizio);
    }

    private static List<IDPortaDelegata> _getIDPorteDelegateAssociate(long idFruizione, boolean defaultMapping, String azioneMapping, Connection con, String tipoDB, String tabellaSoggetti, IDSoggetto idFruitore, IDServizio idServizio) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ArrayList<IDPortaDelegata> arrayList;
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            sqlQueryObject.addWhereCondition("id_fruizione = ?");
            if (defaultMapping) {
                sqlQueryObject.addWhereCondition("is_default = ?");
            }
            sqlQueryObject.addWhereCondition("porte_delegate.id=mapping_fruizione_pd.id_porta");
            if (azioneMapping != null) {
                sqlQueryObject.addFromTable("pd_azioni");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_azioni.id_porta");
                sqlQueryObject.addWhereCondition("pd_azioni.azione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idFruizione);
            if (defaultMapping) {
                stm.setInt(indexStmt++, 1);
            }
            if (azioneMapping != null) {
                stm.setString(indexStmt++, azioneMapping);
            }
            rs = stm.executeQuery();
            ArrayList<IDPortaDelegata> list = new ArrayList<IDPortaDelegata>();
            while (rs.next()) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                String nome = rs.getString("nome_porta");
                idPD.setNome(nome);
                IdentificativiFruizione identificativiFruizione = new IdentificativiFruizione();
                identificativiFruizione.setSoggettoFruitore(idFruitore);
                identificativiFruizione.setIdServizio(idServizio);
                idPD.setIdentificativiFruizione(identificativiFruizione);
                list.add(idPD);
            }
            if (list.size() <= 0) {
                arrayList = null;
                return arrayList;
            }
            arrayList = list;
            return arrayList;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("getIDPortaDelegataAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsIDPortaDelegataAssociataDefault(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaDelegataAssociataDefault(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaDelegataAssociataDefault(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        int c = DBMappingUtils._countIDPorteDelegateAssociate(idFruizione, true, null, con, tipoDB, tabellaSoggetti);
        if (c <= 0) {
            return false;
        }
        if (c > 1) {
            throw new CoreException("Esiste pi\u00f9 di un mapping di default per la fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "]");
        }
        return true;
    }

    public static boolean existsIDPortaDelegataAssociataAzione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaDelegataAssociataAzione(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaDelegataAssociataAzione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        if (idServizio.getAzione() == null) {
            throw new CoreException("Azione non indicata nel parametro 'idServizio'");
        }
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        int c = DBMappingUtils._countIDPorteDelegateAssociate(idFruizione, false, idServizio.getAzione(), con, tipoDB, tabellaSoggetti);
        if (c <= 0) {
            return false;
        }
        if (c > 1) {
            throw new CoreException("Esiste pi\u00f9 di un mapping per la fruizione dell'azione '" + idServizio.getAzione() + "' da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "]");
        }
        return true;
    }

    public static boolean existsIDPorteDelegateAssociate(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPorteDelegateAssociate(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPorteDelegateAssociate(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._countIDPorteDelegateAssociate(idFruizione, false, null, con, tipoDB, tabellaSoggetti) > 0;
    }

    private static int _countIDPorteDelegateAssociate(long idFruizione, boolean defaultMapping, String azioneMapping, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addWhereCondition("id_fruizione = ?");
            if (defaultMapping) {
                sqlQueryObject.addWhereCondition("is_default = ?");
            }
            if (azioneMapping != null) {
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_azioni");
                sqlQueryObject.addWhereCondition("porte_delegate.id=mapping_fruizione_pd.id_porta");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_azioni.id_porta");
                sqlQueryObject.addWhereCondition("pd_azioni.azione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idFruizione);
            if (defaultMapping) {
                stm.setInt(indexStmt++, 1);
            }
            if (azioneMapping != null) {
                stm.setString(indexStmt++, azioneMapping);
            }
            rs = stm.executeQuery();
            int c = 0;
            while (rs.next()) {
                ++c;
            }
            int n = c;
            return n;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("existsIDPortaDelegataAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static boolean existsMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        try {
            long id = DBMappingUtils.getTableIdMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB);
            return id > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getTableIdMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getTableIdMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static long getTableIdMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getTableIdMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    private static long _getTableIdMappingFruizione(long idFruizione, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            long idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getNome(), con, tipoDB);
            if (idPD <= 0L) {
                throw new Exception("PortaDelegata [" + idPortaDelegata + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addWhereCondition("id_fruizione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idFruizione);
            stm.setLong(2, idPD);
            rs = stm.executeQuery();
            if (rs.next()) {
                long l = rs.getLong("id");
                return l;
            }
            try {
                throw new CoreException("Mapping tra PD (id:" + idPD + ") e Fruizione (id:" + idFruizione + ") non esistente");
            }
            catch (CoreException de) {
                throw de;
            }
            catch (Exception e) {
                throw new CoreException("_getTableIdMappingFruizione error", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean checkMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, boolean isDefault, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.checkMappingFruizione(idServizio, idFruitore, idPortaDelegata, isDefault, con, tipoDB, "soggetti");
    }

    public static boolean checkMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, boolean isDefault, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils.checkMappingFruizione(idFruizione, idPortaDelegata, isDefault, con, tipoDB, tabellaSoggetti);
    }

    private static boolean checkMappingFruizione(long idFruizione, IDPortaDelegata idPortaDelegata, boolean isDefault, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            long idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getNome(), con, tipoDB);
            if (idPD <= 0L) {
                throw new Exception("PortaDelegata [" + idPortaDelegata + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addSelectCountField("id", "mapping_count");
            sqlQueryObject.addWhereCondition("id_fruizione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.addWhereCondition("is_default = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idFruizione);
            stm.setLong(2, idPD);
            stm.setLong(3, isDefault ? 1 : 0);
            rs = stm.executeQuery();
            int found = 0;
            if (rs.next()) {
                found = rs.getInt("mapping_count");
            }
            boolean bl = found > 0;
            return bl;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("getIDPortaApplicativaAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static MappingFruizionePortaDelegata getMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static MappingFruizionePortaDelegata getMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        long idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getNome(), con, tipoDB);
        if (idPD <= 0L) {
            throw new CoreException("PortaDelegata [" + idPortaDelegata + "] non esistente");
        }
        MappingFruizionePortaDelegata mapping = DBMappingUtils._getMappingFruizione(idFruizione, idPD, con, tipoDB, tabellaSoggetti);
        mapping.setIdPortaDelegata(idPortaDelegata);
        mapping.setIdServizio(idServizio);
        mapping.setIdFruitore(idFruitore);
        return mapping;
    }

    private static MappingFruizionePortaDelegata _getMappingFruizione(long idFruizione, long idPD, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addWhereCondition("id_fruizione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idFruizione);
            stm.setLong(2, idPD);
            rs = stm.executeQuery();
            if (rs.next()) {
                MappingFruizionePortaDelegata mapping = new MappingFruizionePortaDelegata();
                int isDefault = rs.getInt("is_default");
                mapping.setDefault(isDefault == 1);
                mapping.setTableId(rs.getLong("id"));
                mapping.setNome(rs.getString("nome"));
                mapping.setDescrizione(rs.getString("descrizione"));
                MappingFruizionePortaDelegata mappingFruizionePortaDelegata = mapping;
                return mappingFruizionePortaDelegata;
            }
            try {
                throw new CoreException("Mapping tra PD (id:" + idPD + ") e Fruizione (id:" + idFruizione + ") non esistente");
            }
            catch (CoreException de) {
                throw de;
            }
            catch (Exception e) {
                throw new CoreException("getMappingFruizione error", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

