/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.mapping;

import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizio;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IdentificativiErogazione;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;

public class ImplementationUtils {
    public static IDPortaApplicativa setCommonParameter(PortaApplicativa portaApplicativa, IDServizio idServizio, boolean setDatiServizio, boolean portaClonata) {
        portaApplicativa.setTipoSoggettoProprietario(idServizio.getSoggettoErogatore().getTipo());
        portaApplicativa.setNomeSoggettoProprietario(idServizio.getSoggettoErogatore().getNome());
        if (setDatiServizio) {
            PortaApplicativaServizio pdServizio = new PortaApplicativaServizio();
            pdServizio.setTipo(idServizio.getTipo());
            pdServizio.setNome(idServizio.getNome());
            pdServizio.setVersione(idServizio.getVersione());
            portaApplicativa.setServizio(pdServizio);
        }
        portaApplicativa.setStato(StatoFunzionalita.ABILITATO);
        if (!portaClonata) {
            portaApplicativa.setRicevutaAsincronaAsimmetrica(StatoFunzionalita.ABILITATO);
            portaApplicativa.setRicevutaAsincronaSimmetrica(StatoFunzionalita.ABILITATO);
            portaApplicativa.setAllegaBody(StatoFunzionalita.DISABILITATO);
            portaApplicativa.setScartaBody(StatoFunzionalita.DISABILITATO);
            portaApplicativa.setStatoMessageSecurity(StatoFunzionalita.DISABILITATO.toString());
        }
        IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
        idPortaApplicativa.setNome(portaApplicativa.getNome());
        IdentificativiErogazione identificativiErogazione = new IdentificativiErogazione();
        identificativiErogazione.setIdServizio(idServizio);
        idPortaApplicativa.setIdentificativiErogazione(identificativiErogazione);
        return idPortaApplicativa;
    }

    public static void setAzioneDelegate(PortaApplicativa portaApplicativa, String nomePortaDelegante, String ... azione) {
        PortaApplicativaAzione pda = new PortaApplicativaAzione();
        pda.setIdentificazione(PortaApplicativaAzioneIdentificazione.DELEGATED_BY);
        pda.setNomePortaDelegante(nomePortaDelegante);
        for (int i = 0; i < azione.length; ++i) {
            pda.addAzioneDelegata(azione[i]);
        }
        portaApplicativa.setAzione(pda);
        portaApplicativa.setRicercaPortaAzioneDelegata(StatoFunzionalita.DISABILITATO);
    }

    public static MappingErogazionePortaApplicativa createMappingDefault(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) {
        MappingErogazionePortaApplicativa mappingErogazione = ImplementationUtils._creteMapping(idServizio, idPortaApplicativa);
        mappingErogazione.setDefault(true);
        mappingErogazione.setNome(ImplementationUtils.getDefaultMappingName());
        mappingErogazione.setDescrizione(ImplementationUtils.getDefaultMappingDescription());
        return mappingErogazione;
    }

    public static MappingErogazionePortaApplicativa createMapping(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa, String ruleName, String description) {
        MappingErogazionePortaApplicativa mappingErogazione = ImplementationUtils._creteMapping(idServizio, idPortaApplicativa);
        mappingErogazione.setDefault(false);
        mappingErogazione.setNome(ruleName);
        mappingErogazione.setDescrizione(description);
        return mappingErogazione;
    }

    private static MappingErogazionePortaApplicativa _creteMapping(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) {
        MappingErogazionePortaApplicativa mappingErogazione = new MappingErogazionePortaApplicativa();
        mappingErogazione.setIdServizio(idServizio);
        mappingErogazione.setIdPortaApplicativa(idPortaApplicativa);
        return mappingErogazione;
    }

    public static boolean isPortaApplicativaUtilizzabileComeDefault(PortaApplicativa pa) {
        return pa.getAzione() == null || !PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals(pa.getAzione().getIdentificazione()) && (pa.getAzione().getNome() == null || "".equals(pa.getAzione().getNome())) && (pa.getRicercaPortaAzioneDelegata() == null || StatoFunzionalita.ABILITATO.equals(pa.getRicercaPortaAzioneDelegata()));
    }

    public static String getDefaultMappingName() {
        return "__qualsiasi__";
    }

    public static String getDefaultMappingDescription() {
        return "Predefinito";
    }
}

