/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;

public class IDAccordoFactory {
    private static final String ACCORDO_NON_FORNITO = "Accordo non fornito";
    private static IDAccordoFactory factory = null;

    private static synchronized void init() {
        if (factory == null) {
            factory = new IDAccordoFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDAccordoFactory getInstance() {
        if (factory != null) return factory;
        Class<IDAccordoFactory> clazz = IDAccordoFactory.class;
        synchronized (IDAccordoFactory.class) {
            IDAccordoFactory.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    private IDAccordoFactory() {
    }

    private IDAccordo build(String nome, IDSoggetto soggettoReferente, Integer versione) {
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.setNome(nome);
        idAccordo.setSoggettoReferente(soggettoReferente);
        idAccordo.setVersione(versione);
        return idAccordo;
    }

    public String normalizeUri(String uri) throws DriverRegistroServiziException {
        IDAccordo idAccordo = this.getIDAccordoFromUri(uri);
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromIDAccordo(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("IDAccordo non fornito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("Nome accordo non fornito");
        }
        IDSoggetto soggettoReferente = idAccordo.getSoggettoReferente();
        if (soggettoReferente != null) {
            if (soggettoReferente.getTipo() == null) {
                throw new DriverRegistroServiziException("Tipo soggetto referente non fornito?");
            }
            if (soggettoReferente.getNome() == null) {
                throw new DriverRegistroServiziException("Nome soggetto referente non fornito?");
            }
        }
        if (soggettoReferente != null) {
            return soggettoReferente.toString() + ":" + idAccordo.getNome() + ":" + idAccordo.getVersione();
        }
        return idAccordo.getNome() + ":" + idAccordo.getVersione();
    }

    public String getUriFromAccordo(AccordoServizioParteComune accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromAccordo(AccordoServizioParteComuneSintetico accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, Integer ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        IDAccordo idAccordo = this.build(nomeAS, soggettoReferente, ver);
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromValues(String nomeAS, IDSoggetto soggettoReferente, Integer ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        if (soggettoReferente == null) {
            return this.getUriFromValues(nomeAS, null, null, ver);
        }
        return this.getUriFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }

    public IDAccordo getIDAccordoFromUri(String uriAccordo) throws DriverRegistroServiziException {
        try {
            if (uriAccordo == null) {
                throw new DriverRegistroServiziException("Uri accordo non fornita");
            }
            int primoMarcatore = uriAccordo.indexOf(":");
            int secondoMarcatore = -1;
            if (primoMarcatore >= 0) {
                secondoMarcatore = uriAccordo.indexOf(":", primoMarcatore + 1);
            }
            int terzoMarcatore = -1;
            if (secondoMarcatore > 0 && (terzoMarcatore = uriAccordo.indexOf(":", secondoMarcatore + 1)) > 0) {
                throw new DriverRegistroServiziException("sintassi non corretta, possibili usi: nomeAccordo  nomeAccordo:versione  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
            }
            if (primoMarcatore < 0) {
                return this.build(uriAccordo, null, 1);
            }
            String tmp1 = null;
            String tmp2 = null;
            String tmp3 = null;
            if (primoMarcatore >= 0 && secondoMarcatore > 0) {
                tmp1 = uriAccordo.substring(0, primoMarcatore);
                tmp2 = uriAccordo.substring(primoMarcatore + 1, secondoMarcatore);
                tmp3 = uriAccordo.substring(secondoMarcatore + 1, uriAccordo.length());
                int versione = 1;
                try {
                    versione = Integer.parseInt(tmp3);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("sintassi della versione non corretta: " + e.getMessage(), e);
                }
                int divisorioSoggettoReferente = tmp1.indexOf("/");
                if (divisorioSoggettoReferente <= 0) {
                    throw new DriverRegistroServiziException("sintassi del soggetto referente non corretta, l'uri deve essere definita con la seguente forma: tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
                }
                String tipoSoggettoReferente = tmp1.substring(0, divisorioSoggettoReferente);
                String nomeSoggettoReferente = tmp1.substring(divisorioSoggettoReferente + 1, tmp1.length());
                return this.build(tmp2, new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente), versione);
            }
            tmp1 = uriAccordo.substring(0, primoMarcatore);
            tmp2 = uriAccordo.substring(primoMarcatore + 1, uriAccordo.length());
            int divisorioSoggettoReferente = tmp1.indexOf("/");
            if (divisorioSoggettoReferente < 0) {
                int versione = 1;
                try {
                    versione = Integer.parseInt(tmp2);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("sintassi della versione non corretta: " + e.getMessage(), e);
                }
                return this.build(tmp1, null, versione);
            }
            if (divisorioSoggettoReferente == 0) {
                throw new DriverRegistroServiziException("sintassi non corretta, possibili usi: nomeAccordo  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo  nomeAccordo:versione  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
            }
            String tipoSoggettoReferente = tmp1.substring(0, divisorioSoggettoReferente);
            String nomeSoggettoReferente = tmp1.substring(divisorioSoggettoReferente + 1, tmp1.length());
            return this.build(tmp2, new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente), 1);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Parsing uriAccordo[" + uriAccordo + "] non riusciuto: " + e.getMessage());
        }
    }

    public IDAccordo getIDAccordoFromAccordo(AccordoServizioParteComune accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        return this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
    }

    public IDAccordo getIDAccordoFromAccordo(AccordoServizioParteComuneSintetico accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        return this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
    }

    public IDAccordo getIDAccordoFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, Integer ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        return this.build(nomeAS, soggettoReferente, ver);
    }

    public IDAccordo getIDAccordoFromValuesWithoutCheck(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, Integer ver) {
        IDSoggetto soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        return this.build(nomeAS, soggettoReferente, ver);
    }

    public IDAccordo getIDAccordoFromValues(String nomeAS, IDSoggetto soggettoReferente, Integer ver) throws DriverRegistroServiziException {
        if (soggettoReferente == null) {
            return this.getIDAccordoFromValues(nomeAS, null, null, ver);
        }
        return this.getIDAccordoFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }
}

