/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.registry.constants.ParameterType;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiExistsDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiExistsDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComune(idAccordo)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            if (idAccordo.getSoggettoReferente() != null && !this.driver.existsSoggetto(connection, idAccordo.getSoggettoReferente())) {
                boolean e = false;
                return e;
            }
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, connection, this.driver.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            this.driver.closeConnection(connection);
        }
    }

    protected boolean existsAccordoServizioParteComune(long idAccordo) throws DriverRegistroServiziException {
        boolean bl;
        ResultSet rs;
        PreparedStatement stm;
        Connection connection;
        block9: {
            connection = null;
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            stm = null;
            rs = null;
            if (this.driver.atomica) {
                try {
                    connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComune(longId)");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                connection = this.driver.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            rs = stm.executeQuery();
            if (!rs.next()) break block9;
            boolean bl2 = true;
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(connection);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return bl;
    }

    protected boolean existsAccordoServizioParteComuneAzione(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComuneAzione(nome,idAccordo)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        try {
            boolean e = this.existsAccordoServizioParteComuneAzione(nome, DBUtils.getIdAccordoServizioParteComune(idAccordo, connection, this.driver.tipoDB));
            return e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            this.driver.closeConnection(connection);
        }
    }

    protected boolean existsAccordoServizioParteComuneAzione(String nome, long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComuneAzione(nome,longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioParteComuneAzione(long idAzione) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComuneAzione(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioParteComunePorttype(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComunePorttype(nome,idAccordo)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttype] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        try {
            boolean e = this.existsAccordoServizioParteComunePorttype(nome, DBUtils.getIdAccordoServizioParteComune(idAccordo, connection, this.driver.tipoDB));
            return e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            this.driver.closeConnection(connection);
        }
    }

    protected boolean existsAccordoServizioParteComuneOperation(long idAzione) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComuneOperation(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneOperation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioParteComunePorttype(String nome, long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComunePorttype(nome,longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttype] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioParteComunePorttypeOperation(String nome, IDPortType idPortType) throws DriverRegistroServiziException {
        Connection connection;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComunePorttypeOperation(nome,idPortType)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttypeOperation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        try {
            long idAccordo = DBUtils.getIdAccordoServizioParteComune(idPortType.getIdAccordo(), connection, this.driver.tipoDB);
            boolean bl = this.existsAccordoServizioParteComunePorttypeOperation(nome, DBUtils.getIdPortType(idAccordo, idPortType.getNome(), connection));
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            this.driver.closeConnection(connection);
        }
    }

    protected boolean existsAccordoServizioParteComunePorttypeOperation(String nome, long idPortType) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComunePorttypeOperation(nome,longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttypeOperation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idPortType);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioParteComuneResource(String nome, long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComuneResource(nome,idAccordo)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneResource] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioParteComuneResource(String httpMethod, String path, long idAccordo, String excludeResourceWithName) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioParteComuneResource(httpMethod,path,idAccordo)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneResource] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("http_method = ?");
            sqlQueryObject.addWhereCondition("path = ?");
            if (excludeResourceWithName != null && !"".equals(excludeResourceWithName)) {
                sqlQueryObject.addWhereCondition("nome <> ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            if (httpMethod == null || "".equals(httpMethod)) {
                stm.setString(2, "ALL");
            } else {
                stm.setString(2, httpMethod);
            }
            if (path == null || "".equals(path)) {
                stm.setString(3, "*");
            } else {
                stm.setString(3, path);
            }
            if (excludeResourceWithName != null && !"".equals(excludeResourceWithName)) {
                stm.setString(4, excludeResourceWithName);
            }
            if ((rs = stm.executeQuery()).next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioResourceResponse(long idRisorsa, int httpStatus) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioResourceResponse(idRisorsa,httpStatus)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioResourceResponse] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources_response");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_resource = ?");
            sqlQueryObject.addWhereCondition("status = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idRisorsa);
            stm.setInt(2, httpStatus);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioResourceRepresentation(Long idRisorsa, boolean isRequest, Long idResponse, String mediaType) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioResourceRepresentation(idRisorsa,isRequest,idResponse,mediaType)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioResourceRepresentation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources_media");
            sqlQueryObject.addSelectField("*");
            if (isRequest) {
                sqlQueryObject.addWhereCondition("id_resource_media = ?");
            } else {
                sqlQueryObject.addWhereCondition("id_resource_response_media = ?");
            }
            sqlQueryObject.addWhereCondition("media_type = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            if (isRequest) {
                stm.setLong(1, idRisorsa);
            } else {
                stm.setLong(1, idResponse);
            }
            stm.setString(2, mediaType);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected boolean existsAccordoServizioResourceParameter(Long idRisorsa, boolean isRequest, Long idResponse, ParameterType tipo, String nome) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoServizioResourceRepresentation(idRisorsa,isRequest,idResponse,tipo,nome)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioResourceRepresentation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources_parameter");
            sqlQueryObject.addSelectField("*");
            if (isRequest) {
                sqlQueryObject.addWhereCondition("id_resource_parameter = ?");
            } else {
                sqlQueryObject.addWhereCondition("id_resource_response_par = ?");
            }
            sqlQueryObject.addWhereCondition("tipo_parametro = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            if (isRequest) {
                stm.setLong(1, idRisorsa);
            } else {
                stm.setLong(1, idResponse);
            }
            stm.setString(2, tipo.toString());
            stm.setString(3, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }
}

