/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_protocolPropertiesDriver;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiFindAllDriver {
    private DriverRegistroServiziDB driver = null;
    private DriverRegistroServiziDB_protocolPropertiesDriver protocolPropertiesDriver = null;

    protected DriverRegistroServiziDB_accordiFindAllDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
        this.protocolPropertiesDriver = new DriverRegistroServiziDB_protocolPropertiesDriver(driver);
    }

    protected List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordo> list = new ArrayList<IDAccordo>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAccordiServizioParteComune", filtroRicerca, null, null, null, null, list);
        return list;
    }

    protected List<IDPortType> getAllIdPortType(FiltroRicercaPortTypes filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortType> list = new ArrayList<IDPortType>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdPortType", filtroRicerca, filtroRicerca, null, null, null, list);
        return list;
    }

    protected List<IDPortTypeAzione> getAllIdAzionePortType(FiltroRicercaOperations filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortTypeAzione> list = new ArrayList<IDPortTypeAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzionePortType", filtroRicerca, null, filtroRicerca, null, null, list);
        return list;
    }

    protected List<IDAccordoAzione> getAllIdAzioneAccordo(FiltroRicercaAzioni filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordoAzione> list = new ArrayList<IDAccordoAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzioneAccordo", filtroRicerca, null, null, filtroRicerca, null, list);
        return list;
    }

    protected List<IDResource> getAllIdResource(FiltroRicercaResources filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDResource> list = new ArrayList<IDResource>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdResource", filtroRicerca, null, null, null, filtroRicerca, list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> void _fillAllIdAccordiServizioParteComuneEngine(String nomeMetodo, FiltroRicercaAccordi filtroRicercaBase, FiltroRicercaPortTypes filtroPT, FiltroRicercaOperations filtroOP, FiltroRicercaAzioni filtroAZ, FiltroRicercaResources filtroResource, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        this.driver.logDebug(nomeMetodo + "...");
        if (listReturn == null) {
            throw new DriverRegistroServiziException("Lista per collezionare i risultati non definita");
        }
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource(nomeMetodo) : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            List<String> tipoSoggettiProtocollo = null;
            try {
                if (filtroRicercaBase != null && (filtroRicercaBase.getProtocollo() != null || filtroRicercaBase.getProtocolli() != null && !filtroRicercaBase.getProtocolli().isEmpty())) {
                    tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filtroRicercaBase.getProtocollo(), Filtri.convertToString(filtroRicercaBase.getProtocolli()));
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            boolean searchByTipoSoggetto = tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0;
            sqlQueryObject.addFromTable("accordi");
            if (filtroRicercaBase != null && (searchByTipoSoggetto || filtroRicercaBase.getTipoSoggettoReferente() != null || filtroRicercaBase.getNomeSoggettoReferente() != null)) {
                sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            }
            if (filtroPT != null) {
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addWhereCondition("accordi.id=port_type.id_accordo");
            }
            if (filtroOP != null) {
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addWhereCondition("accordi.id=port_type.id_accordo");
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("port_type.id=port_type_azioni.id_port_type");
            }
            if (filtroAZ != null) {
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addWhereCondition("accordi.id=accordi_azioni.id_accordo");
            }
            if (filtroResource != null) {
                sqlQueryObject.addFromTable("api_resources");
                sqlQueryObject.addWhereCondition("accordi.id=api_resources.id_accordo");
            }
            if (filtroRicercaBase != null && filtroRicercaBase.getIdGruppo() != null && filtroRicercaBase.getIdGruppo().getNome() != null) {
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addFromTable("accordi_gruppi");
                sqlQueryObject.addWhereCondition("gruppi.id=accordi_gruppi.id_gruppo");
                sqlQueryObject.addWhereCondition("accordi.id=accordi_gruppi.id_accordo");
            }
            sqlQueryObject.addSelectAliasField("accordi", "nome", "nomeAccordo");
            sqlQueryObject.addSelectField("accordi", "versione");
            sqlQueryObject.addSelectField("accordi", "id_referente");
            if (filtroPT != null) {
                sqlQueryObject.addSelectAliasField("port_type", "nome", "nomePT");
            }
            if (filtroOP != null) {
                sqlQueryObject.addSelectAliasField("port_type", "nome", "nomePT");
                sqlQueryObject.addSelectAliasField("port_type_azioni", "nome", "nomeOP");
            }
            if (filtroAZ != null) {
                sqlQueryObject.addSelectAliasField("accordi_azioni", "nome", "nomeAZ");
            }
            if (filtroResource != null) {
                sqlQueryObject.addSelectAliasField("api_resources", "nome", "nomeResource");
            }
            sqlQueryObject.setSelectDistinct(true);
            if (filtroRicercaBase != null && filtroRicercaBase.isOrder()) {
                sqlQueryObject.addOrderBy("nomeAccordo");
                sqlQueryObject.addOrderBy("versione");
                if (searchByTipoSoggetto) {
                    sqlQueryObject.addSelectAliasField(this.driver.tabellaSoggetti, "tipo_soggetto", "tipoSoggettoReferente");
                    sqlQueryObject.addSelectAliasField(this.driver.tabellaSoggetti, "nome_soggetto", "nomeSoggettoReferente");
                    sqlQueryObject.addOrderBy("tipoSoggettoReferente");
                    sqlQueryObject.addOrderBy("nomeSoggettoReferente");
                }
                if (filtroPT != null) {
                    sqlQueryObject.addOrderBy("nomePT");
                } else if (filtroOP != null) {
                    sqlQueryObject.addOrderBy("nomePT");
                    sqlQueryObject.addOrderBy("nomeOP");
                } else if (filtroAZ != null) {
                    sqlQueryObject.addOrderBy("nomeAZ");
                } else if (filtroResource != null) {
                    sqlQueryObject.addOrderBy("nomeResource");
                }
            }
            if (filtroRicercaBase != null) {
                ISQLQueryObject sqlQueryObjectASComposti;
                if (filtroRicercaBase.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi.ora_registrazione > ?");
                }
                if (filtroRicercaBase.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi.ora_registrazione < ?");
                }
                if (filtroRicercaBase.getNomeAccordo() != null) {
                    sqlQueryObject.addWhereCondition("accordi.nome = ?");
                }
                if (filtroRicercaBase.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("accordi.versione = ?");
                }
                if (searchByTipoSoggetto || filtroRicercaBase.getTipoSoggettoReferente() != null || filtroRicercaBase.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition("accordi.id_referente=" + this.driver.tabellaSoggetti + ".id");
                    if (filtroRicercaBase.getTipoSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".tipo_soggetto=?");
                    } else if (searchByTipoSoggetto) {
                        sqlQueryObject.addWhereINCondition(this.driver.tabellaSoggetti + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                    }
                    if (filtroRicercaBase.getNomeSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".nome_soggetto=?");
                    }
                }
                if (filtroRicercaBase.getServiceBinding() != null) {
                    sqlQueryObject.addWhereCondition("accordi.service_binding = ?");
                }
                if (filtroRicercaBase.getIdGruppo() != null && filtroRicercaBase.getIdGruppo().getNome() != null) {
                    sqlQueryObject.addWhereCondition("gruppi.nome = ?");
                }
                if (filtroRicercaBase.getIdAccordoCooperazione() != null && (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null || filtroRicercaBase.getIdAccordoCooperazione().getSoggettoReferente() != null || filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null)) {
                    sqlQueryObjectASComposti = sqlQueryObject.newSQLQueryObject();
                    sqlQueryObjectASComposti.addFromTable("acc_serv_composti");
                    sqlQueryObjectASComposti.addFromTable("accordi_cooperazione");
                    sqlQueryObjectASComposti.addSelectField("acc_serv_composti.id");
                    sqlQueryObjectASComposti.setANDLogicOperator(true);
                    sqlQueryObjectASComposti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
                    sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.id=acc_serv_composti.id_accordo_cooperazione");
                    if (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null) {
                        sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.nome=?");
                    }
                    if (filtroRicercaBase.getIdAccordoCooperazione().getSoggettoReferente() != null) {
                        sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.id_referente=?");
                    }
                    if (filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null) {
                        sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.versione=?");
                    }
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectASComposti);
                } else if (filtroRicercaBase.isServizioComposto() != null) {
                    sqlQueryObjectASComposti = sqlQueryObject.newSQLQueryObject();
                    sqlQueryObjectASComposti.addFromTable("acc_serv_composti");
                    sqlQueryObjectASComposti.addSelectField("id");
                    sqlQueryObjectASComposti.setANDLogicOperator(true);
                    sqlQueryObjectASComposti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
                    sqlQueryObject.addWhereExistsCondition(filtroRicercaBase.isServizioComposto() == false, sqlQueryObjectASComposti);
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroRicercaBase, "accordi");
            }
            if (filtroPT != null) {
                if (filtroPT.getNomePortType() != null) {
                    sqlQueryObject.addWhereCondition("port_type.nome=?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroPT, "port_type");
            }
            if (filtroOP != null) {
                if (filtroOP.getNomePortType() != null) {
                    sqlQueryObject.addWhereCondition("port_type.nome=?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroOP, "port_type");
                if (filtroOP.getNomeAzione() != null) {
                    sqlQueryObject.addWhereCondition("port_type_azioni.nome=?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroOP, "port_type_azioni");
            }
            if (filtroAZ != null) {
                if (filtroAZ.getNomeAzione() != null) {
                    sqlQueryObject.addWhereCondition("accordi_azioni.nome=?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroAZ, "accordi_azioni");
            }
            if (filtroResource != null) {
                if (filtroResource.getResourceName() != null) {
                    sqlQueryObject.addWhereCondition("api_resources.nome=?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroResource, "api_resources");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicercaBase != null) {
                if (filtroRicercaBase.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + filtroRicercaBase.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicercaBase.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicercaBase.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + filtroRicercaBase.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicercaBase.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicercaBase.getNomeAccordo() != null) {
                    this.driver.logDebug("nomeAccordo stmt.setString(" + filtroRicercaBase.getNomeAccordo() + ")");
                    stm.setString(indexStmt, filtroRicercaBase.getNomeAccordo());
                    ++indexStmt;
                }
                if (filtroRicercaBase.getVersione() != null) {
                    this.driver.logDebug("versioneAccordo stmt.setString(" + filtroRicercaBase.getVersione() + ")");
                    stm.setInt(indexStmt, filtroRicercaBase.getVersione());
                    ++indexStmt;
                }
                if (filtroRicercaBase.getTipoSoggettoReferente() != null || filtroRicercaBase.getNomeSoggettoReferente() != null) {
                    if (filtroRicercaBase.getTipoSoggettoReferente() != null) {
                        this.driver.logDebug("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicercaBase.getTipoSoggettoReferente() + ")");
                        stm.setString(indexStmt, filtroRicercaBase.getTipoSoggettoReferente());
                        ++indexStmt;
                    }
                    if (filtroRicercaBase.getNomeSoggettoReferente() != null) {
                        this.driver.logDebug("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicercaBase.getNomeSoggettoReferente() + ")");
                        stm.setString(indexStmt, filtroRicercaBase.getNomeSoggettoReferente());
                        ++indexStmt;
                    }
                }
                if (filtroRicercaBase.getServiceBinding() != null) {
                    this.driver.logDebug("serviceBinding stmt.setString(" + filtroRicercaBase.getServiceBinding().getValue() + ")");
                    stm.setString(indexStmt, filtroRicercaBase.getServiceBinding().getValue());
                    ++indexStmt;
                }
                if (filtroRicercaBase.getIdGruppo() != null && filtroRicercaBase.getIdGruppo().getNome() != null) {
                    this.driver.logDebug("gruppo stmt.setString(" + filtroRicercaBase.getIdGruppo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicercaBase.getIdGruppo().getNome());
                    ++indexStmt;
                }
                if (filtroRicercaBase.getIdAccordoCooperazione() != null && (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null || filtroRicercaBase.getIdAccordoCooperazione().getSoggettoReferente() != null || filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null)) {
                    if (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null) {
                        this.driver.logDebug("nomeAccordoCooperazione stmt.setString(" + filtroRicercaBase.getIdAccordoCooperazione().getNome() + ")");
                        stm.setString(indexStmt, filtroRicercaBase.getIdAccordoCooperazione().getNome());
                        ++indexStmt;
                    }
                    if (filtroRicercaBase.getIdAccordoCooperazione().getSoggettoReferente() != null) {
                        long idReferenteAccordoCooperazione = DBUtils.getIdSoggetto(filtroRicercaBase.getIdAccordoCooperazione().getSoggettoReferente().getNome(), filtroRicercaBase.getIdAccordoCooperazione().getSoggettoReferente().getTipo(), con, this.driver.tipoDB, this.driver.tabellaSoggetti);
                        this.driver.logDebug("referenteAccordoCooperazione stmt.setLong(" + idReferenteAccordoCooperazione + ")");
                        stm.setLong(indexStmt, idReferenteAccordoCooperazione);
                        ++indexStmt;
                    }
                    if (filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null) {
                        this.driver.logDebug("versioneAccordoCooperazione stmt.setString(" + filtroRicercaBase.getIdAccordoCooperazione().getVersione() + ")");
                        stm.setInt(indexStmt, filtroRicercaBase.getIdAccordoCooperazione().getVersione());
                        ++indexStmt;
                    }
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroRicercaBase, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE);
            }
            if (filtroPT != null) {
                if (filtroPT.getNomePortType() != null) {
                    stm.setString(indexStmt, filtroPT.getNomePortType());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroPT, ProprietariProtocolProperty.PORT_TYPE);
            }
            if (filtroOP != null) {
                if (filtroOP.getNomePortType() != null) {
                    stm.setString(indexStmt, filtroOP.getNomePortType());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroOP, ProprietariProtocolProperty.PORT_TYPE);
                if (filtroOP.getNomeAzione() != null) {
                    stm.setString(indexStmt, filtroOP.getNomeAzione());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroOP, ProprietariProtocolProperty.OPERATION);
            }
            if (filtroAZ != null) {
                if (filtroAZ.getNomeAzione() != null) {
                    stm.setString(indexStmt, filtroAZ.getNomeAzione());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroAZ, ProprietariProtocolProperty.AZIONE_ACCORDO);
            }
            if (filtroResource != null) {
                if (filtroResource.getResourceName() != null) {
                    stm.setString(indexStmt, filtroResource.getResourceName());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroResource, ProprietariProtocolProperty.RESOURCE);
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                Cloneable idAzione;
                long idReferente = rs.getLong("id_referente");
                IDSoggetto idSoggettoReferente = null;
                Exception excp = null;
                if (idReferente > 0L) {
                    try {
                        idSoggettoReferente = this.driver.getIdSoggetto(idReferente, con);
                        if (idSoggettoReferente == null) {
                            throw new DriverRegistroServiziNotFound("non esiste");
                        }
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                        try {
                            excp = new Exception("Soggetto referente [" + idReferente + "] presente nell'accordo [" + rs.getString("nome") + "] (versione [" + rs.getInt("versione") + "]) non presente?");
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (stm != null) {
                                    stm.close();
                                    stm = null;
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (excp != null) {
                    throw excp;
                }
                if (rs == null) {
                    throw new Exception("Ricerca referente non riuscita");
                }
                IDAccordo idAccordo = this.driver.idAccordoFactory.getIDAccordoFromValues(rs.getString("nomeAccordo"), idSoggettoReferente, rs.getInt("versione"));
                if (filtroPT != null) {
                    IDPortType idPT = new IDPortType();
                    idPT.setIdAccordo(idAccordo);
                    idPT.setNome(rs.getString("nomePT"));
                    listReturn.add(idPT);
                    continue;
                }
                if (filtroOP != null) {
                    idAzione = new IDPortTypeAzione();
                    IDPortType idPT = new IDPortType();
                    idPT.setIdAccordo(idAccordo);
                    idPT.setNome(rs.getString("nomePT"));
                    ((IDPortTypeAzione)idAzione).setIdPortType(idPT);
                    ((IDPortTypeAzione)idAzione).setNome(rs.getString("nomeOP"));
                    listReturn.add(idAzione);
                    continue;
                }
                if (filtroAZ != null) {
                    idAzione = new IDAccordoAzione();
                    ((IDAccordoAzione)idAzione).setIdAccordo(idAccordo);
                    ((IDAccordoAzione)idAzione).setNome(rs.getString("nomeAZ"));
                    listReturn.add(idAzione);
                    continue;
                }
                if (filtroResource != null) {
                    IDResource idResource = new IDResource();
                    idResource.setIdAccordo(idAccordo);
                    idResource.setNome(rs.getString("nomeResource"));
                    listReturn.add(idResource);
                    continue;
                }
                listReturn.add(idAccordo);
            }
            if (listReturn.size() <= 0) {
                String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                if (filtroPT != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroPT.toString());
                }
                if (filtroOP != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroOP.toString());
                }
                if (filtroAZ != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroAZ.toString());
                }
                if (filtroResource != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroResource.toString());
                }
                if (filtroRicercaBase == null) throw new DriverRegistroServiziNotFound("Elementi non trovati");
                throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicercaBase.toString());
            }
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException(nomeMetodo + " error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
    }
}

