/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_connettoriLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiParteSpecificaLIB {
    public static long CRUDAccordoServizioParteSpecifica(int type, AccordoServizioParteSpecifica asps, Connection con, String tipoDatabase, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] asps non valido.");
        }
        String nomeProprietario = asps.getNomeSoggettoErogatore();
        String tipoProprietario = asps.getTipoSoggettoErogatore();
        String nomeServizio = asps.getNome();
        String tipoServizio = asps.getTipo();
        Integer versioneServizio = asps.getVersione();
        String descrizione = asps.getDescrizione();
        String stato = asps.getStatoPackage();
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Nome Proprietario non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Tipo Proprietario non valido.");
        }
        if (nomeServizio == null || nomeServizio.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Nome Servizio non valido.");
        }
        if (tipoServizio == null || tipoServizio.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Tipo Servizio non valido.");
        }
        if (versioneServizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Versione Servizio non valido.");
        }
        Connettore connettore = null;
        if (asps.getConfigurazioneServizio() != null) {
            connettore = asps.getConfigurazioneServizio().getConnettore();
        }
        String wsdlImplementativoErogatore = asps.getByteWsdlImplementativoErogatore() != null ? new String(asps.getByteWsdlImplementativoErogatore()) : null;
        String wsdlImplementativoFruitore = asps.getByteWsdlImplementativoFruitore() != null ? new String(asps.getByteWsdlImplementativoFruitore()) : null;
        wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replace("\n", "")) ? wsdlImplementativoErogatore : null;
        wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replace("\n", "")) ? wsdlImplementativoFruitore : null;
        String superUser = asps.getSuperUser();
        StatoFunzionalita servizioCorrelato = TipologiaServizio.CORRELATO.equals(asps.getTipologiaServizio()) ? CostantiRegistroServizi.ABILITATO : CostantiRegistroServizi.DISABILITATO;
        String portType = asps.getPortType() != null ? asps.getPortType() : null;
        long idSoggetto = -1L;
        long idAccordoLong = -1L;
        try {
            if (type != 3) {
                String uriAccordo = asps.getAccordoServizioParteComune();
                if (uriAccordo == null || uriAccordo.equals("")) {
                    throw new DriverRegistroServiziException("L'uri dell'Accordo di Servizio non puo essere null.");
                }
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordo);
                idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, DriverRegistroServiziDB_LIB.tipoDB);
            }
        }
        catch (Exception e) {
            DriverRegistroServiziDB_LIB.logError("Driver Error for get IDAccordo nome:[" + asps.getAccordoServizioParteComune() + "].", e);
            throw new DriverRegistroServiziException(e);
        }
        try {
            String nomeS = nomeProprietario;
            String tipoS = tipoProprietario;
            idSoggetto = DBUtils.getIdSoggetto(nomeS, tipoS, con, DriverRegistroServiziDB_LIB.tipoDB);
        }
        catch (CoreException e) {
            DriverRegistroServiziDB_LIB.logError("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] getIdSoggetto failed: " + e.getMessage(), e);
            throw new DriverRegistroServiziException(e);
        }
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametri non validi. Impossibile risalire all'id del soggettoo");
        }
        if (idAccordoLong <= 0L && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametri non validi. Impossibile risalire all'id dell'accordo");
        }
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Il Connettore non puo essere nullo.");
        }
        PreparedStatement updateStmt = null;
        ResultSet updateRS = null;
        String updateQuery = "";
        try {
            long idServizio = 0L;
            int n = 0;
            int sizeFruitori = 0;
            int sizeAzioni = 0;
            asps.setIdAccordo(idAccordoLong);
            switch (type) {
                case 1: {
                    Documento doc;
                    int i;
                    int i2;
                    if (connettore == null) {
                        connettore = new Connettore();
                        connettore.setNome("CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio + "/" + versioneServizio);
                    }
                    if (connettore.getNome() == null || connettore.getNome().equals("")) {
                        connettore.setNome("CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio + "/" + versioneServizio);
                    }
                    long idConnettore = DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(1, connettore, con, driverBYOK);
                    String utenteRichiedente = null;
                    utenteRichiedente = asps.getProprietaOggetto() != null && asps.getProprietaOggetto().getUtenteRichiedente() != null ? asps.getProprietaOggetto().getUtenteRichiedente() : superUser;
                    Timestamp dataCreazione = null;
                    dataCreazione = asps.getProprietaOggetto() != null && asps.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(asps.getProprietaOggetto().getDataCreazione().getTime()) : (asps.getOraRegistrazione() != null ? new Timestamp(asps.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("servizi");
                    sqlQueryObject.addInsertField("nome_servizio", "?");
                    sqlQueryObject.addInsertField("tipo_servizio", "?");
                    sqlQueryObject.addInsertField("versione_servizio", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("servizio_correlato", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_fruitore", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    sqlQueryObject.addInsertField("privato", "?");
                    sqlQueryObject.addInsertField("port_type", "?");
                    sqlQueryObject.addInsertField("profilo", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    if (stato != null) {
                        sqlQueryObject.addInsertField("stato", "?");
                    }
                    if (asps.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addInsertField("message_type", "?");
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nomeServizio);
                    updateStmt.setString(index++, tipoServizio);
                    updateStmt.setInt(index++, versioneServizio);
                    updateStmt.setLong(index++, idSoggetto);
                    updateStmt.setLong(index++, idAccordoLong);
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(servizioCorrelato));
                    updateStmt.setLong(index++, idConnettore);
                    updateStmt.setString(index++, wsdlImplementativoErogatore);
                    updateStmt.setString(index++, wsdlImplementativoFruitore);
                    updateStmt.setString(index++, superUser);
                    if (asps.getPrivato() != null && asps.getPrivato().booleanValue()) {
                        updateStmt.setInt(index++, 1);
                    } else {
                        updateStmt.setInt(index++, 0);
                    }
                    updateStmt.setString(index++, portType);
                    updateStmt.setString(index++, asps.getVersioneProtocollo());
                    updateStmt.setString(index++, descrizione);
                    if (stato != null) {
                        updateStmt.setString(index++, stato);
                    }
                    if (asps.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(asps.getOraRegistrazione().getTime()));
                    }
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(asps.getMessageType()));
                    if (utenteRichiedente != null) {
                        updateStmt.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        updateStmt.setTimestamp(index++, dataCreazione);
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecifica CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, versioneServizio, idSoggetto, idAccordoLong, servizioCorrelato, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore, superUser));
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("servizi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_servizio = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("versione_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLQuery();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nomeServizio);
                    updateStmt.setString(2, tipoServizio);
                    updateStmt.setInt(3, versioneServizio);
                    updateStmt.setLong(4, idSoggetto);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecifica recupero l'id del servizio appena creato : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto));
                    updateRS = updateStmt.executeQuery();
                    if (updateRS.next()) {
                        idServizio = updateRS.getLong("id");
                    }
                    updateRS.close();
                    updateStmt.close();
                    if (idServizio <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(addFruitore)] id servizio non recuperato");
                    }
                    asps.setId(idServizio);
                    sizeFruitori = asps.sizeFruitoreList();
                    Fruitore fruitore = null;
                    for (i2 = 0; i2 < sizeFruitori; ++i2) {
                        fruitore = asps.getFruitore(i2);
                        DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaFruitore(1, fruitore, con, asps, driverBYOK);
                    }
                    if (asps.getConfigurazioneServizio() != null) {
                        sizeAzioni = asps.getConfigurazioneServizio().sizeConfigurazioneAzioneList();
                        for (i2 = 0; i2 < sizeAzioni; ++i2) {
                            ConfigurazioneServizioAzione conf = asps.getConfigurazioneServizio().getConfigurazioneAzione(i2);
                            DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaAzioni(1, conf, con, asps, driverBYOK);
                        }
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < asps.sizeAllegatoList(); ++i) {
                        doc = asps.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
                        doc = asps.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
                        doc = asps.getSpecificaLivelloServizio(i);
                        doc.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                        doc = asps.getSpecificaSicurezza(i);
                        doc.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                        documenti.add(doc);
                    }
                    DriverRegistroServiziDB_documentiLIB.CRUDDocumento(1, documenti, idServizio, ProprietariDocumento.servizio, con, tipoDatabase);
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(1, asps.getProtocolPropertyList(), idServizio, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
                    break;
                }
                case 2: {
                    Documento doc;
                    int i;
                    String oldNomeSoggetto = null;
                    String oldTipoSoggetto = null;
                    String oldNomeServizio = null;
                    String oldTipoServizio = null;
                    Integer oldVersioneServizio = null;
                    if (asps.getOldIDServizioForUpdate() != null) {
                        if (asps.getOldIDServizioForUpdate().getSoggettoErogatore() != null) {
                            oldNomeSoggetto = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                            oldTipoSoggetto = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo();
                        }
                        oldNomeServizio = asps.getOldIDServizioForUpdate().getNome();
                        oldTipoServizio = asps.getOldIDServizioForUpdate().getTipo();
                        oldVersioneServizio = asps.getOldIDServizioForUpdate().getVersione();
                    }
                    if (oldNomeServizio == null || oldNomeServizio.equals("")) {
                        oldNomeServizio = nomeServizio;
                    }
                    if (oldTipoServizio == null || oldTipoServizio.equals("")) {
                        oldTipoServizio = tipoServizio;
                    }
                    if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                        oldNomeSoggetto = nomeProprietario;
                    }
                    if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                        oldTipoSoggetto = tipoProprietario;
                    }
                    if (oldVersioneServizio == null) {
                        oldVersioneServizio = versioneServizio;
                    }
                    if ((idServizio = DBUtils.getIdServizio(oldNomeServizio, oldTipoServizio, oldVersioneServizio, oldNomeSoggetto, oldTipoSoggetto, con, DriverRegistroServiziDB_LIB.tipoDB)) <= 0L) {
                        idServizio = DBUtils.getIdServizio(oldNomeServizio, oldTipoServizio, oldVersioneServizio, nomeProprietario, tipoProprietario, con, DriverRegistroServiziDB_LIB.tipoDB);
                    }
                    if (idServizio <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(UPDATE)] Id Servizio non valido.");
                    }
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(oldNomeServizio, oldTipoServizio, oldVersioneServizio, oldNomeSoggetto, oldTipoSoggetto, con);
                    if (idConnettore <= 0L) {
                        idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(oldNomeServizio, oldTipoServizio, oldVersioneServizio, nomeProprietario, tipoProprietario, con);
                    }
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] id connettore nullo.");
                    }
                    connettore.setId(idConnettore);
                    String utenteUltimaModifica = null;
                    utenteUltimaModifica = asps.getProprietaOggetto() != null && asps.getProprietaOggetto().getUtenteUltimaModifica() != null ? asps.getProprietaOggetto().getUtenteUltimaModifica() : superUser;
                    Timestamp dataUltimaModifica = null;
                    if (asps.getProprietaOggetto() != null && asps.getProprietaOggetto().getDataUltimaModifica() != null) {
                        dataUltimaModifica = new Timestamp(asps.getProprietaOggetto().getDataUltimaModifica().getTime());
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("servizi");
                    sqlQueryObject.addUpdateField("nome_servizio", "?");
                    sqlQueryObject.addUpdateField("tipo_servizio", "?");
                    sqlQueryObject.addUpdateField("versione_servizio", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    sqlQueryObject.addUpdateField("id_accordo", "?");
                    sqlQueryObject.addUpdateField("servizio_correlato", "?");
                    sqlQueryObject.addUpdateField("id_connettore", "?");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_fruitore", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("privato", "?");
                    sqlQueryObject.addUpdateField("port_type", "?");
                    sqlQueryObject.addUpdateField("profilo", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    if (stato != null) {
                        sqlQueryObject.addUpdateField("stato", "?");
                    }
                    if (asps.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addUpdateField("message_type", "?");
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nomeServizio);
                    updateStmt.setString(index++, tipoServizio);
                    updateStmt.setInt(index++, versioneServizio);
                    updateStmt.setLong(index++, idSoggetto);
                    updateStmt.setLong(index++, idAccordoLong);
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(servizioCorrelato));
                    updateStmt.setLong(index++, idConnettore);
                    updateStmt.setString(index++, wsdlImplementativoErogatore);
                    updateStmt.setString(index++, wsdlImplementativoFruitore);
                    updateStmt.setString(index++, superUser);
                    if (asps.getPrivato() != null && asps.getPrivato().booleanValue()) {
                        updateStmt.setInt(index++, 1);
                    } else {
                        updateStmt.setInt(index++, 0);
                    }
                    updateStmt.setString(index++, portType);
                    updateStmt.setString(index++, asps.getVersioneProtocollo());
                    updateStmt.setString(index++, descrizione);
                    if (stato != null) {
                        updateStmt.setString(index++, stato);
                    }
                    if (asps.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(asps.getOraRegistrazione().getTime()));
                    }
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(asps.getMessageType()));
                    if (utenteUltimaModifica != null) {
                        updateStmt.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        updateStmt.setTimestamp(index++, dataUltimaModifica);
                    }
                    updateStmt.setLong(index++, idServizio);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecifica UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto, idAccordoLong, servizioCorrelato, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore, superUser, idServizio));
                    String newNomeConnettore = "CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio + "/" + versioneServizio;
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, driverBYOK);
                    sizeFruitori = asps.sizeFruitoreList();
                    Fruitore fruitore = null;
                    ArrayList<Long> idFruitoriEsistenti = new ArrayList<Long>();
                    for (i = 0; i < sizeFruitori; ++i) {
                        fruitore = asps.getFruitore(i);
                        IDServizio idS = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, new IDSoggetto(tipoProprietario, nomeProprietario), versioneServizio);
                        long idFruizione = DBUtils.getIdFruizioneServizio(idS, new IDSoggetto(fruitore.getTipo(), fruitore.getNome()), con, tipoDatabase);
                        int typeFruitore = 1;
                        if (idFruizione > 0L) {
                            typeFruitore = 2;
                        }
                        DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaFruitore(typeFruitore, fruitore, con, asps, driverBYOK);
                        idFruitoriEsistenti.add(DBUtils.getIdSoggetto(fruitore.getNome(), fruitore.getTipo(), con, tipoDatabase));
                    }
                    DriverRegistroServiziDB_accordiParteSpecificaLIB.deleteAllFruitoriServizio(idServizio, idFruitoriEsistenti, con);
                    if (asps.getConfigurazioneServizio() != null) {
                        sizeAzioni = asps.getConfigurazioneServizio().sizeConfigurazioneAzioneList();
                        DriverRegistroServiziDB_accordiParteSpecificaLIB.deleteAllAzioniServizio(idServizio, con);
                        for (i = 0; i < sizeAzioni; ++i) {
                            ConfigurazioneServizioAzione conf = asps.getConfigurazioneServizio().getConfigurazioneAzione(i);
                            DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaAzioni(1, conf, con, asps, driverBYOK);
                        }
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < asps.sizeAllegatoList(); ++i) {
                        doc = asps.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
                        doc = asps.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
                        doc = asps.getSpecificaLivelloServizio(i);
                        doc.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                        doc = asps.getSpecificaSicurezza(i);
                        doc.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                        documenti.add(doc);
                    }
                    DriverRegistroServiziDB_documentiLIB.CRUDDocumento(2, documenti, idServizio, ProprietariDocumento.servizio, con, tipoDatabase);
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(2, asps.getProtocolPropertyList(), idServizio, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
                    break;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject;
                    int i;
                    idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeProprietario, tipoProprietario, con, DriverRegistroServiziDB_LIB.tipoDB);
                    if (idServizio <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(DELETE)] Id Servizio non valido.");
                    }
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(nomeServizio, tipoServizio, versioneServizio, nomeProprietario, tipoProprietario, con);
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(DELETE)] Id Connettore non valido.");
                    }
                    sizeFruitori = asps.sizeFruitoreList();
                    Fruitore fruitore = null;
                    for (i = 0; i < sizeFruitori; ++i) {
                        fruitore = asps.getFruitore(i);
                        DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaFruitore(3, fruitore, con, asps, driverBYOK);
                    }
                    if (asps.getConfigurazioneServizio() != null) {
                        sizeAzioni = asps.getConfigurazioneServizio().sizeConfigurazioneAzioneList();
                        for (i = 0; i < sizeAzioni; ++i) {
                            ConfigurazioneServizioAzione conf = asps.getConfigurazioneServizio().getConfigurazioneAzione(i);
                            DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaAzioni(3, conf, con, asps, driverBYOK);
                        }
                    }
                    DriverRegistroServiziDB_documentiLIB.CRUDDocumento(3, null, idServizio, ProprietariDocumento.servizio, con, tipoDatabase);
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(3, null, idServizio, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
                    if (CostantiDB.isServiziDigestEnabled()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addDeleteTable("servizi_digest_params");
                        sqlQueryObject.addWhereCondition("id_servizio=?");
                        try (PreparedStatement stmt = con.prepareStatement(sqlQueryObject.createSQLDelete());){
                            stmt.setLong(1, idServizio);
                            n = stmt.executeUpdate();
                        }
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("servizi");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idServizio);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n);
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(3, connettore, con, driverBYOK);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecifica CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idServizio));
                }
            }
            long l = n;
            return l;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateRS, updateStmt);
        }
    }

    public static long CRUDAccordoServizioParteSpecificaFruitore(int type, Fruitore fruitore, Connection con, AccordoServizioParteSpecifica servizio, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        PreparedStatement updateStmt = null;
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idServizio = -1L;
        try {
            String tipoServ = servizio.getTipo();
            String nomeServ = servizio.getNome();
            Integer verServ = servizio.getVersione();
            String tipoSogg = servizio.getTipoSoggettoErogatore();
            String nomeSogg = servizio.getNomeSoggettoErogatore();
            idServizio = DBUtils.getIdServizio(nomeServ, tipoServ, verServ, nomeSogg, tipoSogg, con, DriverRegistroServiziDB_LIB.tipoDB);
        }
        catch (CoreException e1) {
            DriverRegistroServiziDB_LIB.logError("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] getIdServizio failed: " + e1.getMessage(), e1);
            throw new DriverRegistroServiziException(e1);
        }
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] ID Servizio non valido.");
        }
        Connettore connettore = fruitore.getConnettore();
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] il connettore non puo essere nullo.");
        }
        String nomeSoggetto = fruitore.getNome();
        String tipoSoggetto = fruitore.getTipo();
        if (nomeSoggetto == null || nomeSoggetto.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] Nome Fruitore non valido.");
        }
        if (tipoSoggetto == null || tipoSoggetto.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] Tipo Fruitore non valido.");
        }
        String stato = fruitore.getStatoPackage();
        String descrizione = fruitore.getDescrizione();
        long idSoggettoFruitore = -1L;
        try {
            idSoggettoFruitore = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, DriverRegistroServiziDB_LIB.tipoDB);
        }
        catch (CoreException e1) {
            DriverRegistroServiziDB_LIB.logError("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] getIdSoggetto failed: " + e1.getMessage(), e1);
            throw new DriverRegistroServiziException(e1);
        }
        if (idSoggettoFruitore <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] Id Soggetto Fruitore non valido.");
        }
        String wsdlImplementativoErogatore = fruitore.getByteWsdlImplementativoErogatore() != null ? new String(fruitore.getByteWsdlImplementativoErogatore()) : null;
        wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
        String wsdlImplementativoFruitore = fruitore.getByteWsdlImplementativoFruitore() != null ? new String(fruitore.getByteWsdlImplementativoFruitore()) : null;
        wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
        long idFruizione = 0L;
        if (1 != type) {
            idFruizione = DriverRegistroServiziDB_LIB.getIdFruizione(idServizio, nomeSoggetto, tipoSoggetto, con);
        }
        long idConnettore = 0L;
        long n = 0L;
        try {
            switch (type) {
                case 1: {
                    if (connettore == null) {
                        connettore = new Connettore();
                    }
                    connettore.setNome("CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + "_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome() + "/" + servizio.getVersione());
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(1, connettore, con, driverBYOK);
                    idConnettore = connettore.getId();
                    String utenteRichiedente = null;
                    utenteRichiedente = fruitore.getProprietaOggetto() != null && fruitore.getProprietaOggetto().getUtenteRichiedente() != null ? fruitore.getProprietaOggetto().getUtenteRichiedente() : DBUtils.getSuperUserServizioSafe(DriverRegistroServiziDB_LIB.log, "DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore", idServizio, con, DriverRegistroServiziDB_LIB.tipoDB);
                    Timestamp dataCreazione = null;
                    dataCreazione = fruitore.getProprietaOggetto() != null && fruitore.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(fruitore.getProprietaOggetto().getDataCreazione().getTime()) : (fruitore.getOraRegistrazione() != null ? new Timestamp(fruitore.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("servizi_fruitori");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_fruitore", "?");
                    if (stato != null) {
                        sqlQueryObject.addInsertField("stato", "?");
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addInsertField("descrizione", "?");
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idServizio);
                    updateStmt.setLong(2, idSoggettoFruitore);
                    updateStmt.setLong(3, idConnettore);
                    updateStmt.setString(4, wsdlImplementativoErogatore);
                    updateStmt.setString(5, wsdlImplementativoFruitore);
                    int index = 6;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(fruitore.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    updateStmt.setString(index, descrizione);
                    ++index;
                    if (utenteRichiedente != null) {
                        updateStmt.setString(index, utenteRichiedente);
                        ++index;
                    }
                    if (dataCreazione != null) {
                        updateStmt.setTimestamp(index, dataCreazione);
                        ++index;
                    }
                    n = updateStmt.executeUpdate();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitore CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idServizio, idSoggettoFruitore, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("id_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idServizio);
                    selectStmt.setLong(2, idSoggettoFruitore);
                    selectStmt.setLong(3, idConnettore);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        idFruizione = selectRS.getLong("id");
                    }
                    int sizeAzioni = fruitore.sizeConfigurazioneAzioneList();
                    for (int i = 0; i < sizeAzioni; ++i) {
                        ConfigurazioneServizioAzione conf = fruitore.getConfigurazioneAzione(i);
                        DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaFruitoreAzioni(1, conf, con, servizio, fruitore, driverBYOK);
                    }
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(2, fruitore.getProtocolPropertyList(), idFruizione, ProprietariProtocolProperty.FRUITORE, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
                    break;
                }
                case 2: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioFruitore(idServizio, nomeSoggetto, tipoSoggetto, con);
                    if (idConnettore < 0L) {
                        throw new DriverRegistroServiziException("Il connettore del Fruitore del Servizio e' invalido id<0");
                    }
                    connettore.setId(idConnettore);
                    String utenteUltimaModifica = null;
                    if (fruitore.getProprietaOggetto() != null && fruitore.getProprietaOggetto().getUtenteUltimaModifica() != null) {
                        utenteUltimaModifica = fruitore.getProprietaOggetto().getUtenteUltimaModifica();
                    }
                    Timestamp dataUltimaModifica = null;
                    if (fruitore.getProprietaOggetto() != null && fruitore.getProprietaOggetto().getDataUltimaModifica() != null) {
                        dataUltimaModifica = new Timestamp(fruitore.getProprietaOggetto().getDataUltimaModifica().getTime());
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("servizi_fruitori");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_fruitore", "?");
                    if (stato != null) {
                        sqlQueryObject.addUpdateField("stato", "?");
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id_servizio=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, wsdlImplementativoErogatore);
                    updateStmt.setString(2, wsdlImplementativoFruitore);
                    int index = 3;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(fruitore.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    updateStmt.setString(index, descrizione);
                    ++index;
                    if (utenteUltimaModifica != null) {
                        updateStmt.setString(index, utenteUltimaModifica);
                        ++index;
                    }
                    if (dataUltimaModifica != null) {
                        updateStmt.setTimestamp(index, dataUltimaModifica);
                        ++index;
                    }
                    updateStmt.setLong(index, idServizio);
                    updateStmt.setLong(++index, idSoggettoFruitore);
                    updateStmt.setLong(++index, idConnettore);
                    ++index;
                    n = updateStmt.executeUpdate();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitore UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, wsdlImplementativoErogatore, wsdlImplementativoFruitore, idServizio, idSoggettoFruitore, idConnettore));
                    DriverRegistroServiziDB_LIB.logDebug("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + connettore.getNome() + "]...");
                    String newNomeConnettore = "CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + "_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome() + "/" + servizio.getVersione();
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.logDebug("nuovo nome connettore [" + newNomeConnettore + "]");
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, driverBYOK);
                    int sizeAzioni = fruitore.sizeConfigurazioneAzioneList();
                    DriverRegistroServiziDB_accordiParteSpecificaLIB.deleteAllAzioniFruizioneServizio(idFruizione, con);
                    for (int i = 0; i < sizeAzioni; ++i) {
                        ConfigurazioneServizioAzione conf = fruitore.getConfigurazioneAzione(i);
                        DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaFruitoreAzioni(1, conf, con, servizio, fruitore, driverBYOK);
                    }
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(2, fruitore.getProtocolPropertyList(), idFruizione, ProprietariProtocolProperty.FRUITORE, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
                    break;
                }
                case 3: {
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(3, null, idFruizione, ProprietariProtocolProperty.FRUITORE, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
                    int sizeAzioni = fruitore.sizeConfigurazioneAzioneList();
                    for (int i = 0; i < sizeAzioni; ++i) {
                        ConfigurazioneServizioAzione conf = fruitore.getConfigurazioneAzione(i);
                        DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecificaFruitoreAzioni(3, conf, con, servizio, fruitore, driverBYOK);
                    }
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioFruitore(idServizio, nomeSoggetto, tipoSoggetto, con);
                    connettore.setId(idConnettore);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_fruitori");
                    sqlQueryObject.addWhereCondition("id_servizio=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idServizio);
                    updateStmt.setLong(2, idSoggettoFruitore);
                    updateStmt.setLong(3, idConnettore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitore DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizio, idSoggettoFruitore, idConnettore));
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(3, connettore, con, driverBYOK);
                }
            }
            DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitore type = " + type + " row affected =" + n);
            if (1 == type) {
                long utenteRichiedente = idFruizione;
                return utenteRichiedente;
            }
            long utenteRichiedente = n;
            return utenteRichiedente;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDFruitore] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDFruitore] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    public static long CRUDAccordoServizioParteSpecificaAzioni(int type, ConfigurazioneServizioAzione conf, Connection con, AccordoServizioParteSpecifica servizio, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        PreparedStatement updateStmt = null;
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idServizio = -1L;
        try {
            String tipoServ = servizio.getTipo();
            String nomeServ = servizio.getNome();
            Integer verServ = servizio.getVersione();
            String tipoSogg = servizio.getTipoSoggettoErogatore();
            String nomeSogg = servizio.getNomeSoggettoErogatore();
            idServizio = DBUtils.getIdServizio(nomeServ, tipoServ, verServ, nomeSogg, tipoSogg, con, DriverRegistroServiziDB_LIB.tipoDB);
        }
        catch (CoreException e1) {
            DriverRegistroServiziDB_LIB.logError("Driver Error.", e1);
            throw new DriverRegistroServiziException(e1);
        }
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] ID Servizio non valido.");
        }
        Connettore connettore = conf.getConnettore();
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] il connettore non puo essere nullo.");
        }
        if (conf.sizeAzioneList() <= 0) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] la configurazione non contiene azioni??");
        }
        String azioneValue = conf.getAzione(0);
        if (azioneValue == null || azioneValue.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] Azione non valida.");
        }
        String nomeConnettore = "CNT_SAZIONE_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome() + "/" + servizio.getVersione() + "_" + azioneValue;
        if (connettore == null) {
            connettore = new Connettore();
        }
        connettore.setNome(nomeConnettore);
        long idConnettore = 0L;
        long n = 0L;
        try {
            switch (type) {
                case 1: {
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(1, connettore, con, driverBYOK);
                    idConnettore = connettore.getId();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("servizi_azioni");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idServizio);
                    updateStmt.setLong(2, idConnettore);
                    n = updateStmt.executeUpdate();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaAzioni CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idServizio, idConnettore));
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("servizi_azioni");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idServizio);
                    selectStmt.setLong(2, idConnettore);
                    selectRS = selectStmt.executeQuery();
                    long idServizioAzione = -1L;
                    if (selectRS.next()) {
                        idServizioAzione = selectRS.getLong("id");
                    }
                    selectRS.close();
                    selectStmt.close();
                    if (idServizioAzione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] Recuro id per idServizio[" + idServizio + "] idConnettore[" + idConnettore + "] non riuscito");
                    }
                    for (String azione : conf.getAzioneList()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("servizi_azione");
                        sqlQueryObject.addInsertField("nome_azione", "?");
                        sqlQueryObject.addInsertField("id_servizio_azioni", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, azione);
                        updateStmt.setLong(2, idServizioAzione);
                        n = updateStmt.executeUpdate();
                        DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaAzione CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, azione, idServizioAzione));
                        updateStmt.close();
                    }
                    break;
                }
                case 2: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioAzione(idServizio, azioneValue, con);
                    if (idConnettore < 0L) {
                        throw new DriverRegistroServiziException("Il connettore dell'azione [" + azioneValue + "] del Servizio e' invalido id<0");
                    }
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_LIB.logDebug("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + connettore.getNome() + "]...");
                    DriverRegistroServiziDB_LIB.logDebug("nuovo nome connettore [" + connettore.getNome() + "]");
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, driverBYOK);
                    break;
                }
                case 3: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioAzione(idServizio, azioneValue, con);
                    connettore.setId(idConnettore);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("servizi_azioni");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idServizio);
                    selectStmt.setLong(2, idConnettore);
                    selectRS = selectStmt.executeQuery();
                    long idServizioAzione = -1L;
                    if (selectRS.next()) {
                        idServizioAzione = selectRS.getLong("id");
                    }
                    selectRS.close();
                    selectStmt.close();
                    if (idServizioAzione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] Recuro id per idServizio[" + idServizio + "] idConnettore[" + idConnettore + "] non riuscito");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_azione");
                    sqlQueryObject.addWhereCondition("id_servizio_azioni=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idServizioAzione);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaAzioni DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizioAzione));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_azioni");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idServizioAzione);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaAzioni DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizioAzione));
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(3, connettore, con, driverBYOK);
                }
            }
            DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaAzioni type = " + type + " row affected =" + n);
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    public static long CRUDAccordoServizioParteSpecificaFruitoreAzioni(int type, ConfigurazioneServizioAzione conf, Connection con, AccordoServizioParteSpecifica servizio, Fruitore fruitore, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        PreparedStatement updateStmt = null;
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idFruizione = -1L;
        try {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(servizio);
            IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
            idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, DriverRegistroServiziDB_LIB.tipoDB);
        }
        catch (CoreException e1) {
            DriverRegistroServiziDB_LIB.logError("Driver Error.", e1);
            throw new DriverRegistroServiziException(e1);
        }
        if (idFruizione <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] ID Servizio non valido.");
        }
        Connettore connettore = conf.getConnettore();
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] il connettore non puo essere nullo.");
        }
        if (conf.sizeAzioneList() <= 0) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] la configurazione non contiene azioni??");
        }
        String azioneValue = conf.getAzione(0);
        if (azioneValue == null || azioneValue.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] Azione non valida.");
        }
        String nomeConnettore = "CNT_SF_AZIONE_" + fruitore.getTipo() + "/" + fruitore.getNome() + "_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome() + "/" + servizio.getVersione() + "_" + azioneValue;
        if (connettore == null) {
            connettore = new Connettore();
        }
        connettore.setNome(nomeConnettore);
        long idConnettore = 0L;
        long n = 0L;
        try {
            switch (type) {
                case 1: {
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(1, connettore, con, driverBYOK);
                    idConnettore = connettore.getId();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("servizi_fruitori_azioni");
                    sqlQueryObject.addInsertField("id_fruizione", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idFruizione);
                    updateStmt.setLong(2, idConnettore);
                    n = updateStmt.executeUpdate();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitoreAzioni CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idFruizione, idConnettore));
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori_azioni");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_fruizione = ?");
                    sqlQueryObject.addWhereCondition("id_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idFruizione);
                    selectStmt.setLong(2, idConnettore);
                    selectRS = selectStmt.executeQuery();
                    long idFruizioneAzione = -1L;
                    if (selectRS.next()) {
                        idFruizioneAzione = selectRS.getLong("id");
                    }
                    selectRS.close();
                    selectStmt.close();
                    if (idFruizioneAzione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] Recuro id per idFruizione[" + idFruizione + "] idConnettore[" + idConnettore + "] non riuscito");
                    }
                    for (String azione : conf.getAzioneList()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("servizi_fruitori_azione");
                        sqlQueryObject.addInsertField("nome_azione", "?");
                        sqlQueryObject.addInsertField("id_fruizione_azioni", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, azione);
                        updateStmt.setLong(2, idFruizioneAzione);
                        n = updateStmt.executeUpdate();
                        DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitoreAzioni CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, azione, idFruizioneAzione));
                        updateStmt.close();
                    }
                    break;
                }
                case 2: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreFruizioneServizioAzione(idFruizione, azioneValue, con);
                    if (idConnettore < 0L) {
                        throw new DriverRegistroServiziException("Il connettore dell'azione [" + azioneValue + "] della fruizione di Servizio e' invalido id<0");
                    }
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_LIB.logDebug("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + connettore.getNome() + "]...");
                    DriverRegistroServiziDB_LIB.logDebug("nuovo nome connettore [" + connettore.getNome() + "]");
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, driverBYOK);
                    break;
                }
                case 3: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreFruizioneServizioAzione(idFruizione, azioneValue, con);
                    connettore.setId(idConnettore);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori_azioni");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_fruizione = ?");
                    sqlQueryObject.addWhereCondition("id_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idFruizione);
                    selectStmt.setLong(2, idConnettore);
                    selectRS = selectStmt.executeQuery();
                    long idFruizioneAzione = -1L;
                    if (selectRS.next()) {
                        idFruizioneAzione = selectRS.getLong("id");
                    }
                    selectRS.close();
                    selectStmt.close();
                    if (idFruizioneAzione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] Recuro id per idFruizione[" + idFruizione + "] idConnettore[" + idConnettore + "] non riuscito");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_fruitori_azione");
                    sqlQueryObject.addWhereCondition("id_fruizione_azioni=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idFruizioneAzione);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitoreAzioni DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idFruizioneAzione));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_fruitori_azioni");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idFruizioneAzione);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitoreAzioni DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idFruizioneAzione));
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(3, connettore, con, driverBYOK);
                }
            }
            DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoServizioParteSpecificaFruitoreAzioni type = " + type + " row affected =" + n);
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitoreAzioni] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteAllFruitoriServizio(long idServizio, List<Long> idFruitoriEsistenti, Connection con) throws DriverRegistroServiziException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            long idFruizione;
            int i;
            ArrayList<Long> listaFruizioniDaEliminare = new ArrayList<Long>();
            ArrayList<Long> listaFruizioniDaEliminareConnettori = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            while (rs.next()) {
                long idSoggettoFruitore = rs.getLong("id_soggetto");
                boolean find = false;
                for (int i2 = 0; i2 < idFruitoriEsistenti.size(); ++i2) {
                    if (idSoggettoFruitore != idFruitoriEsistenti.get(i2)) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                listaFruizioniDaEliminare.add(rs.getLong("id"));
                listaFruizioniDaEliminareConnettori.add(rs.getLong("id_connettore"));
            }
            rs.close();
            stm.close();
            for (i = 0; i < listaFruizioniDaEliminare.size(); ++i) {
                idFruizione = (Long)listaFruizioniDaEliminare.get(i);
                DriverRegistroServiziDB_LIB.CRUDProtocolProperty(3, null, idFruizione, ProprietariProtocolProperty.FRUITORE, con, DriverRegistroServiziDB_LIB.tipoDB, null);
                DriverRegistroServiziDB_accordiParteSpecificaLIB.deleteAllAzioniFruizioneServizio(idFruizione, con);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                sqlQueryObject.addDeleteTable("servizi_fruitori");
                sqlQueryObject.addWhereCondition("id=?");
                String sqlQuery = sqlQueryObject.createSQLDelete();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idFruizione);
                int n = stm.executeUpdate();
                stm.close();
                DriverRegistroServiziDB_LIB.logDebug("Cancellata (row:" + n + ") fruizione con id:" + idFruizione);
            }
            for (i = 0; i < listaFruizioniDaEliminareConnettori.size(); ++i) {
                idFruizione = (Long)listaFruizioniDaEliminare.get(i);
                long idConnettore = (Long)listaFruizioniDaEliminareConnettori.get(i);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                sqlQueryObject.addDeleteTable("connettori_custom");
                sqlQueryObject.addWhereCondition("id_connettore=?");
                String sqlQuery = sqlQueryObject.createSQLDelete();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
                stm.close();
                DriverRegistroServiziDB_LIB.logDebug("Cancellato connettore custom associato al connettore con id:" + idConnettore + " associato alla fruizione con id:" + idFruizione);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                sqlQueryObject.addDeleteTable("connettori");
                sqlQueryObject.addWhereCondition("id=?");
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
                stm.close();
                DriverRegistroServiziDB_LIB.logDebug("Cancellati connettoro con id:" + idConnettore + " associato alla fruizione con id:" + idFruizione);
            }
        }
        catch (SQLException e) {
            try {
                DriverRegistroServiziDB_LIB.logError("Errore SQL", e);
                throw new DriverRegistroServiziException(e);
                catch (Exception e2) {
                    DriverRegistroServiziDB_LIB.logError("Errore", e2);
                    throw new DriverRegistroServiziException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stm);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteAllAzioniServizio(long idServizio, Connection con) throws DriverRegistroServiziException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ArrayList<Long> listaConnettori = new ArrayList<Long>();
            ArrayList<Long> listaConfigurazioni = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("servizi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            while (rs.next()) {
                listaConnettori.add(rs.getLong("id_connettore"));
                listaConfigurazioni.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_azione");
            sqlQueryObject.addWhereCondition("id_servizio_azioni=?");
            String sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConfigurazione : listaConfigurazioni) {
                stm.setLong(1, idConfigurazione);
                int n = stm.executeUpdate();
                DriverRegistroServiziDB_LIB.logDebug("Cancellati " + n + " Azioni della configurazione del servizio " + idConfigurazione);
            }
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_azioni");
            sqlQueryObject.addWhereCondition("id_servizio=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            int n = stm.executeUpdate();
            stm.close();
            DriverRegistroServiziDB_LIB.logDebug("Cancellati " + n + " Azioni del servizio " + idServizio);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            sqlQueryObject.addWhereCondition("id_connettore=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            DriverRegistroServiziDB_LIB.logDebug("Cancellati connettori " + listaConnettori.toString() + " associati alle azioni del servizio " + idServizio);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            DriverRegistroServiziDB_LIB.logDebug("Cancellati connettori " + listaConnettori.toString() + " associati ai Fruitori del servizio " + idServizio);
        }
        catch (SQLException e) {
            try {
                DriverRegistroServiziDB_LIB.logError("Errore SQL", e);
                throw new DriverRegistroServiziException(e);
                catch (Exception e2) {
                    DriverRegistroServiziDB_LIB.logError("Errore", e2);
                    throw new DriverRegistroServiziException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stm);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteAllAzioniFruizioneServizio(long idFruizione, Connection con) throws DriverRegistroServiziException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ArrayList<Long> listaConnettori = new ArrayList<Long>();
            ArrayList<Long> listaConfigurazioni = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_fruizione = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idFruizione);
            rs = stm.executeQuery();
            while (rs.next()) {
                listaConnettori.add(rs.getLong("id_connettore"));
                listaConfigurazioni.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_fruitori_azione");
            sqlQueryObject.addWhereCondition("id_fruizione_azioni=?");
            String sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConfigurazione : listaConfigurazioni) {
                stm.setLong(1, idConfigurazione);
                int n = stm.executeUpdate();
                DriverRegistroServiziDB_LIB.logDebug("Cancellati " + n + " Azioni della configurazione della fruizione del servizio " + idConfigurazione);
            }
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_fruitori_azioni");
            sqlQueryObject.addWhereCondition("id_fruizione=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idFruizione);
            int n = stm.executeUpdate();
            stm.close();
            DriverRegistroServiziDB_LIB.logDebug("Cancellati " + n + " Azioni della fruizione del servizio " + idFruizione);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            sqlQueryObject.addWhereCondition("id_connettore=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            DriverRegistroServiziDB_LIB.logDebug("Cancellati connettori " + listaConnettori.toString() + " associati alle azioni della fruizione del servizio " + idFruizione);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            DriverRegistroServiziDB_LIB.logDebug("Cancellati connettori " + listaConnettori.toString() + " associati ai Fruitori della fruizione del servizio " + idFruizione);
        }
        catch (SQLException e) {
            try {
                DriverRegistroServiziDB_LIB.logError("Errore SQL", e);
                throw new DriverRegistroServiziException(e);
                catch (Exception e2) {
                    DriverRegistroServiziDB_LIB.logError("Errore", e2);
                    throw new DriverRegistroServiziException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stm);
    }
}

