/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceParameter;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiRestLIB {
    public static int CRUDResource(int type, AccordoServizioParteComune as, Resource resource, Connection con, long idAccordo, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        PreparedStatement updateStmt = null;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        int n = 0;
        if (idAccordo <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDResource] ID Accordo non valido.");
        }
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("api_resources");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("http_method", "?");
                    sqlQueryObject.addInsertField("path", "?");
                    sqlQueryObject.addInsertField("message_type", "?");
                    sqlQueryObject.addInsertField("message_type_request", "?");
                    sqlQueryObject.addInsertField("message_type_response", "?");
                    sqlQueryObject.addInsertField("profilo_azione", "?");
                    sqlQueryObject.addInsertField("filtro_duplicati", "?");
                    sqlQueryObject.addInsertField("conferma_ricezione", "?");
                    sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                    sqlQueryObject.addInsertField("id_riferimento_richiesta", "?");
                    sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                    sqlQueryObject.addInsertField("scadenza", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setLong(index++, idAccordo);
                    updateStmt.setString(index++, resource.getNome());
                    updateStmt.setString(index++, resource.getDescrizione());
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getMethod()));
                    if (resource.getPath() == null) {
                        updateStmt.setString(index++, "*");
                    } else {
                        updateStmt.setString(index++, resource.getPath());
                    }
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getMessageType()));
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getRequestMessageType()));
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getResponseMessageType()));
                    DriverRegistroServiziDB_LIB.log.debug("Aggiungo resource [" + resource.getNome() + "] con profilo [" + resource.getProfAzione() + "]");
                    updateStmt.setString(index++, resource.getProfAzione());
                    if ("ridefinito".equals(resource.getProfAzione())) {
                        DriverRegistroServiziDB_LIB.log.debug("ridefinizione...");
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getFiltroDuplicati()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getConfermaRicezione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getIdCollaborazione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getIdRiferimentoRichiesta()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getConsegnaInOrdine()));
                        updateStmt.setString(index++, resource.getScadenza());
                    } else {
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getIdRiferimentoRichiesta()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        updateStmt.setString(index++, as.getScadenza());
                    }
                    n = updateStmt.executeUpdate();
                    DriverRegistroServiziDB_LIB.log.debug("CRUDResource type = " + type + " row affected =" + n);
                    break;
                }
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("port_type");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("http_method", "?");
                    sqlQueryObject.addUpdateField("path", "?");
                    sqlQueryObject.addUpdateField("message_type", "?");
                    sqlQueryObject.addUpdateField("message_type_request", "?");
                    sqlQueryObject.addUpdateField("message_type_response", "?");
                    sqlQueryObject.addUpdateField("profilo_azione", "?");
                    sqlQueryObject.addUpdateField("filtro_duplicati", "?");
                    sqlQueryObject.addUpdateField("conferma_ricezione", "?");
                    sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
                    sqlQueryObject.addUpdateField("id_riferimento_richiesta", "?");
                    sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
                    sqlQueryObject.addUpdateField("scadenza", "?");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, resource.getDescrizione());
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getMethod()));
                    if (resource.getPath() == null) {
                        updateStmt.setString(index++, "*");
                    } else {
                        updateStmt.setString(index++, resource.getPath());
                    }
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getMessageType()));
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getRequestMessageType()));
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getResponseMessageType()));
                    updateStmt.setString(index++, resource.getProfAzione());
                    if ("ridefinito".equals(resource.getProfAzione())) {
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getFiltroDuplicati()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getConfermaRicezione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getIdCollaborazione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getIdRiferimentoRichiesta()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resource.getConsegnaInOrdine()));
                        updateStmt.setString(index++, resource.getScadenza());
                    } else {
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getIdRiferimentoRichiesta()));
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        updateStmt.setString(index++, as.getScadenza());
                    }
                    updateStmt.setLong(index++, idAccordo);
                    updateStmt.setString(index++, resource.getNome());
                    n = updateStmt.executeUpdate();
                    DriverRegistroServiziDB_LIB.log.debug("CRUDResource type = " + type + " row affected =" + n);
                    break;
                }
                case 3: {
                    Long idResource = 0L;
                    if (resource.getId() == null || resource.getId() <= 0L) {
                        idResource = DBUtils.getIdResource(idAccordo, resource.getNome(), con);
                        if (idResource == null || idResource <= 0L) {
                            throw new Exception("ID della risorsa [" + resource.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                        }
                    } else {
                        idResource = resource.getId();
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("api_resources_media");
                    sqlQueryObject.addWhereCondition("id_resource_media=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idResource);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("api_resources_parameter");
                    sqlQueryObject.addWhereCondition("id_resource_parameter=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idResource);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    ArrayList<Long> idResourceResponse = new ArrayList<Long>();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("api_resources_response");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_resource=?");
                    updateQuery = sqlQueryObject.createSQLQuery();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idResource);
                    selectRS = updateStmt.executeQuery();
                    while (selectRS.next()) {
                        idResourceResponse.add(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    updateStmt.close();
                    while (idResourceResponse.size() > 0) {
                        long idRR = (Long)idResourceResponse.remove(0);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addDeleteTable("api_resources_media");
                        sqlQueryObject.addWhereCondition("id_resource_response_media=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        updateQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idRR);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addDeleteTable("api_resources_parameter");
                        sqlQueryObject.addWhereCondition("id_resource_response_par=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        updateQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idRR);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("api_resources_response");
                    sqlQueryObject.addWhereCondition("id_resource=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idResource);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("api_resources");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idResource);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.log.debug("CRUDResource type = " + type + " row affected =" + n);
                }
            }
            if (1 == type || 2 == type) {
                int i;
                Long idResource = DBUtils.getIdResource(idAccordo, resource.getNome(), con);
                if (idResource == null || idResource <= 0L) {
                    throw new Exception("ID della risorsa [" + resource.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                }
                DriverRegistroServiziDB_LIB.log.debug("ID risorsa: " + idResource);
                if (2 == type) {
                    if (resource.getRequest() != null) {
                        DriverRegistroServiziDB_accordiRestLIB.CRUDResourceRequest(3, as, resource, resource.getRequest(), con, idResource);
                        DriverRegistroServiziDB_LIB.log.info("Cancellato dettagli di richiesta della risorsa [" + idResource + "] associata all'accordo " + idAccordo);
                    }
                    n = 0;
                    for (i = 0; i < resource.sizeResponseList(); ++i) {
                        DriverRegistroServiziDB_accordiRestLIB.CRUDResourceResponse(3, as, resource, resource.getResponse(i), con, idResource);
                    }
                    DriverRegistroServiziDB_LIB.log.info("Cancellate " + n + " dettagli di risposta della risorsa [" + idResource + "] associata all'accordo " + idAccordo);
                }
                if (resource.getRequest() != null) {
                    DriverRegistroServiziDB_accordiRestLIB.CRUDResourceRequest(1, as, resource, resource.getRequest(), con, idResource);
                }
                for (i = 0; i < resource.sizeResponseList(); ++i) {
                    DriverRegistroServiziDB_accordiRestLIB.CRUDResourceResponse(1, as, resource, resource.getResponse(i), con, idResource);
                }
                DriverRegistroServiziDB_LIB.log.debug("inserite " + resource.sizeResponseList() + " dettagli di risposta relative alla risorsa [" + resource.getNome() + "] id-risorsa[" + resource.getId() + "] dell'accordo :" + IDAccordoFactory.getInstance().getUriFromAccordo(as) + " id-accordo :" + idAccordo);
                DriverRegistroServiziDB_LIB.CRUDProtocolProperty(type, resource.getProtocolPropertyList(), idResource, ProprietariProtocolProperty.RESOURCE, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
            }
            int idResource = n;
            return idResource;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDResource] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDResource] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    public static void CRUDResourceRequest(int type, AccordoServizioParteComune as, Resource resource, ResourceRequest resourceRequest, Connection con, long idResource) throws DriverRegistroServiziException {
        DriverRegistroServiziDB_accordiRestLIB._CRUDResourceRequestResponse(type, as, resource, resourceRequest, null, con, idResource);
    }

    public static void CRUDResourceResponse(int type, AccordoServizioParteComune as, Resource resource, ResourceResponse resourceResponse, Connection con, long idResource) throws DriverRegistroServiziException {
        DriverRegistroServiziDB_accordiRestLIB._CRUDResourceRequestResponse(type, as, resource, null, resourceResponse, con, idResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _CRUDResourceRequestResponse(int type, AccordoServizioParteComune as, Resource resource, ResourceRequest resourceRequest, ResourceResponse resourceResponse, Connection con, long idResource) throws DriverRegistroServiziException {
        PreparedStatement updateStmt = null;
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long n = 0L;
        if (idResource <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::_CRUDResourceRequestResponse] ID Risorda non valido.");
        }
        try {
            switch (type) {
                case 1: {
                    String updateQuery;
                    long idFK = -1L;
                    if (resourceRequest != null) {
                        idFK = idResource;
                    } else {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("api_resources_response");
                        sqlQueryObject.addInsertField("id_resource", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("status", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index++, idResource);
                        updateStmt.setString(index++, resourceResponse.getDescrizione());
                        updateStmt.setInt(index++, resourceResponse.getStatus());
                        DriverRegistroServiziDB_LIB.log.debug("_CRUDResourceRequestResponse (RESPONSE) CREATE :\n" + updateQuery);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        DriverRegistroServiziDB_LIB.log.debug("_CRUDResourceRequestResponse (RESPONSE) type = " + type + " row affected =" + n);
                        index = 1;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addFromTable("api_resources_response");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_resource = ?");
                        sqlQueryObject.addWhereCondition("status = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        selectQuery = sqlQueryObject.createSQLQuery();
                        selectStmt = con.prepareStatement(selectQuery);
                        selectStmt.setLong(index++, idResource);
                        selectStmt.setInt(index++, resourceResponse.getStatus());
                        selectRS = selectStmt.executeQuery();
                        if (!selectRS.next()) throw new Exception("Recupero dell'id della tabella 'api_resources_response' con id_resource='" + idResource + "' e status='" + resourceResponse.getStatus() + "' non riuscito");
                        idFK = selectRS.getLong("id");
                    }
                    if (idFK <= 0L) {
                        throw new Exception("Recupero dell'id della tabella padre non riuscito");
                    }
                    if (resourceRequest != null) {
                        resourceRequest.setIdResource(idFK);
                    } else {
                        resourceResponse.setIdResource(idFK);
                    }
                    List<ResourceRepresentation> lRR = null;
                    lRR = resourceRequest != null ? resourceRequest.getRepresentationList() : resourceResponse.getRepresentationList();
                    for (ResourceRepresentation resourceRepresentation : lRR) {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("api_resources_media");
                        if (resourceRequest != null) {
                            sqlQueryObject.addInsertField("id_resource_media", "?");
                        } else {
                            sqlQueryObject.addInsertField("id_resource_response_media", "?");
                        }
                        sqlQueryObject.addInsertField("media_type", "?");
                        sqlQueryObject.addInsertField("message_type", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("xml_tipo", "?");
                        sqlQueryObject.addInsertField("xml_name", "?");
                        sqlQueryObject.addInsertField("xml_namespace", "?");
                        sqlQueryObject.addInsertField("json_type", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index++, idFK);
                        updateStmt.setString(index++, resourceRepresentation.getMediaType());
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resourceRepresentation.getMessageType()));
                        updateStmt.setString(index++, resourceRepresentation.getNome());
                        updateStmt.setString(index++, resourceRepresentation.getDescrizione());
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(resourceRepresentation.getRepresentationType()));
                        updateStmt.setString(index++, resourceRepresentation.getXml() != null ? DriverRegistroServiziDB_LIB.getValue(resourceRepresentation.getXml().getXmlType()) : null);
                        updateStmt.setString(index++, resourceRepresentation.getXml() != null ? resourceRepresentation.getXml().getNome() : null);
                        updateStmt.setString(index++, resourceRepresentation.getXml() != null ? resourceRepresentation.getXml().getNamespace() : null);
                        updateStmt.setString(index++, resourceRepresentation.getJson() != null ? resourceRepresentation.getJson().getTipo() : null);
                        DriverRegistroServiziDB_LIB.log.debug("_CRUDResourceRequestResponse (MEDIA) CREATE :\n" + updateQuery);
                        n = updateStmt.executeUpdate();
                        DriverRegistroServiziDB_LIB.log.debug("_CRUDResourceRequestResponse (MEDIA) type = " + type + " row affected =" + n);
                        updateStmt.close();
                    }
                    List<ResourceParameter> lRP = null;
                    lRP = resourceRequest != null ? resourceRequest.getParameterList() : resourceResponse.getParameterList();
                    Iterator<ResourceParameter> iterator = lRP.iterator();
                    while (iterator.hasNext()) {
                        ResourceParameter rp = iterator.next();
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("api_resources_parameter");
                        if (resourceRequest != null) {
                            sqlQueryObject.addInsertField("id_resource_parameter", "?");
                        } else {
                            sqlQueryObject.addInsertField("id_resource_response_par", "?");
                        }
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("tipo_parametro", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("restrizioni", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index++, idFK);
                        updateStmt.setString(index++, rp.getNome());
                        updateStmt.setString(index++, rp.getDescrizione());
                        updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue(rp.getParameterType()));
                        updateStmt.setBoolean(index++, rp.isRequired());
                        updateStmt.setString(index++, rp.getTipo());
                        updateStmt.setString(index++, rp.getRestrizioni());
                        DriverRegistroServiziDB_LIB.log.debug("_CRUDResourceRequestResponse (PARAMETER) CREATE :\n" + updateQuery);
                        n = updateStmt.executeUpdate();
                        DriverRegistroServiziDB_LIB.log.debug("_CRUDResourceRequestResponse (PARAMETER) type = " + type + " row affected =" + n);
                        updateStmt.close();
                    }
                    return;
                }
                case 2: {
                    throw new Exception("Not Implemented");
                }
                case 3: {
                    if (resourceRequest != null) {
                        ISQLQueryObject iSQLQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        iSQLQueryObject.addDeleteTable("api_resources_media");
                        iSQLQueryObject.addWhereCondition("id_resource_media=?");
                        iSQLQueryObject.setANDLogicOperator(true);
                        String updateQuery = iSQLQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idResource);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        ISQLQueryObject iSQLQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        iSQLQueryObject2.addDeleteTable("api_resources_parameter");
                        iSQLQueryObject2.addWhereCondition("id_resource_parameter=?");
                        iSQLQueryObject2.setANDLogicOperator(true);
                        updateQuery = iSQLQueryObject2.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idResource);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        return;
                    }
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("api_resources_response");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_resource=?");
                    String updateQuery = sqlQueryObject.createSQLQuery();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idResource);
                    selectRS = updateStmt.executeQuery();
                    while (selectRS.next()) {
                        arrayList.add(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    updateStmt.close();
                    while (true) {
                        if (arrayList.size() <= 0) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addDeleteTable("api_resources_response");
                            sqlQueryObject.addWhereCondition("id_resource=?");
                            sqlQueryObject.setANDLogicOperator(true);
                            updateQuery = sqlQueryObject.createSQLDelete();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idResource);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                            return;
                        }
                        long idRR = (Long)arrayList.remove(0);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addDeleteTable("api_resources_media");
                        sqlQueryObject.addWhereCondition("id_resource_response_media=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        updateQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idRR);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addDeleteTable("api_resources_parameter");
                        sqlQueryObject.addWhereCondition("id_resource_response_par=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        updateQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idRR);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::_CRUDResourceRequestResponse] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::_CRUDResourceRequestResponse] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }
}

