/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiServiziCompostiDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiServiziCompostiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readAccordoServizioComposto(AccordoServizioParteComune as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stm2 = null;
        ResultSet rs2 = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readAccordoServizioComposto") : this.driver.globalConnection);
            if (as.getId() == null) throw new Exception("Accordo id non definito");
            if (as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId()));
            rs = stm.executeQuery();
            AccordoServizioParteComuneServizioComposto asComposto = null;
            if (rs.next()) {
                asComposto = new AccordoServizioParteComuneServizioComposto();
                asComposto.setId(rs.getLong("id"));
                asComposto.setIdAccordoCooperazione(rs.getLong("id_accordo_cooperazione"));
                IDAccordoCooperazione idAccordoCooperazione = this.driver.getIdAccordoCooperazione(asComposto.getIdAccordoCooperazione(), con);
                String uriAccordo = this.driver.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoCooperazione);
                asComposto.setAccordoCooperazione(uriAccordo);
            }
            rs.close();
            stm.close();
            if (asComposto != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio_composto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, asComposto.getId());
                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, asComposto.getId()));
                rs = stm.executeQuery();
                while (rs.next()) {
                    AccordoServizioParteComuneServizioCompostoServizioComponente asComponente = new AccordoServizioParteComuneServizioCompostoServizioComponente();
                    asComponente.setIdServizioComponente(rs.getLong("id_servizio_componente"));
                    asComponente.setAzione(rs.getString("azione"));
                    AccordoServizioParteSpecifica aspsServizioComponente = this.driver.getAccordoServizioParteSpecifica((long)asComponente.getIdServizioComponente(), con);
                    asComponente.setTipo(aspsServizioComponente.getTipo());
                    asComponente.setNome(aspsServizioComponente.getNome());
                    asComponente.setVersione(aspsServizioComponente.getVersione());
                    asComponente.setTipoSoggetto(aspsServizioComponente.getTipoSoggettoErogatore());
                    asComponente.setNomeSoggetto(aspsServizioComponente.getNomeSoggettoErogatore());
                    asComposto.addServizioComponente(asComponente);
                }
                rs.close();
                stm.close();
                as.setServizioComposto(asComposto);
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs2, stm2);
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(rs2, stm2);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
    }

    protected List<AccordoServizioParteComune> accordiServizio_serviziComponentiConSoggettoErogatore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizio_serviziComponentiConSoggettoErogatore";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiServizio_serviziComponentiConSoggettoErogatore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.driver.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return idAccordoServizio;
    }

    protected List<AccordoServizioParteComune> accordiServizio_serviziComponenti(IDServizio idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizio_serviziComponenti";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiServizio_serviziComponenti");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.tipo_servizio=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.nome_servizio=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.versione_servizio=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idServizio.getSoggettoErogatore().getTipo());
            stmt.setString(2, idServizio.getSoggettoErogatore().getNome());
            stmt.setString(3, idServizio.getTipo());
            stmt.setString(4, idServizio.getNome());
            stmt.setInt(5, idServizio.getVersione());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.driver.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return idAccordoServizio;
    }

    protected List<AccordoServizioParteComune> accordiServizioWithAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizioWithAccordoCooperazione";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiServizioWithAccordoCooperazione");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.nome=?");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.versione=?");
            if (idAccordoCooperazione.getSoggettoReferente() != null) {
                sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.id_referente=?");
            }
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idAccordoCooperazione.getNome());
            stmt.setInt(2, idAccordoCooperazione.getVersione());
            if (idAccordoCooperazione.getSoggettoReferente() != null) {
                stmt.setLong(3, DBUtils.getIdSoggetto(idAccordoCooperazione.getSoggettoReferente().getNome(), idAccordoCooperazione.getSoggettoReferente().getTipo(), con, this.driver.tipoDB));
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.driver.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return idAccordoServizio;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getIdServizioCorrelato(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, this.driver.tipoDB, this.driver.tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizio_correlato = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            stm.setLong(3, idSoggetto);
            stm.setString(4, CostantiRegistroServizi.ABILITATO.toString());
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizio = rs.getLong("id");
            }
            l = idServizio;
        }
        catch (CoreException e) {
            try {
                throw new DriverRegistroServiziException(e.getMessage(), e);
                catch (SQLException e2) {
                    throw new DriverRegistroServiziException(e2.getMessage(), e2);
                }
                catch (Exception e3) {
                    throw new DriverRegistroServiziException(e3.getMessage(), e3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    protected List<AccordoServizioParteComuneServizioCompostoServizioComponente> accordiComponentiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente> arrayList;
        String nomeMetodo = "accordiComponentiList";
        int idLista = Liste.ACCORDI_COMPONENTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente> lista = new ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiComponentiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
                sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
                sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
                sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
                sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("acc_serv_componenti", "id_servizio_componente");
            sqlQueryObject.addSelectField("acc_serv_componenti", "azione");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addSelectField("servizi", "tipo_servizio");
            sqlQueryObject.addSelectField("servizi", "nome_servizio");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
            sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idServizioComponente = risultato.getLong("id_servizio_componente");
                String azione = risultato.getString("azione");
                AccordoServizioParteComuneServizioCompostoServizioComponente asComponente = new AccordoServizioParteComuneServizioCompostoServizioComponente();
                asComponente.setAzione(azione);
                asComponente.setIdServizioComponente(idServizioComponente);
                asComponente.setTipo(risultato.getString("tipo_servizio"));
                asComponente.setNome(risultato.getString("nome_servizio"));
                asComponente.setTipoSoggetto(risultato.getString("tipo_soggetto"));
                asComponente.setNomeSoggetto(risultato.getString("nome_soggetto"));
                lista.add(asComponente);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Documento> accordiCoopAllegatiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Documento> arrayList;
        String nomeMetodo = "accordiCoopAllegatiList";
        int idLista = Liste.ACCORDI_COOP_ALLEGATI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiCoopAllegatiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_documentiLIB.getDocumento(risultato.getLong("id"), false, con, this.driver.tipoDB);
                lista.add(doc);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

