/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.mapping.DBProtocolPropertiesUtils;
import org.openspcoop2.core.mapping.FiltroRicercaProtocolProperty;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaProtocolPropertyRegistry;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class DriverRegistroServiziDB_protocolPropertiesDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_protocolPropertiesDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected boolean existsProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome) throws DriverRegistroServiziException {
        Connection connection;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsProtocolProperty");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsProtocolProperty] Exception accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            boolean e = DBProtocolPropertiesUtils.existsProtocolProperty(proprietarioProtocolProperty, idProprietario, nome, connection, this.driver.tipoDB);
            return e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            this.driver.closeConnection(connection);
        }
    }

    protected ProtocolProperty getProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome) throws DriverRegistroServiziException {
        String nomeMetodo = "getProtocolProperty";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getProtocolProperty");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ProtocolProperty e = DBProtocolPropertiesUtils.getProtocolPropertyRegistry(proprietarioProtocolProperty, idProprietario, nome, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected ProtocolProperty getProtocolProperty(long idProtocolProperty) throws DriverRegistroServiziException {
        String nomeMetodo = "getProtocolProperty";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getProtocolProperty");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ProtocolProperty e = DriverRegistroServiziDB_LIB.getProtocolProperty(idProtocolProperty, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicercaFruizioniServizio filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolPropertiesFruizione(), tabella);
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicercaAzioni filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolPropertiesAzione(), tabella);
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicercaOperations filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            if ("port_type".equals(tabella)) {
                this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolPropertiesPortType(), tabella);
            } else {
                this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolPropertiesAzione(), tabella);
            }
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicercaPortTypes filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolPropertiesPortType(), tabella);
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicercaResources filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolPropertiesResources(), tabella);
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicercaAccordi filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolPropertiesAccordo(), tabella);
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicerca filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolProperties(), tabella);
        }
    }

    private void _setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, List<FiltroRicercaProtocolPropertyRegistry> list, String tabella) throws SQLQueryObjectException {
        if (list != null && !list.isEmpty()) {
            ArrayList<FiltroRicercaProtocolProperty> l = new ArrayList<FiltroRicercaProtocolProperty>();
            l.addAll(list);
            DBProtocolPropertiesUtils.setProtocolPropertiesForSearch(sqlQueryObject, l, tabella);
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicercaFruizioniServizio filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolPropertiesFruizione(), proprietario);
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicercaAzioni filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolPropertiesAzione(), proprietario);
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicercaOperations filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            if (ProprietariProtocolProperty.PORT_TYPE.equals((Object)proprietario)) {
                this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolPropertiesPortType(), proprietario);
            } else {
                this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolPropertiesAzione(), proprietario);
            }
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicercaPortTypes filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolPropertiesPortType(), proprietario);
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicercaResources filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolPropertiesResources(), proprietario);
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicercaAccordi filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolPropertiesAccordo(), proprietario);
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicerca filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolProperties(), proprietario);
        }
    }

    private void _setProtocolPropertiesForSearch(PreparedStatement stmt, int index, List<FiltroRicercaProtocolPropertyRegistry> list, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (list != null && !list.isEmpty()) {
            ArrayList<FiltroRicercaProtocolProperty> l = new ArrayList<FiltroRicercaProtocolProperty>();
            l.addAll(list);
            DBProtocolPropertiesUtils.setProtocolPropertiesForSearch(stmt, index, l, proprietario, this.driver.tipoDB, this.driver.log);
        }
    }
}

