/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_utilsDriver;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_scopeDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_scopeDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Scope getScope(IDScope idScope) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Scope scope;
        this.driver.logDebug("richiesto getScope: " + idScope);
        if (idScope == null) {
            throw new DriverRegistroServiziException("[getScope] Parametro idScope is null");
        }
        if (idScope.getNome() == null || idScope.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getScope] Parametro idScope.nome non e' definito");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getScope(nome)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getScope] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("scope");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setString(1, idScope.getNome());
            rs = stm.executeQuery();
            Scope scope2 = null;
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getScope] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idScope.getNome()));
            }
            scope2 = new Scope();
            scope2.setId(rs.getLong("id"));
            scope2.setNome(rs.getString("nome"));
            scope2.setDescrizione(rs.getString("descrizione"));
            String tipologia = rs.getString("tipologia");
            if (tipologia != null) {
                scope2.setTipologia(tipologia);
            }
            scope2.setNomeEsterno(rs.getString("nome_esterno"));
            String contestoUtilizzo = rs.getString("contesto_utilizzo");
            if (contestoUtilizzo != null) {
                scope2.setContestoUtilizzo(ScopeContesto.toEnumConstant(contestoUtilizzo));
            }
            scope2.setSuperUser(rs.getString("superuser"));
            if (rs.getTimestamp("ora_registrazione") != null) {
                scope2.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            scope2.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggetto(rs, false));
            scope = scope2;
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getScope] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getScope] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return scope;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Scope getScope(long idScope) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getScope: " + idScope);
        if (idScope <= 0L) {
            throw new DriverRegistroServiziException("[getScope] Parametro idScope non valido");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getScope(id)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getScope] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        IDScope idScopeObject = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("scope");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addWhereCondition("id = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idScope);
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getScope] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idScope));
            }
            idScopeObject = new IDScope(rs.getString("nome"));
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getScope] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getScope] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return this.getScope(idScopeObject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDScope> getAllIdScope(FiltroRicercaScope filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDScope> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean filtroRicercaTipo = false;
        if (filtroRicerca != null) {
            filtroRicercaTipo = StringUtils.isNotEmpty((String)filtroRicerca.getTipologia());
        }
        ArrayList<String> listTipologia = null;
        if (filtroRicercaTipo) {
            listTipologia = new ArrayList<String>();
            listTipologia.add(filtroRicerca.getTipologia());
        }
        boolean filtroRicercaContesto = false;
        if (filtroRicerca != null) {
            filtroRicercaContesto = filtroRicerca.getContesto() != null && !ScopeContesto.QUALSIASI.equals(filtroRicerca.getContesto());
        }
        ArrayList<String> listContesto = null;
        if (filtroRicercaContesto) {
            listContesto = new ArrayList<String>();
            listContesto.add(ScopeContesto.QUALSIASI.getValue());
            listContesto.add(filtroRicerca.getContesto().getValue());
        }
        this.driver.logDebug("getAllIdScope...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdScope") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("scope");
            sqlQueryObject.addSelectField("nome");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome = ?");
                }
                if (filtroRicercaTipo) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"tipologia = ?", "tipologia = ?"});
                }
                if (filtroRicercaContesto) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"contesto_utilizzo = ?", "contesto_utilizzo = ?"});
                }
                sqlQueryObject.addOrderBy("nome");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                int i;
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicercaTipo) {
                    for (i = 0; i < listTipologia.size(); ++indexStmt, ++i) {
                        this.driver.logDebug("tipo stmt.setString(" + (String)listTipologia.get(i) + ")");
                        stm.setString(indexStmt, (String)listTipologia.get(i));
                    }
                }
                if (filtroRicercaContesto) {
                    for (i = 0; i < listContesto.size(); ++indexStmt, ++i) {
                        this.driver.logDebug("contesto stmt.setString(" + (String)listContesto.get(i) + ")");
                        stm.setString(indexStmt, (String)listContesto.get(i));
                    }
                }
            }
            rs = stm.executeQuery();
            ArrayList<IDScope> nomiScope = new ArrayList<IDScope>();
            while (rs.next()) {
                nomiScope.add(new IDScope(rs.getString("nome")));
            }
            if (nomiScope.isEmpty()) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Scope non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Scope non trovati");
            }
            arrayList = nomiScope;
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException("getAllIdScope error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void createScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createScope] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createScope");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createScope] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDScope type = 1");
            DriverRegistroServiziDB_LIB.CRUDScope(1, scope, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createScope] Errore durante la creazione del scope : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsScope(IDScope idScope) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (idScope == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (idScope.getNome() == null || idScope.getNome().equals("")) {
            throw new DriverRegistroServiziException("Parametro vuoto non valido");
        }
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsScope");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsScope] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("scope");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idScope.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza scope: " + e.getMessage(), (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        return exist;
    }

    protected void updateScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateScope] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateScope");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateScope] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDScope type = 2");
            DriverRegistroServiziDB_LIB.CRUDScope(2, scope, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateScope] Errore durante l'aggiornamento del scope : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteScope] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteScope");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteScope] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDScope type = 3");
            DriverRegistroServiziDB_LIB.CRUDScope(3, scope, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteScope] Errore durante l'eliminazione del scope : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected List<Scope> scopeList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "scopeList";
        int idLista = Liste.SCOPE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterScopeTipologia = SearchUtils.getFilter(ricerca, idLista, "filtroScopeTipologia");
        String scopeTipologia = null;
        if (filterScopeTipologia != null) {
            scopeTipologia = StringUtils.isNotEmpty((String)filterScopeTipologia) ? filterScopeTipologia : null;
        }
        String filterScopeContesto = SearchUtils.getFilter(ricerca, idLista, "filtroScopeContesto");
        ScopeContesto scopeContesto = null;
        if (filterScopeContesto != null) {
            scopeContesto = ScopeContesto.toEnumConstant(filterScopeContesto);
        }
        boolean isFilterGruppoErogazione = false;
        boolean isFilterGruppoFruizione = false;
        String filterGruppo = SearchUtils.getFilter(ricerca, idLista, "filtroGruppo");
        if (filterGruppo != null && !"".equals(filterGruppo)) {
            isFilterGruppoErogazione = true;
            isFilterGruppoFruizione = true;
        }
        TipoPdD apiContesto = null;
        String filterApiContesto = SearchUtils.getFilter(ricerca, idLista, "filtroApiContesto");
        if (filterApiContesto != null && !"".equals(filterApiContesto)) {
            apiContesto = TipoPdD.toTipoPdD(filterApiContesto);
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                isFilterGruppoFruizione = false;
            } else if (TipoPdD.DELEGATA.equals(apiContesto)) {
                isFilterGruppoErogazione = false;
            } else {
                apiContesto = null;
            }
        }
        String filterProtocollo = null;
        String filterProtocolli = null;
        List<String> tipoSoggettiProtocollo = null;
        String filterSoggettoTipo = null;
        String filterSoggettoNome = null;
        boolean filterSoggettoProprietario = false;
        boolean filterTipoSoggettoProtocollo = false;
        if (apiContesto != null) {
            String filterSoggettoTipoNome;
            filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
            filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
            try {
                tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                filterTipoSoggettoProtocollo = true;
            }
            if ((filterSoggettoTipoNome = SearchUtils.getFilter(ricerca, idLista, "filtroSoggetto")) != null && !"".equals(filterSoggettoTipoNome)) {
                filterSoggettoTipo = filterSoggettoTipoNome.split("/")[0];
                filterSoggettoNome = filterSoggettoTipoNome.split("/")[1];
                filterSoggettoProprietario = true;
                filterTipoSoggettoProtocollo = false;
            }
        }
        String filterApiImplementazione = null;
        IDServizio apiImplementazioneErogazione = null;
        IDFruizione apiImplementazioneFruizione = null;
        if (apiContesto != null && (filterApiImplementazione = SearchUtils.getFilter(ricerca, idLista, "filtroApiImpl")) != null && !"".equals(filterApiImplementazione)) {
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                try {
                    apiImplementazioneErogazione = IDServizio.toIDServizio(filterApiImplementazione);
                    isFilterGruppoErogazione = false;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
            if (TipoPdD.DELEGATA.equals(apiContesto)) {
                try {
                    apiImplementazioneFruizione = IDFruizione.toIDFruizione(filterApiImplementazione);
                    isFilterGruppoFruizione = false;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterScopeTipologia : " + filterScopeTipologia);
        this.driver.logDebug("filterScopeContesto : " + filterScopeContesto);
        this.driver.logDebug("filterGruppo : " + filterGruppo);
        this.driver.logDebug("filterApiContesto : " + filterApiContesto);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterSoggettoNome : " + filterSoggettoNome);
        this.driver.logDebug("filterSoggettoTipo : " + filterSoggettoTipo);
        this.driver.logDebug("filterApiImplementazione : " + filterApiImplementazione);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Scope> lista = new ArrayList<Scope>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("scopeList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<IDScope> listIdScope = null;
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ArrayList<String> existsConditions = new ArrayList<String>();
            ArrayList<Object> existsParameters = new ArrayList<Object>();
            String aliasPDSCOPE = "pdscope";
            String aliasPD = "pd";
            String aliasPASCOPE = "pascope";
            String aliasPA = "pa";
            String aliasSERVIZI = "s";
            String aliasACCORDI = "a";
            String aliasACCORDIGRUPPI = "ag";
            String aliasGRUPPI = "g";
            String aliasSOGGETTI = "sProprietario";
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                ISQLQueryObject sqlQueryObjectAutorizzazioniPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("pd_scope", aliasPDSCOPE);
                sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("porte_delegate", aliasPD);
                if (isFilterGruppoFruizione) {
                    sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("servizi", aliasSERVIZI);
                    sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("accordi", aliasACCORDI);
                    sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                    sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
                }
                if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
                }
                sqlQueryObjectAutorizzazioniPorteDelegate.addSelectAliasField(aliasPDSCOPE, "id", aliasPDSCOPE + "id");
                sqlQueryObjectAutorizzazioniPorteDelegate.setANDLogicOperator(true);
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPDSCOPE + ".scope = scope.nome");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPDSCOPE + ".id_porta = " + aliasPD + ".id");
                if (isFilterGruppoFruizione) {
                    sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
                    sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                    sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
                    existsParameters.add(filterGruppo);
                }
                if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
                    if (apiImplementazioneFruizione != null) {
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                        existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                    } else if (filterSoggettoProprietario) {
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        existsParameters.add(filterSoggettoTipo);
                        existsParameters.add(filterSoggettoNome);
                    } else if (filterTipoSoggettoProtocollo) {
                        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                    }
                }
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteDelegate));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                ISQLQueryObject sqlQueryObjectAutorizzazioniPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("pa_scope", aliasPASCOPE);
                sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("porte_applicative", aliasPA);
                if (isFilterGruppoErogazione) {
                    sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                    sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi", aliasACCORDI);
                    sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                    sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
                }
                if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
                }
                sqlQueryObjectAutorizzazioniPorteApplicative.addSelectAliasField(aliasPASCOPE, "id", aliasPASCOPE + "id");
                sqlQueryObjectAutorizzazioniPorteApplicative.setANDLogicOperator(true);
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPASCOPE + ".scope = scope.nome");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPASCOPE + ".id_porta = " + aliasPA + ".id");
                if (isFilterGruppoErogazione) {
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                    existsParameters.add(filterGruppo);
                }
                if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                    if (apiImplementazioneErogazione != null) {
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                        existsParameters.add(apiImplementazioneErogazione.getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getNome());
                        existsParameters.add(apiImplementazioneErogazione.getVersione());
                    } else if (filterSoggettoProprietario) {
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        existsParameters.add(filterSoggettoTipo);
                        existsParameters.add(filterSoggettoNome);
                    } else if (filterTipoSoggettoProtocollo) {
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                    }
                }
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteApplicative));
            }
            if (!search.equals("")) {
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("scope");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                sqlQueryObject2.addWhereLikeCondition("nome", search, true, true);
                if (scopeContesto != null) {
                    sqlQueryObject2.addWhereCondition("contesto_utilizzo = ?");
                }
                if (scopeTipologia != null) {
                    sqlQueryObject2.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject2.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("scope");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (scopeContesto != null) {
                    sqlQueryObject2.addWhereCondition("contesto_utilizzo = ?");
                }
                if (scopeTipologia != null) {
                    sqlQueryObject2.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject2.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (scopeContesto != null) {
                stmt.setString(index++, scopeContesto.getValue());
            }
            if (scopeTipologia != null) {
                stmt.setString(index++, scopeTipologia);
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object e : existsParameters) {
                    if (e instanceof String) {
                        stmt.setString(index++, (String)e);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)e);
                }
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("scope");
                sqlQueryObject.addSelectField("nome");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (scopeContesto != null) {
                    sqlQueryObject.addWhereCondition("contesto_utilizzo = ?");
                }
                if (scopeTipologia != null) {
                    sqlQueryObject.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("scope");
                sqlQueryObject.addSelectField("nome");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (scopeContesto != null) {
                    sqlQueryObject.addWhereCondition("contesto_utilizzo = ?");
                }
                if (scopeTipologia != null) {
                    sqlQueryObject.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (scopeContesto != null) {
                stmt.setString(index++, scopeContesto.getValue());
            }
            if (scopeTipologia != null) {
                stmt.setString(index++, scopeTipologia);
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object e : existsParameters) {
                    if (e instanceof String) {
                        stmt.setString(index++, (String)e);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)e);
                }
            }
            risultato = stmt.executeQuery();
            listIdScope = new ArrayList<IDScope>();
            while (risultato.next()) {
                listIdScope.add(new IDScope(risultato.getString("nome")));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        if (listIdScope != null) {
            for (IDScope idScope : listIdScope) {
                try {
                    lista.add(this.getScope(idScope));
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new DriverRegistroServiziException(notFound.getMessage(), notFound);
                }
            }
        }
        return lista;
    }
}

