/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.uddi;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.IDriverWS;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.ProtocolPropertiesUtilities;
import org.openspcoop2.core.registry.driver.uddi.UDDILib;
import org.openspcoop2.core.registry.driver.web.XMLLib;
import org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class DriverRegistroServiziUDDI
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    private UDDILib uddiLib = null;
    private String urlPrefix;
    private XMLLib generatoreXML;
    private ValidatoreXSD validatoreRegistro = null;
    private Logger log = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();

    public DriverRegistroServiziUDDI(String inquiry, Logger alog) {
        this(inquiry, null, null, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String user, String password, Logger alog) {
        this(inquiry, null, user, password, null, null, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String publish, String urlPrefix, String pathPrefix, Logger alog) {
        this(inquiry, publish, null, null, urlPrefix, pathPrefix, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String publish, String user, String password, String urlPrefix, String pathPrefix, Logger alog) {
        this.log = alog == null ? LoggerWrapperFactory.getLogger(DriverRegistroServiziUDDI.class) : alog;
        if (this.log == null) {
            throw new UtilsRuntimeException("Logger unavailable");
        }
        try {
            this.uddiLib = publish != null ? new UDDILib(inquiry, publish, user, password) : (user != null && password != null ? new UDDILib(inquiry, user, password) : new UDDILib(inquiry));
            try {
                this.validatoreRegistro = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverRegistroServiziUDDI.class.getResourceAsStream("/registroServizi.xsd"));
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage(), e);
            }
            if (urlPrefix != null) {
                this.urlPrefix = !urlPrefix.endsWith("/") ? urlPrefix + "/" : urlPrefix;
            }
            if (urlPrefix != null && pathPrefix != null) {
                this.generatoreXML = new XMLLib(pathPrefix, urlPrefix);
            }
            this.create = this.uddiLib.create;
        }
        catch (Exception e) {
            this.log.error("Inizializzazione fallita: " + e.getMessage(), (Throwable)e);
            this.create = false;
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Nome accordo servizio non fornito");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsAccordoCooperazione(idAccordo)) {
            throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo richiesto non esiste: " + idAccordo);
        }
        AccordoCooperazione accRichiesto = null;
        String urlXMLAccordoCooperazione = this.uddiLib.getUrlXmlAccordoCooperazione(idAccordo);
        if (urlXMLAccordoCooperazione == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLAccordoCooperazione);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo richiesto non esiste nel repository http: " + idAccordo);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoCooperazione);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[AccordoCooperazione] Riscontrato errore durante la validazione XSD Accordo(" + idAccordo + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeAccordoCooperazioneList() > 0) {
                accRichiesto = rs.getAccordoCooperazione(0);
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[AccordoCooperazione] Errore durante il parsing xml Accordo(" + idAccordo + "): " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo di Cooperazione [" + idAccordo + "] non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            IDAccordoCooperazione idAccordoFiltro = null;
            if (filtroRicerca != null && filtroRicerca.getNomeAccordo() != null) {
                IDSoggetto soggettoReferente = null;
                if (filtroRicerca.getTipoSoggettoReferente() != null && filtroRicerca.getNomeSoggettoReferente() != null) {
                    soggettoReferente = new IDSoggetto(filtroRicerca.getTipoSoggettoReferente(), filtroRicerca.getNomeSoggettoReferente());
                }
                idAccordoFiltro = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(filtroRicerca.getNomeAccordo(), soggettoReferente, filtroRicerca.getVersione());
            }
            String[] urlXMLAccordi = this.uddiLib.getUrlXmlAccordiCooperazione(idAccordoFiltro, this.urlPrefix);
            ArrayList<IDAccordoCooperazione> idAccordi = new ArrayList<IDAccordoCooperazione>();
            for (int i = 0; i < urlXMLAccordi.length; ++i) {
                AccordoCooperazione ac = null;
                try {
                    this.validatoreRegistro.valida(urlXMLAccordi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Riscontrato errore durante la validazione XSD (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLAccordi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizeAccordoCooperazioneList() > 0) {
                        ac = rs.getAccordoCooperazione(0);
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Errore durante il parsing xml (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                if (ac == null) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] accordo non definito per la url [" + urlXMLAccordi[i] + "]");
                }
                String acURI = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di cooperazione [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ac.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di cooperazione [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ac.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !ac.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !ac.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (ac.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !ac.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !ac.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente())) || !ProtocolPropertiesUtilities.isMatch(ac, filtroRicerca.getProtocolPropertiesAccordo())) continue;
                }
                idAccordi.add(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idAccordi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Nome accordo servizio non fornito");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsAccordoServizio(idAccordo)) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo richiesto non esiste: " + idAccordo);
        }
        AccordoServizioParteComune accRichiesto = null;
        String urlXMLAccordoServizio = this.uddiLib.getUrlXmlAccordoServizio(idAccordo);
        if (urlXMLAccordoServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLAccordoServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo richiesto non esiste nel repository http: " + idAccordo);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Riscontrato errore durante la validazione XSD Accordo(" + idAccordo + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeAccordoServizioParteComuneList() > 0) {
                accRichiesto = rs.getAccordoServizioParteComune(0);
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Errore durante il parsing xml Accordo(" + idAccordo + "): " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo di Servizio [" + idAccordo + "] non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordo> list = new ArrayList<IDAccordo>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAccordiServizioParteComune", filtroRicerca, null, null, null, null, list);
        return list;
    }

    @Override
    public List<IDPortType> getAllIdPortType(FiltroRicercaPortTypes filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortType> list = new ArrayList<IDPortType>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdPortType", filtroRicerca, filtroRicerca, null, null, null, list);
        return list;
    }

    @Override
    public List<IDPortTypeAzione> getAllIdAzionePortType(FiltroRicercaOperations filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortTypeAzione> list = new ArrayList<IDPortTypeAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzionePortType", filtroRicerca, null, filtroRicerca, null, null, list);
        return list;
    }

    @Override
    public List<IDAccordoAzione> getAllIdAzioneAccordo(FiltroRicercaAzioni filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordoAzione> list = new ArrayList<IDAccordoAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzioneAccordo", filtroRicerca, null, null, filtroRicerca, null, list);
        return list;
    }

    @Override
    public List<IDResource> getAllIdResource(FiltroRicercaResources filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDResource> list = new ArrayList<IDResource>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdResource", filtroRicerca, null, null, null, filtroRicerca, list);
        return list;
    }

    public <T> void _fillAllIdAccordiServizioParteComuneEngine(String nomeMetodo, FiltroRicercaAccordi filtroRicercaBase, FiltroRicercaPortTypes filtroPT, FiltroRicercaOperations filtroOP, FiltroRicercaAzioni filtroAZ, FiltroRicercaResources filtroResource, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            IDAccordo idAccordoFiltro = null;
            if (filtroRicercaBase != null && filtroRicercaBase.getNomeAccordo() != null) {
                IDSoggetto soggettoReferente = null;
                if (filtroRicercaBase.getTipoSoggettoReferente() != null && filtroRicercaBase.getNomeSoggettoReferente() != null) {
                    soggettoReferente = new IDSoggetto(filtroRicercaBase.getTipoSoggettoReferente(), filtroRicercaBase.getNomeSoggettoReferente());
                }
                idAccordoFiltro = this.idAccordoFactory.getIDAccordoFromValues(filtroRicercaBase.getNomeAccordo(), soggettoReferente, filtroRicercaBase.getVersione());
            }
            String[] urlXMLAccordi = this.uddiLib.getUrlXmlAccordiServizio(idAccordoFiltro, this.urlPrefix);
            ArrayList idAccordi = new ArrayList();
            for (int i = 0; i < urlXMLAccordi.length; ++i) {
                AccordoServizioParteComune as = null;
                try {
                    this.validatoreRegistro.valida(urlXMLAccordi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[" + nomeMetodo + "] Riscontrato errore durante la validazione XSD (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLAccordi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizeAccordoServizioParteComuneList() > 0) {
                        as = rs.getAccordoServizioParteComune(0);
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception deserializer) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[" + nomeMetodo + "] Errore durante il parsing xml (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                if (as == null) {
                    throw new DriverRegistroServiziException("[" + nomeMetodo + "] accordo non definito per la url [" + urlXMLAccordi[i] + "]");
                }
                String asURI = this.idAccordoFactory.getUriFromAccordo(as);
                if (filtroRicercaBase != null) {
                    boolean searchByTipoSoggetto;
                    List<String> tipoSoggettiProtocollo = null;
                    try {
                        if (filtroRicercaBase != null && (filtroRicercaBase.getProtocollo() != null || filtroRicercaBase.getProtocolli() != null && !filtroRicercaBase.getProtocolli().isEmpty())) {
                            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filtroRicercaBase.getProtocollo(), Filtri.convertToString(filtroRicercaBase.getProtocolli()));
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException(e.getMessage(), e);
                    }
                    boolean bl = searchByTipoSoggetto = tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0;
                    if (filtroRicercaBase.getMinDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug("[" + nomeMetodo + "](FiltroByMinDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (as.getOraRegistrazione().before(filtroRicercaBase.getMinDate())) continue;
                    }
                    if (filtroRicercaBase.getMaxDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug("[" + nomeMetodo + "](FiltroByMaxDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (as.getOraRegistrazione().after(filtroRicercaBase.getMaxDate())) continue;
                    }
                    if (filtroRicercaBase.getNomeAccordo() != null && !as.getNome().equals(filtroRicercaBase.getNomeAccordo()) || filtroRicercaBase.getVersione() != null && !as.getVersione().equals(filtroRicercaBase.getVersione())) continue;
                    if (searchByTipoSoggetto || filtroRicercaBase.getTipoSoggettoReferente() != null || filtroRicercaBase.getNomeSoggettoReferente() != null) {
                        if (as.getSoggettoReferente() == null) continue;
                        if (filtroRicercaBase.getTipoSoggettoReferente() != null) {
                            if (!as.getSoggettoReferente().getTipo().equals(filtroRicercaBase.getTipoSoggettoReferente())) {
                                continue;
                            }
                        } else if (searchByTipoSoggetto) {
                            boolean find = false;
                            for (String tipoSoggettoProtocollo : tipoSoggettiProtocollo) {
                                if (!as.getSoggettoReferente().getTipo().equals(tipoSoggettoProtocollo)) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        if (filtroRicercaBase.getNomeSoggettoReferente() != null && !as.getSoggettoReferente().getNome().equals(filtroRicercaBase.getNomeSoggettoReferente())) continue;
                    }
                    if (filtroRicercaBase.getServiceBinding() != null && !as.getServiceBinding().equals(filtroRicercaBase.getServiceBinding())) continue;
                    if (filtroRicercaBase.getIdGruppo() != null && filtroRicercaBase.getIdGruppo().getNome() != null) {
                        boolean found = false;
                        if (as.getGruppi() != null && as.getGruppi().sizeGruppoList() > 0) {
                            for (GruppoAccordo gruppo : as.getGruppi().getGruppoList()) {
                                if (!gruppo.getNome().equals(filtroRicercaBase.getIdGruppo().getNome())) continue;
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                    }
                    if (filtroRicercaBase.getIdAccordoCooperazione() != null && (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null || filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null)) {
                        if (as.getServizioComposto() == null) continue;
                        IDAccordoCooperazione idAC = this.idAccordoCooperazioneFactory.getIDAccordoFromUri(as.getServizioComposto().getAccordoCooperazione());
                        if (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null && !idAC.getNome().equals(filtroRicercaBase.getIdAccordoCooperazione().getNome()) || filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null && !idAC.getVersione().equals(filtroRicercaBase.getIdAccordoCooperazione().getVersione())) {
                            continue;
                        }
                    } else if (filtroRicercaBase.isServizioComposto() != null && (filtroRicercaBase.isServizioComposto() == false ? as.getServizioComposto() != null : as.getServizioComposto() == null)) continue;
                    if (!ProtocolPropertiesUtilities.isMatch(as, filtroRicercaBase.getProtocolPropertiesAccordo())) continue;
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID(as.getSoggettoReferente()), as.getVersione());
                if (filtroPT != null) {
                    for (PortType pt : as.getPortTypeList()) {
                        if (filtroPT.getNomePortType() != null && !pt.getNome().equals(filtroPT.getNomePortType()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroPT.getProtocolPropertiesPortType())) continue;
                        IDPortType idPT = new IDPortType();
                        idPT.setIdAccordo(idAccordo);
                        idPT.setNome(pt.getNome());
                        listReturn.add(idPT);
                    }
                    continue;
                }
                if (filtroOP != null) {
                    for (PortType pt : as.getPortTypeList()) {
                        if (filtroOP.getNomePortType() != null && !pt.getNome().equals(filtroOP.getNomePortType()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroOP.getProtocolPropertiesPortType())) continue;
                        for (Operation op : pt.getAzioneList()) {
                            if (filtroOP.getNomeAzione() != null && !op.getNome().equals(filtroOP.getNomeAzione()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroOP.getProtocolPropertiesAzione())) continue;
                            IDPortTypeAzione idAzione = new IDPortTypeAzione();
                            IDPortType idPT = new IDPortType();
                            idPT.setIdAccordo(idAccordo);
                            idPT.setNome(pt.getNome());
                            idAzione.setIdPortType(idPT);
                            idAzione.setNome(op.getNome());
                            listReturn.add(idAzione);
                        }
                    }
                    continue;
                }
                if (filtroAZ != null) {
                    for (Azione az : as.getAzioneList()) {
                        if (filtroAZ.getNomeAzione() != null && !az.getNome().equals(filtroAZ.getNomeAzione()) || !ProtocolPropertiesUtilities.isMatch(az, filtroAZ.getProtocolPropertiesAzione())) continue;
                        IDAccordoAzione idAzione = new IDAccordoAzione();
                        idAzione.setIdAccordo(idAccordo);
                        idAzione.setNome(az.getNome());
                        listReturn.add(idAzione);
                    }
                    continue;
                }
                if (filtroResource != null) {
                    for (Resource resource : as.getResourceList()) {
                        if (filtroResource.getResourceName() != null && !resource.getNome().equals(filtroResource.getResourceName()) || !ProtocolPropertiesUtilities.isMatch(resource, filtroResource.getProtocolPropertiesResources())) continue;
                        IDResource idResource = new IDResource();
                        idResource.setIdAccordo(idAccordo);
                        idResource.setNome(resource.getNome());
                        listReturn.add(idResource);
                    }
                    continue;
                }
                listReturn.add(idAccordo);
            }
            if (idAccordi.size() <= 0) {
                String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                if (filtroPT != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroPT.toString());
                }
                if (filtroOP != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroOP.toString());
                }
                if (filtroAZ != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroAZ.toString());
                }
                if (filtroRicercaBase != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicercaBase.toString());
                }
                throw new DriverRegistroServiziNotFound("Elementi non trovati");
            }
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException(nomeMetodo + " error", e);
        }
    }

    @Override
    public Documento getAllegato(IDAccordo idAccordo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaSemiformale(IDAccordo idAccordo, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getPortaDominio] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsPortaDominio(nomePdD)) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste: " + nomePdD);
        }
        PortaDominio pddRichiesta = null;
        String urlXMLPortaDominio = this.uddiLib.getUrlXmlPortaDominio(nomePdD);
        if (urlXMLPortaDominio == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste nel repository http: " + nomePdD);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getPortaDominio] Riscontrato errore durante la validazione XSD della Porta di dominio(" + nomePdD + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizePortaDominioList() > 0) {
                pddRichiesta = rs.getPortaDominio(0);
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante il parsing xml della Porta di dominio(" + nomePdD + "): " + e.getMessage(), e);
        }
        if (pddRichiesta == null) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio [" + nomePdD + "] non trovata.");
        }
        return pddRichiesta;
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String nomeFiltro = null;
            if (filtroRicerca != null) {
                nomeFiltro = filtroRicerca.getNome();
            }
            String[] urlXMLPdd = this.uddiLib.getUrlXmlPortaDominio(nomeFiltro, this.urlPrefix);
            ArrayList<String> nomiPdd = new ArrayList<String>();
            for (int i = 0; i < urlXMLPdd.length; ++i) {
                PortaDominio pd = null;
                try {
                    this.validatoreRegistro.valida(urlXMLPdd[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Riscontrato errore durante la validazione XSD (" + urlXMLPdd[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLPdd[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizePortaDominioList() > 0) {
                        pd = rs.getPortaDominio(0);
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Errore durante il parsing xml (" + urlXMLPdd[i] + "): " + e.getMessage(), e);
                }
                if (pd == null) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] porta di dominio non definita per la url [" + urlXMLPdd[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMinDate) Porta di dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMaxDate) Porta di dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pd.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pd.getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPdd.add(pd.getNome());
            }
            if (nomiPdd.size() == 0) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return nomiPdd;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    @Override
    public Gruppo getGruppo(IDGruppo idGruppo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idGruppo == null || idGruppo.getNome() == null) {
            throw new DriverRegistroServiziException("[getGruppo] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getGruppo] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsGruppo(idGruppo.getNome())) {
            throw new DriverRegistroServiziNotFound("[getGruppo] Gruppo richiesto non esiste: " + idGruppo.getNome());
        }
        Gruppo gruppoRichiesto = null;
        String urlXMLGruppo = this.uddiLib.getUrlXmlGruppo(idGruppo.getNome());
        if (urlXMLGruppo == null) {
            throw new DriverRegistroServiziException("[getGruppo] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLGruppo);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getGruppo] Gruppo richiesto non esiste nel repository http: " + idGruppo.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLGruppo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getGruppo] Riscontrato errore durante la validazione XSD del Gruppo (" + idGruppo.getNome() + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeGruppoList() > 0) {
                gruppoRichiesto = rs.getGruppo(0);
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getGruppo] Errore durante il parsing xml del Gruppo (" + idGruppo.getNome() + "): " + e.getMessage(), e);
        }
        if (gruppoRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getGruppo] Gruppo [" + idGruppo.getNome() + "] non trovato.");
        }
        return gruppoRichiesto;
    }

    @Override
    public List<IDGruppo> getAllIdGruppi(FiltroRicercaGruppi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String nomeFiltro = null;
            if (filtroRicerca != null) {
                nomeFiltro = filtroRicerca.getNome();
            }
            String[] urlXMLGruppi = this.uddiLib.getUrlXmlGruppo(nomeFiltro, this.urlPrefix);
            ArrayList<IDGruppo> idGruppi = new ArrayList<IDGruppo>();
            for (int i = 0; i < urlXMLGruppi.length; ++i) {
                Gruppo gruppo = null;
                try {
                    this.validatoreRegistro.valida(urlXMLGruppi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdGruppi] Riscontrato errore durante la validazione XSD (" + urlXMLGruppi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLGruppi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizeGruppoList() > 0) {
                        gruppo = rs.getGruppo(0);
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdGruppi] Errore durante il parsing xml (" + urlXMLGruppi[i] + "): " + e.getMessage(), e);
                }
                if (gruppo == null) {
                    throw new DriverRegistroServiziException("[getAllIdGruppi] Gruppo non definito per la url [" + urlXMLGruppi[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (gruppo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdGruppi](FiltroByMinDate) Gruppo [" + gruppo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (gruppo.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (gruppo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdGruppi](FiltroByMaxDate) Gruppo [" + gruppo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (gruppo.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !gruppo.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getServiceBinding() != null && gruppo.getServiceBinding() != null && !gruppo.getServiceBinding().equals(filtroRicerca.getServiceBinding())) continue;
                }
                IDGruppo id = new IDGruppo(gruppo.getNome());
                idGruppi.add(id);
            }
            if (idGruppi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Gruppi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idGruppi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdGruppi error", e);
        }
    }

    @Override
    public Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idRuolo == null || idRuolo.getNome() == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getRuolo] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsRuolo(idRuolo.getNome())) {
            throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo richiesto non esiste: " + idRuolo.getNome());
        }
        Ruolo ruoloRichiesto = null;
        String urlXMLRuolo = this.uddiLib.getUrlXmlRuolo(idRuolo.getNome());
        if (urlXMLRuolo == null) {
            throw new DriverRegistroServiziException("[getRuolo] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLRuolo);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo richiesto non esiste nel repository http: " + idRuolo.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLRuolo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getRuolo] Riscontrato errore durante la validazione XSD del Ruolo (" + idRuolo.getNome() + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeRuoloList() > 0) {
                ruoloRichiesto = rs.getRuolo(0);
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getRuolo] Errore durante il parsing xml del Ruolo (" + idRuolo.getNome() + "): " + e.getMessage(), e);
        }
        if (ruoloRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo [" + idRuolo.getNome() + "] non trovato.");
        }
        return ruoloRichiesto;
    }

    @Override
    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String nomeFiltro = null;
            if (filtroRicerca != null) {
                nomeFiltro = filtroRicerca.getNome();
            }
            String[] urlXMLRuoli = this.uddiLib.getUrlXmlRuolo(nomeFiltro, this.urlPrefix);
            ArrayList<IDRuolo> idRuoli = new ArrayList<IDRuolo>();
            for (int i = 0; i < urlXMLRuoli.length; ++i) {
                Ruolo ruolo = null;
                try {
                    this.validatoreRegistro.valida(urlXMLRuoli[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Riscontrato errore durante la validazione XSD (" + urlXMLRuoli[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLRuoli[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizeRuoloList() > 0) {
                        ruolo = rs.getRuolo(0);
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Errore durante il parsing xml (" + urlXMLRuoli[i] + "): " + e.getMessage(), e);
                }
                if (ruolo == null) {
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Ruolo non definito per la url [" + urlXMLRuoli[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ruolo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMinDate) Ruolo [" + ruolo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruolo.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ruolo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMaxDate) Ruolo [" + ruolo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruolo.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !ruolo.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && !RuoloTipologia.QUALSIASI.equals(filtroRicerca.getTipologia()) && (ruolo.getTipologia() == null || !RuoloTipologia.QUALSIASI.equals(ruolo.getTipologia()) && !ruolo.getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !RuoloContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (ruolo.getContestoUtilizzo() == null || !RuoloContesto.QUALSIASI.equals(ruolo.getContestoUtilizzo()) && !ruolo.getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDRuolo id = new IDRuolo(ruolo.getNome());
                idRuoli.add(id);
            }
            if (idRuoli.size() == 0) {
                throw new DriverRegistroServiziNotFound("Ruoli non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idRuoli;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdRuoli error", e);
        }
    }

    @Override
    public Scope getScope(IDScope idScope) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idScope == null || idScope.getNome() == null) {
            throw new DriverRegistroServiziException("[getScope] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getScope] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsScope(idScope.getNome())) {
            throw new DriverRegistroServiziNotFound("[getScope] Scope richiesto non esiste: " + idScope.getNome());
        }
        Scope scopeRichiesto = null;
        String urlXMLScope = this.uddiLib.getUrlXmlScope(idScope.getNome());
        if (urlXMLScope == null) {
            throw new DriverRegistroServiziException("[getScope] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLScope);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getScope] Scope richiesto non esiste nel repository http: " + idScope.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLScope);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getScope] Riscontrato errore durante la validazione XSD del Scope (" + idScope.getNome() + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeScopeList() > 0) {
                scopeRichiesto = rs.getScope(0);
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getScope] Errore durante il parsing xml del Scope (" + idScope.getNome() + "): " + e.getMessage(), e);
        }
        if (scopeRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getScope] Scope [" + idScope.getNome() + "] non trovato.");
        }
        return scopeRichiesto;
    }

    @Override
    public List<IDScope> getAllIdScope(FiltroRicercaScope filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String nomeFiltro = null;
            if (filtroRicerca != null) {
                nomeFiltro = filtroRicerca.getNome();
            }
            String[] urlXMLScope = this.uddiLib.getUrlXmlScope(nomeFiltro, this.urlPrefix);
            ArrayList<IDScope> idScope = new ArrayList<IDScope>();
            for (int i = 0; i < urlXMLScope.length; ++i) {
                Scope scope = null;
                try {
                    this.validatoreRegistro.valida(urlXMLScope[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdScope] Riscontrato errore durante la validazione XSD (" + urlXMLScope[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLScope[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizeScopeList() > 0) {
                        scope = rs.getScope(0);
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdScope] Errore durante il parsing xml (" + urlXMLScope[i] + "): " + e.getMessage(), e);
                }
                if (scope == null) {
                    throw new DriverRegistroServiziException("[getAllIdScope] Scope non definito per la url [" + urlXMLScope[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (scope.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdScope](FiltroByMinDate) Scope [" + scope.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (scope.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (scope.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdScope](FiltroByMaxDate) Scope [" + scope.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (scope.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !scope.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && (scope.getTipologia() == null || !scope.getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !ScopeContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (scope.getContestoUtilizzo() == null || !ScopeContesto.QUALSIASI.equals(scope.getContestoUtilizzo()) && !scope.getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDScope id = new IDScope(scope.getNome());
                idScope.add(id);
            }
            if (idScope.size() == 0) {
                throw new DriverRegistroServiziNotFound("Scope non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idScope;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdScope error", e);
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getSoggetto] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idSoggetto)) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Il soggetto [" + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
        }
        Soggetto soggRichiesto = null;
        String urlXMLSoggetto = this.uddiLib.getUrlXmlSoggetto(idSoggetto);
        if (urlXMLSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Definizione xml non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLSoggetto);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto richiesto non esiste nel repository http: " + idSoggetto);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLSoggetto);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getSoggetto] Riscontrato errore durante la validazione XSD del soggetto(" + idSoggetto + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeSoggettoList() > 0) {
                soggRichiesto = rs.getSoggetto(0);
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante il parsing xml del soggetto(" + idSoggetto + "): " + e.getMessage(), e);
        }
        if (soggRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto [" + idSoggetto + "] non trovato.");
        }
        return soggRichiesto;
    }

    @Override
    public Soggetto getSoggettoByCredenzialiBasic(String user, String password, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null, null, false, null, config, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiApiKey(String user, String password, boolean appId, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null, null, false, null, config, appId);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(String subject, String issuer) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, issuer, null, false, null, null, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, null, null, certificate, strictVerifier, null, null, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiPrincipal(String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.PRINCIPAL, null, null, null, null, null, false, principal, null, false);
    }

    private Soggetto getEngineSoggettoAutenticato(CredenzialeTipo tipoCredenziale, String user, String password, String aSubject, String aIssuer, CertificateInfo aCertificate, boolean aStrictVerifier, String principal, CryptConfig config, boolean appId) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (tipoCredenziale == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro tipoCredenziale is null");
        }
        switch (tipoCredenziale) {
            case BASIC: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for basic auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for basic auth)");
            }
            case APIKEY: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for apikey auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for apikey auth)");
            }
            case SSL: {
                if (aSubject != null && !"".equalsIgnoreCase(aSubject) || aCertificate != null) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro subject/certificate is null (required for ssl auth)");
            }
            case PRINCIPAL: {
                if (principal != null && !"".equalsIgnoreCase(principal)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro principal is null (required for principal auth)");
            }
        }
        IDSoggetto idSoggetto = null;
        try {
            FiltroRicercaSoggetti filtroRicerca = new FiltroRicercaSoggetti();
            CredenzialiSoggetto credenzialiSoggetto = new CredenzialiSoggetto();
            credenzialiSoggetto.setTipo(tipoCredenziale);
            switch (tipoCredenziale) {
                case BASIC: {
                    credenzialiSoggetto.setUser(user);
                    credenzialiSoggetto.setPassword(password);
                    break;
                }
                case APIKEY: {
                    credenzialiSoggetto.setUser(user);
                    credenzialiSoggetto.setPassword(password);
                    credenzialiSoggetto.setAppId(appId);
                    break;
                }
                case SSL: {
                    credenzialiSoggetto.setSubject(aSubject);
                    credenzialiSoggetto.setIssuer(aIssuer);
                    if (aCertificate != null) {
                        try {
                            credenzialiSoggetto.setCertificate(aCertificate.getCertificate().getEncoded());
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    }
                    credenzialiSoggetto.setCertificateStrictVerification(aStrictVerifier);
                    break;
                }
                case PRINCIPAL: {
                    credenzialiSoggetto.setUser(principal);
                }
            }
            filtroRicerca.setCredenzialiSoggetto(credenzialiSoggetto, config);
            List<IDSoggetto> l = this.getAllIdSoggetti(filtroRicerca);
            if (l.size() > 1) {
                throw new DriverRegistroServiziException("Trovato pi\u00f9 di un soggetto che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
            }
            if (l.size() == 1) {
                idSoggetto = l.get(0);
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (idSoggetto == null) {
            throw new DriverRegistroServiziNotFound("Nessun soggetto trovato che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
        }
        return this.getSoggetto(idSoggetto);
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String[] urlXMLSoggetti = this.uddiLib.getUrlXmlSoggetti();
            boolean testInChiaro = false;
            ICrypt crypt = null;
            if (filtroRicerca != null && filtroRicerca.getCredenzialiSoggetto() != null && filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                CryptConfig config;
                CredenzialeTipo cTipo = filtroRicerca.getCredenzialiSoggetto().getTipo();
                if (CredenzialeTipo.BASIC.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config == null || config.isBackwardCompatibility()) {
                        testInChiaro = true;
                    }
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    }
                } else if (CredenzialeTipo.APIKEY.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    } else {
                        testInChiaro = true;
                    }
                }
            }
            ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
            for (int i = 0; i < urlXMLSoggetti.length; ++i) {
                Soggetto ss = null;
                try {
                    this.validatoreRegistro.valida(urlXMLSoggetti[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Riscontrato errore durante la validazione XSD (" + urlXMLSoggetti[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLSoggetti[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizeSoggettoList() > 0) {
                        ss = rs.getSoggetto(0);
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception deserializer) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Errore durante il parsing xml (" + urlXMLSoggetti[i] + "): " + e.getMessage(), e);
                }
                if (ss == null) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] soggetto non definito per la url [" + urlXMLSoggetti[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMinDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ss.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMaxDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ss.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ss.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ss.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getNomePdd() != null && !ss.getPortaDominio().equals(filtroRicerca.getNomePdd()) || !ProtocolPropertiesUtilities.isMatch(ss, filtroRicerca.getProtocolProperties())) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (ss.getRuoli() == null) continue;
                        boolean contains = false;
                        for (int j = 0; j < ss.getRuoli().sizeRuoloList(); ++j) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(ss.getRuoli().getRuolo(j).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto() != null) {
                        CredenzialiSoggetto credenziali;
                        CredenzialiSoggetto credenzialiSoggetto = credenziali = ss.sizeCredenzialiList() > 0 ? ss.getCredenziali(0) : null;
                        if (credenziali == null) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getTipo() != null) {
                            if (credenziali.getTipo() == null) {
                                if (!filtroRicerca.getCredenzialiSoggetto().getTipo().equals(CredenzialeTipo.SSL)) {
                                    continue;
                                }
                            } else if (!filtroRicerca.getCredenzialiSoggetto().getTipo().equals(credenziali.getTipo()) || CredenzialeTipo.APIKEY.equals(filtroRicerca.getCredenzialiSoggetto().getTipo()) && (!filtroRicerca.getCredenzialiSoggetto().isAppId() ? credenziali.isAppId() : !credenziali.isAppId())) continue;
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getUser() != null && !filtroRicerca.getCredenzialiSoggetto().getUser().equals(credenziali.getUser())) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                            String passwordSaved = credenziali.getPassword();
                            boolean found = false;
                            if (testInChiaro) {
                                found = filtroRicerca.getCredenzialiSoggetto().getPassword().equals(passwordSaved);
                            }
                            if (!found && crypt != null) {
                                found = crypt.check(filtroRicerca.getCredenzialiSoggetto().getPassword(), passwordSaved);
                            }
                            if (!found) continue;
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                            try {
                                if (credenziali.getSubject() == null) continue;
                                boolean subjectValid = CertificateUtils.sslVerify((String)credenziali.getSubject(), (String)filtroRicerca.getCredenzialiSoggetto().getSubject(), (PrincipalType)PrincipalType.SUBJECT, (Logger)this.log);
                                boolean issuerValid = true;
                                if (filtroRicerca.getCredenzialiSoggetto().getIssuer() != null) {
                                    issuerValid = CertificateUtils.sslVerify((String)credenziali.getIssuer(), (String)filtroRicerca.getCredenzialiSoggetto().getIssuer(), (PrincipalType)PrincipalType.ISSUER, (Logger)this.log);
                                } else {
                                    boolean bl = issuerValid = credenziali.getIssuer() == null;
                                }
                                if (!subjectValid || !issuerValid) {
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverRegistroServiziException(e.getMessage(), e);
                            }
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getCnSubject() != null && filtroRicerca.getCredenzialiSoggetto().getCertificate() != null) {
                            if (!filtroRicerca.getCredenzialiSoggetto().getCnSubject().equals(credenziali.getCnSubject())) continue;
                            Certificate certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])credenziali.getCertificate(), (int)0, null);
                            Certificate certificatoFiltro = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])filtroRicerca.getCredenzialiSoggetto().getCertificate(), (int)0, null);
                            if (!certificatoFiltro.getCertificate().equals(certificato.getCertificate(), filtroRicerca.getCredenzialiSoggetto().isCertificateStrictVerification())) continue;
                        }
                    }
                }
                IDSoggetto idS = new IDSoggetto(ss.getTipo(), ss.getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idSoggetti;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServizio == null || idServizio.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idServizio.getSoggettoErogatore())) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Il soggetto [" + idServizio.getSoggettoErogatore() + "] non risulta gia' inserito nel registro dei servizi.");
        }
        if (!this.uddiLib.existsServizio(idServizio)) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Il servizio [" + idServizio.toString() + "] non risulta gia' registrato nel registro");
        }
        AccordoServizioParteSpecifica servRichiesto = null;
        String urlXMLServizio = this.uddiLib.getUrlXmlServizio(idServizio);
        if (urlXMLServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Definizione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Servizio richiesto non esiste nel repository http: " + idServizio);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Riscontrato errore durante la validazione XSD del servizio(" + idServizio + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                servRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                servRichiesto.setNomeSoggettoErogatore(idServizio.getSoggettoErogatore().getNome());
                servRichiesto.setTipoSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo());
            }
            bin.close();
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Errore durante il parsing xml del servizio(" + idServizio + "): " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Servizio non trovato.");
        }
        return servRichiesto;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null || idAccordo == null || idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idSoggetto)) {
            throw new DriverRegistroServiziNotFound("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
        }
        String[] url = this.uddiLib.getUrlXmlServizi(idSoggetto, idAccordo);
        if (url == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizi correlati che rispettano il parametri di ricerca, non esistenti.");
        }
        AccordoServizioParteSpecifica servCorrelatoRichiesto = null;
        for (int i = 0; i < url.length; ++i) {
            ByteArrayInputStream bin = null;
            try {
                byte[] fileXML = null;
                try {
                    fileXML = HttpUtilities.requestHTTPFile((String)url[i]);
                }
                catch (UtilsException e) {
                    if ("404".equals(e.getMessage())) {
                        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizio richiesto non esiste nel repository http, accordo:" + idAccordo + " e soggetto:" + idSoggetto);
                    }
                    throw e;
                }
                try {
                    this.validatoreRegistro.valida(url[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Riscontrato errore durante la validazione XSD del servizioUrl(" + url[i] + "): " + e.getMessage(), e);
                }
                bin = new ByteArrayInputStream(fileXML);
                JaxbDeserializer deserializer = new JaxbDeserializer();
                RegistroServizi rs = deserializer.readRegistroServizi(bin);
                if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                    servCorrelatoRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                    servCorrelatoRichiesto.setNomeSoggettoErogatore(idSoggetto.getNome());
                    servCorrelatoRichiesto.setTipoSoggettoErogatore(idSoggetto.getTipo());
                }
                bin.close();
                if (servCorrelatoRichiesto == null) continue;
                break;
            }
            catch (Exception e) {
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (e instanceof DriverRegistroServiziNotFound) {
                    throw (DriverRegistroServiziNotFound)e;
                }
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Errore durante il parsing xml del servizioUrl(" + url[i] + "): " + e.getMessage(), e);
            }
        }
        if (servCorrelatoRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizio non trovato.");
        }
        return servCorrelatoRichiesto;
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDServizio> list = new ArrayList<IDServizio>();
        this._fillAllIdServiziEngine("getAllIdServizi", filtroRicerca, list);
        return list;
    }

    @Override
    public List<IDFruizione> getAllIdFruizioniServizio(FiltroRicercaFruizioniServizio filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDFruizione> list = new ArrayList<IDFruizione>();
        this._fillAllIdServiziEngine("getAllIdFruizioniServizio", filtroRicerca, list);
        return list;
    }

    public <T> void _fillAllIdServiziEngine(String nomeMetodo, FiltroRicercaServizi filtroRicerca, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            FiltroRicercaFruizioniServizio filtroFruizioni = null;
            if (filtroRicerca instanceof FiltroRicercaFruizioniServizio) {
                filtroFruizioni = (FiltroRicercaFruizioniServizio)filtroRicerca;
            }
            IDAccordo idAccordo = null;
            IDSoggetto soggettoErogatore = null;
            String tipoServizio = null;
            String nomeServizio = null;
            if (filtroRicerca != null) {
                idAccordo = filtroRicerca.getIdAccordoServizioParteComune();
                if (filtroRicerca.getTipoSoggettoErogatore() != null && filtroRicerca.getNomeSoggettoErogatore() != null) {
                    soggettoErogatore = new IDSoggetto(filtroRicerca.getTipoSoggettoErogatore(), filtroRicerca.getNomeSoggettoErogatore());
                }
                tipoServizio = filtroRicerca.getTipo();
                nomeServizio = filtroRicerca.getNome();
            }
            String[] urlXMLServizi = this.uddiLib.getUrlXMLServiziBySearch(idAccordo, soggettoErogatore, tipoServizio, nomeServizio);
            for (int i = 0; i < urlXMLServizi.length; ++i) {
                AccordoServizioParteSpecifica serv = null;
                try {
                    this.validatoreRegistro.valida(urlXMLServizi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdServizi] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                try {
                    byte[] fileXML = HttpUtilities.requestHTTPFile((String)urlXMLServizi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    RegistroServizi rs = deserializer.readRegistroServizi(bin);
                    if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                        Soggetto s = rs.getSoggetto(0);
                        if (s.sizeAccordoServizioParteSpecificaList() <= 0) continue;
                        serv = s.getAccordoServizioParteSpecifica(0);
                        serv.setNomeSoggettoErogatore(s.getNome());
                        serv.setTipoSoggettoErogatore(s.getTipo());
                    }
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception deserializer) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdServizi] Errore durante il parsing xml del servizio(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                if (serv == null) {
                    throw new DriverRegistroServiziException("[getAllIdServizi] servizio non definito per la url [" + urlXMLServizi[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getTipoSoggettoErogatore() != null && !serv.getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !serv.getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                    if (filtroRicerca.getMinDate() != null) {
                        if (serv.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdServizi](FiltroByMinDate) [" + this.idServizioFactory.getUriFromAccordo(serv) + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (serv.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (serv.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdServizi](FiltroByMaxDate) Servizio[" + this.idServizioFactory.getUriFromAccordo(serv) + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (serv.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !serv.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getVersione() != null && serv.getVersione().intValue() != filtroRicerca.getVersione().intValue() || filtroRicerca.getPortType() != null && !serv.getPortType().equals(filtroRicerca.getPortType())) continue;
                    if (filtroRicerca.getIdAccordoServizioParteComune() != null) {
                        String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordoServizioParteComune());
                        if (!serv.getAccordoServizioParteComune().equals(uriAccordo)) continue;
                    }
                    if (!ProtocolPropertiesUtilities.isMatch(serv, filtroRicerca.getProtocolProperties())) continue;
                    if (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null) {
                        if (serv.sizeFruitoreList() <= 0) continue;
                        boolean found = false;
                        for (int k = 0; k < serv.sizeFruitoreList(); ++k) {
                            Fruitore fruitore = serv.getFruitore(k);
                            if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
                IDServizio idServ = this.idServizioFactory.getIDServizioFromAccordo(serv);
                if (filtroFruizioni != null) {
                    for (Fruitore fruitore : serv.getFruitoreList()) {
                        if (filtroFruizioni.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroFruizioni.getTipoSoggettoFruitore()) || filtroFruizioni.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroFruizioni.getNomeSoggettoFruitore()) || !ProtocolPropertiesUtilities.isMatch(fruitore, filtroFruizioni.getProtocolPropertiesFruizione())) continue;
                        IDFruizione idFruizione = new IDFruizione();
                        idFruizione.setIdServizio(idServ);
                        idFruizione.setIdFruitore(new IDSoggetto(fruitore.getTipo(), fruitore.getNome()));
                        listReturn.add(idFruizione);
                    }
                    continue;
                }
                listReturn.add(idServ);
            }
            if (listReturn.size() <= 0) {
                String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                if (filtroFruizioni != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroFruizioni.toString());
                }
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Elementi non trovati");
            }
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
    }

    @Override
    public Documento getAllegato(IDServizio idASPS, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaSemiformale(IDServizio idASPS, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaSicurezza(IDServizio idASPS, TipiDocumentoSicurezza tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaLivelloServizio(IDServizio idASPS, TipiDocumentoLivelloServizio tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordo, accordoCooperazione);
            String urlXML = this.urlPrefix + "accordi_cooperazione/" + this.generatoreXML.mappingIDAccordoCooperazioneToFileName(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione)) + ".xml";
            this.uddiLib.createAccordoCooperazione(idAccordo, urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Errore generatosi durante la creazione di un nuovo accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoCooperazione] Accordo non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordoOLD = null;
        idAccordoOLD = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da modificare non definito");
            }
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.uddiLib.existsAccordoCooperazione(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordoCooperazione idAccordoNEW = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.uddiLib.existsAccordoCooperazione(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordoOLD, accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW)) {
                String urlXML = this.urlPrefix + "accordi_cooperazione/" + this.generatoreXML.mappingIDAccordoCooperazioneToFileName(idAccordoNEW) + ".xml";
                this.uddiLib.updateAccordoCooperazione(idAccordoOLD, idAccordoNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Errore generatosi durante la modifica dell'accordo di cooperazione [" + idAccordoOLD + "]: " + e);
        }
    }

    @Override
    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da eliminare non definito");
            }
            if (!this.uddiLib.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoCooperazione(idAccordo);
            this.uddiLib.deleteAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Errore generatosi durante l'eliminazione dell'accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(accordoCooperazione) + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordo, accordoServizio);
            String urlXML = this.urlPrefix + "accordi/" + this.generatoreXML.mappingIDAccordoToFileName(this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio)) + ".xml";
            this.uddiLib.createAccordoServizio(idAccordo, urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Errore generatosi durante la creazione di un nuovo accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteComune] Accordo non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordoOLD = null;
        idAccordoOLD = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da modificare non definito");
            }
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.uddiLib.existsAccordoServizio(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordo idAccordoNEW = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.uddiLib.existsAccordoServizio(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordoOLD, accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW)) {
                String urlXML = this.urlPrefix + "accordi/" + this.generatoreXML.mappingIDAccordoToFileName(idAccordoNEW) + ".xml";
                this.uddiLib.updateAccordoServizio(idAccordoOLD, idAccordoNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Errore generatosi durante la modifica dell'accordo di servizio [" + idAccordoOLD + "]: " + e);
        }
    }

    @Override
    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da eliminare non definito");
            }
            if (!this.uddiLib.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoServizioParteComune(idAccordo);
            this.uddiLib.deleteAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Errore generatosi durante l'eliminazione dell'accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(accordoServizio) + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[createPortaDominio] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio non completamente definita nei parametri obbligatori");
            }
            if (this.uddiLib.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pdd.getNome(), pdd);
            String urlXML = this.urlPrefix + "porte_di_dominio/" + pdd.getNome() + ".xml";
            this.uddiLib.createPortaDominio(pdd.getNome(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createPortaDominio] Errore generatosi durante la creazione di una nuova porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            return false;
        }
        try {
            return this.uddiLib.existsPortaDominio(nome);
        }
        catch (Exception e) {
            this.log.error("[existsPortaDominio] Porta di dominio non trovata: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Parametro Non Valido");
        }
        String pddOLD = null;
        if (pddOLD == null) {
            pddOLD = pdd.getNome();
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pddOLD == null) {
                throw new DriverRegistroServiziException("Porta di dominio da modificare non definito");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio modificata non completamente definita nei parametri obbligatori");
            }
            if (!this.uddiLib.existsPortaDominio(pddOLD)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            String pddNEW = pdd.getNome();
            if (!pddOLD.equals(pddNEW) && this.uddiLib.existsPortaDominio(pddNEW)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pddOLD, pdd);
            if (!pddOLD.equals(pddNEW)) {
                String urlXML = this.urlPrefix + "porte_di_dominio/" + pddNEW + ".xml";
                this.uddiLib.updatePortaDominio(pddOLD, pddNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Errore generatosi durante la modifica della porta di dominio [" + pddOLD + "]: " + e);
        }
    }

    @Override
    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio da eliminare non definito");
            }
            if (!this.uddiLib.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deletePortaDominio(pdd.getNome());
            this.uddiLib.deletePortaDominio(pdd.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Errore generatosi durante l'eliminazione della porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[createGruppo] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (gruppo.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsGruppo(gruppo.getNome())) {
                throw new DriverRegistroServiziException("Il gruppo [" + gruppo.getNome() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createGruppo(gruppo.getNome(), gruppo);
            String urlXML = this.urlPrefix + "gruppi/" + gruppo.getNome() + ".xml";
            this.uddiLib.createGruppo(gruppo.getNome(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createGruppo] Errore generatosi durante la creazione di un nuovo gruppo [" + gruppo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsGruppo(IDGruppo idGruppo) throws DriverRegistroServiziException {
        if (idGruppo == null || idGruppo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsGruppo(idGruppo.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsGruppo] Gruppo non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[updateGruppo] Parametro Non Valido");
        }
        IDGruppo idGruppoOLD = null;
        idGruppoOLD = new IDGruppo(gruppo.getNome());
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (idGruppoOLD == null || idGruppoOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo da modificare non definito");
            }
            if (gruppo.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo modificato non completamente definita nei parametri obbligatori");
            }
            if (!this.uddiLib.existsGruppo(idGruppoOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Gruppo [" + idGruppoOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDGruppo idGruppoNEW = new IDGruppo(gruppo.getNome());
            if (!idGruppoOLD.equals(idGruppoNEW) && this.uddiLib.existsGruppo(idGruppoNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Gruppo [" + idGruppoNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createGruppo(idGruppoOLD.getNome(), gruppo);
            if (!idGruppoOLD.equals(idGruppoNEW)) {
                String urlXML = this.urlPrefix + "gruppi/" + idGruppoNEW + ".xml";
                this.uddiLib.updateGruppo(idGruppoOLD.getNome(), idGruppoNEW.getNome(), urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateGruppo] Errore generatosi durante la modifica del gruppo [" + idGruppoOLD + "]: " + e);
        }
    }

    @Override
    public void deleteGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[deleteGruppo] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (gruppo.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo da eliminare non definito");
            }
            if (!this.uddiLib.existsGruppo(gruppo.getNome())) {
                throw new DriverRegistroServiziException("Il Gruppo [" + gruppo.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deleteGruppo(gruppo.getNome());
            this.uddiLib.deleteGruppo(gruppo.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteGruppo] Errore generatosi durante l'eliminazione del gruppo [" + gruppo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[createRuolo] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il ruolo [" + ruolo.getNome() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(ruolo.getNome(), ruolo);
            String urlXML = this.urlPrefix + "ruoli/" + ruolo.getNome() + ".xml";
            this.uddiLib.createRuolo(ruolo.getNome(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createRuolo] Errore generatosi durante la creazione di un nuovo ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException {
        if (idRuolo == null || idRuolo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsRuolo(idRuolo.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsRuolo] Ruolo non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[updateRuolo] Parametro Non Valido");
        }
        IDRuolo idRuoloOLD = null;
        idRuoloOLD = new IDRuolo(ruolo.getNome());
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (idRuoloOLD == null || idRuoloOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da modificare non definito");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo modificato non completamente definita nei parametri obbligatori");
            }
            if (!this.uddiLib.existsRuolo(idRuoloOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDRuolo idRuoloNEW = new IDRuolo(ruolo.getNome());
            if (!idRuoloOLD.equals(idRuoloNEW) && this.uddiLib.existsRuolo(idRuoloNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(idRuoloOLD.getNome(), ruolo);
            if (!idRuoloOLD.equals(idRuoloNEW)) {
                String urlXML = this.urlPrefix + "ruoli/" + idRuoloNEW + ".xml";
                this.uddiLib.updateRuolo(idRuoloOLD.getNome(), idRuoloNEW.getNome(), urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateRuolo] Errore generatosi durante la modifica del ruolo [" + idRuoloOLD + "]: " + e);
        }
    }

    @Override
    public void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[deleteRuolo] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da eliminare non definito");
            }
            if (!this.uddiLib.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + ruolo.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deleteRuolo(ruolo.getNome());
            this.uddiLib.deleteRuolo(ruolo.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteRuolo] Errore generatosi durante l'eliminazione del ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[createScope] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (scope.getNome() == null) {
                throw new DriverRegistroServiziException("Scope non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsScope(scope.getNome())) {
                throw new DriverRegistroServiziException("Il scope [" + scope.getNome() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createScope(scope.getNome(), scope);
            String urlXML = this.urlPrefix + "ruoli/" + scope.getNome() + ".xml";
            this.uddiLib.createScope(scope.getNome(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createScope] Errore generatosi durante la creazione di un nuovo scope [" + scope.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsScope(IDScope idScope) throws DriverRegistroServiziException {
        if (idScope == null || idScope.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsScope(idScope.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsScope] Scope non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[updateScope] Parametro Non Valido");
        }
        IDScope idScopeOLD = null;
        idScopeOLD = new IDScope(scope.getNome());
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (idScopeOLD == null || idScopeOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Scope da modificare non definito");
            }
            if (scope.getNome() == null) {
                throw new DriverRegistroServiziException("Scope modificato non completamente definita nei parametri obbligatori");
            }
            if (!this.uddiLib.existsScope(idScopeOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Scope [" + idScopeOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDScope idScopeNEW = new IDScope(scope.getNome());
            if (!idScopeOLD.equals(idScopeNEW) && this.uddiLib.existsScope(idScopeNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Scope [" + idScopeNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createScope(idScopeOLD.getNome(), scope);
            if (!idScopeOLD.equals(idScopeNEW)) {
                String urlXML = this.urlPrefix + "ruoli/" + idScopeNEW + ".xml";
                this.uddiLib.updateScope(idScopeOLD.getNome(), idScopeNEW.getNome(), urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateScope] Errore generatosi durante la modifica del scope [" + idScopeOLD + "]: " + e);
        }
    }

    @Override
    public void deleteScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[deleteScope] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (scope.getNome() == null) {
                throw new DriverRegistroServiziException("Scope da eliminare non definito");
            }
            if (!this.uddiLib.existsScope(scope.getNome())) {
                throw new DriverRegistroServiziException("Il Scope [" + scope.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deleteScope(scope.getNome());
            this.uddiLib.deleteScope(scope.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteScope] Errore generatosi durante l'eliminazione del scope [" + scope.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[createSoggetto] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            String idSoggetto_string = soggetto.getTipo() + soggetto.getNome();
            if (this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] risulta gia' inserito nel registro dei servizi.");
            }
            String urlXML = this.urlPrefix + idSoggetto_string + "/" + idSoggetto_string + ".xml";
            this.generatoreXML.createSoggetto(idSoggetto, soggetto);
            this.uddiLib.createSoggetto(idSoggetto, soggetto.getDescrizione(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createSoggetto] Errore generatosi durante la creazione del nuovo Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto == null) {
            return false;
        }
        try {
            return this.uddiLib.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[updateSoggetto] Parametro Non Valido");
        }
        String tipoOLD = null;
        String nomeOLD = null;
        if (soggetto.getOldIDSoggettoForUpdate() != null) {
            tipoOLD = soggetto.getOldIDSoggettoForUpdate().getTipo();
            nomeOLD = soggetto.getOldIDSoggettoForUpdate().getNome();
        }
        if (tipoOLD == null || nomeOLD == null) {
            tipoOLD = soggetto.getTipo();
            nomeOLD = soggetto.getNome();
        }
        String idSoggettoOLD_string = tipoOLD + nomeOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoOLD, nomeOLD);
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (tipoOLD == null || nomeOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare non definito");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto modificato non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggettoNEW = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (!this.uddiLib.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = soggetto.getTipo() + soggetto.getNome();
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && this.uddiLib.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("La nuova identita da associare al soggetto [" + idSoggettoNEW_string + "] risulta gia' utilizzata nel registro dei servizi.");
            }
            String urlXML = this.urlPrefix + idSoggettoNEW_string + "/" + idSoggettoNEW_string + ".xml";
            this.generatoreXML.createSoggetto(idSoggettoOLD, soggetto);
            this.uddiLib.updateIdentificativoPortaSoggetto(idSoggettoOLD, soggetto.getIdentificativoPorta());
            this.uddiLib.updateDescrizioneSoggetto(idSoggettoOLD, soggetto.getDescrizione());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.uddiLib.updateUrlXmlSoggetto(idSoggettoOLD, urlXML);
                this.uddiLib.updateIdSoggetto(idSoggettoOLD, idSoggettoNEW);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateSoggetto] Errore generatosi durante la modifica del Soggetto [" + idSoggettoOLD + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (soggetto.getTipo() == null || soggetto.getNome() == null) {
                throw new DriverRegistroServiziException("Soggetto da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            if (!this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteSoggetto(idSoggetto);
            this.uddiLib.deleteSoggetto(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Errore generatosi durante l'eliminazione del Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        try {
            int i;
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (asps.getNomeSoggettoErogatore() == null || asps.getTipoSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (asps.getNome() == null || asps.getTipo() == null || asps.getVersione() == null) {
                throw new DriverRegistroServiziException("Servizio, non definito");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (asps.getConfigurazioneServizio() != null && asps.getConfigurazioneServizio().getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(asps.getConfigurazioneServizio().getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (asps.getConfigurazioneServizio().getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                for (int j = 0; j < checkFr.sizeConfigurazioneAzioneList(); ++j) {
                    ConfigurazioneServizioAzione checkAz = checkFr.getConfigurazioneAzione(j);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un azione (fruizione) senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso delle azioni " + checkAz.getAzioneList() + " della fruizione di servizio non corretta");
                }
                String idSoggettoFruitore_string = checkFr.getTipo() + checkFr.getNome();
                IDSoggetto idSoggettoFruitore = new IDSoggetto(checkFr.getTipo(), checkFr.getNome());
                if (this.uddiLib.existsSoggetto(idSoggettoFruitore)) continue;
                throw new DriverRegistroServiziException("Il fruitore [" + idSoggettoFruitore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            if (asps.getConfigurazioneServizio() != null) {
                for (i = 0; i < asps.getConfigurazioneServizio().sizeConfigurazioneAzioneList(); ++i) {
                    ConfigurazioneServizioAzione checkAz = asps.getConfigurazioneServizio().getConfigurazioneAzione(i);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un azione senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso delle azioni " + checkAz.getAzioneList() + " del servizio non corretta");
                }
            }
            IDSoggetto idSoggettoErogatore = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            String idSoggettoErogatore_string = asps.getTipoSoggettoErogatore() + asps.getNomeSoggettoErogatore();
            if (!this.uddiLib.existsSoggetto(idSoggettoErogatore)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoErogatore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idServizio_string = asps.getTipo() + asps.getNome() + asps.getVersione();
            String uriServizio = this.idServizioFactory.getUriFromAccordo(asps);
            IDServizio idServizio = this.idServizioFactory.getIDServizioFromAccordo(asps);
            if (this.uddiLib.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + uriServizio + "] risulta gia' registrato nel registro");
            }
            String urlXML = this.urlPrefix + idSoggettoErogatore_string + "/servizi/" + idServizio_string + ".xml";
            this.generatoreXML.createAccordoServizioParteSpecifica(idServizio, asps);
            this.uddiLib.createServizio(idServizio, urlXML, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Errore generatosi durante la creazione del nuovo Servizio [" + this.idServizioFactory.getUriFromAccordo(asps) + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            return false;
        }
        try {
            this.getAccordoServizioParteSpecifica(idServizio);
            return true;
        }
        catch (DriverRegistroServiziNotFound de) {
            return false;
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteSpecifica] Servizio non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String tipoServizioOLD = null;
        String nomeServizioOLD = null;
        Integer versioneServizioOLD = null;
        if (asps.getOldIDServizioForUpdate() != null) {
            tipoServizioOLD = asps.getOldIDServizioForUpdate().getTipo();
            nomeServizioOLD = asps.getOldIDServizioForUpdate().getNome();
            versioneServizioOLD = asps.getOldIDServizioForUpdate().getVersione();
        }
        if (tipoServizioOLD == null || nomeServizioOLD == null || versioneServizioOLD == null) {
            tipoServizioOLD = asps.getTipo();
            nomeServizioOLD = asps.getNome();
            versioneServizioOLD = asps.getVersione();
        }
        String tipoSoggettoOLD = null;
        String nomeSoggettoOLD = null;
        if (asps.getOldIDServizioForUpdate() != null && asps.getOldIDServizioForUpdate().getSoggettoErogatore() != null) {
            tipoSoggettoOLD = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo();
            nomeSoggettoOLD = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
        }
        if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
            tipoSoggettoOLD = asps.getTipoSoggettoErogatore();
            nomeSoggettoOLD = asps.getNomeSoggettoErogatore();
        }
        String idSoggettoOLD_string = tipoSoggettoOLD + nomeSoggettoOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoSoggettoOLD, nomeSoggettoOLD);
        String idServizioOLD_string = tipoServizioOLD + nomeServizioOLD + versioneServizioOLD;
        IDServizio idServizioOLD = this.idServizioFactory.getIDServizioFromValues(tipoServizioOLD, nomeServizioOLD, idSoggettoOLD, versioneServizioOLD);
        try {
            int i;
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare, erogatore del servizio, non definito");
            }
            if (asps.getTipoSoggettoErogatore() == null || asps.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (tipoServizioOLD == null || nomeServizioOLD == null) {
                throw new DriverRegistroServiziException("Servizio da modificare non definito");
            }
            if (asps.getNome() == null || asps.getTipo() == null || asps.getVersione() == null) {
                throw new DriverRegistroServiziException("Dati del nuovo servizio, non definiti");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (asps.getConfigurazioneServizio() != null && asps.getConfigurazioneServizio().getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(asps.getConfigurazioneServizio().getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (asps.getConfigurazioneServizio().getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                for (int j = 0; j < checkFr.sizeConfigurazioneAzioneList(); ++j) {
                    ConfigurazioneServizioAzione checkAz = checkFr.getConfigurazioneAzione(j);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getAzioneList() + " della fruizione di servizio non corretta");
                }
            }
            if (asps.getConfigurazioneServizio() != null) {
                for (i = 0; i < asps.getConfigurazioneServizio().sizeConfigurazioneAzioneList(); ++i) {
                    ConfigurazioneServizioAzione checkAz = asps.getConfigurazioneServizio().getConfigurazioneAzione(i);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getAzioneList() + " del servizio non corretta");
                }
            }
            if (!this.uddiLib.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] da modificare, non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = asps.getTipoSoggettoErogatore() + asps.getNomeSoggettoErogatore();
            IDSoggetto idSoggettoNEW = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && !this.uddiLib.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoNEW_string + "] a cui re-assegnare il servizio, non risulta gia' inserito nel registro dei servizi.");
            }
            if (!this.uddiLib.existsServizio(idServizioOLD)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "] non risulta gia' registrato nel registro");
            }
            IDServizio idServizioNEW = this.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), idSoggettoNEW, asps.getVersione());
            String idServizioNEW_string = asps.getTipo() + asps.getNome() + asps.getVersione();
            if (!idServizioOLD_string.equals(idServizioNEW_string) && this.uddiLib.existsServizio(idServizioNEW)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioNEW_string + "] erogato dal soggetto [" + idSoggettoNEW_string + "] risulta gia' registrato nel registro");
            }
            String urlXML = this.urlPrefix + idSoggettoNEW_string + "/servizi/" + idServizioNEW_string + ".xml";
            if (idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioOLD, asps);
                this.uddiLib.updateAccordoServizio(idServizioOLD, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                this.uddiLib.updateUrlXmlServizio(idServizioOLD, urlXML);
                this.uddiLib.updateIdServizio(idServizioOLD, idServizioNEW);
            } else {
                this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizioOLD);
                this.uddiLib.deleteServizio(idServizioOLD);
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioNEW, asps);
                this.uddiLib.createServizio(idServizioNEW, urlXML, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Errore generatosi durante la modifica del Servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String idSoggetto_string = asps.getTipoSoggettoErogatore() + asps.getNomeSoggettoErogatore();
        String idServizio_string = asps.getTipo() + asps.getNome() + asps.getVersione();
        try {
            if (asps.getTipoSoggettoErogatore() == null || asps.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (asps.getTipo() == null || asps.getNome() == null || asps.getVersione() == null) {
                throw new DriverRegistroServiziException("Servizio da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            if (!this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDServizio idServizio = this.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), idSoggetto, asps.getVersione());
            if (!this.uddiLib.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "] non risulta gia' registrato nel registro");
            }
            this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizio);
            this.uddiLib.deleteServizio(idServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Errore generatosi durante l'eliminazione del Servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void reset() throws DriverRegistroServiziException {
        Cloneable idS;
        Cloneable idInEliminazione;
        int i;
        Object inEliminazione = null;
        try {
            AccordoServizioParteComune[] accordiRegistrati = this.generatoreXML.getAccordiServizioParteComune();
            if (accordiRegistrati != null) {
                for (i = 0; i < accordiRegistrati.length; ++i) {
                    idInEliminazione = this.idAccordoFactory.getIDAccordoFromAccordo(accordiRegistrati[i]);
                    this.log.info("eliminazione accordo di servizio [" + idInEliminazione + "] in corso...");
                    if (this.existsAccordoServizioParteComune((IDAccordo)idInEliminazione)) {
                        this.deleteAccordoServizioParteComune(accordiRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoServizioParteComune((IDAccordo)idInEliminazione);
                    }
                    this.log.info("eliminazione accordo di servizio [" + idInEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            AccordoCooperazione[] accordiCooperazioneRegistrati = this.generatoreXML.getAccordiCooperazione();
            if (accordiCooperazioneRegistrati != null) {
                for (i = 0; i < accordiCooperazioneRegistrati.length; ++i) {
                    idInEliminazione = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordiCooperazioneRegistrati[i]);
                    this.log.info("eliminazione accordo di cooperazione [" + (IDAccordoCooperazione)idInEliminazione + "] in corso...");
                    if (this.existsAccordoCooperazione((IDAccordoCooperazione)idInEliminazione)) {
                        this.deleteAccordoCooperazione(accordiCooperazioneRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoCooperazione((IDAccordoCooperazione)idInEliminazione);
                    }
                    this.log.info("eliminazione accordo di cooperazione [" + (IDAccordoCooperazione)idInEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            AccordoServizioParteSpecifica[] serviziRegistrati = this.generatoreXML.getAccordiServiziParteSpecifica();
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    inEliminazione = this.idServizioFactory.getUriFromAccordo(serviziRegistrati[i]);
                    this.log.info("eliminazione servizio [" + (String)inEliminazione + "] in corso...");
                    idS = this.idServizioFactory.getIDServizioFromAccordo(serviziRegistrati[i]);
                    if (this.existsAccordoServizioParteSpecifica((IDServizio)idS)) {
                        this.deleteAccordoServizioParteSpecifica(serviziRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoServizioParteSpecifica((IDServizio)idS);
                    }
                    this.log.info("eliminazione servizio [" + (String)inEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            Soggetto[] soggettiRegistrati = this.generatoreXML.getSoggetti();
            if (soggettiRegistrati != null) {
                for (i = 0; i < soggettiRegistrati.length; ++i) {
                    inEliminazione = soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome();
                    this.log.info("eliminazione soggetto [" + (String)inEliminazione + "] in corso...");
                    idS = new IDSoggetto(soggettiRegistrati[i].getTipo(), soggettiRegistrati[i].getNome());
                    if (this.existsSoggetto((IDSoggetto)idS)) {
                        this.deleteSoggetto(soggettiRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteSoggetto((IDSoggetto)idS);
                    }
                    this.log.info("eliminazione soggetto [" + (String)inEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei soggetti registrati [" + (String)inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            PortaDominio[] pddRegistrate = this.generatoreXML.getPorteDominio();
            if (pddRegistrate != null) {
                for (i = 0; i < pddRegistrate.length; ++i) {
                    inEliminazione = pddRegistrate[i].getNome();
                    this.log.info("eliminazione porta di dominio [" + (String)inEliminazione + "] in corso...");
                    if (this.existsPortaDominio((String)inEliminazione)) {
                        this.deletePortaDominio(pddRegistrate[i]);
                    } else {
                        this.generatoreXML.deletePortaDominio((String)inEliminazione);
                    }
                    this.log.info("eliminazione porta di dominio [" + (String)inEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + (String)inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione delle porte di dominio registrate [" + (String)inEliminazione + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        try {
            if (this.uddiLib.getTModel("isAliveTest", "OpenSPCoop:SPCoopIdentifier") == null) {
                throw new Exception("TModel [OpenSPCoop:SPCoopIdentifier] non trovata");
            }
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }
}

