/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.web;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.IDriverWS;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.ProtocolPropertiesUtilities;
import org.openspcoop2.core.registry.driver.web.XMLLib;
import org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class DriverRegistroServiziWEB
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    private String urlPrefix;
    private XMLLib generatoreXML;
    private ValidatoreXSD validatoreRegistro = null;
    private Logger log = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();

    public DriverRegistroServiziWEB(String urlPrefix, Logger alog) {
        this(urlPrefix, null, alog);
    }

    public DriverRegistroServiziWEB(String urlPrefix, String pathPrefix, Logger alog) {
        this.log = alog == null ? LoggerWrapperFactory.getLogger(DriverRegistroServiziWEB.class) : alog;
        if (this.log == null) {
            throw new UtilsRuntimeException("Logger unavailable");
        }
        try {
            this.urlPrefix = !urlPrefix.endsWith("/") ? urlPrefix + "/" : urlPrefix;
            try {
                this.validatoreRegistro = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverRegistroServiziWEB.class.getResourceAsStream("/registroServizi.xsd"));
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage(), e);
            }
            if (pathPrefix != null) {
                this.generatoreXML = new XMLLib(pathPrefix, urlPrefix);
            }
            this.create = true;
        }
        catch (Exception e) {
            this.log.error("Inizializzazione fallita: " + e.getMessage());
            this.create = false;
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Nome accordo cooperazione non fornito");
        }
        AccordoCooperazione accRichiesto = null;
        String fileName = this.generatoreXML.mappingIDAccordoCooperazioneToFileName(idAccordo);
        String urlXMLAccordoCooperazione = this.urlPrefix + "accordi_cooperazione/" + fileName + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLAccordoCooperazione);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo richiesto non esiste: " + fileName);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoCooperazione);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoCooperazione] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeAccordoCooperazioneList() > 0) {
                accRichiesto = rs.getAccordoCooperazione(0);
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo di Cooperazione non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoCooperazione[] acList = this.generatoreXML.getAccordiCooperazione();
            if (acList == null) {
                throw new DriverRegistroServiziNotFound("Accordi non esistenti nel repository WEB");
            }
            ArrayList<IDAccordoCooperazione> idAccordi = new ArrayList<IDAccordoCooperazione>();
            for (int i = 0; i < acList.length; ++i) {
                String fileName = this.generatoreXML.mappingUriToFileName_accordoCooperazione(this.idAccordoCooperazioneFactory.getUriFromAccordo(acList[i]));
                String acUrlXML = this.urlPrefix + "accordi_cooperazione/" + fileName + ".xml";
                String acURI = this.idAccordoCooperazioneFactory.getUriFromAccordo(acList[i]);
                try {
                    this.validatoreRegistro.valida(acUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Riscontrato errore durante la validazione XSD (" + acUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (acList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di servizio [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (acList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (acList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di servizio [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (acList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !acList[i].getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !acList[i].getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (acList[i].getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !acList[i].getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !acList[i].getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente())) || !ProtocolPropertiesUtilities.isMatch(acList[i], filtroRicerca.getProtocolPropertiesAccordo())) continue;
                }
                idAccordi.add(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(acList[i]));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idAccordi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[AccordoServizioParteComune] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[AccordoServizioParteComune] Nome accordo servizio non fornito");
        }
        AccordoServizioParteComune accRichiesto = null;
        String fileName = this.generatoreXML.mappingIDAccordoToFileName(idAccordo);
        String urlXMLAccordoServizio = this.urlPrefix + "accordi/" + fileName + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLAccordoServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[AccordoServizioParteComune] Accordo richiesto non esiste: " + fileName);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[AccordoServizioParteComune] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeAccordoServizioParteComuneList() > 0) {
                accRichiesto = rs.getAccordoServizioParteComune(0);
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[AccordoServizioParteComune] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[AccordoServizioParteComune] Accordo di Servizio non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordo> list = new ArrayList<IDAccordo>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAccordiServizioParteComune", filtroRicerca, null, null, null, null, list);
        return list;
    }

    @Override
    public List<IDPortType> getAllIdPortType(FiltroRicercaPortTypes filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortType> list = new ArrayList<IDPortType>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdPortType", filtroRicerca, filtroRicerca, null, null, null, list);
        return list;
    }

    @Override
    public List<IDPortTypeAzione> getAllIdAzionePortType(FiltroRicercaOperations filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortTypeAzione> list = new ArrayList<IDPortTypeAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzionePortType", filtroRicerca, null, filtroRicerca, null, null, list);
        return list;
    }

    @Override
    public List<IDAccordoAzione> getAllIdAzioneAccordo(FiltroRicercaAzioni filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordoAzione> list = new ArrayList<IDAccordoAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzioneAccordo", filtroRicerca, null, null, filtroRicerca, null, list);
        return list;
    }

    @Override
    public List<IDResource> getAllIdResource(FiltroRicercaResources filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDResource> list = new ArrayList<IDResource>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdResource", filtroRicerca, null, null, null, filtroRicerca, list);
        return list;
    }

    public <T> void _fillAllIdAccordiServizioParteComuneEngine(String nomeMetodo, FiltroRicercaAccordi filtroRicercaBase, FiltroRicercaPortTypes filtroPT, FiltroRicercaOperations filtroOP, FiltroRicercaAzioni filtroAZ, FiltroRicercaResources filtroResource, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[" + nomeMetodo + "] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoServizioParteComune[] asList = this.generatoreXML.getAccordiServizioParteComune();
            if (asList == null) {
                throw new DriverRegistroServiziNotFound("Accordi non esistenti nel repository WEB");
            }
            for (int i = 0; i < asList.length; ++i) {
                String fileName = this.generatoreXML.mappingUriToFileName(this.idAccordoFactory.getUriFromAccordo(asList[i]));
                String asUrlXML = this.urlPrefix + "accordi/" + fileName + ".xml";
                String asURI = this.idAccordoFactory.getUriFromAccordo(asList[i]);
                try {
                    this.validatoreRegistro.valida(asUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteComune] Riscontrato errore durante la validazione XSD (" + asUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicercaBase != null) {
                    boolean searchByTipoSoggetto;
                    List<String> tipoSoggettiProtocollo = null;
                    try {
                        if (filtroRicercaBase != null && (filtroRicercaBase.getProtocollo() != null || filtroRicercaBase.getProtocolli() != null && !filtroRicercaBase.getProtocolli().isEmpty())) {
                            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filtroRicercaBase.getProtocollo(), Filtri.convertToString(filtroRicercaBase.getProtocolli()));
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException(e.getMessage(), e);
                    }
                    boolean bl = searchByTipoSoggetto = tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0;
                    if (filtroRicercaBase.getMinDate() != null) {
                        if (asList[i].getOraRegistrazione() == null) {
                            this.log.debug("[" + nomeMetodo + "](FiltroByMinDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (asList[i].getOraRegistrazione().before(filtroRicercaBase.getMinDate())) continue;
                    }
                    if (filtroRicercaBase.getMaxDate() != null) {
                        if (asList[i].getOraRegistrazione() == null) {
                            this.log.debug("[" + nomeMetodo + "](FiltroByMaxDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (asList[i].getOraRegistrazione().after(filtroRicercaBase.getMaxDate())) continue;
                    }
                    if (filtroRicercaBase.getNomeAccordo() != null && !asList[i].getNome().equals(filtroRicercaBase.getNomeAccordo()) || filtroRicercaBase.getVersione() != null && !asList[i].getVersione().equals(filtroRicercaBase.getVersione())) continue;
                    if (searchByTipoSoggetto || filtroRicercaBase.getTipoSoggettoReferente() != null || filtroRicercaBase.getNomeSoggettoReferente() != null) {
                        if (asList[i].getSoggettoReferente() == null) continue;
                        if (filtroRicercaBase.getTipoSoggettoReferente() != null) {
                            if (!asList[i].getSoggettoReferente().getTipo().equals(filtroRicercaBase.getTipoSoggettoReferente())) {
                                continue;
                            }
                        } else if (searchByTipoSoggetto) {
                            boolean find = false;
                            for (String tipoSoggettoProtocollo : tipoSoggettiProtocollo) {
                                if (!asList[i].getSoggettoReferente().getTipo().equals(tipoSoggettoProtocollo)) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        if (filtroRicercaBase.getNomeSoggettoReferente() != null && !asList[i].getSoggettoReferente().getNome().equals(filtroRicercaBase.getNomeSoggettoReferente())) continue;
                    }
                    if (filtroRicercaBase.getServiceBinding() != null && !asList[i].getServiceBinding().equals(filtroRicercaBase.getServiceBinding())) continue;
                    if (filtroRicercaBase.getIdGruppo() != null && filtroRicercaBase.getIdGruppo().getNome() != null) {
                        boolean found = false;
                        if (asList[i].getGruppi() != null && asList[i].getGruppi().sizeGruppoList() > 0) {
                            for (GruppoAccordo gruppo : asList[i].getGruppi().getGruppoList()) {
                                if (!gruppo.getNome().equals(filtroRicercaBase.getIdGruppo().getNome())) continue;
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                    }
                    if (filtroRicercaBase.getIdAccordoCooperazione() != null && (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null || filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null)) {
                        if (asList[i].getServizioComposto() == null) continue;
                        IDAccordoCooperazione idAC = this.idAccordoCooperazioneFactory.getIDAccordoFromUri(asList[i].getServizioComposto().getAccordoCooperazione());
                        if (filtroRicercaBase.getIdAccordoCooperazione().getNome() != null && !idAC.getNome().equals(filtroRicercaBase.getIdAccordoCooperazione().getNome()) || filtroRicercaBase.getIdAccordoCooperazione().getVersione() != null && !idAC.getVersione().equals(filtroRicercaBase.getIdAccordoCooperazione().getVersione())) {
                            continue;
                        }
                    } else if (filtroRicercaBase.isServizioComposto() != null && (filtroRicercaBase.isServizioComposto() == false ? asList[i].getServizioComposto() != null : asList[i].getServizioComposto() == null)) continue;
                    if (!ProtocolPropertiesUtilities.isMatch(asList[i], filtroRicercaBase.getProtocolPropertiesAccordo())) continue;
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(asList[i].getNome(), BeanUtilities.getSoggettoReferenteID(asList[i].getSoggettoReferente()), asList[i].getVersione());
                if (filtroPT != null) {
                    for (PortType pt : asList[i].getPortTypeList()) {
                        if (filtroPT.getNomePortType() != null && !pt.getNome().equals(filtroPT.getNomePortType()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroPT.getProtocolPropertiesPortType())) continue;
                        IDPortType idPT = new IDPortType();
                        idPT.setIdAccordo(idAccordo);
                        idPT.setNome(pt.getNome());
                        listReturn.add(idPT);
                    }
                    continue;
                }
                if (filtroOP != null) {
                    for (PortType pt : asList[i].getPortTypeList()) {
                        if (filtroOP.getNomePortType() != null && !pt.getNome().equals(filtroOP.getNomePortType()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroOP.getProtocolPropertiesPortType())) continue;
                        for (Operation op : pt.getAzioneList()) {
                            if (filtroOP.getNomeAzione() != null && !op.getNome().equals(filtroOP.getNomeAzione()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroOP.getProtocolPropertiesAzione())) continue;
                            IDPortTypeAzione idAzione = new IDPortTypeAzione();
                            IDPortType idPT = new IDPortType();
                            idPT.setIdAccordo(idAccordo);
                            idPT.setNome(pt.getNome());
                            idAzione.setIdPortType(idPT);
                            idAzione.setNome(op.getNome());
                            listReturn.add(idAzione);
                        }
                    }
                    continue;
                }
                if (filtroAZ != null) {
                    for (Azione az : asList[i].getAzioneList()) {
                        if (filtroAZ.getNomeAzione() != null && !az.getNome().equals(filtroAZ.getNomeAzione()) || !ProtocolPropertiesUtilities.isMatch(az, filtroAZ.getProtocolPropertiesAzione())) continue;
                        IDAccordoAzione idAzione = new IDAccordoAzione();
                        idAzione.setIdAccordo(idAccordo);
                        idAzione.setNome(az.getNome());
                        listReturn.add(idAzione);
                    }
                    continue;
                }
                if (filtroResource != null) {
                    for (Resource resource : asList[i].getResourceList()) {
                        if (filtroResource.getResourceName() != null && !resource.getNome().equals(filtroResource.getResourceName()) || !ProtocolPropertiesUtilities.isMatch(resource, filtroResource.getProtocolPropertiesResources())) continue;
                        IDResource idResource = new IDResource();
                        idResource.setIdAccordo(idAccordo);
                        idResource.setNome(resource.getNome());
                        listReturn.add(idResource);
                    }
                    continue;
                }
                listReturn.add(idAccordo);
            }
            if (listReturn.size() <= 0) {
                String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                if (filtroPT != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroPT.toString());
                }
                if (filtroOP != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroOP.toString());
                }
                if (filtroAZ != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroAZ.toString());
                }
                if (filtroRicercaBase != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicercaBase.toString());
                }
                throw new DriverRegistroServiziNotFound("Elementi non trovati");
            }
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException(nomeMetodo + " error", e);
        }
    }

    @Override
    public Documento getAllegato(IDAccordo idAccordo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaSemiformale(IDAccordo idAccordo, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        PortaDominio pddRichiesta = null;
        String urlXMLPortaDominio = this.urlPrefix + "porte_di_dominio/" + nomePdD + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste: " + nomePdD);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getPortaDominio] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizePortaDominioList() > 0) {
                pddRichiesta = rs.getPortaDominio(0);
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (pddRichiesta == null) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di Dominio non trovata.");
        }
        return pddRichiesta;
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdPorteDominio] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            PortaDominio[] pddList = this.generatoreXML.getPorteDominio();
            if (pddList == null) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non esistenti nel repository WEB");
            }
            ArrayList<String> nomiPdd = new ArrayList<String>();
            for (int i = 0; i < pddList.length; ++i) {
                String pdUrlXML = this.urlPrefix + "porte_di_dominio/" + pddList[i].getNome() + ".xml";
                try {
                    this.validatoreRegistro.valida(pdUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Riscontrato errore durante la validazione XSD (" + pdUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pddList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMinDate) Porta di Dominio [" + pddList[i].getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pddList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pddList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMaxDate) Porta di Dominio [" + pddList[i].getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pddList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pddList[i].getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPdd.add(pddList[i].getNome());
            }
            if (nomiPdd.size() == 0) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return nomiPdd;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    @Override
    public Gruppo getGruppo(IDGruppo idGruppo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idGruppo == null || idGruppo.getNome() == null) {
            throw new DriverRegistroServiziException("[getGruppo] Parametro Non Valido");
        }
        Gruppo gruppoRichiesto = null;
        String urlXMLPortaDominio = this.urlPrefix + "gruppi/" + idGruppo.getNome() + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getGruppo] Gruppo richiesto non esiste: " + idGruppo.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getGruppo] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeGruppoList() > 0) {
                gruppoRichiesto = rs.getGruppo(0);
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getGruppo] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (gruppoRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getGruppo] Gruppo non trovato.");
        }
        return gruppoRichiesto;
    }

    @Override
    public List<IDGruppo> getAllIdGruppi(FiltroRicercaGruppi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdGruppi] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            Gruppo[] gruppoList = this.generatoreXML.getGruppi();
            if (gruppoList == null) {
                throw new DriverRegistroServiziNotFound("Gruppi non esistenti nel repository WEB");
            }
            ArrayList<IDGruppo> idGruppi = new ArrayList<IDGruppo>();
            for (int i = 0; i < gruppoList.length; ++i) {
                String gruppoUrlXML = this.urlPrefix + "gruppi/" + gruppoList[i].getNome() + ".xml";
                try {
                    this.validatoreRegistro.valida(gruppoUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdGruppi] Riscontrato errore durante la validazione XSD (" + gruppoUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (gruppoList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdGruppi](FiltroByMinDate) Gruppo [" + gruppoList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (gruppoList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (gruppoList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdGruppi](FiltroByMaxDate) Gruppo [" + gruppoList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (gruppoList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !gruppoList[i].getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getServiceBinding() != null && gruppoList[i].getServiceBinding() != null && !gruppoList[i].getServiceBinding().equals(filtroRicerca.getServiceBinding())) continue;
                }
                IDGruppo id = new IDGruppo(gruppoList[i].getNome());
                idGruppi.add(id);
            }
            if (idGruppi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Gruppi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idGruppi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdGruppi error", e);
        }
    }

    @Override
    public Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idRuolo == null || idRuolo.getNome() == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro Non Valido");
        }
        Ruolo ruoloRichiesto = null;
        String urlXMLPortaDominio = this.urlPrefix + "ruoli/" + idRuolo.getNome() + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo richiesto non esiste: " + idRuolo.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getRuolo] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeRuoloList() > 0) {
                ruoloRichiesto = rs.getRuolo(0);
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getRuolo] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (ruoloRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo non trovato.");
        }
        return ruoloRichiesto;
    }

    @Override
    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdRuoli] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            Ruolo[] ruoloList = this.generatoreXML.getRuoli();
            if (ruoloList == null) {
                throw new DriverRegistroServiziNotFound("Ruoli non esistenti nel repository WEB");
            }
            ArrayList<IDRuolo> idRuoli = new ArrayList<IDRuolo>();
            for (int i = 0; i < ruoloList.length; ++i) {
                String ruoloUrlXML = this.urlPrefix + "ruoli/" + ruoloList[i].getNome() + ".xml";
                try {
                    this.validatoreRegistro.valida(ruoloUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Riscontrato errore durante la validazione XSD (" + ruoloUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ruoloList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMinDate) Ruolo [" + ruoloList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruoloList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ruoloList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMaxDate) Ruolo [" + ruoloList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruoloList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !ruoloList[i].getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && !RuoloTipologia.QUALSIASI.equals(filtroRicerca.getTipologia()) && (ruoloList[i].getTipologia() == null || !RuoloTipologia.QUALSIASI.equals(ruoloList[i].getTipologia()) && !ruoloList[i].getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !RuoloContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (ruoloList[i].getContestoUtilizzo() == null || !RuoloContesto.QUALSIASI.equals(ruoloList[i].getContestoUtilizzo()) && !ruoloList[i].getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDRuolo id = new IDRuolo(ruoloList[i].getNome());
                idRuoli.add(id);
            }
            if (idRuoli.size() == 0) {
                throw new DriverRegistroServiziNotFound("Ruoli non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idRuoli;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdRuoli error", e);
        }
    }

    @Override
    public Scope getScope(IDScope idScope) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idScope == null || idScope.getNome() == null) {
            throw new DriverRegistroServiziException("[getScope] Parametro Non Valido");
        }
        Scope scopeRichiesto = null;
        String urlXMLPortaDominio = this.urlPrefix + "scope/" + idScope.getNome() + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getScope] Scope richiesto non esiste: " + idScope.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getScope] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeScopeList() > 0) {
                scopeRichiesto = rs.getScope(0);
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getScope] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (scopeRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getScope] Scope non trovato.");
        }
        return scopeRichiesto;
    }

    @Override
    public List<IDScope> getAllIdScope(FiltroRicercaScope filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdScope] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            Scope[] scopeList = this.generatoreXML.getScope();
            if (scopeList == null) {
                throw new DriverRegistroServiziNotFound("Scope non esistenti nel repository WEB");
            }
            ArrayList<IDScope> idScope = new ArrayList<IDScope>();
            for (int i = 0; i < scopeList.length; ++i) {
                String scopeUrlXML = this.urlPrefix + "scope/" + scopeList[i].getNome() + ".xml";
                try {
                    this.validatoreRegistro.valida(scopeUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdScope] Riscontrato errore durante la validazione XSD (" + scopeUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (scopeList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdScope](FiltroByMinDate) Scope [" + scopeList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (scopeList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (scopeList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdScope](FiltroByMaxDate) Scope [" + scopeList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (scopeList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !scopeList[i].getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && (scopeList[i].getTipologia() == null || !scopeList[i].getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !ScopeContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (scopeList[i].getContestoUtilizzo() == null || !ScopeContesto.QUALSIASI.equals(scopeList[i].getContestoUtilizzo()) && !scopeList[i].getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDScope id = new IDScope(scopeList[i].getNome());
                idScope.add(id);
            }
            if (idScope.size() == 0) {
                throw new DriverRegistroServiziNotFound("Scope non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idScope;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdScope error", e);
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipo = idSoggetto.getTipo();
        String nome = idSoggetto.getNome();
        if (tipo == null || nome == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        Soggetto soggRichiesto = null;
        String idSoggettoXML = tipo + nome;
        String urlXMLSoggetto = this.urlPrefix + idSoggettoXML + "/" + idSoggettoXML + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLSoggetto);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getSoggetto] Il soggetto [" + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLSoggetto);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getSoggetto] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeSoggettoList() > 0) {
                soggRichiesto = rs.getSoggetto(0);
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (soggRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non trovato.");
        }
        return soggRichiesto;
    }

    @Override
    public Soggetto getSoggettoByCredenzialiBasic(String user, String password, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null, null, false, null, config, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiApiKey(String user, String password, boolean appId, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null, null, false, null, config, appId);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(String subject, String issuer) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, issuer, null, false, null, null, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, null, null, certificate, strictVerifier, null, null, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiPrincipal(String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.PRINCIPAL, null, null, null, null, null, false, principal, null, false);
    }

    private Soggetto getEngineSoggettoAutenticato(CredenzialeTipo tipoCredenziale, String user, String password, String aSubject, String aIssuer, CertificateInfo aCertificate, boolean aStrictVerifier, String principal, CryptConfig config, boolean appId) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (tipoCredenziale == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro tipoCredenziale is null");
        }
        switch (tipoCredenziale) {
            case BASIC: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for basic auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for basic auth)");
            }
            case APIKEY: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for apikey auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for apikey auth)");
            }
            case SSL: {
                if (aSubject != null && !"".equalsIgnoreCase(aSubject) || aCertificate != null) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro subject/certificate is null (required for ssl auth)");
            }
            case PRINCIPAL: {
                if (principal != null && !"".equalsIgnoreCase(principal)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro principal is null (required for principal auth)");
            }
        }
        IDSoggetto idSoggetto = null;
        try {
            FiltroRicercaSoggetti filtroRicerca = new FiltroRicercaSoggetti();
            CredenzialiSoggetto credenzialiSoggetto = new CredenzialiSoggetto();
            credenzialiSoggetto.setTipo(tipoCredenziale);
            switch (tipoCredenziale) {
                case BASIC: {
                    credenzialiSoggetto.setUser(user);
                    credenzialiSoggetto.setPassword(password);
                    break;
                }
                case APIKEY: {
                    credenzialiSoggetto.setUser(user);
                    credenzialiSoggetto.setPassword(password);
                    credenzialiSoggetto.setAppId(appId);
                    break;
                }
                case SSL: {
                    credenzialiSoggetto.setSubject(aSubject);
                    credenzialiSoggetto.setIssuer(aIssuer);
                    if (aCertificate != null) {
                        try {
                            credenzialiSoggetto.setCertificate(aCertificate.getCertificate().getEncoded());
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    }
                    credenzialiSoggetto.setCertificateStrictVerification(aStrictVerifier);
                    break;
                }
                case PRINCIPAL: {
                    credenzialiSoggetto.setUser(principal);
                }
            }
            filtroRicerca.setCredenzialiSoggetto(credenzialiSoggetto, config);
            List<IDSoggetto> l = this.getAllIdSoggetti(filtroRicerca);
            if (l.size() > 1) {
                throw new DriverRegistroServiziException("Trovato pi\u00f9 di un soggetto che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
            }
            if (l.size() == 1) {
                idSoggetto = l.get(0);
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (idSoggetto == null) {
            throw new DriverRegistroServiziNotFound("Nessun soggetto trovato che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
        }
        return this.getSoggetto(idSoggetto);
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            Soggetto[] ssList = this.generatoreXML.getSoggetti();
            if (ssList == null) {
                throw new DriverRegistroServiziNotFound("Soggetti non esistenti nel repository WEB");
            }
            boolean testInChiaro = false;
            ICrypt crypt = null;
            if (filtroRicerca != null && filtroRicerca.getCredenzialiSoggetto() != null && filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                CryptConfig config;
                CredenzialeTipo cTipo = filtroRicerca.getCredenzialiSoggetto().getTipo();
                if (CredenzialeTipo.BASIC.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config == null || config.isBackwardCompatibility()) {
                        testInChiaro = true;
                    }
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    }
                } else if (CredenzialeTipo.APIKEY.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    } else {
                        testInChiaro = true;
                    }
                }
            }
            ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
            for (int i = 0; i < ssList.length; ++i) {
                String idSoggettoXML = ssList[i].getTipo() + ssList[i].getNome();
                String urlXMLSoggetto = this.urlPrefix + idSoggettoXML + "/" + idSoggettoXML + ".xml";
                try {
                    this.validatoreRegistro.valida(urlXMLSoggetto);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Riscontrato errore durante la validazione XSD (" + urlXMLSoggetto + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ssList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMinDate) Soggetto [" + ssList[i].getTipo() + "/" + ssList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ssList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ssList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMaxDate) Soggetto [" + ssList[i].getTipo() + "/" + ssList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ssList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ssList[i].getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ssList[i].getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getNomePdd() != null && !ssList[i].getPortaDominio().equals(filtroRicerca.getNomePdd()) || !ProtocolPropertiesUtilities.isMatch(ssList[i], filtroRicerca.getProtocolProperties())) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (ssList[i].getRuoli() == null) continue;
                        boolean contains = false;
                        for (int j = 0; j < ssList[i].getRuoli().sizeRuoloList(); ++j) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(ssList[i].getRuoli().getRuolo(j).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto() != null) {
                        CredenzialiSoggetto credenziali;
                        CredenzialiSoggetto credenzialiSoggetto = credenziali = ssList[i].sizeCredenzialiList() > 0 ? ssList[i].getCredenziali(0) : null;
                        if (credenziali == null) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getTipo() != null) {
                            if (credenziali.getTipo() == null) {
                                if (!filtroRicerca.getCredenzialiSoggetto().getTipo().equals(CredenzialeTipo.SSL)) {
                                    continue;
                                }
                            } else if (!filtroRicerca.getCredenzialiSoggetto().getTipo().equals(credenziali.getTipo()) || CredenzialeTipo.APIKEY.equals(filtroRicerca.getCredenzialiSoggetto().getTipo()) && (!filtroRicerca.getCredenzialiSoggetto().isAppId() ? credenziali.isAppId() : !credenziali.isAppId())) continue;
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getUser() != null && !filtroRicerca.getCredenzialiSoggetto().getUser().equals(credenziali.getUser())) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                            String passwordSaved = credenziali.getPassword();
                            boolean found = false;
                            if (testInChiaro) {
                                found = filtroRicerca.getCredenzialiSoggetto().getPassword().equals(passwordSaved);
                            }
                            if (!found && crypt != null) {
                                found = crypt.check(filtroRicerca.getCredenzialiSoggetto().getPassword(), passwordSaved);
                            }
                            if (!found) continue;
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                            try {
                                if (credenziali.getSubject() == null) continue;
                                boolean subjectValid = CertificateUtils.sslVerify((String)credenziali.getSubject(), (String)filtroRicerca.getCredenzialiSoggetto().getSubject(), (PrincipalType)PrincipalType.SUBJECT, (Logger)this.log);
                                boolean issuerValid = true;
                                if (filtroRicerca.getCredenzialiSoggetto().getIssuer() != null) {
                                    issuerValid = CertificateUtils.sslVerify((String)credenziali.getIssuer(), (String)filtroRicerca.getCredenzialiSoggetto().getIssuer(), (PrincipalType)PrincipalType.ISSUER, (Logger)this.log);
                                } else {
                                    boolean bl = issuerValid = credenziali.getIssuer() == null;
                                }
                                if (!subjectValid || !issuerValid) {
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverRegistroServiziException(e.getMessage(), e);
                            }
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getCnSubject() != null && filtroRicerca.getCredenzialiSoggetto().getCertificate() != null) {
                            if (!filtroRicerca.getCredenzialiSoggetto().getCnSubject().equals(credenziali.getCnSubject())) continue;
                            Certificate certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])credenziali.getCertificate(), (int)0, null);
                            Certificate certificatoFiltro = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])filtroRicerca.getCredenzialiSoggetto().getCertificate(), (int)0, null);
                            if (!certificatoFiltro.getCertificate().equals(certificato.getCertificate(), filtroRicerca.getCredenzialiSoggetto().isCertificateStrictVerification())) continue;
                        }
                    }
                }
                IDSoggetto idS = new IDSoggetto(ssList[i].getTipo(), ssList[i].getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idSoggetti;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        String uri = this.idServizioFactory.getUriFromIDServizio(idService);
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Soggetto) Non Validi");
        }
        AccordoServizioParteSpecifica servRichiesto = null;
        String idSoggettoXML = tipoSogg + nomeSogg;
        String idServizioXML = tipoServizio + servizio + versioneServizio;
        String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/servizi/" + idServizioXML + ".xml";
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizio] Il servizio [" + uri + "] non risulta gia' registrato nel registro");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                servRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                servRichiesto.setNomeSoggettoErogatore(idService.getSoggettoErogatore().getNome());
                servRichiesto.setTipoSoggettoErogatore(idService.getSoggettoErogatore().getTipo());
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizio] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizio] Servizio non trovato.");
        }
        return servRichiesto;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        String nomeSoggetto = idSoggetto.getNome();
        String tipoSoggetto = idSoggetto.getTipo();
        if (nomeSoggetto == null || tipoSoggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametri (Soggetto) Non Validi");
        }
        if (idAccordo == null || idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametri (Accordo) Non Valido");
        }
        AccordoServizioParteSpecifica servRichiesto = null;
        String idSoggettoXML = tipoSoggetto + nomeSoggetto;
        String urlXMLIndexServizi = this.urlPrefix + idSoggettoXML + "/servizi/servizi.index";
        String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
        IDServizio[] lista = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile((String)urlXMLIndexServizi);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il soggetto [" + idSoggetto + "] non possiede un index dei servizi erogati");
                }
                throw e;
            }
            lista = XMLLib.mappingIndexServizi(new String(fileXML));
            if (lista == null) {
                throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il soggetto [" + idSoggetto + "] non possiede una lista di servizi erogati");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Errore durante la get Servizi List Index: " + e.getMessage(), e);
        }
        String urlXMLServizio = null;
        String tipoServizio = null;
        String nomeServizio = null;
        Integer versioneServizio = null;
        try {
            for (int i = 0; i < lista.length; ++i) {
                if (!uriAccordo.equals(lista[i].getUriAccordoServizioParteComune()) || !TipologiaServizio.CORRELATO.getValue().equals(lista[i].getTipologia().getValue()) || !idSoggetto.getTipo().equals(lista[i].getSoggettoErogatore().getTipo()) || !idSoggetto.getNome().equals(lista[i].getSoggettoErogatore().getNome())) continue;
                urlXMLServizio = this.urlPrefix + idSoggettoXML + "/servizi/" + lista[i].getTipo() + lista[i].getNome() + lista[i].getVersione() + ".xml";
                tipoServizio = lista[i].getTipo();
                nomeServizio = lista[i].getNome();
                versioneServizio = lista[i].getVersione();
                break;
            }
            if (urlXMLServizio == null) {
                throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il soggetto [" + idSoggetto + "] non possiede un servizio correlato che implementa l'accordo con uri [" + uriAccordo + "]");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Errore durante la ricerca: " + e.getMessage(), e);
        }
        ByteArrayInputStream bin = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il servizio [" + tipoServizio + "/" + nomeServizio + ":" + versioneServizio + "] erogato dal soggetto [" + idSoggetto + "] non risulta gia' registrato nel registro");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            JaxbDeserializer deserializer = new JaxbDeserializer();
            RegistroServizi rs = deserializer.readRegistroServizi(bin);
            if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                servRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                servRichiesto.setNomeSoggettoErogatore(idSoggetto.getNome());
                servRichiesto.setTipoSoggettoErogatore(idSoggetto.getTipo());
            }
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Servizio non trovato.");
        }
        return servRichiesto;
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDServizio> list = new ArrayList<IDServizio>();
        this._fillAllIdServiziEngine("getAllIdServizi", filtroRicerca, list);
        return list;
    }

    @Override
    public List<IDFruizione> getAllIdFruizioniServizio(FiltroRicercaFruizioniServizio filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDFruizione> list = new ArrayList<IDFruizione>();
        this._fillAllIdServiziEngine("getAllIdFruizioniServizio", filtroRicerca, list);
        return list;
    }

    public <T> void _fillAllIdServiziEngine(String nomeMetodo, FiltroRicercaServizi filtroRicerca, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            FiltroRicercaFruizioniServizio filtroFruizioni = null;
            if (filtroRicerca instanceof FiltroRicercaFruizioniServizio) {
                filtroFruizioni = (FiltroRicercaFruizioniServizio)filtroRicerca;
            }
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[" + nomeMetodo + "] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoServizioParteSpecifica[] servList = this.generatoreXML.getAccordiServiziParteSpecifica();
            if (servList == null) {
                throw new DriverRegistroServiziNotFound("Servizi non esistenti nel repository WEB");
            }
            for (int i = 0; i < servList.length; ++i) {
                String idSoggettoXML = servList[i].getTipoSoggettoErogatore() + servList[i].getNomeSoggettoErogatore();
                String idServizioXML = servList[i].getTipo() + servList[i].getNome() + servList[i].getVersione();
                String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/servizi/" + idServizioXML + ".xml";
                try {
                    this.validatoreRegistro.valida(urlXMLServizio);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[" + nomeMetodo + "] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizio + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getTipoSoggettoErogatore() != null && !servList[i].getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !servList[i].getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                    if (filtroRicerca.getMinDate() != null) {
                        if (servList[i].getOraRegistrazione() == null) {
                            this.log.debug("[" + nomeMetodo + "](FiltroByMinDate) Servizio[" + this.idServizioFactory.getUriFromAccordo(servList[i]) + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (servList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (servList[i].getOraRegistrazione() == null) {
                            this.log.debug("[" + nomeMetodo + "](FiltroByMaxDate) Servizio[" + this.idServizioFactory.getUriFromAccordo(servList[i]) + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (servList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !servList[i].getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !servList[i].getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getVersione() != null && servList[i].getVersione().intValue() != filtroRicerca.getVersione().intValue() || filtroRicerca.getPortType() != null && !servList[i].getPortType().equals(filtroRicerca.getPortType())) continue;
                    if (filtroRicerca.getIdAccordoServizioParteComune() != null) {
                        String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordoServizioParteComune());
                        if (!servList[i].getAccordoServizioParteComune().equals(uriAccordo)) continue;
                    }
                    if (!ProtocolPropertiesUtilities.isMatch(servList[i], filtroRicerca.getProtocolProperties())) continue;
                    if (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null) {
                        if (servList[i].sizeFruitoreList() <= 0) continue;
                        boolean found = false;
                        for (int k = 0; k < servList[i].sizeFruitoreList(); ++k) {
                            Fruitore fruitore = servList[i].getFruitore(k);
                            if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
                IDServizio idServ = this.idServizioFactory.getIDServizioFromAccordo(servList[i]);
                if (filtroFruizioni != null) {
                    for (Fruitore fruitore : servList[i].getFruitoreList()) {
                        if (filtroFruizioni.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroFruizioni.getTipoSoggettoFruitore()) || filtroFruizioni.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroFruizioni.getNomeSoggettoFruitore()) || !ProtocolPropertiesUtilities.isMatch(fruitore, filtroFruizioni.getProtocolPropertiesFruizione())) continue;
                        IDFruizione idFruizione = new IDFruizione();
                        idFruizione.setIdServizio(idServ);
                        idFruizione.setIdFruitore(new IDSoggetto(fruitore.getTipo(), fruitore.getNome()));
                        listReturn.add(idFruizione);
                    }
                    continue;
                }
                listReturn.add(idServ);
            }
            if (listReturn.size() <= 0) {
                String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                if (filtroFruizioni != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroFruizioni.toString());
                }
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Elementi non trovati");
            }
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[" + nomeMetodo + "] error", e);
        }
    }

    @Override
    public Documento getAllegato(IDServizio idASPS, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaSemiformale(IDServizio idASPS, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaSicurezza(IDServizio idASPS, TipiDocumentoSicurezza tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public Documento getSpecificaLivelloServizio(IDServizio idASPS, TipiDocumentoLivelloServizio tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione non completamente definito nei parametri obbligatori");
            }
            if (this.generatoreXML.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo.toString() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordo, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Errore generatosi durante la creazione di un nuovo accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoCooperazione] Accordo non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordoOLD = null;
        idAccordoOLD = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da modificare non definito");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsAccordoCooperazione(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordoCooperazione idAccordoNEW = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.generatoreXML.existsAccordoCooperazione(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordoOLD, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Errore generatosi durante la modifica dell'accordo di cooperazione [" + idAccordoOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da eliminare non definito");
            }
            if (!this.generatoreXML.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Errore generatosi durante l'eliminazione dell'accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune non completamente definito nei parametri obbligatori");
            }
            if (this.generatoreXML.existsAccordoServizioParteComune(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo.toString() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordo, accordoServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Errore generatosi durante la creazione di un nuovo accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsAccordoServizioParteComune(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteComune] Accordo non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordoOLD = null;
        idAccordoOLD = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da modificare non definito");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsAccordoServizioParteComune(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordo idAccordoNEW = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.generatoreXML.existsAccordoServizioParteComune(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordoOLD, accordoServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Errore generatosi durante la modifica dell'accordo di servizio [" + idAccordoOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (accordoServizio.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da eliminare non definito");
            }
            if (!this.generatoreXML.existsAccordoServizioParteComune(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoServizioParteComune(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Errore generatosi durante l'eliminazione dell'accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[createPortaDominio] Parametro Non Valido");
        }
        try {
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio non completamente definita nei parametri obbligatori");
            }
            if (this.generatoreXML.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pdd.getNome(), pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createPortaDominio] Errore generatosi durante la creazione di una nuova porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsPortaDominio(nome);
        }
        catch (Exception e) {
            this.log.error("[existsPortaDominio] Porta di dominio non trovata: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Parametro Non Valido");
        }
        String pddOLD = null;
        pddOLD = pdd.getNome();
        try {
            if (pddOLD == null) {
                throw new DriverRegistroServiziException("Porta di dominio da modificare non definita");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio modificata non completamente definita nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsPortaDominio(pddOLD)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            String pddNEW = pdd.getNome();
            if (!pddOLD.equals(pddNEW) && this.generatoreXML.existsPortaDominio(pddNEW)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pddOLD, pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Errore generatosi durante la modifica della porta di dominio [" + pddOLD + "]: " + e, e);
        }
    }

    @Override
    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Parametro Non Valido");
        }
        try {
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio da eliminare non definita");
            }
            if (!this.generatoreXML.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deletePortaDominio(pdd.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Errore generatosi durante l'eliminazione della porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[createGruppo] Parametro Non Valido");
        }
        try {
            if (gruppo.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo non completamente definita nei parametri obbligatori");
            }
            if (this.generatoreXML.existsGruppo(gruppo.getNome())) {
                throw new DriverRegistroServiziException("Il Gruppo [" + gruppo.getNome() + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createGruppo(gruppo.getNome(), gruppo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createGruppo] Errore generatosi durante la creazione di un nuovo gruppo [" + gruppo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsGruppo(IDGruppo idGruppo) throws DriverRegistroServiziException {
        if (idGruppo == null || idGruppo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsGruppo(idGruppo.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsGruppo] Gruppo non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[updateGruppo] Parametro Non Valido");
        }
        IDGruppo idGruppoOLD = null;
        idGruppoOLD = new IDGruppo(gruppo.getNome());
        try {
            if (idGruppoOLD == null || idGruppoOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo da modificare non definito");
            }
            if (gruppo.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsGruppo(idGruppoOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Gruppo [" + idGruppoOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDGruppo idGruppoNEW = new IDGruppo(gruppo.getNome());
            if (!idGruppoOLD.equals(idGruppoNEW) && this.generatoreXML.existsGruppo(idGruppoNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Gruppo [" + idGruppoNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createGruppo(idGruppoOLD.getNome(), gruppo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateGruppo] Errore generatosi durante la modifica della porta di dominio [" + idGruppoOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[deleteGruppo] Parametro Non Valido");
        }
        try {
            if (gruppo.getNome() == null) {
                throw new DriverRegistroServiziException("Gruppo da eliminare non definito");
            }
            if (!this.generatoreXML.existsGruppo(gruppo.getNome())) {
                throw new DriverRegistroServiziException("Il Gruppo [" + gruppo.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteGruppo(gruppo.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteGruppo] Errore generatosi durante l'eliminazione del gruppo [" + gruppo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[createRuolo] Parametro Non Valido");
        }
        try {
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo non completamente definita nei parametri obbligatori");
            }
            if (this.generatoreXML.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + ruolo.getNome() + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(ruolo.getNome(), ruolo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createRuolo] Errore generatosi durante la creazione di un nuovo ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException {
        if (idRuolo == null || idRuolo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsRuolo(idRuolo.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsRuolo] Ruolo non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[updateRuolo] Parametro Non Valido");
        }
        IDRuolo idRuoloOLD = null;
        idRuoloOLD = new IDRuolo(ruolo.getNome());
        try {
            if (idRuoloOLD == null || idRuoloOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da modificare non definito");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsRuolo(idRuoloOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDRuolo idRuoloNEW = new IDRuolo(ruolo.getNome());
            if (!idRuoloOLD.equals(idRuoloNEW) && this.generatoreXML.existsRuolo(idRuoloNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(idRuoloOLD.getNome(), ruolo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateRuolo] Errore generatosi durante la modifica della porta di dominio [" + idRuoloOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[deleteRuolo] Parametro Non Valido");
        }
        try {
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da eliminare non definito");
            }
            if (!this.generatoreXML.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + ruolo.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteRuolo(ruolo.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteRuolo] Errore generatosi durante l'eliminazione del ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[createScope] Parametro Non Valido");
        }
        try {
            if (scope.getNome() == null) {
                throw new DriverRegistroServiziException("Scope non completamente definita nei parametri obbligatori");
            }
            if (this.generatoreXML.existsScope(scope.getNome())) {
                throw new DriverRegistroServiziException("Il Scope [" + scope.getNome() + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createScope(scope.getNome(), scope);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createScope] Errore generatosi durante la creazione di un nuovo scope [" + scope.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsScope(IDScope idScope) throws DriverRegistroServiziException {
        if (idScope == null || idScope.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsScope(idScope.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsScope] Scope non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[updateScope] Parametro Non Valido");
        }
        IDScope idScopeOLD = null;
        idScopeOLD = new IDScope(scope.getNome());
        try {
            if (idScopeOLD == null || idScopeOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Scope da modificare non definito");
            }
            if (scope.getNome() == null) {
                throw new DriverRegistroServiziException("Scope modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsScope(idScopeOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Scope [" + idScopeOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDScope idScopeNEW = new IDScope(scope.getNome());
            if (!idScopeOLD.equals(idScopeNEW) && this.generatoreXML.existsScope(idScopeNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Scope [" + idScopeNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createScope(idScopeOLD.getNome(), scope);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateScope] Errore generatosi durante la modifica della porta di dominio [" + idScopeOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteScope(Scope scope) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[deleteScope] Parametro Non Valido");
        }
        try {
            if (scope.getNome() == null) {
                throw new DriverRegistroServiziException("Scope da eliminare non definito");
            }
            if (!this.generatoreXML.existsScope(scope.getNome())) {
                throw new DriverRegistroServiziException("Il Scope [" + scope.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteScope(scope.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteScope] Errore generatosi durante l'eliminazione del scope [" + scope.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[createSoggetto] Parametro Non Valido");
        }
        try {
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            String idSoggetto_string = soggetto.getTipo() + soggetto.getNome();
            if (this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createSoggetto(idSoggetto, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createSoggetto] Errore generatosi durante la creazione del nuovo Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[updateSoggetto] Parametro Non Valido");
        }
        String tipoOLD = null;
        String nomeOLD = null;
        if (soggetto.getOldIDSoggettoForUpdate() != null) {
            tipoOLD = soggetto.getOldIDSoggettoForUpdate().getTipo();
            nomeOLD = soggetto.getOldIDSoggettoForUpdate().getNome();
        }
        if (tipoOLD == null || nomeOLD == null) {
            tipoOLD = soggetto.getTipo();
            nomeOLD = soggetto.getNome();
        }
        String idSoggettoOLD_string = tipoOLD + nomeOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoOLD, nomeOLD);
        try {
            if (tipoOLD == null || nomeOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare non definito");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto modificato non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggettoNEW = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (!this.generatoreXML.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = soggetto.getTipo() + soggetto.getNome();
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && this.generatoreXML.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("La nuova identita da associare al soggetto [" + idSoggettoNEW_string + "] risulta gia' utilizzata nel registro dei servizi.");
            }
            this.generatoreXML.createSoggetto(idSoggettoOLD, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateSoggetto] Errore generatosi durante la modifica del Soggetto [" + idSoggettoOLD + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Parametro Non Valido");
        }
        try {
            if (soggetto.getTipo() == null || soggetto.getNome() == null) {
                throw new DriverRegistroServiziException("Soggetto da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (!this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteSoggetto(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Errore generatosi durante l'eliminazione del Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        try {
            int i;
            if (asps.getNomeSoggettoErogatore() == null || asps.getTipoSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (asps.getNome() == null || asps.getTipo() == null || asps.getVersione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Specifica, non definito");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (asps.getConfigurazioneServizio() != null && asps.getConfigurazioneServizio().getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(asps.getConfigurazioneServizio().getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (asps.getConfigurazioneServizio().getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                for (int j = 0; j < checkFr.sizeConfigurazioneAzioneList(); ++j) {
                    ConfigurazioneServizioAzione checkAz = checkFr.getConfigurazioneAzione(i);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un azione senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getAzioneList() + " della fruizione del servizio non corretta");
                }
                String idSoggettoFruitore_string = checkFr.getTipo() + checkFr.getNome();
                IDSoggetto idSoggettoFruitore = new IDSoggetto(checkFr.getTipo(), checkFr.getNome());
                if (this.generatoreXML.existsSoggetto(idSoggettoFruitore)) continue;
                throw new DriverRegistroServiziException("Il fruitore [" + idSoggettoFruitore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            if (asps.getConfigurazioneServizio() != null) {
                for (i = 0; i < asps.getConfigurazioneServizio().sizeConfigurazioneAzioneList(); ++i) {
                    ConfigurazioneServizioAzione checkAz = asps.getConfigurazioneServizio().getConfigurazioneAzione(i);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un azione senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getAzioneList() + " del servizio non corretta");
                }
            }
            IDSoggetto idSoggettoErogatore = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            String idSoggettoErogatore_string = asps.getTipoSoggettoErogatore() + asps.getNomeSoggettoErogatore();
            if (!this.generatoreXML.existsSoggetto(idSoggettoErogatore)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoErogatore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idServizio_string = asps.getTipo() + asps.getNome() + asps.getVersione();
            IDServizio idServizio = this.idServizioFactory.getIDServizioFromAccordo(asps);
            if (this.generatoreXML.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggettoErogatore_string + "] risulta gia' registrato nel registro");
            }
            this.generatoreXML.createAccordoServizioParteSpecifica(idServizio, asps);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Errore generatosi durante la creazione del nuovo Servizio [" + this.idServizioFactory.getIDServizioFromAccordo(asps) + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            return false;
        }
        try {
            this.getAccordoServizioParteSpecifica(idServizio);
            return true;
        }
        catch (DriverRegistroServiziNotFound notFound) {
            return false;
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteSpecifica] Servizio non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String tipoServizioOLD = null;
        String nomeServizioOLD = null;
        Integer versioneServizioOLD = null;
        if (asps.getOldIDServizioForUpdate() != null) {
            tipoServizioOLD = asps.getOldIDServizioForUpdate().getTipo();
            nomeServizioOLD = asps.getOldIDServizioForUpdate().getNome();
            versioneServizioOLD = asps.getOldIDServizioForUpdate().getVersione();
        }
        if (tipoServizioOLD == null || nomeServizioOLD == null || versioneServizioOLD == null) {
            tipoServizioOLD = asps.getTipo();
            nomeServizioOLD = asps.getNome();
            versioneServizioOLD = asps.getVersione();
        }
        String tipoSoggettoOLD = null;
        String nomeSoggettoOLD = null;
        if (asps.getOldIDServizioForUpdate() != null && asps.getOldIDServizioForUpdate().getSoggettoErogatore() != null) {
            tipoSoggettoOLD = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo();
            nomeSoggettoOLD = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
        }
        if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
            tipoSoggettoOLD = asps.getTipoSoggettoErogatore();
            nomeSoggettoOLD = asps.getNomeSoggettoErogatore();
        }
        String idSoggettoOLD_string = tipoSoggettoOLD + nomeSoggettoOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoSoggettoOLD, nomeSoggettoOLD);
        String idServizioOLD_string = tipoServizioOLD + nomeServizioOLD + versioneServizioOLD;
        IDServizio idServizioOLD = this.idServizioFactory.getIDServizioFromValues(tipoServizioOLD, nomeServizioOLD, idSoggettoOLD, versioneServizioOLD);
        try {
            int i;
            if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare, erogatore del servizio, non definito");
            }
            if (asps.getTipoSoggettoErogatore() == null || asps.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (tipoServizioOLD == null || nomeServizioOLD == null) {
                throw new DriverRegistroServiziException("Servizio da modificare non definito");
            }
            if (asps.getNome() == null || asps.getTipo() == null || asps.getVersione() == null) {
                throw new DriverRegistroServiziException("Dati del nuovo servizio, non definiti");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (asps.getConfigurazioneServizio() != null && asps.getConfigurazioneServizio().getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(asps.getConfigurazioneServizio().getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (asps.getConfigurazioneServizio().getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                for (int j = 0; j < checkFr.sizeConfigurazioneAzioneList(); ++j) {
                    ConfigurazioneServizioAzione checkAz = checkFr.getConfigurazioneAzione(j);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getAzioneList() + " della fruizione del servizio non corretta");
                }
            }
            if (asps.getConfigurazioneServizio() != null) {
                for (i = 0; i < asps.getConfigurazioneServizio().sizeConfigurazioneAzioneList(); ++i) {
                    ConfigurazioneServizioAzione checkAz = asps.getConfigurazioneServizio().getConfigurazioneAzione(i);
                    if (checkAz.sizeAzioneList() <= 0 || checkAz.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                    }
                    if (checkAz.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getAzioneList() + " del servizio non corretta");
                }
            }
            if (!this.generatoreXML.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] da modificare, non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = asps.getTipoSoggettoErogatore() + asps.getNomeSoggettoErogatore();
            IDSoggetto idSoggettoNEW = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && !this.generatoreXML.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoNEW_string + "] a cui re-assegnare il servizio, non risulta gia' inserito nel registro dei servizi.");
            }
            if (!this.generatoreXML.existsAccordoServizioParteSpecifica(idServizioOLD)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "] non risulta gia' registrato nel registro");
            }
            IDServizio idServizioNEW = this.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), idSoggettoNEW, asps.getVersione());
            String idServizioNEW_string = asps.getTipo() + asps.getNome() + asps.getVersione();
            if (!(idServizioOLD_string.equals(idServizioNEW_string) && idSoggettoOLD_string.equals(idSoggettoNEW_string) || !this.generatoreXML.existsAccordoServizioParteSpecifica(idServizioNEW))) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioNEW_string + "] erogato dal soggetto [" + idSoggettoNEW_string + "] risulta gia' registrato nel registro");
            }
            if (idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioOLD, asps);
            } else {
                this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizioOLD);
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioNEW, asps);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Errore generatosi durante la modifica del Servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String idSoggetto_string = asps.getTipoSoggettoErogatore() + asps.getNomeSoggettoErogatore();
        String idServizio_string = asps.getTipo() + asps.getNome() + asps.getVersione();
        try {
            if (asps.getTipoSoggettoErogatore() == null || asps.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (asps.getTipo() == null || asps.getNome() == null || asps.getVersione() == null) {
                throw new DriverRegistroServiziException("Servizio da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            if (!this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDServizio idServizio = this.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), idSoggetto, asps.getVersione());
            if (!this.generatoreXML.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "] non risulta gia' registrato nel registro");
            }
            this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Errore generatosi durante l'eliminazione del Servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void reset() throws DriverRegistroServiziException {
        int i;
        try {
            AccordoServizioParteComune[] accordiRegistrati = this.generatoreXML.getAccordiServizioParteComune();
            if (accordiRegistrati != null) {
                for (i = 0; i < accordiRegistrati.length; ++i) {
                    this.log.info("eliminazione accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(accordiRegistrati[i]) + "] in corso...");
                    this.deleteAccordoServizioParteComune(accordiRegistrati[i]);
                    this.log.info("eliminazione accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(accordiRegistrati[i]) + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati: " + e.getMessage(), e);
        }
        try {
            AccordoCooperazione[] accordiCooperazioneRegistrati = this.generatoreXML.getAccordiCooperazione();
            if (accordiCooperazioneRegistrati != null) {
                for (i = 0; i < accordiCooperazioneRegistrati.length; ++i) {
                    this.log.info("eliminazione accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(accordiCooperazioneRegistrati[i]) + "] in corso...");
                    this.deleteAccordoCooperazione(accordiCooperazioneRegistrati[i]);
                    this.log.info("eliminazione accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(accordiCooperazioneRegistrati[i]) + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi di cooperazione registrati: " + e.getMessage(), e);
        }
        try {
            AccordoServizioParteSpecifica[] serviziRegistrati = this.generatoreXML.getAccordiServiziParteSpecifica();
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    this.log.info("eliminazione servizio [" + this.idServizioFactory.getUriFromAccordo(serviziRegistrati[i]) + "] in corso...");
                    this.deleteAccordoServizioParteSpecifica(serviziRegistrati[i]);
                    this.log.info("eliminazione servizio [" + this.idServizioFactory.getUriFromAccordo(serviziRegistrati[i]) + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati: " + e.getMessage(), e);
        }
        try {
            Soggetto[] soggettiRegistrati = this.generatoreXML.getSoggetti();
            if (soggettiRegistrati != null) {
                for (i = 0; i < soggettiRegistrati.length; ++i) {
                    this.log.info("eliminazione soggetto [" + soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome() + "] in corso...");
                    this.deleteSoggetto(soggettiRegistrati[i]);
                    this.log.info("eliminazione soggetto [" + soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome() + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei soggetti registrati: " + e.getMessage(), e);
        }
        try {
            PortaDominio[] pddRegistrate = this.generatoreXML.getPorteDominio();
            if (pddRegistrate != null) {
                for (i = 0; i < pddRegistrate.length; ++i) {
                    this.log.info("eliminazione porta di dominio [" + pddRegistrate[i].getNome() + "] in corso...");
                    this.deletePortaDominio(pddRegistrate[i]);
                    this.log.info("eliminazione porta di dominio [" + pddRegistrate[i].getNome() + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione delle porte di dominio registrate: " + e.getMessage(), e);
        }
    }

    public void resetCtrlstat() throws DriverRegistroServiziException {
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        String urlVerifica = this.urlPrefix + "/";
        try {
            byte[] dir = HttpUtilities.requestHTTPFile((String)urlVerifica);
            if (dir == null) {
                throw new Exception("Directory accordi richiesta non ritornata");
            }
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile [" + urlVerifica + "]: " + e.getMessage(), e);
        }
    }
}

