/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.rest;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.rest.AccordoServizioWrapper;
import org.openspcoop2.core.registry.rest.RegistryAPI;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiSchemaType;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XSDUtils;
import org.slf4j.Logger;

public class AccordoServizioWrapperUtilities {
    private Logger logger = null;
    private AbstractXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;
    private JSONUtils jsonUtils = null;
    private YAMLUtils yamlUtils = null;
    private OpenSPCoop2MessageFactory messageFactory;
    private AccordoServizioWrapper accordoServizioWrapper = null;
    public static final String API_SENZA_SPECIFICA = "L'API non contiene una specifica";

    public AccordoServizioWrapperUtilities(OpenSPCoop2MessageFactory messageFactory, Logger log, AccordoServizioWrapper accordoServizio) {
        this.logger = log != null ? log : LoggerWrapperFactory.getLogger(AccordoServizioWrapperUtilities.class);
        this.accordoServizioWrapper = accordoServizio;
        this.messageFactory = messageFactory;
        this.xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.messageFactory);
        this.xsdUtils = new XSDUtils(this.xmlUtils);
        this.jsonUtils = JSONUtils.getInstance();
        this.yamlUtils = YAMLUtils.getInstance();
    }

    public AccordoServizioWrapper getAccordoServizioWrapper() {
        return this.accordoServizioWrapper;
    }

    public void setAccordoServizio(AccordoServizioWrapper accordoServizio) {
        this.accordoServizioWrapper = accordoServizio;
    }

    public void buildApiFromSpecific(boolean fromBytes, boolean buildSchemi, boolean processInclude) throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("AccordoWrapper non fornito");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("API non fornita");
        }
        AccordoServizioParteComune as = this.accordoServizioWrapper.getAccordoServizio();
        IApiReader apiReader = null;
        FormatoSpecifica formato = as.getFormatoSpecifica();
        if (formato == null) {
            formato = FormatoSpecifica.OPEN_API_3;
        }
        switch (formato) {
            case WADL: {
                try {
                    apiReader = ApiFactory.newApiReader((ApiFormats)ApiFormats.WADL);
                    break;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Inizializzazione Reader Specifica [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] fallito: " + e.getMessage(), e);
                }
            }
            case SWAGGER_2: {
                try {
                    apiReader = ApiFactory.newApiReader((ApiFormats)ApiFormats.SWAGGER_2);
                    break;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Inizializzazione Reader Specifica [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] fallito: " + e.getMessage(), e);
                }
            }
            case OPEN_API_3: {
                try {
                    apiReader = ApiFactory.newApiReader((ApiFormats)ApiFormats.OPEN_API_3);
                    break;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Inizializzazione Reader Specifica [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] fallito: " + e.getMessage(), e);
                }
            }
            case WSDL_11: {
                throw new DriverRegistroServiziException("Tipo specifica [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] non supportata");
            }
        }
        if (apiReader == null) {
            throw new DriverRegistroServiziException("Inizializzazione Reader Specifica [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] fallita");
        }
        byte[] specifica = null;
        if (fromBytes) {
            if (as.getByteWsdlConcettuale() != null) {
                specifica = as.getByteWsdlConcettuale();
            }
        } else if (as.getWsdlConcettuale() != null) {
            try {
                String location = as.getWsdlConcettuale();
                if (location.startsWith("http://") || location.startsWith("file://")) {
                    URL url = new URL(location);
                    specifica = HttpUtilities.requestHTTPFile((String)url.toString());
                } else {
                    File f = new File(location);
                    specifica = FileSystemUtilities.readBytesFromFile((File)f);
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("L'API contiene una specifica corrotta: " + e.getMessage(), e);
            }
        }
        if (specifica == null) {
            throw new DriverRegistroServiziException(API_SENZA_SPECIFICA);
        }
        ApiSchema[] s = null;
        ApiReaderConfig config = new ApiReaderConfig();
        if (buildSchemi) {
            config.setProcessInclude(processInclude);
            config.setProcessInlineSchema(true);
            s = this.buildSchemas(as, fromBytes);
        } else {
            config.setProcessInclude(false);
            config.setProcessInlineSchema(false);
        }
        try {
            if (s != null) {
                apiReader.init(this.logger, specifica, config, s);
            } else {
                apiReader.init(this.logger, specifica, config);
            }
            Api api = apiReader.read();
            this.accordoServizioWrapper.setApi(api);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Inizializzazione Specifica [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] fallita: " + e.getMessage(), e);
        }
    }

    public void buildApiFromRegistry(boolean fromBytes, boolean buildSchemi) throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("AccordoWrapper non fornito");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("API non fornita");
        }
        AccordoServizioParteComune as = this.accordoServizioWrapper.getAccordoServizio();
        try {
            RegistryAPI api = new RegistryAPI(as, "http://TODO");
            ApiSchema[] s = null;
            if (buildSchemi && (s = this.buildSchemas(as, fromBytes)) != null && s.length > 0) {
                for (int i = 0; i < s.length; ++i) {
                    api.addSchema(s[i]);
                }
            }
            this.accordoServizioWrapper.setApi(api);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Inizializzazione Specifica [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] fallita: " + e.getMessage(), e);
        }
    }

    private ApiSchema[] buildSchemas(AccordoServizioParteComune as, boolean fromBytes) throws DriverRegistroServiziException {
        byte[] value;
        File f;
        URL url;
        String location;
        String systemId;
        byte[] resource;
        int i;
        HashMap<String, byte[]> resourcesXSD = new HashMap<String, byte[]>();
        HashMap<String, byte[]> resourcesJSON = new HashMap<String, byte[]>();
        HashMap<String, byte[]> resourcesYAML = new HashMap<String, byte[]>();
        if (as.sizeAllegatoList() > 0) {
            for (i = 0; i < as.sizeAllegatoList(); ++i) {
                Documento allegato = as.getAllegato(i);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = allegato.getFile();
                    resource = allegato.getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Allegato [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = allegato.getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile((String)url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile((File)f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Allegato [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (this.xsdUtils.isXSDSchema(resource)) {
                        if (resourcesXSD.containsKey(systemId)) {
                            throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione di Govway richiede l'utilizzo di nomi diversi)");
                        }
                        resourcesXSD.put(systemId, resource);
                        continue;
                    }
                    if (this.yamlUtils.isYaml(resource)) {
                        if (resourcesYAML.containsKey(systemId)) {
                            throw new Exception("Esiste pi\u00f9 di un documento yaml, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione di Govway richiede l'utilizzo di nomi diversi)");
                        }
                        resourcesYAML.put(systemId, resource);
                        continue;
                    }
                    if (!this.jsonUtils.isJson(resource)) continue;
                    if (resourcesJSON.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento json, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione di Govway richiede l'utilizzo di nomi diversi)");
                    }
                    resourcesJSON.put(systemId, resource);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura dell'allegato [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        if (as.sizeSpecificaSemiformaleList() > 0) {
            for (i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
                Iterator specificaSemiformale = as.getSpecificaSemiformale(i);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = ((Documento)((Object)specificaSemiformale)).getFile();
                    resource = ((Documento)((Object)specificaSemiformale)).getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = ((Documento)((Object)specificaSemiformale)).getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile((String)url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile((File)f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (this.xsdUtils.isXSDSchema(resource)) {
                        if (resourcesXSD.containsKey(systemId)) {
                            throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione di Govway richiede l'utilizzo di nomi diversi)");
                        }
                        resourcesXSD.put(systemId, resource);
                        continue;
                    }
                    if (this.yamlUtils.isYaml(resource)) {
                        if (resourcesYAML.containsKey(systemId)) {
                            throw new Exception("Esiste pi\u00f9 di un documento yaml, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione di Govway richiede l'utilizzo di nomi diversi)");
                        }
                        resourcesYAML.put(systemId, resource);
                        continue;
                    }
                    if (!this.jsonUtils.isJson(resource)) continue;
                    if (resourcesJSON.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento json, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione di Govway richiede l'utilizzo di nomi diversi)");
                    }
                    resourcesJSON.put(systemId, resource);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura della specifica semiformale [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        ArrayList<ApiSchema> schemas = new ArrayList<ApiSchema>();
        if (resourcesXSD != null && resourcesXSD.size() > 0) {
            for (String key : resourcesXSD.keySet()) {
                value = (byte[])resourcesXSD.get(key);
                schemas.add(new ApiSchema(key, value, ApiSchemaType.XSD));
            }
        }
        if (resourcesYAML != null && resourcesYAML.size() > 0) {
            for (String key : resourcesYAML.keySet()) {
                value = (byte[])resourcesYAML.get(key);
                schemas.add(new ApiSchema(key, value, ApiSchemaType.YAML));
            }
        }
        if (resourcesJSON != null && resourcesJSON.size() > 0) {
            for (String key : resourcesJSON.keySet()) {
                value = (byte[])resourcesJSON.get(key);
                schemas.add(new ApiSchema(key, value, ApiSchemaType.JSON));
            }
        }
        ApiSchema[] s = null;
        if (schemas.size() > 0) {
            s = schemas.toArray(new ApiSchema[1]);
        }
        return s;
    }
}

