/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.wsdl;

import javax.xml.soap.SOAPEnvelope;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class RootElementBody {
    private String localName;
    private String namespace;
    private String xsiType;
    private String namespaceElementoCheContieneXSIType;

    public RootElementBody(SOAPEnvelope soapEnvelope, Node nodoPadre, boolean rpc, Node n) throws Exception {
        NamedNodeMap attributes = n.getAttributes();
        this.localName = n.getLocalName();
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (!(attribute instanceof Attr)) continue;
                Attr a = (Attr)attribute;
                String attrLocalName = a.getLocalName();
                String attrNamespace = a.getNamespaceURI();
                String value = a.getNodeValue();
                if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attrNamespace) || !"type".equals(attrLocalName) || value == null) continue;
                String prefix = "";
                String typeName = value;
                if (value.contains(":")) {
                    prefix = value.split(":")[0];
                    typeName = value.split(":")[1];
                }
                this.xsiType = typeName;
                this.namespace = this.mappingPrefixToNamespace(n, prefix);
                if (this.namespace != null) continue;
                if (rpc) {
                    this.namespace = this.mappingPrefixToNamespace(nodoPadre, prefix);
                    if (this.namespace != null) continue;
                    this.namespace = this.mappingPrefixToNamespace((Node)soapEnvelope.getBody(), prefix);
                    if (this.namespace != null) continue;
                    this.namespace = this.mappingPrefixToNamespace((Node)soapEnvelope, prefix);
                    if (this.namespace != null) continue;
                    throw new Exception("[RPCStyle] Namespace (for prefix " + prefix + ") not found for element [" + n.getLocalName() + "] with xsi:type=\"" + value + "\"");
                }
                this.namespace = this.mappingPrefixToNamespace(nodoPadre, prefix);
                if (this.namespace != null) continue;
                this.namespace = this.mappingPrefixToNamespace((Node)soapEnvelope, prefix);
                if (this.namespace != null) continue;
                throw new Exception("[DocumentStyle] Namespace (for prefix " + prefix + ") not found for element [" + n.getLocalName() + "] with xsi:type=\"" + value + "\"");
            }
        }
        if (this.xsiType == null) {
            this.namespace = n.getNamespaceURI();
        } else {
            this.namespaceElementoCheContieneXSIType = n.getNamespaceURI();
        }
    }

    private String mappingPrefixToNamespace(Node n, String prefix) {
        NamedNodeMap attributes = n.getAttributes();
        if (attributes == null || attributes.getLength() <= 0) {
            return null;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!(attribute instanceof Attr)) continue;
            Attr a = (Attr)attribute;
            String attrName = a.getName();
            String value = a.getNodeValue();
            if (!attrName.startsWith("xmlns") || !(prefix == null || prefix.equals("") ? "xmlns".equals(attrName) : attrName.equals("xmlns:" + prefix))) continue;
            return value;
        }
        return null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getXsiType() {
        return this.xsiType;
    }

    public void setXsiType(String xsiType) {
        this.xsiType = xsiType;
    }

    public String getNamespaceElementoCheContieneXSIType() {
        return this.namespaceElementoCheContieneXSIType;
    }

    public void setNamespaceElementoCheContieneXSIType(String namespaceElementoCheContieneXSIType) {
        this.namespaceElementoCheContieneXSIType = namespaceElementoCheContieneXSIType;
    }

    public String toString() {
        return RootElementBody.toString(this.localName, this.namespace, this.xsiType, this.namespaceElementoCheContieneXSIType);
    }

    public static String toString(String localName, String namespace, String xsiType) {
        return RootElementBody.toString(localName, namespace, xsiType, null);
    }

    private static String toString(String localName, String namespace, String xsiType, String namespaceElementoCheContieneXSIType) {
        StringBuilder bf = new StringBuilder();
        if (xsiType == null) {
            bf.append("{");
            bf.append(namespace);
            bf.append("}");
            bf.append(localName);
        } else {
            bf.append("[xsi:type=\"{");
            bf.append(namespace);
            bf.append("\"}" + xsiType + "]");
            if (namespaceElementoCheContieneXSIType != null) {
                bf.append("{");
                bf.append(namespaceElementoCheContieneXSIType);
                bf.append("}");
            }
            bf.append(localName);
        }
        return bf.toString();
    }
}

