/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.tracciamento.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.core.tracciamento.Allegati;
import org.openspcoop2.core.tracciamento.Allegato;
import org.openspcoop2.core.tracciamento.Busta;
import org.openspcoop2.core.tracciamento.Data;
import org.openspcoop2.core.tracciamento.Dominio;
import org.openspcoop2.core.tracciamento.Eccezione;
import org.openspcoop2.core.tracciamento.Eccezioni;
import org.openspcoop2.core.tracciamento.ProfiloCollaborazione;
import org.openspcoop2.core.tracciamento.ProfiloTrasmissione;
import org.openspcoop2.core.tracciamento.Proprieta;
import org.openspcoop2.core.tracciamento.Protocollo;
import org.openspcoop2.core.tracciamento.Riscontri;
import org.openspcoop2.core.tracciamento.Riscontro;
import org.openspcoop2.core.tracciamento.Servizio;
import org.openspcoop2.core.tracciamento.Soggetto;
import org.openspcoop2.core.tracciamento.Traccia;
import org.openspcoop2.core.tracciamento.Trasmissione;
import org.openspcoop2.core.tracciamento.Trasmissioni;
import org.openspcoop2.core.tracciamento.utils.XMLUtilsException;
import org.openspcoop2.core.tracciamento.utils.serializer.JsonJacksonDeserializer;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;
    private static final String BUSTA_PREFIX = "Busta.";

    private XMLUtils() {
    }

    private static synchronized void initValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), log, XMLUtils.class.getResourceAsStream("/openspcoopTracciamento.xsd"));
        }
    }

    public static ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            XMLUtils.initValidatoreXSD(log);
        }
        return validatoreXSD;
    }

    public static boolean validate(Traccia traccia, StringBuilder motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (traccia.getTipo() == null) {
            motivoErroreValidazione.append("Tipo non definito\n");
        }
        if (traccia.getDominio() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(traccia.getDominio(), motivoErroreValidazione);
        }
        if (traccia.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (traccia.getEsitoElaborazione() == null) {
            motivoErroreValidazione.append("EsitoElaborazione non definito\n");
        } else if (traccia.getEsitoElaborazione().getTipo() == null) {
            motivoErroreValidazione.append("EsitoElaborazione.tipo non definito\n");
        }
        if (traccia.getLocation() == null) {
            motivoErroreValidazione.append("Location non definito\n");
        }
        if (traccia.getBusta() == null) {
            motivoErroreValidazione.append("Busta non definita\n");
        } else {
            XMLUtils.validate(traccia.getBusta(), motivoErroreValidazione);
        }
        if (traccia.getAllegati() != null) {
            XMLUtils.validate(traccia.getAllegati(), motivoErroreValidazione);
        }
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(Dominio dominio, StringBuilder motivoErroreValidazione) {
        if (dominio.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("Dominio.identificativoPorta non definito\n");
        }
        if (dominio.getFunzione() == null) {
            motivoErroreValidazione.append("Dominio.funzione non definito\n");
        }
        if (dominio.getSoggetto() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getSoggetto().getTipo() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getSoggetto().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    private static void validate(Busta busta, StringBuilder motivoErroreValidazione) {
        if (busta.getMittente() != null) {
            XMLUtils.validate(busta.getMittente(), motivoErroreValidazione, "mittente");
        }
        if (busta.getDestinatario() != null) {
            XMLUtils.validate(busta.getDestinatario(), motivoErroreValidazione, "destinatario");
        }
        if (busta.getProfiloCollaborazione() != null) {
            XMLUtils.validate(busta.getProfiloCollaborazione(), motivoErroreValidazione);
        }
        if (busta.getServizio() != null) {
            XMLUtils.validate(busta.getServizio(), motivoErroreValidazione, "servizio");
        }
        if (busta.getServizioCorrelato() != null) {
            XMLUtils.validate(busta.getServizio(), motivoErroreValidazione, "servizio-correlato");
        }
        if (busta.getOraRegistrazione() != null) {
            XMLUtils.validate(busta.getOraRegistrazione(), motivoErroreValidazione, "ora-registrazione");
        }
        if (busta.getProfiloTrasmissione() != null) {
            XMLUtils.validate(busta.getProfiloTrasmissione(), motivoErroreValidazione);
        }
        if (busta.getTrasmissioni() != null) {
            XMLUtils.validate(busta.getTrasmissioni(), motivoErroreValidazione);
        }
        if (busta.getRiscontri() != null) {
            XMLUtils.validate(busta.getRiscontri(), motivoErroreValidazione);
        }
        if (busta.getEccezioni() != null) {
            XMLUtils.validate(busta.getEccezioni(), motivoErroreValidazione);
        }
        if (busta.getProtocollo() == null) {
            motivoErroreValidazione.append("Busta.protocollo non definita\n");
        } else {
            XMLUtils.validate(busta.getProtocollo(), motivoErroreValidazione);
        }
    }

    private static void validate(Soggetto soggetto, StringBuilder motivoErroreValidazione, String tipo) {
        String prefix = BUSTA_PREFIX + tipo + ".identificativo";
        if (soggetto.getIdentificativo() == null) {
            motivoErroreValidazione.append(prefix + " non definita\n");
        } else {
            if (soggetto.getIdentificativo().getTipo() == null) {
                motivoErroreValidazione.append(prefix + ".tipo non definita\n");
            }
            if (soggetto.getIdentificativo().getBase() == null) {
                motivoErroreValidazione.append(prefix + ".base non definita\n");
            }
        }
    }

    private static void validate(ProfiloCollaborazione profilo, StringBuilder motivoErroreValidazione) {
        if (profilo.getTipo() == null) {
            motivoErroreValidazione.append("Busta.profiloCollaborazione.identificativo.tipo non definita\n");
        }
        if (profilo.getBase() == null) {
            motivoErroreValidazione.append("Busta.profiloCollaborazione.identificativo.base non definita\n");
        }
    }

    private static void validate(Servizio servizio, StringBuilder motivoErroreValidazione, String tipo) {
        if (servizio.getBase() == null) {
            motivoErroreValidazione.append(BUSTA_PREFIX + tipo + ".base non definita\n");
        }
    }

    private static void validate(Data data, StringBuilder motivoErroreValidazione, String tipo) {
        if (data.getSorgente() != null) {
            if (data.getSorgente().getBase() == null) {
                motivoErroreValidazione.append(BUSTA_PREFIX + tipo + ".sorgente.base non definita\n");
            }
            if (data.getSorgente().getTipo() == null) {
                motivoErroreValidazione.append(BUSTA_PREFIX + tipo + ".sorgente.tipo non definita\n");
            }
        }
    }

    private static void validate(ProfiloTrasmissione profiloTrasmissione, StringBuilder motivoErroreValidazione) {
        if (profiloTrasmissione.getInoltro() != null) {
            if (profiloTrasmissione.getInoltro().getBase() == null) {
                motivoErroreValidazione.append("Busta.profiloTrasmissione.base non definita\n");
            }
            if (profiloTrasmissione.getInoltro().getTipo() == null) {
                motivoErroreValidazione.append("Busta.profiloTrasmissione.tipo non definita\n");
            }
        }
    }

    private static void validate(Trasmissioni trasmissioni, StringBuilder motivoErroreValidazione) {
        for (int i = 0; i < trasmissioni.sizeTrasmissioneList(); ++i) {
            Trasmissione tr = trasmissioni.getTrasmissione(i);
            if (tr == null) {
                motivoErroreValidazione.append("Busta.tramissione[" + i + "] non definita\n");
                continue;
            }
            String prefix = "tramissione[" + i + "]";
            if (tr.getOrigine() != null) {
                XMLUtils.validate(tr.getOrigine(), motivoErroreValidazione, prefix + ".origine");
            }
            if (tr.getDestinazione() != null) {
                XMLUtils.validate(tr.getDestinazione(), motivoErroreValidazione, prefix + ".destinazione");
            }
            if (tr.getOraRegistrazione() == null) continue;
            XMLUtils.validate(tr.getOraRegistrazione(), motivoErroreValidazione, prefix + ".ora-registrazione");
        }
    }

    private static void validate(Riscontri riscontri, StringBuilder motivoErroreValidazione) {
        for (int i = 0; i < riscontri.sizeRiscontroList(); ++i) {
            Riscontro r = riscontri.getRiscontro(i);
            if (r == null) {
                motivoErroreValidazione.append("Busta.riscontro[" + i + "] non definito\n");
                continue;
            }
            if (r.getOraRegistrazione() == null) continue;
            XMLUtils.validate(r.getOraRegistrazione(), motivoErroreValidazione, "riscontro[" + i + "].ora-registrazione");
        }
    }

    private static void validate(Eccezioni eccezioni, StringBuilder motivoErroreValidazione) {
        for (int i = 0; i < eccezioni.sizeEccezioneList(); ++i) {
            String prefix = "Busta.eccezione[" + i + "]";
            Eccezione e = eccezioni.getEccezione(i);
            if (e == null) {
                motivoErroreValidazione.append(prefix + " non definita\n");
                continue;
            }
            XMLUtils.validate(prefix, e, motivoErroreValidazione);
        }
    }

    private static void validate(String prefix, Eccezione e, StringBuilder motivoErroreValidazione) {
        if (e.getCodice() != null) {
            if (e.getCodice().getBase() == null) {
                motivoErroreValidazione.append(prefix + ".codice.base non definita\n");
            }
            if (e.getCodice().getTipo() == null) {
                motivoErroreValidazione.append(prefix + ".codice.tipo non definita\n");
            }
        }
        if (e.getContestoCodifica() != null) {
            if (e.getContestoCodifica().getBase() == null) {
                motivoErroreValidazione.append(prefix + ".contesto-codifica.base non definita\n");
            }
            if (e.getContestoCodifica().getTipo() == null) {
                motivoErroreValidazione.append(prefix + ".contesto-codifica.tipo non definita\n");
            }
        }
        if (e.getRilevanza() != null) {
            if (e.getRilevanza().getBase() == null) {
                motivoErroreValidazione.append(prefix + ".rilevanza.base non definita\n");
            }
            if (e.getRilevanza().getTipo() == null) {
                motivoErroreValidazione.append(prefix + ".rilevanza.tipo non definita\n");
            }
        }
    }

    private static void validate(Allegati allegati, StringBuilder motivoErroreValidazione) {
        for (int i = 0; i < allegati.sizeAllegatoList(); ++i) {
            Allegato a = allegati.getAllegato(i);
            if (a != null) continue;
            motivoErroreValidazione.append("Busta.allegato[" + i + "] non definita\n");
        }
    }

    private static void validate(Protocollo protocollo, StringBuilder motivoErroreValidazione) {
        if (protocollo.getIdentificativo() == null) {
            motivoErroreValidazione.append("Busta.protocollo.identificativo non definito\n");
        }
        for (int i = 0; i < protocollo.sizeProprietaList(); ++i) {
            String prefix = "Busta.protocollo.proprieta[" + i + "]";
            Proprieta pp = protocollo.getProprieta(i);
            if (pp == null) {
                motivoErroreValidazione.append(prefix + " non definito\n");
                continue;
            }
            if (pp.getNome() == null) {
                motivoErroreValidazione.append(prefix + ".nome non definito\n");
            }
            if (pp.getValore() != null) continue;
            motivoErroreValidazione.append(prefix + "[" + pp.getNome() + "].valore non definito\n");
        }
    }

    public static Traccia getTraccia(Logger log, byte[] m) throws XMLUtilsException {
        Traccia traccia;
        ByteArrayInputStream bin = new ByteArrayInputStream(m);
        try {
            traccia = XMLUtils.getTraccia(log, bin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        bin.close();
        return traccia;
    }

    public static Traccia getTraccia(Logger log, File m) throws XMLUtilsException {
        Traccia traccia;
        FileInputStream fin = new FileInputStream(m);
        try {
            traccia = XMLUtils.getTraccia(log, fin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        fin.close();
        return traccia;
    }

    public static Traccia getTraccia(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getTraccia(log, m.getBytes());
    }

    public static Traccia getTraccia(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (Traccia)JaxbUtils.xmlToObj((InputStream)binTrasformazione, Traccia.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static Traccia getTracciaFromJson(Logger log, InputStream is) throws XMLUtilsException {
        try {
            if (log != null) {
                // empty if block
            }
            JsonJacksonDeserializer deserializer = new JsonJacksonDeserializer();
            return deserializer.readTraccia(is);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateTraccia(Traccia traccia, File out) throws XMLUtilsException {
        XMLUtils.generateTraccia(traccia, out, false, false);
    }

    public static void generateTraccia(Traccia traccia, File out, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(traccia, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateTracciaEngine(traccia, prettyDocument, omitXmlDeclaration));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateTraccia(Traccia traccia, String fileName) throws XMLUtilsException {
        XMLUtils.generateTraccia(traccia, fileName, false, false);
    }

    public static void generateTraccia(Traccia traccia, String fileName, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(traccia, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])XMLUtils.generateTracciaEngine(traccia, prettyDocument, omitXmlDeclaration));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateTraccia(Traccia traccia) throws XMLUtilsException {
        return XMLUtils.generateTraccia(traccia, false, false);
    }

    public static byte[] generateTraccia(Traccia traccia, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(traccia, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            return XMLUtils.generateTracciaEngine(traccia, prettyDocument, omitXmlDeclaration);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateTraccia(Traccia traccia, OutputStream out) throws XMLUtilsException {
        XMLUtils.generateTraccia(traccia, out, false, false);
    }

    public static void generateTraccia(Traccia traccia, OutputStream out, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(traccia, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateTracciaEngine(traccia, prettyDocument, omitXmlDeclaration));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static String generateTracciaAsJson(Traccia traccia) throws XMLUtilsException {
        return XMLUtils.generateTracciaAsJson(traccia, false);
    }

    public static String generateTracciaAsJson(Traccia traccia, boolean prettyDocument) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(traccia, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            return XMLUtils.generateTracciaAsJsonEngine(traccia, prettyDocument);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateTracciaEngine(Traccia traccia, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, Traccia.class, (Object)traccia, (boolean)prettyDocument, (boolean)omitXmlDeclaration);
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static String generateTracciaAsJsonEngine(Traccia traccia, boolean prettyDocument) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            traccia.writeTo(bout, WriteToSerializerType.JSON_JACKSON, prettyDocument);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isTraccia(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isTracciaEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTraccia(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isTracciaEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTraccia(Element elemXML) {
        return XMLUtils.isTracciaEngine(elemXML);
    }

    public static boolean isTraccia(Node nodeXml) {
        return XMLUtils.isTracciaEngine(nodeXml);
    }

    private static boolean isTracciaEngine(Node nodeXml) {
        try {
            return "traccia".equals(nodeXml.getLocalName()) && "http://www.openspcoop2.org/core/tracciamento".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

