/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenziale;
import org.openspcoop2.utils.UtilsException;

public abstract class AbstractCredenzialeList
extends AbstractCredenziale {
    private List<String> values;
    public static final String PREFIX = "##";

    protected AbstractCredenzialeList(TipoCredenzialeMittente tipo, List<String> values) {
        super(tipo);
        this.values = values;
    }

    @Override
    public String getCredenziale() throws UtilsException {
        StringBuilder bf = new StringBuilder();
        bf.append(PREFIX);
        for (String value : this.values) {
            bf.append(value);
            bf.append(PREFIX);
        }
        return bf.toString();
    }

    public static String getDBValue(String address) {
        return AbstractCredenzialeList.getDBValue(address, true);
    }

    public static String getDBValue(String address, boolean ricercaEsatta) {
        if (ricercaEsatta) {
            return PREFIX + address + PREFIX;
        }
        return "##%" + address + "%##";
    }

    public static List<String> normalizeToList(String dbValue) {
        List<String> lReturn = null;
        if (dbValue.contains(PREFIX)) {
            ArrayList<String> l = new ArrayList<String>();
            String[] tmp = dbValue.split(PREFIX);
            AbstractCredenzialeList.normalizeToList(tmp, l);
            if (!l.isEmpty()) {
                return l;
            }
        }
        return lReturn;
    }

    private static void normalizeToList(String[] tmp, List<String> l) {
        if (tmp != null && tmp.length > 0) {
            for (String t : tmp) {
                if (t == null || StringUtils.isEmpty((String)(t = t.trim()))) continue;
                l.add(t);
            }
        }
    }

    public static String normalize(String dbValue) {
        List<String> l = AbstractCredenzialeList.normalizeToList(dbValue);
        if (l != null && !l.isEmpty()) {
            StringBuilder bf = new StringBuilder();
            for (String v : l) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(v);
            }
            return bf.toString();
        }
        return null;
    }

    @Override
    public void updateCredenziale(String newCredential) throws UtilsException {
        throw new UtilsException("Aggiornamento non supportato dal tipo di credenziale");
    }
}

