/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.fill.JRFillGanttSeries;
import net.sf.jasperreports.charts.util.CategoryLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

public class JRFillGanttDataset
extends JRFillChartDataset
implements JRGanttDataset {
    protected JRFillGanttSeries[] ganttSeries;
    private List<Comparable<?>> seriesNames;
    private Map<Comparable<?>, TaskSeries> seriesMap;
    private Map<Comparable<?>, Map<Comparable<?>, String>> labelsMap;
    private Map<Comparable<?>, Map<Pair, JRPrintHyperlink>> itemHyperlinks;

    public JRFillGanttDataset(JRGanttDataset ganttDataset, JRFillObjectFactory factory) {
        super(ganttDataset, factory);
        JRGanttSeries[] srcGanttSeries = ganttDataset.getSeries();
        if (srcGanttSeries != null && srcGanttSeries.length > 0) {
            this.ganttSeries = new JRFillGanttSeries[srcGanttSeries.length];
            for (int i = 0; i < this.ganttSeries.length; ++i) {
                this.ganttSeries[i] = (JRFillGanttSeries)factory.getGanttSeries(srcGanttSeries[i]);
            }
        }
    }

    @Override
    public JRGanttSeries[] getSeries() {
        return this.ganttSeries;
    }

    @Override
    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    @Override
    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.ganttSeries != null && this.ganttSeries.length > 0) {
            for (int i = 0; i < this.ganttSeries.length; ++i) {
                this.ganttSeries[i].evaluate(calculator);
            }
        }
    }

    @Override
    protected void customIncrement() {
        if (this.ganttSeries != null && this.ganttSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i = 0; i < this.ganttSeries.length; ++i) {
                Number percent;
                Task subtask;
                Task task;
                JRFillGanttSeries crtGanttSeries = this.ganttSeries[i];
                Comparable<?> seriesName = crtGanttSeries.getSeries();
                TaskSeries taskSrs = this.seriesMap.get(seriesName);
                if (taskSrs == null) {
                    taskSrs = new TaskSeries((String)((Object)seriesName));
                    this.seriesNames.add(seriesName);
                    this.seriesMap.put(seriesName, taskSrs);
                }
                if ((task = taskSrs.get(crtGanttSeries.getTask())) == null) {
                    task = new Task(crtGanttSeries.getTask(), crtGanttSeries.getStartDate(), crtGanttSeries.getEndDate());
                    taskSrs.add(task);
                }
                if ((subtask = new Task(crtGanttSeries.getSubtask(), crtGanttSeries.getStartDate(), crtGanttSeries.getEndDate())).getDuration().getStart().before(task.getDuration().getStart())) {
                    task.setDuration((TimePeriod)new SimpleTimePeriod(subtask.getDuration().getStart(), task.getDuration().getEnd()));
                }
                if (subtask.getDuration().getEnd().after(task.getDuration().getEnd())) {
                    task.setDuration((TimePeriod)new SimpleTimePeriod(task.getDuration().getStart(), subtask.getDuration().getEnd()));
                }
                if ((percent = crtGanttSeries.getPercent()) != null) {
                    subtask.setPercentComplete(percent.doubleValue());
                }
                task.addSubtask(subtask);
                if (crtGanttSeries.getLabelExpression() != null) {
                    Map<Comparable<?>, String> seriesLabels = this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put((Comparable<?>)((Object)crtGanttSeries.getTask()), crtGanttSeries.getLabel());
                }
                if (!crtGanttSeries.hasItemHyperlinks()) continue;
                Map<Pair, JRPrintHyperlink> seriesLinks = this.itemHyperlinks.get(seriesName);
                if (seriesLinks == null) {
                    seriesLinks = new HashMap<Pair, JRPrintHyperlink>();
                    this.itemHyperlinks.put(seriesName, seriesLinks);
                }
                Pair<String, String> taskSubtaskKey = new Pair<String, String>(crtGanttSeries.getTask(), crtGanttSeries.getSubtask());
                seriesLinks.put(taskSubtaskKey, crtGanttSeries.getPrintItemHyperlink());
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        if (this.seriesNames != null) {
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                Comparable<?> seriesName = this.seriesNames.get(i);
                dataset.add(this.seriesMap.get(seriesName));
            }
        }
        return dataset;
    }

    @Override
    public byte getDatasetType() {
        return 9;
    }

    @Override
    public Object getLabelGenerator() {
        return new CategoryLabelGenerator(this.labelsMap, this.getLocale());
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Map<Comparable<?>, Map<Pair, JRPrintHyperlink>> getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.ganttSeries != null && this.ganttSeries.length > 0) {
            for (int i = 0; i < this.ganttSeries.length && !foundLinks; ++i) {
                JRFillGanttSeries series = this.ganttSeries[i];
                foundLinks = series.hasItemHyperlinks();
            }
        }
        return foundLinks;
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

