/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.ConstantExpressionEvaluation;
import net.sf.jasperreports.compilers.DirectConstantEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionEvaluation;
import net.sf.jasperreports.compilers.DirectExpressionEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionEvaluators;
import net.sf.jasperreports.compilers.DirectExpressionValueFilter;
import net.sf.jasperreports.compilers.DirectFieldEvaluator;
import net.sf.jasperreports.compilers.DirectParameterEvaluator;
import net.sf.jasperreports.compilers.DirectVariableEvaluator;
import net.sf.jasperreports.compilers.FieldEvaluation;
import net.sf.jasperreports.compilers.ParameterEvaluation;
import net.sf.jasperreports.compilers.ResourceEvaluation;
import net.sf.jasperreports.compilers.SimpleTextEvaluation;
import net.sf.jasperreports.compilers.UniformExpressionEvaluator;
import net.sf.jasperreports.compilers.VariableEvaluation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.ExpressionValues;
import net.sf.jasperreports.engine.fill.FillExpressionDefaultValues;
import net.sf.jasperreports.engine.fill.FillExpressionEstimatedValues;
import net.sf.jasperreports.engine.fill.FillExpressionOldValues;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.SimpleTextExpressionEvaluator;

public class StandardExpressionEvaluators
implements DirectExpressionEvaluators {
    private static DirectExpressionEvaluator NULL_PLACEHOLDER = new UniformExpressionEvaluator(){

        @Override
        protected Object defaultEvaluate() {
            throw new UnsupportedOperationException();
        }
    };
    private Map<Integer, DirectExpressionEvaluation> directEvaluations;
    private DirectExpressionValueFilter valueFilter;
    private Map<Integer, DirectExpressionEvaluator> evaluators;
    private JREvaluator evaluator;
    private Map<String, JRFillParameter> parametersMap;
    private Map<String, JRFillField> fieldsMap;
    private Map<String, JRFillVariable> variablesMap;
    private ExpressionValues defaultValues;
    private ExpressionValues oldValues;
    private ExpressionValues estimatedValues;

    public StandardExpressionEvaluators(Map<Integer, DirectExpressionEvaluation> directEvaluations, DirectExpressionValueFilter valueFilter) {
        this.directEvaluations = directEvaluations;
        this.valueFilter = valueFilter;
        this.evaluators = new HashMap<Integer, DirectExpressionEvaluator>();
    }

    @Override
    public void init(JREvaluator evaluator, Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) {
        this.evaluator = evaluator;
        this.parametersMap = parametersMap;
        this.fieldsMap = fieldsMap;
        this.variablesMap = variablesMap;
        this.defaultValues = new FillExpressionDefaultValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.oldValues = new FillExpressionOldValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.estimatedValues = new FillExpressionEstimatedValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.evaluators.clear();
    }

    @Override
    public DirectExpressionEvaluator getEvaluator(JRExpression expression) {
        int expressionId = expression.getId();
        DirectExpressionEvaluator evaluator = this.evaluators.get(expressionId);
        if (evaluator == null) {
            DirectExpressionEvaluation directEvaluation = this.directEvaluation(expression.getId());
            evaluator = directEvaluation == null ? NULL_PLACEHOLDER : this.createDirectEvaluator(directEvaluation);
            this.evaluators.put(expressionId, evaluator);
        }
        return evaluator == NULL_PLACEHOLDER ? null : evaluator;
    }

    protected DirectExpressionEvaluation directEvaluation(int expressionId) {
        DirectExpressionEvaluation directEvaluation = this.directEvaluations == null ? null : this.directEvaluations.get(expressionId);
        return directEvaluation;
    }

    protected DirectExpressionEvaluator createDirectEvaluator(DirectExpressionEvaluation evaluation) {
        DirectExpressionEvaluator evaluator;
        switch (evaluation.getType()) {
            case CONSTANT: {
                Object expressionValue = ((ConstantExpressionEvaluation)evaluation).getValue();
                Object value = this.valueFilter.filterValue(expressionValue, null);
                evaluator = new DirectConstantEvaluator(value);
                break;
            }
            case SIMPLE_TEXT: {
                evaluator = new SimpleTextEvaluator(((SimpleTextEvaluation)evaluation).getChunks());
                break;
            }
            case PARAMETER: {
                String parameterName = ((ParameterEvaluation)evaluation).getName();
                JRFillParameter parameter = this.parametersMap.get(parameterName);
                if (parameter == null) {
                    throw new JRRuntimeException("Did not find parameter " + parameterName);
                }
                evaluator = new DirectParameterEvaluator(parameter, this.valueFilter);
                break;
            }
            case FIELD: {
                String fieldName = ((FieldEvaluation)evaluation).getName();
                JRFillField field = this.fieldsMap.get(fieldName);
                if (field == null) {
                    throw new JRRuntimeException("Did not find field " + fieldName);
                }
                evaluator = new DirectFieldEvaluator(field, this.valueFilter);
                break;
            }
            case VARIABLE: {
                String variableName = ((VariableEvaluation)evaluation).getName();
                JRFillVariable variable = this.variablesMap.get(variableName);
                if (variable == null) {
                    throw new JRRuntimeException("Did not find variable " + variableName);
                }
                evaluator = new DirectVariableEvaluator(variable, this.valueFilter);
                break;
            }
            case RESOURCE: {
                String messageKey = ((ResourceEvaluation)evaluation).getMessageKey();
                Object message = this.valueFilter.filterValue(this.evaluator.str(messageKey), null);
                evaluator = new DirectConstantEvaluator(message);
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown direct expression evaluation type " + (Object)((Object)evaluation.getType()));
            }
        }
        return evaluator;
    }

    protected class SimpleTextEvaluator
    implements DirectExpressionEvaluator {
        private JRExpressionChunk[] chunks;

        public SimpleTextEvaluator(JRExpressionChunk[] chunks) {
            this.chunks = chunks;
        }

        @Override
        public Object evaluate() {
            return SimpleTextExpressionEvaluator.evaluate(this.chunks, StandardExpressionEvaluators.this.defaultValues);
        }

        @Override
        public Object evaluateOld() {
            return SimpleTextExpressionEvaluator.evaluate(this.chunks, StandardExpressionEvaluators.this.oldValues);
        }

        @Override
        public Object evaluateEstimated() {
            return SimpleTextExpressionEvaluator.evaluate(this.chunks, StandardExpressionEvaluators.this.estimatedValues);
        }
    }
}

