/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.awt.Color;
import java.util.Locale;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.headertoolbar.actions.EditTextElementData;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.web.commands.Command;

public class EditTextElementCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    private EditTextElementData editTextElementData;
    private EditTextElementData oldEditTextElementData;
    private JRDesignTextElement textElement;
    private String oldText;
    private ReportContext reportContext;

    public EditTextElementCommand(JRDesignTextElement textElement, EditTextElementData editTextElementData, ReportContext reportContext) {
        this.textElement = textElement;
        this.editTextElementData = editTextElementData;
        this.reportContext = reportContext;
    }

    @Override
    public void execute() {
        if (this.textElement != null) {
            Locale locale = (Locale)this.reportContext.getParameterValue("REPORT_LOCALE");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.oldEditTextElementData = new EditTextElementData();
            this.oldEditTextElementData.setApplyTo(this.editTextElementData.getApplyTo());
            HeaderToolbarElementUtils.copyOwnTextElementStyle(this.oldEditTextElementData, this.textElement, locale);
            this.applyColumnHeaderData(this.editTextElementData, this.textElement, true);
        }
    }

    private void applyColumnHeaderData(EditTextElementData textElementData, JRDesignTextElement textElement, boolean execute) {
        if ("heading".equals(textElementData.getApplyTo())) {
            if (textElement instanceof JRDesignTextField) {
                JRDesignTextField designTextField = (JRDesignTextField)textElement;
                if (execute) {
                    if (this.oldText == null) {
                        this.oldText = designTextField.getExpression().getText();
                    }
                    ((JRDesignExpression)designTextField.getExpression()).setText("\"" + JRStringUtil.escapeJavaStringLiteral(textElementData.getHeadingName()) + "\"");
                } else {
                    ((JRDesignExpression)designTextField.getExpression()).setText(this.oldText);
                }
            } else if (textElement instanceof JRDesignStaticText) {
                JRDesignStaticText staticText = (JRDesignStaticText)textElement;
                if (execute) {
                    if (this.oldText == null) {
                        this.oldText = staticText.getText();
                    }
                    staticText.setText(textElementData.getHeadingName());
                } else {
                    staticText.setText(this.oldText);
                }
            }
        }
        textElement.setFontName(textElementData.getFontName());
        textElement.setFontSize(textElementData.getFloatFontSize());
        textElement.setBold(textElementData.getFontBold());
        textElement.setItalic(textElementData.getFontItalic());
        textElement.setUnderline(textElementData.getFontUnderline());
        textElement.setForecolor(textElementData.getFontColor() != null ? JRColorUtil.getColor("#" + textElementData.getFontColor(), textElement.getForecolor()) : null);
        textElement.setHorizontalTextAlign(HorizontalTextAlignEnum.getByName(textElementData.getFontHAlign()));
        textElement.setBackcolor(textElementData.getFontBackColor() != null ? JRColorUtil.getColor("#" + textElementData.getFontBackColor(), Color.white) : null);
        textElement.setMode(ModeEnum.getByName(textElementData.getMode()));
        if (textElement instanceof JRDesignTextField && TableUtil.hasSingleChunkExpression((JRDesignTextField)textElement)) {
            ((JRDesignTextField)textElement).setPattern(textElementData.getFormatPattern());
        }
    }

    @Override
    public void undo() {
        if (this.oldEditTextElementData != null) {
            this.applyColumnHeaderData(this.oldEditTextElementData, this.textElement, false);
        }
    }

    @Override
    public void redo() {
        this.applyColumnHeaderData(this.editTextElementData, this.textElement, true);
    }
}

