/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.random;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class RandomDataSource
implements JRRewindableDataSource {
    private final int count;
    private final Random random = new Random();
    private int index;

    public RandomDataSource(int count) {
        this.count = count;
        this.index = 0;
    }

    @Override
    public boolean next() throws JRException {
        if (this.index >= this.count) {
            return false;
        }
        ++this.index;
        return true;
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        Comparable<Comparable<Date>> value;
        Class<?> valueClass = field.getValueClass();
        if (String.class.equals(valueClass)) {
            String name = field.getName();
            if (name.length() > 1000) {
                name = name.substring(0, 1000);
            }
            StringBuilder valueStr = new StringBuilder(name);
            int cnt = 2 + this.random.nextInt(3);
            for (int i = 0; i < cnt; ++i) {
                valueStr.append(" ").append(this.random.nextInt(100));
            }
            value = valueStr.toString();
        } else {
            value = Float.class.equals(valueClass) ? Float.valueOf(200000.0f * this.random.nextFloat()) : (Double.class.equals(valueClass) ? Double.valueOf(200000.0 * this.random.nextDouble()) : (Long.class.equals(valueClass) ? Long.valueOf(this.random.nextLong()) : (Integer.class.equals(valueClass) ? Integer.valueOf(this.random.nextInt(20)) : (BigInteger.class.equals(valueClass) ? BigInteger.valueOf(this.random.nextLong()) : (BigDecimal.class.equals(valueClass) ? BigDecimal.valueOf((double)this.random.nextInt(10000) / 100.0) : (Date.class.equals(valueClass) ? new Date(System.currentTimeMillis() - (long)this.random.nextInt(1728000000)) : (java.sql.Date.class.equals(valueClass) ? new java.sql.Date(System.currentTimeMillis() - (long)this.random.nextInt(1728000000)) : (Timestamp.class.equals(valueClass) ? new Timestamp(System.currentTimeMillis() - (long)this.random.nextInt(1728000000)) : (Boolean.class.equals(valueClass) ? Boolean.valueOf(this.random.nextInt(2) == 0) : null)))))))));
        }
        return value;
    }

    @Override
    public void moveFirst() throws JRException {
        this.index = 0;
    }
}

