/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRQueryParser;

public class JRBaseQueryChunk
implements JRQueryChunk,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected byte type = 1;
    protected String text;
    protected String[] tokens;
    protected Character tokenSeparator;

    protected JRBaseQueryChunk() {
    }

    protected JRBaseQueryChunk(JRQueryChunk queryChunk, JRBaseObjectFactory factory) {
        factory.put(queryChunk, this);
        this.type = queryChunk.getType();
        this.text = queryChunk.getText();
        this.tokenSeparator = queryChunk.getTokenSeparator();
        String[] chunkTokens = queryChunk.getTokens();
        if (chunkTokens == null) {
            this.tokens = null;
        } else {
            this.tokens = new String[chunkTokens.length];
            System.arraycopy(chunkTokens, 0, this.tokens, 0, chunkTokens.length);
        }
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public String getText() {
        if (this.type == 4) {
            return JRQueryParser.instance().asClauseText(this.getTokens(), this.getTokenSeparator());
        }
        return this.text;
    }

    @Override
    public String[] getTokens() {
        return this.tokens;
    }

    @Override
    public Character getTokenSeparator() {
        return this.tokenSeparator;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }
}

