/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;

public class JRReportCompileData
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_COMPILE_DATA_FOR_CROSSTAB_NOT_FOUND = "design.compile.data.for.crosstab.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_COMPILE_DATA_FOR_DATASET_NOT_FOUND = "design.compile.data.for.dataset.not.found";
    private Serializable mainDatasetCompileData;
    private Map<String, Serializable> datasetCompileData = new HashMap<String, Serializable>();
    private Map<Integer, Serializable> crosstabCompileData = new HashMap<Integer, Serializable>();

    public void setMainDatasetCompileData(Serializable compileData) {
        this.mainDatasetCompileData = compileData;
    }

    public void setDatasetCompileData(JRDataset dataset, Serializable compileData) {
        if (dataset.isMainDataset()) {
            this.setMainDatasetCompileData(compileData);
        } else {
            this.datasetCompileData.put(dataset.getName(), compileData);
        }
    }

    public void setCrosstabCompileData(int crosstabId, Serializable compileData) {
        this.crosstabCompileData.put(crosstabId, compileData);
    }

    public Serializable getMainDatasetCompileData() {
        return this.mainDatasetCompileData;
    }

    public Serializable getDatasetCompileData(JRDataset dataset) throws JRException {
        Serializable compileData;
        if (dataset.isMainDataset()) {
            compileData = this.getMainDatasetCompileData();
        } else {
            compileData = this.datasetCompileData.get(dataset.getName());
            if (compileData == null) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_COMPILE_DATA_FOR_DATASET_NOT_FOUND, dataset.getName());
            }
        }
        return compileData;
    }

    public Serializable getCrosstabCompileData(JRCrosstab crosstab) throws JRException {
        Serializable compileData = this.crosstabCompileData.get(crosstab.getId());
        if (compileData == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_COMPILE_DATA_FOR_CROSSTAB_NOT_FOUND, (Object[])null);
        }
        return compileData;
    }

    public String getUnitName(JasperReport jasperReport, JRDataset dataset) {
        return JRAbstractCompiler.getUnitName(jasperReport, dataset);
    }

    public String getUnitName(JasperReport jasperReport, JRCrosstab crosstab) {
        return JRAbstractCompiler.getUnitName(jasperReport, crosstab);
    }

    public Map<Integer, Serializable> getCrosstabsCompileData() {
        return this.crosstabCompileData;
    }
}

