/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.GridCellSize;
import net.sf.jasperreports.engine.export.GridCellStyle;
import net.sf.jasperreports.engine.type.ModeEnum;

public abstract class JRExporterGridCell {
    public static final byte TYPE_EMPTY_CELL = 1;
    public static final byte TYPE_OCCUPIED_CELL = 2;
    public static final byte TYPE_ELEMENT_CELL = 3;
    private GridCellStyle style;

    public JRExporterGridCell() {
    }

    protected JRExporterGridCell(GridCellStyle style) {
        this.style = style;
    }

    public abstract GridCellSize getSize();

    public int getWidth() {
        return this.getSize().getWidth();
    }

    public int getHeight() {
        return this.getSize().getHeight();
    }

    public int getColSpan() {
        return this.getSize().getColSpan();
    }

    public int getRowSpan() {
        return this.getSize().getRowSpan();
    }

    public GridCellStyle getStyle() {
        return this.style;
    }

    public void setStyle(GridCellStyle style) {
        this.style = style;
    }

    public Color getBackcolor() {
        return this.style == null ? null : this.style.getBackcolor();
    }

    public JRLineBox getBox() {
        return this.style == null ? null : this.style.getBox();
    }

    public void setBox(JRLineBox box) {
        throw new UnsupportedOperationException("Cannot set the box on a cell of type " + this.getType());
    }

    public Color getForecolor() {
        return this.style == null ? null : this.style.getForecolor();
    }

    public Color getCellBackcolor() {
        JRPrintElement element = this.getElement();
        Color color = element != null && element.getModeValue() == ModeEnum.OPAQUE ? element.getBackcolor() : this.getBackcolor();
        return color;
    }

    public abstract byte getType();

    public abstract JRPrintElement getElement();

    public abstract String getElementAddress();

    public abstract String getProperty(String var1);
}

