/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.BaseFontHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxZip;
import net.sf.jasperreports.engine.fonts.FontFace;

public class DocxFontHelper
extends BaseFontHelper {
    public DocxFontHelper(JasperReportsContext jasperReportsContext, DocxZip docxZip, boolean isEmbedFonts) {
        super(jasperReportsContext, docxZip.getFontTableEntry().getWriter(), docxZip.getFontTableRelsEntry().getWriter(), docxZip, isEmbedFonts);
    }

    @Override
    protected String getExporterKey() {
        return "net.sf.jasperreports.docx";
    }

    @Override
    protected String getEndFontTag() {
        return "  </w:font>\n";
    }

    @Override
    protected String getFontsDir() {
        return "word/fonts/";
    }

    @Override
    protected String getStartFontTag(String fontName) {
        return "  <w:font w:name=\"" + fontName + "\">\n";
    }

    @Override
    protected String getRegularEmbedding(String id) {
        return "    <w:embedRegular r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getBoldEmbedding(String id) {
        return "    <w:embedBold r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getItalicEmbedding(String id) {
        return "    <w:embedItalic r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getBoldItalicEmbedding(String id) {
        return "    <w:embedBoldItalic r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getFontPath(FontFace fontFace) {
        return fontFace == null ? null : fontFace.getTtf();
    }
}

