/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import net.sf.jasperreports.engine.util.BigDecimalHandler;
import net.sf.jasperreports.engine.util.Java14BigDecimalHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BigDecimalUtils {
    private static final Log log = LogFactory.getLog(BigDecimalUtils.class);
    private static final BigDecimalHandler handler = BigDecimalUtils.loadHandler();

    private static BigDecimalHandler loadHandler() {
        BigDecimalHandler handler;
        try {
            Class<?> handlerClass = Class.forName("net.sf.jasperreports.engine.util.Java15BigDecimalHandler");
            handler = (BigDecimalHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to instantiate Java 1.5 BigDecimal handler");
            }
            handler = new Java14BigDecimalHandler();
        }
        return handler;
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        return handler.divide(dividend, divisor);
    }

    private BigDecimalUtils() {
    }
}

