/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.ibm.icu.lang.UScript;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CharScriptsSet {
    private Set<Integer> includedScripts;
    private Set<Integer> excludedScripts;
    private boolean excludedCommon;
    private boolean excludedInherited;

    public CharScriptsSet(List<String> includedScriptNames, List<String> excludedScriptNames) {
        int scriptCode;
        if (includedScriptNames != null) {
            this.includedScripts = new HashSet<Integer>(includedScriptNames.size() * 4 / 3, 0.75f);
            for (String script : includedScriptNames) {
                scriptCode = this.resolveScript(script);
                if (scriptCode == -1) continue;
                this.includedScripts.add(scriptCode);
            }
            if (this.includedScripts.isEmpty()) {
                this.includedScripts = null;
            }
        }
        if (excludedScriptNames != null) {
            this.excludedScripts = new HashSet<Integer>(excludedScriptNames.size() * 4 / 3, 0.75f);
            for (String script : excludedScriptNames) {
                scriptCode = this.resolveScript(script);
                if (scriptCode == -1) continue;
                this.excludedScripts.add(scriptCode);
            }
            if (this.excludedScripts.isEmpty()) {
                this.excludedScripts = null;
            } else {
                this.excludedCommon = this.excludedScripts.contains(0);
                this.excludedInherited = this.excludedScripts.contains(1);
            }
        }
    }

    private int resolveScript(String script) {
        int scriptCode = UScript.getCodeFromName((String)script);
        return scriptCode;
    }

    public boolean includesCharacter(int codePoint) {
        if (this.includedScripts == null && this.excludedScripts == null) {
            return true;
        }
        int codeScript = UScript.getScript((int)codePoint);
        if (codeScript == 103) {
            return true;
        }
        if (codeScript == 0) {
            return !this.excludedCommon;
        }
        if (codeScript == 1) {
            return !this.excludedInherited;
        }
        if (this.includedScripts != null && this.includedScripts.contains(codeScript)) {
            return true;
        }
        if (this.excludedScripts != null && this.excludedScripts.contains(codeScript)) {
            return false;
        }
        if (this.includedScripts == null) {
            return true;
        }
        for (Integer script : this.includedScripts) {
            if (!UScript.hasScript((int)codePoint, (int)script)) continue;
            return true;
        }
        return false;
    }
}

