/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRRuntimeException;

public class ExpressionParser {
    private static final ExpressionParser INSTANCE = new ExpressionParser();
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$([RPFV])\\{(.*?)\\}", 40);
    protected static final int PLACEHOLDER_TYPE_INDEX = 1;
    protected static final int PLACEHOLDER_TEXT_INDEX = 2;
    protected static final char PLACEHOLDER_START = '$';
    protected static final char PLACEHOLDER_OPEN = '{';
    protected static final char PLACEHOLDER_CLOSE = '}';
    protected static final char PLACEHOLDER_TYPE_RESOURCE_MESSAGE = 'R';
    protected static final char PLACEHOLDER_TYPE_PARAMETER = 'P';
    protected static final char PLACEHOLDER_TYPE_FIELD = 'F';
    protected static final char PLACEHOLDER_TYPE_VARIABLE = 'V';

    public static ExpressionParser instance() {
        return INSTANCE;
    }

    public void parseExpression(String text, ParseResult result) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(text);
        int textChunkStart = 0;
        StringBuilder textChunk = new StringBuilder(text.length());
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            if (matchStart > 0 && text.charAt(matchStart - 1) == '$') {
                textChunk.append(text, textChunkStart, matchStart - 1);
                textChunk.append(text, matchStart, matchEnd);
            } else {
                textChunk.append(text, textChunkStart, matchStart);
                if (textChunk.length() > 0) {
                    result.addTextChunk(textChunk.toString());
                    textChunk.delete(0, textChunk.length());
                }
                String chunkStringType = matcher.group(1);
                byte chunkType = this.chunkStringToType(chunkStringType);
                String chunkText = matcher.group(2);
                result.addChunk(chunkType, chunkText);
            }
            textChunkStart = matchEnd;
        }
        textChunk.append(text, textChunkStart, text.length());
        if (textChunk.length() > 0) {
            result.addTextChunk(textChunk.toString());
        }
    }

    protected byte chunkStringToType(String chunkStringType) {
        byte chunkType;
        char firstChar = chunkStringType.charAt(0);
        switch (firstChar) {
            case 'P': {
                chunkType = 2;
                break;
            }
            case 'F': {
                chunkType = 3;
                break;
            }
            case 'V': {
                chunkType = 4;
                break;
            }
            case 'R': {
                chunkType = 5;
                break;
            }
            default: {
                throw new JRRuntimeException("util.expression.unknown.expression.chunk.type", chunkStringType);
            }
        }
        return chunkType;
    }

    public boolean fastPlaceholderDetect(String text) {
        int textLength = text.length();
        int startIdx = text.indexOf(36);
        boolean found = false;
        while (startIdx >= 0 && startIdx + 3 < textLength) {
            char typeChart = text.charAt(startIdx + 1);
            if ((typeChart == 'R' || typeChart == 'P' || typeChart == 'F' || typeChart == 'V') && text.charAt(startIdx + 2) == '{') {
                found = true;
                break;
            }
            startIdx = text.indexOf(36, startIdx + 1);
        }
        return found;
    }

    public static interface ParseResult {
        public void addTextChunk(String var1);

        public void addChunk(byte var1, String var2);
    }
}

