/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;

public class PageRange {
    private Integer startPageIndex;
    private Integer endPageIndex;

    public PageRange(Integer startPageIndex, Integer endPageIndex) {
        this.startPageIndex = startPageIndex;
        this.endPageIndex = endPageIndex;
    }

    public Integer getStartPageIndex() {
        return this.startPageIndex;
    }

    public Integer getEndPageIndex() {
        return this.endPageIndex;
    }

    public static PageRange[] parse(String strRanges) {
        ArrayList<PageRange> ranges = null;
        if (strRanges != null && strRanges.trim().length() > 0) {
            String[] rangeTokens;
            ranges = new ArrayList<PageRange>();
            for (String rangeToken : rangeTokens = strRanges.split(",")) {
                PageRange pageRange = null;
                int hyphenPos = rangeToken.indexOf("-");
                if (hyphenPos > 0 && hyphenPos < rangeToken.length() - 1) {
                    pageRange = new PageRange(Integer.valueOf(rangeToken.substring(0, hyphenPos).trim()), Integer.valueOf(rangeToken.substring(hyphenPos + 1).trim()));
                } else {
                    int pageIndex = Integer.valueOf(rangeToken.trim());
                    pageRange = new PageRange(pageIndex, pageIndex);
                }
                ranges.add(pageRange);
            }
        }
        return ranges == null ? null : ranges.toArray(new PageRange[ranges.size()]);
    }

    public static boolean isPageInRanges(int pageIndex, PageRange[] ranges) {
        boolean isInRanges = false;
        if (ranges != null) {
            for (PageRange range : ranges) {
                if (range.startPageIndex > pageIndex || pageIndex > range.endPageIndex) continue;
                isInRanges = true;
                break;
            }
        }
        return isInRanges;
    }
}

