/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.jasperreports.engine.virtualization.BigIntegerSerializer;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class BigDecimalSerializer
implements ObjectSerializer<BigDecimal> {
    private final BigIntegerSerializer bigIntegerSerializer;

    public BigDecimalSerializer(BigIntegerSerializer bigIntegerSerializer) {
        this.bigIntegerSerializer = bigIntegerSerializer;
    }

    @Override
    public int typeValue() {
        return 26;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.OBJECT;
    }

    @Override
    public boolean defaultStoreReference() {
        return true;
    }

    @Override
    public void write(BigDecimal value, VirtualizationOutput out) throws IOException {
        out.writeIntCompressed(value.scale());
        this.bigIntegerSerializer.write(value.unscaledValue(), out);
    }

    @Override
    public BigDecimal read(VirtualizationInput in) throws IOException {
        int scale = in.readIntCompressed();
        BigInteger unscaled = this.bigIntegerSerializer.read(in);
        return new BigDecimal(unscaled, scale);
    }
}

