/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseField;
import java.awt.Color;
import java.text.AttributedCharacterIterator;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.export.type.PdfFieldBorderStyleEnum;
import net.sf.jasperreports.export.pdf.PdfField;
import net.sf.jasperreports.export.pdf.PdfTextAlignment;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfUtils;

public abstract class ClassicPdfField
implements PdfField {
    protected ClassicPdfProducer pdfProducer;
    private BaseField field;

    public ClassicPdfField(ClassicPdfProducer pdfProducer, BaseField field) {
        this.pdfProducer = pdfProducer;
        this.field = field;
    }

    @Override
    public void setBorderWidth(float borderWidth) {
        float width = borderWidth > 3.0f ? 3.0f : borderWidth;
        this.field.setBorderWidth(width);
    }

    @Override
    public void setBackgroundColor(Color backcolor) {
        this.field.setBackgroundColor(backcolor);
    }

    @Override
    public void setTextColor(Color forecolor) {
        this.field.setTextColor(forecolor);
    }

    @Override
    public void setAlignment(PdfTextAlignment alignment) {
        this.field.setAlignment(ClassicPdfUtils.toITextAlignment(alignment));
    }

    @Override
    public void setBorderColor(Color lineColor) {
        this.field.setBorderColor(lineColor);
    }

    @Override
    public void setBorderStyle(PdfFieldBorderStyleEnum borderStyle) {
        this.field.setBorderStyle(borderStyle.getValue().intValue());
    }

    @Override
    public void setReadOnly() {
        this.field.setOptions(this.field.getOptions() | 1);
    }

    @Override
    public void setText(String value) {
        this.field.setText(value);
    }

    @Override
    public void setFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        Font font = this.pdfProducer.getFont(attributes, locale);
        this.field.setFont(font.getBaseFont());
    }

    @Override
    public void setFontSize(float fontsize) {
        this.field.setFontSize(fontsize);
    }

    @Override
    public void setRotation(int rotation) {
        this.field.setRotation(rotation);
    }

    @Override
    public void setVisible() {
        this.field.setVisibility(0);
    }
}

