/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.PdfXmpCreator;
import net.sf.jasperreports.export.pdf.PdfDocumentWriter;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.export.type.PdfPrintScalingEnum;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import net.sf.jasperreports.export.type.PdfaConformanceEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassicPdfWriter
implements PdfDocumentWriter {
    private static final Log log = LogFactory.getLog(ClassicPdfWriter.class);
    private ClassicPdfProducer pdfProducer;
    private PdfWriter pdfWriter;

    public ClassicPdfWriter(ClassicPdfProducer pdfProducer, PdfWriter pdfWriter) {
        this.pdfProducer = pdfProducer;
        this.pdfWriter = pdfWriter;
    }

    public PdfWriter getPdfWriter() {
        return this.pdfWriter;
    }

    @Override
    public void setPdfVersion(PdfVersionEnum pdfVersion) {
        this.pdfWriter.setPdfVersion(pdfVersion.getName().charAt(0));
    }

    @Override
    public void setMinimalPdfVersion(PdfVersionEnum minimalVersion) {
        this.pdfWriter.setAtLeastPdfVersion(minimalVersion.getName().charAt(0));
    }

    @Override
    public void setFullCompression() {
        this.pdfWriter.setFullCompression();
    }

    @Override
    public void setEncryption(String userPassword, String ownerPassword, int permissions, boolean is128BitKey) throws JRException {
        try {
            this.pdfWriter.setEncryption(PdfWriter.getISOBytes((String)userPassword), PdfWriter.getISOBytes((String)ownerPassword), permissions, is128BitKey ? 1 : 0);
        }
        catch (DocumentException e) {
            throw this.pdfProducer.getContext().handleDocumentException((Exception)((Object)e));
        }
    }

    @Override
    public void setPrintScaling(PdfPrintScalingEnum printScaling) {
        if (PdfPrintScalingEnum.DEFAULT == printScaling) {
            this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, (PdfObject)PdfName.APPDEFAULT);
        } else if (PdfPrintScalingEnum.NONE == printScaling) {
            this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, (PdfObject)PdfName.NONE);
        }
    }

    @Override
    public void setNoSpaceCharRatio() {
        this.pdfWriter.setSpaceCharRatio(1.0E7f);
    }

    @Override
    public void setTabOrderStructure() {
        this.pdfWriter.setTabs(PdfName.S);
    }

    @Override
    public void setLanguage(String language) {
        this.pdfWriter.getExtraCatalog().put(PdfName.LANG, (PdfObject)new PdfString(language));
    }

    @Override
    public void setPdfaConformance(PdfaConformanceEnum pdfaConformance) {
        if (PdfaConformanceEnum.PDFA_1A == pdfaConformance) {
            this.pdfWriter.setPDFXConformance(3);
        } else if (PdfaConformanceEnum.PDFA_1B == pdfaConformance) {
            this.pdfWriter.setPDFXConformance(4);
        }
    }

    @Override
    public void createXmpMetadata(String title, String subject, String keywords) {
        if (PdfXmpCreator.supported()) {
            byte[] metadata = PdfXmpCreator.createXmpMetadata(this.pdfWriter);
            this.pdfWriter.setXmpMetadata(metadata);
        } else {
            if ((title != null || subject != null || keywords != null) && log.isWarnEnabled()) {
                log.warn((Object)"XMP metadata might be non conforming, include the Adobe XMP library to correct");
            }
            this.pdfWriter.createXmpMetadata();
        }
    }

    @Override
    public void setRgbTransparencyBlending(boolean rgbTransparencyBlending) {
        this.pdfWriter.setRgbTransparencyBlending(rgbTransparencyBlending);
    }

    @Override
    public void setIccProfilePath(String iccProfilePath, InputStream iccIs) throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.OUTPUTINTENT);
        pdfDictionary.put(PdfName.OUTPUTCONDITIONIDENTIFIER, (PdfObject)new PdfString("sRGB IEC61966-2.1"));
        pdfDictionary.put(PdfName.INFO, (PdfObject)new PdfString("sRGB IEC61966-2.1"));
        pdfDictionary.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
        PdfICCBased pdfICCBased = new PdfICCBased(ICC_Profile.getInstance(iccIs));
        pdfICCBased.remove(PdfName.ALTERNATE);
        pdfDictionary.put(PdfName.DESTOUTPUTPROFILE, (PdfObject)this.pdfWriter.addToBody((PdfObject)pdfICCBased).getIndirectReference());
        this.pdfWriter.getExtraCatalog().put(PdfName.OUTPUTINTENTS, (PdfObject)new PdfArray((PdfObject)pdfDictionary));
    }

    @Override
    public void addJavaScript(String pdfJavaScript) {
        this.pdfWriter.addJavaScript(pdfJavaScript);
    }

    @Override
    public void setDisplayMetadataTitle() {
        this.pdfWriter.addViewerPreference(PdfName.DISPLAYDOCTITLE, (PdfObject)new PdfBoolean(true));
    }
}

