/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.AbstractQueryExecuterFactory;
import net.sf.jasperreports.engine.query.JREmptyQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.olap.JRMdxQueryExecuterFactory;
import net.sf.jasperreports.olap.Olap4jMondrianQueryExecuter;
import net.sf.jasperreports.olap.Olap4jMondrianQueryExecuterFactory;
import net.sf.jasperreports.olap.xmla.Olap4jXmlaQueryExecuter;
import net.sf.jasperreports.olap.xmla.Olap4jXmlaQueryExecuterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Olap4jQueryExecuterFactory
extends AbstractQueryExecuterFactory {
    private static final Log log = LogFactory.getLog(JRMdxQueryExecuterFactory.class);
    private static final Object[] MDX_BUILTIN_PARAMETERS;
    public static final String CANONICAL_LANGUAGE = "OLAP4J";

    @Override
    public Object[] getBuiltinParameters() {
        return MDX_BUILTIN_PARAMETERS;
    }

    @Override
    public JRQueryExecuter createQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) throws JRException {
        JRQueryExecuter queryExecuter;
        if (this.getParameterValue(parameters, "JdbcUrl") != null) {
            queryExecuter = new Olap4jMondrianQueryExecuter(jasperReportsContext, dataset, parameters);
        } else if (this.getParameterValue(parameters, "XMLA_URL") != null) {
            queryExecuter = new Olap4jXmlaQueryExecuter(jasperReportsContext, dataset, parameters);
        } else {
            log.warn((Object)"No Mondrian connection or XMLA URL set for MDX query");
            queryExecuter = new JREmptyQueryExecuter();
        }
        return queryExecuter;
    }

    protected final Object getParameterValue(Map<String, ? extends JRValueParameter> valueParams, String name) {
        JRValueParameter valueParam = valueParams.get(name);
        return valueParam == null ? null : valueParam.getValue();
    }

    @Override
    public boolean supportsQueryParameterType(String className) {
        return true;
    }

    static {
        Object[] mondrianParams = new Olap4jMondrianQueryExecuterFactory().getBuiltinParameters();
        Object[] xmlaParams = new Olap4jXmlaQueryExecuterFactory().getBuiltinParameters();
        MDX_BUILTIN_PARAMETERS = new Object[mondrianParams.length + xmlaParams.length];
        System.arraycopy(mondrianParams, 0, MDX_BUILTIN_PARAMETERS, 0, mondrianParams.length);
        System.arraycopy(xmlaParams, 0, MDX_BUILTIN_PARAMETERS, mondrianParams.length, xmlaParams.length);
    }
}

