/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.AbstractRenderToImageDataRenderer;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.RenderToImageAwareRenderable;

public class WrappingRenderToImageDataRenderer
extends AbstractRenderToImageDataRenderer {
    private static final long serialVersionUID = 10200L;
    private final Graphics2DRenderable renderer;
    private final DimensionRenderable dimensionRenderer;
    private final Dimension2D dimension;
    private final Color backcolor;

    public WrappingRenderToImageDataRenderer(Graphics2DRenderable renderer, Dimension2D dimension, Color backcolor) {
        this.renderer = renderer;
        this.dimension = dimension;
        this.dimensionRenderer = null;
        this.backcolor = backcolor;
    }

    public WrappingRenderToImageDataRenderer(Graphics2DRenderable renderer, DimensionRenderable dimensionRender, Color backcolor) {
        this.renderer = renderer;
        this.dimension = null;
        this.dimensionRenderer = dimensionRender;
        this.backcolor = backcolor;
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) {
        Dimension2D imageDimension = null;
        if (this.renderer instanceof DimensionRenderable) {
            try {
                imageDimension = ((DimensionRenderable)((Object)this.renderer)).getDimension(jasperReportsContext);
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
        if (imageDimension == null && this.dimensionRenderer != null) {
            try {
                imageDimension = this.dimensionRenderer.getDimension(jasperReportsContext);
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
        if (imageDimension == null) {
            imageDimension = this.dimension;
        }
        return imageDimension;
    }

    @Override
    public Color getBackcolor() {
        return this.backcolor;
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.renderer.render(jasperReportsContext, grx, rectangle);
    }

    @Override
    public int getImageDataDPI(JasperReportsContext jasperReportsContext) {
        if (this.renderer instanceof RenderToImageAwareRenderable) {
            return ((RenderToImageAwareRenderable)((Object)this.renderer)).getImageDataDPI(jasperReportsContext);
        }
        return super.getImageDataDPI(jasperReportsContext);
    }

    @Override
    public Graphics2D createGraphics(BufferedImage bi) {
        if (this.renderer instanceof RenderToImageAwareRenderable) {
            return ((RenderToImageAwareRenderable)((Object)this.renderer)).createGraphics(bi);
        }
        return super.createGraphics(bi);
    }
}

