/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.search.HitTermInfo;
import net.sf.jasperreports.search.SpansInfo;

public class LuceneSpansInfo
implements SpansInfo,
Serializable {
    private static final long serialVersionUID = 10200L;
    private Map<String, List<HitTermInfo>> hitTermsInfo;
    private Map<String, Integer> hitTermsPerPage;
    private int termsPerQuery;

    public LuceneSpansInfo(int termsPerQuery) {
        this.termsPerQuery = termsPerQuery;
        this.hitTermsInfo = new LinkedHashMap<String, List<HitTermInfo>>();
        this.hitTermsPerPage = new LinkedHashMap<String, Integer>();
    }

    public void addTermInfo(String key, HitTermInfo hitTermInfo) {
        if (!this.hitTermsInfo.containsKey(key)) {
            this.hitTermsInfo.put(key, new ArrayList());
        }
        if (!this.hitTermsPerPage.containsKey(hitTermInfo.getPageNo())) {
            this.hitTermsPerPage.put(hitTermInfo.getPageNo(), 0);
        }
        this.hitTermsInfo.get(key).add(hitTermInfo);
        this.hitTermsPerPage.put(hitTermInfo.getPageNo(), this.hitTermsPerPage.get(hitTermInfo.getPageNo()) + 1);
    }

    @Override
    public boolean hasHitTermsInfo(String key) {
        return this.hitTermsInfo.containsKey(key);
    }

    @Override
    public List<HitTermInfo> getHitTermsInfo(String key) {
        return this.hitTermsInfo.get(key);
    }

    @Override
    public Map<String, Integer> getHitTermsPerPage() {
        return this.hitTermsPerPage;
    }

    @Override
    public int getTermsPerQuery() {
        return this.termsPerQuery;
    }
}

