/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.queue;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.web.lib.queue.ClassQueueException;
import org.openspcoop2.web.lib.queue.OperationNotFound;
import org.openspcoop2.web.lib.queue.QueueOperation;
import org.openspcoop2.web.lib.queue.QueueParameter;
import org.openspcoop2.web.lib.queue.config.QueueProperties;
import org.openspcoop2.web.lib.queue.costanti.OperationStatus;
import org.openspcoop2.web.lib.queue.dao.FilterParameter;
import org.openspcoop2.web.lib.queue.dao.Operation;
import org.openspcoop2.web.lib.queue.dao.Parameter;

public class ClassQueue {
    private Connection connectionDB;
    private Session sessionJMS;
    private String tipoDatabase;
    private Properties jndiContext;
    private String connectionFactoryName;
    private int defaultWaitTime;

    public ClassQueue(Connection con, String tipoDatabase) throws ClassQueueException {
        this(con, tipoDatabase, null, true);
    }

    public ClassQueue(Connection con, String tipoDatabase, Session s) throws ClassQueueException {
        this(con, tipoDatabase, s, false);
    }

    private ClassQueue(Connection con, String tipoDatabase, Session s, boolean autoCommit) throws ClassQueueException {
        this.connectionDB = con;
        this.sessionJMS = s;
        if (con == null) {
            throw new ClassQueueException("Connessione al Database non definita");
        }
        if (s == null && !autoCommit) {
            throw new ClassQueueException("Sessione JMS non definita");
        }
        this.tipoDatabase = tipoDatabase;
        if (this.tipoDatabase == null) {
            throw new ClassQueueException("TipoDatabase non definito");
        }
        try {
            QueueProperties queueProperties = null;
            try {
                queueProperties = QueueProperties.getInstance();
                if (autoCommit) {
                    this.connectionFactoryName = queueProperties.getConnectionFactory();
                }
                this.defaultWaitTime = queueProperties.getWaitTime();
                this.jndiContext = queueProperties.getConnectionFactoryContext();
            }
            catch (Exception e) {
                throw new ClassQueueException("Errore durante la costruzione della ClassQueue (Operation)", e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDefaultWaitTime() {
        return this.defaultWaitTime;
    }

    public void setDefaultWaitTime(int defaultWaitTime) {
        this.defaultWaitTime = defaultWaitTime;
    }

    public long insertQueue(String queueName, QueueOperation po) throws ClassQueueException {
        return this.insertQueue(queueName, po, null);
    }

    public long insertQueue(String queueName, QueueOperation po, String idForFilter) throws ClassQueueException {
        long idOp = 0L;
        try {
            idOp = this.insertOperation(po, queueName, this.tipoDatabase);
        }
        catch (Exception e) {
            throw new ClassQueueException("ERRORE DURANTE L'INSERIMENTO IN DB OPERATIONS", e);
        }
        Queue queue = null;
        InitialContext ctx = null;
        QueueConnection qc = null;
        QueueSession s = null;
        try {
            Session sessionJMSforSend = null;
            if (this.connectionFactoryName != null) {
                ctx = new InitialContext(this.jndiContext);
                QueueConnectionFactory qcf = (QueueConnectionFactory)ctx.lookup(this.connectionFactoryName);
                qc = qcf.createQueueConnection();
                s = qc.createQueueSession(false, 1);
                sessionJMSforSend = s;
            } else {
                sessionJMSforSend = this.sessionJMS;
            }
            if (ctx == null) {
                ctx = new InitialContext(this.jndiContext);
            }
            queue = (Queue)ctx.lookup(queueName);
            MessageProducer sender = sessionJMSforSend.createProducer((Destination)queue);
            ObjectMessage message = sessionJMSforSend.createObjectMessage((Serializable)Long.valueOf(idOp));
            if (idForFilter != null && !idForFilter.equals("")) {
                message.setStringProperty("ID", idForFilter);
            }
            sender.send((Message)message);
        }
        catch (Exception e) {
            throw new ClassQueueException("ERRORE DURANTE L'INSERIMENTO IN CODA [" + queueName + "]", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (qc != null) {
                    qc.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return idOp;
    }

    public long insertOperation(QueueOperation po, String hostname, String tipoDatabase) throws Exception {
        Statement stmt = null;
        try {
            Timestamp timeRequestT;
            if (!TipiDatabase.isAMember((String)this.tipoDatabase)) {
                throw new Exception("Tipo database [" + this.tipoDatabase + "] non supportato");
            }
            TipiDatabase tipo = TipiDatabase.toEnumConstant((String)this.tipoDatabase);
            Timestamp timeExecuteT = timeRequestT = new Timestamp(System.currentTimeMillis());
            CustomKeyGeneratorObject customKeyGeneratorObject = new CustomKeyGeneratorObject("operations", "id", "seq_operations", "operations_init_seq");
            long idoperazione = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)this.connectionDB, (TipiDatabase)tipo, (IKeyGeneratorObject)customKeyGeneratorObject, (InsertAndGeneratedKeyObject[])new InsertAndGeneratedKeyObject[]{new InsertAndGeneratedKeyObject("operation", (Object)po.getOperazione().name(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("tipo", (Object)po.getTipoOperazione().name(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("superuser", (Object)po.getSuperuser(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("hostname", (Object)hostname, InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("status", (Object)OperationStatus.NOT_SET.name(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("timereq", (Object)timeRequestT, InsertAndGeneratedKeyJDBCType.TIMESTAMP), new InsertAndGeneratedKeyObject("timexecute", (Object)timeExecuteT, InsertAndGeneratedKeyJDBCType.TIMESTAMP)});
            if (idoperazione <= 0L) {
                throw new Exception("ID autoincrementale non ottenuto");
            }
            for (int i = 0; i < po.sizeParametri(); ++i) {
                QueueParameter pp = po.getParametro(i);
                String updateString = "INSERT INTO parameters (id_operations, name, value) VALUES (?, ?, ?)";
                stmt = this.connectionDB.prepareStatement(updateString);
                stmt.setLong(1, idoperazione);
                stmt.setString(2, pp.getNome());
                stmt.setString(3, pp.getValore());
                stmt.executeUpdate();
                stmt.close();
            }
            long l = idoperazione;
            return l;
        }
        catch (Exception ex) {
            Date now = new Date();
            throw new Exception(now + " OperationDBException: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int updateOperation(Operation operation) throws ClassQueueException {
        Statement stm = null;
        try {
            int n;
            if (operation == null) {
                throw new Exception("L'oggetto Operation passato come parametro non e' valido.");
            }
            if (operation.getId() <= 0L) {
                throw new Exception("L'id dell'oggetto Operation passato come parametro non e' valido.");
            }
            if (operation.getStatus() == null || "".equals(operation.getStatus().toString())) {
                throw new Exception("Stato Operation non impostato");
            }
            Timestamp timereq = operation.getTimeReq() != null ? new Timestamp(operation.getTimeReq().getTime()) : new Timestamp(System.currentTimeMillis());
            Timestamp timexecute = operation.getTimeExecute() != null ? new Timestamp(operation.getTimeExecute().getTime()) : new Timestamp(System.currentTimeMillis());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("operations");
            sqlQueryObject.addUpdateField("operation", "?");
            sqlQueryObject.addUpdateField("tipo", "?");
            sqlQueryObject.addUpdateField("superuser", "?");
            sqlQueryObject.addUpdateField("hostname", "?");
            sqlQueryObject.addUpdateField("status", "?");
            sqlQueryObject.addUpdateField("details", "?");
            sqlQueryObject.addUpdateField("timereq", "?");
            sqlQueryObject.addUpdateField("timexecute", "?");
            sqlQueryObject.addUpdateField("deleted", "?");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, operation.getOperation());
            stm.setString(2, operation.getTipo());
            stm.setString(3, operation.getSuperUser());
            stm.setString(4, operation.getHostname());
            Object status = operation.getStatus().toString();
            if (OperationStatus.WAIT == operation.getStatus()) {
                status = (String)status + "_" + operation.getWaitTime();
            }
            stm.setString(5, (String)status);
            stm.setString(6, operation.getDetails());
            stm.setTimestamp(7, timereq);
            stm.setTimestamp(8, timexecute);
            stm.setInt(9, operation.isDeleted() ? 1 : 0);
            stm.setLong(10, operation.getId());
            int n2 = n = stm.executeUpdate();
            return n2;
        }
        catch (Exception e) {
            throw new ClassQueueException("Errore durante updateOperation", e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int filterOperation(Operation operationDaFiltrare, Operation filtrante) throws ClassQueueException {
        Statement stm = null;
        try {
            int n;
            if (operationDaFiltrare == null) {
                throw new Exception("L'oggetto Operation passato come parametro non e' valido.");
            }
            if (operationDaFiltrare.getId() <= 0L) {
                throw new Exception("L'id dell'oggetto Operation passato come parametro non e' valido.");
            }
            if (operationDaFiltrare.getStatus() == null || "".equals(operationDaFiltrare.getStatus().toString())) {
                throw new Exception("Stato Operation non impostato");
            }
            if (filtrante == null) {
                throw new Exception("L'oggetto Operation passato come parametro non e' valido.");
            }
            if (filtrante.getId() <= 0L) {
                throw new Exception("L'id dell'oggetto Operation passato come parametro non e' valido.");
            }
            if (filtrante.getStatus() == null || "".equals(filtrante.getStatus().toString())) {
                throw new Exception("Stato Operation non impostato");
            }
            Timestamp timereq = operationDaFiltrare.getTimeReq() != null ? new Timestamp(operationDaFiltrare.getTimeReq().getTime()) : new Timestamp(System.currentTimeMillis());
            Timestamp timexecute = operationDaFiltrare.getTimeExecute() != null ? new Timestamp(operationDaFiltrare.getTimeExecute().getTime()) : new Timestamp(System.currentTimeMillis());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addUpdateTable("operations");
            sqlQueryObject.addUpdateField("operation", "?");
            sqlQueryObject.addUpdateField("tipo", "?");
            sqlQueryObject.addUpdateField("superuser", "?");
            sqlQueryObject.addUpdateField("hostname", "?");
            sqlQueryObject.addUpdateField("status", "?");
            sqlQueryObject.addUpdateField("details", "?");
            sqlQueryObject.addUpdateField("timereq", "?");
            sqlQueryObject.addUpdateField("timexecute", "?");
            sqlQueryObject.addUpdateField("deleted", "?");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, operationDaFiltrare.getOperation());
            stm.setString(2, operationDaFiltrare.getTipo());
            stm.setString(3, operationDaFiltrare.getSuperUser());
            stm.setString(4, operationDaFiltrare.getHostname());
            stm.setString(5, OperationStatus.SUCCESS.toString());
            stm.setString(6, "Operazione [" + operationDaFiltrare.toString() + "] filtrata da operazione [" + filtrante.toString() + "]");
            stm.setTimestamp(7, timereq);
            stm.setTimestamp(8, timexecute);
            stm.setInt(9, operationDaFiltrare.isDeleted() ? 1 : 0);
            stm.setLong(10, operationDaFiltrare.getId());
            int n2 = n = stm.executeUpdate();
            return n2;
        }
        catch (Exception e) {
            throw new ClassQueueException("Errore durante updateOperation", e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Operation getOperation(long idOperation) throws OperationNotFound, ClassQueueException {
        if (idOperation <= 0L) {
            throw new ClassQueueException("L'id dell'oggetto Operation passato come parametro non e' valido.");
        }
        Operation operation = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            OperationStatus status;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("operations");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idOperation);
            rs = stm.executeQuery();
            if (rs.next()) {
                operation = new Operation();
                operation.setId(idOperation);
                operation.setDeleted(rs.getInt("deleted") > 0);
                operation.setDetails(rs.getString("details"));
                operation.setHostname(rs.getString("hostname"));
                operation.setOperation(rs.getString("operation"));
                String val = rs.getString("status") != null && !"".equals(rs.getString("status")) ? rs.getString("status") : OperationStatus.NOT_SET.toString();
                status = null;
                if (val.startsWith("WAIT_")) {
                    status = OperationStatus.WAIT;
                    String timeWait = val.substring("WAIT_".length());
                    try {
                        operation.setWaitTime(Integer.valueOf(timeWait));
                    }
                    catch (Exception e) {
                        operation.setWaitTime(this.defaultWaitTime);
                    }
                } else {
                    status = OperationStatus.valueOf(val);
                }
            } else {
                throw new OperationNotFound("L'Operation con id=" + idOperation + " non esiste");
            }
            operation.setStatus(status);
            operation.setSuperUser(rs.getString("superuser"));
            Timestamp timexecute = rs.getTimestamp("timexecute");
            operation.setTimeExecute(new Date(timexecute.getTime()));
            Timestamp timereq = rs.getTimestamp("timereq");
            operation.setTimeReq(new Date(timereq.getTime()));
            operation.setTipo(rs.getString("tipo"));
            rs.close();
            stm.close();
            if (operation != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addFromTable("parameters");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_operations = ?");
                String queryString = sqlQueryObject.createSQLQuery();
                stm = this.connectionDB.prepareStatement(queryString);
                stm.setLong(1, idOperation);
                rs = stm.executeQuery();
                while (rs.next()) {
                    Parameter p = new Parameter();
                    p.setName(rs.getString("name"));
                    p.setValue(rs.getString("value"));
                    operation.addParameter(p);
                }
                rs.close();
                stm.close();
            }
            Operation operation2 = operation;
            return operation2;
        }
        catch (OperationNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassQueueException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setOperazioniPrecedentiByFilterSearch(Operation operation, FilterParameter[] filter, boolean deleted, String oggetto) throws OperationNotFound, ClassQueueException {
        if (filter == null) {
            throw new ClassQueueException("Il parametro non e' valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        String sqlQueryString = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("operations");
            sqlQueryObject.addFromTable("parameters");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("operations.id");
            sqlQueryObject.addWhereCondition("operations.id = parameters.id_operations");
            sqlQueryObject.addWhereCondition("operations.deleted = ?");
            sqlQueryObject.addWhereCondition("operations.status <> '" + OperationStatus.SUCCESS + "'");
            sqlQueryObject.addWhereCondition("operations.status <> '" + OperationStatus.INVALID + "'");
            sqlQueryObject.addWhereCondition("operations.hostname = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"operations.timereq < ?", "operations.timereq = ? AND operations.id < ?"});
            sqlQueryObject.addWhereCondition("parameters.name = ?");
            sqlQueryObject.addWhereCondition("parameters.value = ?");
            StringBuilder substring = new StringBuilder();
            substring.append(" ( ");
            for (int i = 0; i < filter.length; ++i) {
                if (i > 0) {
                    substring.append(" OR ");
                }
                substring.append(" ( ");
                for (int j = 0; j < filter[i].sizeFilterParameters(); ++j) {
                    if (j > 0) {
                        substring.append(" AND ");
                    }
                    substring.append("(parameters.name=? AND parameters.value=?)");
                }
                substring.append(" ) ");
            }
            substring.append(" ) ");
            sqlQueryObject.addWhereCondition(substring.toString());
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryString = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(sqlQueryString);
            if (deleted) {
                stm.setLong(1, 1L);
                sqlQueryString = sqlQueryString.replaceFirst("\\?", "'1'");
            } else {
                stm.setLong(1, 0L);
                sqlQueryString = sqlQueryString.replaceFirst("\\?", "'0'");
            }
            stm.setString(2, operation.getHostname());
            sqlQueryString = sqlQueryString.replaceFirst("\\?", "'" + operation.getHostname() + "'");
            Timestamp t = new Timestamp(operation.getTimeReq().getTime());
            stm.setTimestamp(3, t);
            sqlQueryString = sqlQueryString.replaceFirst("\\?", "'" + t.toString() + "'");
            stm.setTimestamp(4, t);
            sqlQueryString = sqlQueryString.replaceFirst("\\?", "'" + t.toString() + "'");
            stm.setLong(5, operation.getId());
            sqlQueryString = sqlQueryString.replaceFirst("\\?", "'" + operation.getId() + "'");
            stm.setString(6, "Oggetto");
            sqlQueryString = sqlQueryString.replaceFirst("\\?", "'Oggetto'");
            stm.setString(7, oggetto);
            sqlQueryString = sqlQueryString.replaceFirst("\\?", "'" + oggetto + "'");
            int intp = 8;
            for (int i = 0; i < filter.length; ++i) {
                for (int j = 0; j < filter[i].sizeFilterParameters(); ++j) {
                    stm.setString(intp, filter[i].getParameter(j).getName());
                    sqlQueryString = sqlQueryString.replaceFirst("\\?", "'" + filter[i].getParameter(j).getName() + "'");
                    stm.setString(++intp, filter[i].getParameter(j).getValue());
                    sqlQueryString = sqlQueryString.replaceFirst("\\?", "'" + filter[i].getParameter(j).getValue() + "'");
                    ++intp;
                }
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                Operation precedente = this.getOperation(rs.getLong("id"));
                operation.addOperazionePrecedenteAncoraDaGestire(precedente);
            }
            rs.close();
            stm.close();
        }
        catch (OperationNotFound e) {
            if (sqlQueryString != null) {
                throw new OperationNotFound("SQLQuery[" + sqlQueryString + "]: " + e.getMessage(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (sqlQueryString != null) {
                throw new ClassQueueException("SQLQuery[" + sqlQueryString + "]: " + e.getMessage(), e);
            }
            throw new ClassQueueException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Operation> operationsList(ISearch ricerca, OperationStatus os, List<String> utenti, String logAdm, String hostname, String pezzoAny, String daSql, String aSql) throws ClassQueueException {
        int idLista = 0;
        if (os.toString().equals("SUCCESS")) {
            idLista = Liste.OPERATIONS_ESEGUITE;
        }
        if (os.toString().equals("ERROR")) {
            idLista = Liste.OPERATIONS_FALLITE;
        }
        if (os.toString().equals("INVALID")) {
            idLista = Liste.OPERATIONS_INVALIDE;
        }
        if (os.toString().equals("NOT_SET")) {
            idLista = Liste.OPERATIONS_CODA;
        }
        if (os.toString().equals("WAIT")) {
            idLista = Liste.OPERATIONS_WAITING;
        }
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filtroSel = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroUtente", (String)"*");
        ArrayList<String> newUtenti = new ArrayList<String>();
        if (filtroSel.equals("*")) {
            newUtenti.add(logAdm);
            for (int i = 0; i < utenti.size(); ++i) {
                newUtenti.add(utenti.get(i));
            }
        } else {
            newUtenti.add(filtroSel);
        }
        Object pezzoUtenti = "(";
        for (int i = 0; i < newUtenti.size(); ++i) {
            if (!((String)pezzoUtenti).equals("(")) {
                pezzoUtenti = (String)pezzoUtenti + " OR";
            }
            pezzoUtenti = (String)pezzoUtenti + " superuser='" + (String)newUtenti.get(i) + "'";
        }
        pezzoUtenti = (String)pezzoUtenti + ")";
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("operations");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("status = ?");
            if (!hostname.equals("")) {
                sqlQueryObject.addWhereCondition("hostname = ?");
            }
            sqlQueryObject.addWhereCondition((String)pezzoUtenti);
            if (!pezzoAny.equals("")) {
                sqlQueryObject.addWhereCondition(pezzoAny);
            }
            if (!daSql.equals("")) {
                sqlQueryObject.addWhereCondition("timereq > ?");
            }
            if (!aSql.equals("")) {
                sqlQueryObject.addWhereCondition("timereq < ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("hostname", search, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(queryString);
            stm.setString(1, os.toString());
            if (!hostname.equals("")) {
                stm.setString(2, hostname);
            }
            if (!daSql.equals("")) {
                stm.setString(3, daSql);
            }
            if (!aSql.equals("")) {
                stm.setString(4, aSql);
            }
            if ((rs = stm.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stm.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("operations");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("operation");
            sqlQueryObject.addSelectField("timereq");
            sqlQueryObject.addWhereCondition("status = ?");
            if (!hostname.equals("")) {
                sqlQueryObject.addWhereCondition("hostname = ?");
            }
            sqlQueryObject.addWhereCondition((String)pezzoUtenti);
            if (!pezzoAny.equals("")) {
                sqlQueryObject.addWhereCondition(pezzoAny);
            }
            if (!daSql.equals("")) {
                sqlQueryObject.addWhereCondition("timereq > ?");
            }
            if (!aSql.equals("")) {
                sqlQueryObject.addWhereCondition("timereq < ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("hostname", search, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("timereq");
            sqlQueryObject.setSortType(false);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(queryString);
            stm.setString(1, os.toString());
            if (!hostname.equals("")) {
                stm.setString(2, hostname);
            }
            if (!daSql.equals("")) {
                stm.setString(3, daSql);
            }
            if (!aSql.equals("")) {
                stm.setString(4, aSql);
            }
            rs = stm.executeQuery();
            Operation op = null;
            while (rs.next()) {
                op = this.getOperation(rs.getLong("id"));
                lista.add(op);
            }
            ArrayList<Operation> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new ClassQueueException("[ClassQueue::operationsList] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> hostnameList() throws ClassQueueException {
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<String> lista = new ArrayList<String>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("operations");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("hostname");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(queryString);
            rs = stm.executeQuery();
            while (rs.next()) {
                lista.add(rs.getString("hostname"));
            }
            rs.close();
            stm.close();
            ArrayList<String> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new ClassQueueException("[ClassQueue::hostnameList] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsOperationNotCompleted(String operation, String hostname, FilterParameter filtro) throws OperationNotFound, ClassQueueException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("operations");
            sqlQueryObject.addFromTable("parameters");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("operations.id = parameters.id_operations");
            sqlQueryObject.addWhereCondition("operations.operation = ?");
            sqlQueryObject.addWhereCondition("operations.hostname = ?");
            sqlQueryObject.addWhereCondition("operations.status<>?");
            sqlQueryObject.addWhereCondition("operations.status<>?");
            sqlQueryObject.addWhereCondition("operations.status<>?");
            for (int i = 0; i < filtro.sizeFilterParameters(); ++i) {
                ISQLQueryObject sqlQueryObjectEXISTS = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObjectEXISTS.addFromTable("parameters");
                sqlQueryObjectEXISTS.addWhereCondition("parameters.name=?");
                sqlQueryObjectEXISTS.addWhereCondition("parameters.value=?");
                sqlQueryObjectEXISTS.addWhereCondition("parameters.id_operations=operations.id");
                sqlQueryObjectEXISTS.setANDLogicOperator(true);
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectEXISTS);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, operation);
            stm.setString(index++, hostname);
            stm.setString(index++, OperationStatus.SUCCESS.toString());
            stm.setString(index++, OperationStatus.INVALID.toString());
            stm.setString(index++, OperationStatus.DELETED.toString());
            for (int i = 0; i < filtro.sizeFilterParameters(); ++i) {
                stm.setString(index++, filtro.getParameter(i).getName());
                stm.setString(index++, filtro.getParameter(i).getValue());
            }
            rs = stm.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw new ClassQueueException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

