/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.awt.Paint;
import java.io.Serializable;
import java.util.List;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.GradientPaintTransformer;

public class LayeredBarRendererCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    private List<Double> seriesBarWidths;

    public LayeredBarRendererCustomizer(List<Double> seriesBarWidths) {
        this.seriesBarWidths = seriesBarWidths;
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        BarRenderer categoryRenderer = (BarRenderer)chart.getCategoryPlot().getRenderer();
        LayeredBarRenderer renderer = new LayeredBarRenderer();
        renderer.setBaseItemLabelsVisible(categoryRenderer.getBaseItemLabelsVisible());
        renderer.setBaseItemLabelFont(categoryRenderer.getBaseItemLabelFont());
        renderer.setBaseItemLabelPaint(categoryRenderer.getBaseItemLabelPaint());
        renderer.setBaseItemLabelGenerator(categoryRenderer.getBaseItemLabelGenerator());
        renderer.setShadowVisible(categoryRenderer.getShadowsVisible());
        CategoryDataset categoryDataset = chart.getCategoryPlot().getDataset();
        if (categoryDataset != null) {
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                Paint seriesPaint;
                Paint seriesOutlinePaint = categoryRenderer.getSeriesOutlinePaint(i);
                if (seriesOutlinePaint != null) {
                    renderer.setSeriesOutlinePaint(i, seriesOutlinePaint);
                }
                if ((seriesPaint = categoryRenderer.getSeriesPaint(i)) == null) continue;
                renderer.setSeriesPaint(i, seriesPaint);
            }
        }
        renderer.setItemMargin(categoryRenderer.getItemMargin());
        GradientPaintTransformer gradientPaintTransformer = categoryRenderer.getGradientPaintTransformer();
        if (gradientPaintTransformer != null) {
            renderer.setGradientPaintTransformer(gradientPaintTransformer);
        }
        if (this.seriesBarWidths != null) {
            for (int i = 0; i < this.seriesBarWidths.size(); ++i) {
                renderer.setSeriesBarWidth(i, this.seriesBarWidths.get(i).doubleValue());
            }
        }
        chart.getCategoryPlot().setRenderer((CategoryItemRenderer)renderer);
    }
}

