/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.io.Serializable;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class XyStepRendererCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    private Double stepPoint;

    public XyStepRendererCustomizer(Double stepPoint) {
        this.stepPoint = stepPoint;
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
        XYStepRenderer renderer = new XYStepRenderer();
        renderer.setBaseItemLabelsVisible(lineRenderer.getBaseItemLabelsVisible());
        renderer.setBaseItemLabelFont(lineRenderer.getBaseItemLabelFont());
        renderer.setBaseItemLabelPaint(lineRenderer.getBaseItemLabelPaint());
        renderer.setBaseItemLabelGenerator(lineRenderer.getBaseItemLabelGenerator());
        renderer.setBaseShapesVisible(lineRenderer.getBaseShapesVisible());
        renderer.setBaseLinesVisible(lineRenderer.getBaseLinesVisible());
        if (this.stepPoint != null) {
            renderer.setStepPoint(this.stepPoint.doubleValue());
        }
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
    }
}

