/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.util.ResourceBundle;
import net.sf.dynamicreports.report.base.expression.AbstractValueFormatter;
import net.sf.dynamicreports.report.definition.ReportParameters;

public class BooleanTextValueFormatter
extends AbstractValueFormatter<String, Boolean> {
    private static final long serialVersionUID = 10000L;
    private String keyTrue;
    private String keyFalse;
    private boolean emptyWhenNullValue;

    public BooleanTextValueFormatter(String keyTrue, String keyFalse, boolean emptyWhenNullValue) {
        this.keyTrue = keyTrue;
        this.keyFalse = keyFalse;
        this.emptyWhenNullValue = emptyWhenNullValue;
    }

    @Override
    public String format(Boolean value, ReportParameters reportParameters) {
        if (this.emptyWhenNullValue && value == null) {
            return "";
        }
        String key = value != null && value != false ? this.keyTrue : this.keyFalse;
        return ResourceBundle.getBundle("dynamicreports-messages", reportParameters.getLocale()).getString(key);
    }
}

