/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import net.sf.dynamicreports.report.base.chart.dataset.DRSeriesDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRPiePlot;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public abstract class AbstractPieChartBuilder<T extends AbstractPieChartBuilder<T, U>, U extends DRPiePlot>
extends AbstractBaseChartBuilder<T, U, DRSeriesDataset> {
    private static final long serialVersionUID = 10000L;

    protected AbstractPieChartBuilder(ChartType chartType) {
        super(chartType);
    }

    public T setKey(ValueColumnBuilder<?, String> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)column.getColumn());
        return (T)this;
    }

    public T setKey(String fieldName, Class<String> valueClass) {
        return this.setKey(DynamicReports.field(fieldName, valueClass));
    }

    public T setKey(FieldBuilder<String> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)field.build());
        return (T)this;
    }

    public T setKey(DRIExpression<String> expression) {
        ((DRSeriesDataset)this.getDataset()).setValueExpression(expression);
        return (T)this;
    }

    public T series(CategoryChartSerieBuilder ... chartSeries) {
        return this.addSerie(chartSeries);
    }

    public T addSerie(CategoryChartSerieBuilder ... chartSeries) {
        Validate.notNull((Object)chartSeries, (String)"chartSeries must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])chartSeries, (String)"chartSeries must not contains null chartSerie", (Object[])new Object[0]);
        for (CategoryChartSerieBuilder chartSerie : chartSeries) {
            ((DRSeriesDataset)this.getDataset()).addSerie((DRIChartSerie)chartSerie.build());
        }
        return (T)this;
    }

    public T setItemHyperLink(HyperLinkBuilder itemHyperLink) {
        Validate.notNull((Object)itemHyperLink, (String)"itemHyperLink must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setItemHyperLink((DRIHyperLink)itemHyperLink.build());
        return (T)this;
    }

    public T setCircular(Boolean circular) {
        ((DRPiePlot)this.getPlot()).setCircular(circular);
        return (T)this;
    }

    public T setShowLabels(Boolean showLabels) {
        ((DRPiePlot)this.getPlot()).setShowLabels(showLabels);
        return (T)this;
    }

    public T setShowValues(Boolean showValues) {
        ((DRPiePlot)this.getPlot()).setShowValues(showValues);
        return (T)this;
    }

    public T setValuePattern(String valuePattern) {
        ((DRPiePlot)this.getPlot()).setValuePattern(valuePattern);
        return (T)this;
    }

    public T setShowPercentages(Boolean showPercentages) {
        ((DRPiePlot)this.getPlot()).setShowPercentages(showPercentages);
        return (T)this;
    }

    public T setPercentValuePattern(String percentValuePattern) {
        ((DRPiePlot)this.getPlot()).setPercentValuePattern(percentValuePattern);
        return (T)this;
    }

    public T setLabelFormat(String labelFormat) {
        ((DRPiePlot)this.getPlot()).setLabelFormat(labelFormat);
        return (T)this;
    }

    public T setLegendLabelFormat(String legendLabelFormat) {
        ((DRPiePlot)this.getPlot()).setLegendLabelFormat(legendLabelFormat);
        return (T)this;
    }
}

