/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import net.sf.dynamicreports.report.base.chart.dataset.DRSeriesDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisFormat;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisPlot;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AxisFormatBuilder;
import net.sf.dynamicreports.report.builder.chart.XyChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public abstract class AbstractXyChartBuilder<T extends AbstractXyChartBuilder<T, U>, U extends DRAxisPlot>
extends AbstractBaseChartBuilder<T, U, DRSeriesDataset> {
    private static final long serialVersionUID = 10000L;

    protected AbstractXyChartBuilder(ChartType chartType) {
        super(chartType);
    }

    public T setXValue(ValueColumnBuilder<?, ? extends Number> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)column.getColumn());
        return (T)this;
    }

    public T setXValue(String fieldName, Class<? extends Number> valueClass) {
        return this.setXValue(DynamicReports.field(fieldName, valueClass));
    }

    public T setXValue(FieldBuilder<? extends Number> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)field.build());
        return (T)this;
    }

    public T setXValue(DRIExpression<? extends Number> expression) {
        ((DRSeriesDataset)this.getDataset()).setValueExpression(expression);
        return (T)this;
    }

    public T series(XyChartSerieBuilder ... chartSeries) {
        return this.addSerie(chartSeries);
    }

    public T addSerie(XyChartSerieBuilder ... chartSeries) {
        Validate.notNull((Object)chartSeries, (String)"chartSeries must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])chartSeries, (String)"chartSeries must not contains null chartSerie", (Object[])new Object[0]);
        for (XyChartSerieBuilder chartSerie : chartSeries) {
            ((DRSeriesDataset)this.getDataset()).addSerie((DRIChartSerie)chartSerie.build());
        }
        return (T)this;
    }

    public T setItemHyperLink(HyperLinkBuilder itemHyperLink) {
        Validate.notNull((Object)itemHyperLink, (String)"itemHyperLink must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setItemHyperLink((DRIHyperLink)itemHyperLink.build());
        return (T)this;
    }

    public T setXAxisFormat(AxisFormatBuilder xAxisFormat) {
        Validate.notNull((Object)xAxisFormat, (String)"xAxisFormat must not be null", (Object[])new Object[0]);
        ((DRAxisPlot)this.getPlot()).setXAxisFormat((DRAxisFormat)xAxisFormat.build());
        return (T)this;
    }

    public T setYAxisFormat(AxisFormatBuilder yAxisFormat) {
        Validate.notNull((Object)yAxisFormat, (String)"yAxisFormat must not be null", (Object[])new Object[0]);
        ((DRAxisPlot)this.getPlot()).setYAxisFormat((DRAxisFormat)yAxisFormat.build());
        return (T)this;
    }
}

