/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import net.sf.dynamicreports.report.base.chart.dataset.DRSeriesDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisFormat;
import net.sf.dynamicreports.report.base.chart.plot.DRBarPlot;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AxisFormatBuilder;
import net.sf.dynamicreports.report.builder.chart.GanttChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class GanttChartBuilder
extends AbstractBaseChartBuilder<GanttChartBuilder, DRBarPlot, DRSeriesDataset> {
    private static final long serialVersionUID = 10000L;

    protected GanttChartBuilder() {
        super(ChartType.GANTT);
    }

    public GanttChartBuilder setTask(ValueColumnBuilder<?, String> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)column.getColumn());
        return this;
    }

    public GanttChartBuilder setTask(String fieldName, Class<String> valueClass) {
        return this.setTask(DynamicReports.field(fieldName, valueClass));
    }

    public GanttChartBuilder setTask(FieldBuilder<String> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)field.build());
        return this;
    }

    public GanttChartBuilder setTask(DRIExpression<String> expression) {
        ((DRSeriesDataset)this.getDataset()).setValueExpression(expression);
        return this;
    }

    public GanttChartBuilder series(GanttChartSerieBuilder ... chartSeries) {
        return this.addSerie(chartSeries);
    }

    public GanttChartBuilder addSerie(GanttChartSerieBuilder ... chartSeries) {
        Validate.notNull((Object)chartSeries, (String)"chartSeries must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])chartSeries, (String)"chartSeries must not contains null chartSerie", (Object[])new Object[0]);
        for (GanttChartSerieBuilder chartSerie : chartSeries) {
            ((DRSeriesDataset)this.getDataset()).addSerie((DRIChartSerie)chartSerie.build());
        }
        return this;
    }

    public GanttChartBuilder setItemHyperLink(HyperLinkBuilder itemHyperLink) {
        Validate.notNull((Object)itemHyperLink, (String)"itemHyperLink must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setItemHyperLink((DRIHyperLink)itemHyperLink.build());
        return this;
    }

    public GanttChartBuilder setTimeAxisFormat(AxisFormatBuilder timeAxisFormat) {
        Validate.notNull((Object)timeAxisFormat, (String)"timeAxisFormat must not be null", (Object[])new Object[0]);
        ((DRBarPlot)this.getPlot()).setYAxisFormat((DRAxisFormat)timeAxisFormat.build());
        return this;
    }

    public GanttChartBuilder setTaskAxisFormat(AxisFormatBuilder taskAxisFormat) {
        Validate.notNull((Object)taskAxisFormat, (String)"taskAxisFormat must not be null", (Object[])new Object[0]);
        ((DRBarPlot)this.getPlot()).setXAxisFormat((DRAxisFormat)taskAxisFormat.build());
        return this;
    }

    public GanttChartBuilder setShowLabels(Boolean showLabels) {
        ((DRBarPlot)this.getPlot()).setShowLabels(showLabels);
        return this;
    }

    public GanttChartBuilder setShowTickLabels(Boolean showTickLabels) {
        ((DRBarPlot)this.getPlot()).setShowTickLabels(showTickLabels);
        return this;
    }

    public GanttChartBuilder setShowTickMarks(Boolean showTickMarks) {
        ((DRBarPlot)this.getPlot()).setShowTickMarks(showTickMarks);
        return this;
    }
}

