/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.awt.Color;
import net.sf.dynamicreports.report.base.chart.DRChart;
import net.sf.dynamicreports.report.base.chart.dataset.DRCategoryDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRSpiderPlot;
import net.sf.dynamicreports.report.base.style.DRFont;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractChartBuilder;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.SpiderRotation;
import net.sf.dynamicreports.report.constant.TableOrder;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class SpiderChartBuilder
extends AbstractChartBuilder<SpiderChartBuilder> {
    private static final long serialVersionUID = 10000L;

    protected SpiderChartBuilder() {
        super(ChartType.SPIDER);
    }

    public SpiderChartBuilder setCategory(ValueColumnBuilder<?, String> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        this.getDataset().setValueExpression((DRIExpression)column.getColumn());
        return this;
    }

    public SpiderChartBuilder setCategory(String fieldName, Class<String> valueClass) {
        return this.setCategory(DynamicReports.field(fieldName, valueClass));
    }

    public SpiderChartBuilder setCategory(FieldBuilder<String> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.getDataset().setValueExpression((DRIExpression)field.build());
        return this;
    }

    public SpiderChartBuilder setCategory(DRIExpression<String> expression) {
        this.getDataset().setValueExpression(expression);
        return this;
    }

    public SpiderChartBuilder series(CategoryChartSerieBuilder ... chartSeries) {
        return this.addSerie(chartSeries);
    }

    public SpiderChartBuilder addSerie(CategoryChartSerieBuilder ... chartSeries) {
        Validate.notNull((Object)chartSeries, (String)"chartSeries must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])chartSeries, (String)"chartSeries must not contains null chartSerie", (Object[])new Object[0]);
        for (CategoryChartSerieBuilder chartSerie : chartSeries) {
            this.getDataset().addSerie((DRIChartSerie)chartSerie.build());
        }
        return this;
    }

    public SpiderChartBuilder setItemHyperLink(HyperLinkBuilder itemHyperLink) {
        Validate.notNull((Object)itemHyperLink, (String)"itemHyperLink must not be null", (Object[])new Object[0]);
        this.getDataset().setItemHyperLink((DRIHyperLink)itemHyperLink.build());
        return this;
    }

    public SpiderChartBuilder setMaxValue(Double maxValue) {
        this.getPlot().setMaxValueExpression(Expressions.value(maxValue));
        return this;
    }

    public SpiderChartBuilder setMaxValue(DRIExpression<Double> maxValueExpression) {
        this.getPlot().setMaxValueExpression(maxValueExpression);
        return this;
    }

    public SpiderChartBuilder setRotation(SpiderRotation rotation) {
        this.getPlot().setRotation(rotation);
        return this;
    }

    public SpiderChartBuilder setTableOrder(TableOrder tableOrder) {
        this.getPlot().setTableOrder(tableOrder);
        return this;
    }

    public SpiderChartBuilder setWebFilled(Boolean webFilled) {
        this.getPlot().setWebFilled(webFilled);
        return this;
    }

    public SpiderChartBuilder setStartAngle(Double startAngle) {
        this.getPlot().setStartAngle(startAngle);
        return this;
    }

    public SpiderChartBuilder setHeadPercent(Double headPercent) {
        this.getPlot().setHeadPercent(headPercent);
        return this;
    }

    public SpiderChartBuilder setInteriorGap(Double interiorGap) {
        this.getPlot().setInteriorGap(interiorGap);
        return this;
    }

    public SpiderChartBuilder setAxisLineColor(Color axisLineColor) {
        this.getPlot().setAxisLineColor(axisLineColor);
        return this;
    }

    public SpiderChartBuilder setAxisLineWidth(Float axisLineWidth) {
        this.getPlot().setAxisLineWidth(axisLineWidth);
        return this;
    }

    public SpiderChartBuilder setLabelFont(FontBuilder labelFont) {
        Validate.notNull((Object)labelFont, (String)"labelFont must not be null", (Object[])new Object[0]);
        this.getPlot().setLabelFont((DRFont)labelFont.build());
        return this;
    }

    public SpiderChartBuilder setLabelGap(Double labelGap) {
        this.getPlot().setLabelGap(labelGap);
        return this;
    }

    public SpiderChartBuilder setLabelColor(Color labelColor) {
        this.getPlot().setLabelColor(labelColor);
        return this;
    }

    private DRCategoryDataset getDataset() {
        return (DRCategoryDataset)((DRChart)this.getObject()).getDataset();
    }

    private DRSpiderPlot getPlot() {
        return (DRSpiderPlot)((DRChart)this.getObject()).getPlot();
    }
}

