/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.awt.Color;
import net.sf.dynamicreports.report.base.chart.DRChart;
import net.sf.dynamicreports.report.base.chart.dataset.DRValueDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRThermometerPlot;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractChartBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.ValueLocation;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.style.DRIFont;
import org.apache.commons.lang3.Validate;

public class ThermometerChartBuilder
extends AbstractChartBuilder<ThermometerChartBuilder> {
    private static final long serialVersionUID = 10000L;

    protected ThermometerChartBuilder() {
        super(ChartType.THERMOMETER);
    }

    public ThermometerChartBuilder setTheme(String theme) {
        ((DRChart)this.getObject()).setTheme(theme);
        return this;
    }

    public ThermometerChartBuilder setValue(Number value) {
        this.getDataset().setValueExpression(Expressions.number(value));
        return this;
    }

    public ThermometerChartBuilder setValue(ValueColumnBuilder<?, ? extends Number> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        this.getDataset().setValueExpression((DRIExpression)column.getColumn());
        return this;
    }

    public ThermometerChartBuilder setValue(String fieldName, Class<? extends Number> valueClass) {
        return this.setValue(DynamicReports.field(fieldName, valueClass));
    }

    public ThermometerChartBuilder setValue(FieldBuilder<? extends Number> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.getDataset().setValueExpression((DRIExpression)field.build());
        return this;
    }

    public ThermometerChartBuilder setValue(DRIExpression<? extends Number> expression) {
        this.getDataset().setValueExpression(expression);
        return this;
    }

    public ThermometerChartBuilder setDataRangeLowExpression(Number dataRangeLowValue) {
        this.getPlot().setDataRangeLowExpression(Expressions.number(dataRangeLowValue));
        return this;
    }

    public ThermometerChartBuilder setDataRangeLowExpression(DRIExpression<? extends Number> dataRangeLowExpression) {
        this.getPlot().setDataRangeLowExpression(dataRangeLowExpression);
        return this;
    }

    public ThermometerChartBuilder setDataRangeHighExpression(Number dataRangeHighValue) {
        this.getPlot().setDataRangeHighExpression(Expressions.number(dataRangeHighValue));
        return this;
    }

    public ThermometerChartBuilder setDataRangeHighExpression(DRIExpression<? extends Number> dataRangeHighExpression) {
        this.getPlot().setDataRangeHighExpression(dataRangeHighExpression);
        return this;
    }

    public ThermometerChartBuilder setValueColor(Color valueColor) {
        this.getPlot().setValueColor(valueColor);
        return this;
    }

    public ThermometerChartBuilder setValueMask(String valueMask) {
        this.getPlot().setValueMask(valueMask);
        return this;
    }

    public ThermometerChartBuilder setValueFont(FontBuilder valueFont) {
        Validate.notNull((Object)valueFont, (String)"valueFont must not be null", (Object[])new Object[0]);
        this.getPlot().setValueFont((DRIFont)valueFont.build());
        return this;
    }

    public ThermometerChartBuilder setValueLocation(ValueLocation valueLocation) {
        this.getPlot().setValueLocation(valueLocation);
        return this;
    }

    public ThermometerChartBuilder setMercuryColor(Color mercuryColor) {
        this.getPlot().setMercuryColor(mercuryColor);
        return this;
    }

    public ThermometerChartBuilder setLowDataRangeLowExpression(Number lowDataRangeLowValue) {
        this.getPlot().setLowDataRangeLowExpression(Expressions.number(lowDataRangeLowValue));
        return this;
    }

    public ThermometerChartBuilder setLowDataRangeLowExpression(DRIExpression<? extends Number> lowDataRangeLowExpression) {
        this.getPlot().setLowDataRangeLowExpression(lowDataRangeLowExpression);
        return this;
    }

    public ThermometerChartBuilder setLowDataRangeHighExpression(Number lowDataRangeHighValue) {
        this.getPlot().setLowDataRangeHighExpression(Expressions.number(lowDataRangeHighValue));
        return this;
    }

    public ThermometerChartBuilder setLowDataRangeHighExpression(DRIExpression<? extends Number> lowDataRangeHighExpression) {
        this.getPlot().setLowDataRangeHighExpression(lowDataRangeHighExpression);
        return this;
    }

    public ThermometerChartBuilder setMediumDataRangeLowExpression(Number mediumDataRangeLowValue) {
        this.getPlot().setMediumDataRangeLowExpression(Expressions.number(mediumDataRangeLowValue));
        return this;
    }

    public ThermometerChartBuilder setMediumDataRangeLowExpression(DRIExpression<? extends Number> mediumDataRangeLowExpression) {
        this.getPlot().setMediumDataRangeLowExpression(mediumDataRangeLowExpression);
        return this;
    }

    public ThermometerChartBuilder setMediumDataRangeHighExpression(Number mediumDataRangeHighValue) {
        this.getPlot().setMediumDataRangeHighExpression(Expressions.number(mediumDataRangeHighValue));
        return this;
    }

    public ThermometerChartBuilder setMediumDataRangeHighExpression(DRIExpression<? extends Number> mediumDataRangeHighExpression) {
        this.getPlot().setMediumDataRangeHighExpression(mediumDataRangeHighExpression);
        return this;
    }

    public ThermometerChartBuilder setHighDataRangeLowExpression(Number highDataRangeLowValue) {
        this.getPlot().setHighDataRangeLowExpression(Expressions.number(highDataRangeLowValue));
        return this;
    }

    public ThermometerChartBuilder setHighDataRangeLowExpression(DRIExpression<? extends Number> highDataRangeLowExpression) {
        this.getPlot().setHighDataRangeLowExpression(highDataRangeLowExpression);
        return this;
    }

    public ThermometerChartBuilder setHighDataRangeHighExpression(Number highDataRangeHighValue) {
        this.getPlot().setHighDataRangeHighExpression(Expressions.number(highDataRangeHighValue));
        return this;
    }

    public ThermometerChartBuilder setHighDataRangeHighExpression(DRIExpression<? extends Number> highDataRangeHighExpression) {
        this.getPlot().setHighDataRangeHighExpression(highDataRangeHighExpression);
        return this;
    }

    private DRValueDataset getDataset() {
        return (DRValueDataset)((DRChart)this.getObject()).getDataset();
    }

    private DRThermometerPlot getPlot() {
        return (DRThermometerPlot)((DRChart)this.getObject()).getPlot();
    }
}

