/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.condition;

import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import org.apache.commons.lang3.Validate;

public abstract class AbstractValueExpression<T extends Number>
extends AbstractSimpleExpression<Boolean> {
    private static final long serialVersionUID = 10000L;
    private DRIValue<T> value;
    private Number number;

    public AbstractValueExpression(DRIValue<T> value, Number number) {
        Validate.notNull(value, (String)"value must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)number, (String)"number must not be null", (Object[])new Object[0]);
        this.value = value;
        this.number = number;
    }

    @Override
    public Boolean evaluate(ReportParameters reportParameters) {
        Number actualValue = (Number)reportParameters.getValue(this.value);
        if (actualValue != null) {
            return this.compare(actualValue, this.number);
        }
        return false;
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    protected abstract Boolean compare(Number var1, Number var2);
}

