/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterAutoApplyHandler;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class AttributeConverterManager
implements ConverterAutoApplyHandler {
    private static final Logger log = Logger.getLogger(AttributeConverterManager.class);
    private Map<Class<?>, ConverterDescriptor> attributeConverterDescriptorsByClass;
    private Map<Class<?>, RegisteredConversion> registeredConversionsByDomainType;
    private static final StringHelper.Renderer<ConverterDescriptor> RENDERER = value -> value.getAttributeConverterClass().getName();

    public void addConverter(ConverterDescriptor descriptor) {
        ConverterDescriptor old;
        ResolvedType domainValueResolvedType;
        Class domainType;
        RegisteredConversion registeredConversion;
        if (log.isTraceEnabled()) {
            log.tracef("Starting AttributeConverterManager#addConverter : `%s`", (Object)descriptor.getAttributeConverterClass().getName());
        }
        if (this.registeredConversionsByDomainType != null && (registeredConversion = this.registeredConversionsByDomainType.get(domainType = (domainValueResolvedType = descriptor.getDomainValueResolvedType()).getErasedType())) != null) {
            if (log.isDebugEnabled()) {
                log.debugf("Skipping registration of discovered AttributeConverter `%s` for auto-apply; there wasalready ", (Object)descriptor.getAttributeConverterClass().getName());
            }
            return;
        }
        if (this.attributeConverterDescriptorsByClass == null) {
            this.attributeConverterDescriptorsByClass = new ConcurrentHashMap();
        }
        if ((old = this.attributeConverterDescriptorsByClass.put(descriptor.getAttributeConverterClass(), descriptor)) != null) {
            throw new AssertionFailure(String.format(Locale.ENGLISH, "AttributeConverter class [%s] registered multiple times", descriptor.getAttributeConverterClass()));
        }
    }

    public void addRegistration(RegisteredConversion conversion, BootstrapContext context) {
        ConverterDescriptor removed;
        Class domainType;
        if (this.registeredConversionsByDomainType == null) {
            this.registeredConversionsByDomainType = new ConcurrentHashMap();
        }
        if (conversion.getExplicitDomainType().equals(Void.TYPE)) {
            ClassmateContext classmateContext = context.getClassmateContext();
            ResolvedType converterType = classmateContext.getTypeResolver().resolve(conversion.getConverterType(), new Type[0]);
            List converterParamTypes = converterType.typeParametersFor(AttributeConverter.class);
            if (converterParamTypes == null) {
                throw new AnnotationException("Could not extract type parameter information from AttributeConverter implementation [" + conversion.getConverterType().getName() + "]");
            }
            if (converterParamTypes.size() != 2) {
                throw new AnnotationException("Unexpected type parameter information for AttributeConverter implementation [" + conversion.getConverterType().getName() + "]; expected 2 parameter types, but found " + converterParamTypes.size());
            }
            domainType = ((ResolvedType)converterParamTypes.get(0)).getErasedType();
        } else {
            domainType = conversion.getExplicitDomainType();
        }
        RegisteredConversion existingRegistration = this.registeredConversionsByDomainType.get(domainType);
        if (existingRegistration != null) {
            if (!conversion.equals(existingRegistration)) {
                throw new AnnotationException("Attempt to register non-matching `@ConverterRegistration` descriptors for `AttributeConverter` " + conversion.getConverterType().getName());
            }
            if (log.isDebugEnabled()) {
                log.debugf("Skipping duplicate `@ConverterRegistration` for `%s`", (Object)conversion.getConverterType().getName());
            }
        }
        if (this.attributeConverterDescriptorsByClass != null && (removed = this.attributeConverterDescriptorsByClass.remove(conversion.getConverterType())) != null && log.isDebugEnabled()) {
            log.debugf("Removed potentially auto-applicable converter `%s` due to @ConverterRegistration", (Object)removed.getAttributeConverterClass().getName());
        }
        this.registeredConversionsByDomainType.put(domainType, conversion);
    }

    private Collection<ConverterDescriptor> converterDescriptors() {
        if (this.attributeConverterDescriptorsByClass == null) {
            return Collections.emptyList();
        }
        return this.attributeConverterDescriptorsByClass.values();
    }

    @Override
    public ConverterDescriptor findAutoApplyConverterForAttribute(XProperty property, MetadataBuildingContext context) {
        return this.locateMatchingConverter(property, ConversionSite.ATTRIBUTE, autoApplyDescriptor -> autoApplyDescriptor.getAutoAppliedConverterDescriptorForAttribute(property, context), context);
    }

    private ConverterDescriptor locateMatchingConverter(XProperty xProperty, ConversionSite conversionSite, Function<AutoApplicableConverterDescriptor, ConverterDescriptor> matcher, MetadataBuildingContext context) {
        ResolvedType resolveAttributeType;
        RegisteredConversion registrationForDomainType;
        if (this.registeredConversionsByDomainType != null && (registrationForDomainType = this.registeredConversionsByDomainType.get((resolveAttributeType = ConverterHelper.resolveAttributeType(xProperty, context)).getErasedType())) != null) {
            return registrationForDomainType.isAutoApply() ? registrationForDomainType.getConverterDescriptor() : null;
        }
        ArrayList<ConverterDescriptor> matches = new ArrayList<ConverterDescriptor>();
        for (ConverterDescriptor descriptor : this.converterDescriptors()) {
            ConverterDescriptor match;
            if (log.isDebugEnabled()) {
                log.debugf("Checking auto-apply AttributeConverter [%s] (domain-type=%s) for match against %s : %s.%s (type=%s)", new Object[]{descriptor.getAttributeConverterClass().getName(), descriptor.getDomainValueResolvedType().getSignature(), conversionSite.getSiteDescriptor(), xProperty.getDeclaringClass().getName(), xProperty.getName(), xProperty.getType().getName()});
            }
            if ((match = matcher.apply(descriptor.getAutoApplyDescriptor())) == null) continue;
            matches.add(descriptor);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return (ConverterDescriptor)matches.get(0);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Multiple auto-apply converters matched %s [%s.%s] : %s", conversionSite.getSiteDescriptor(), xProperty.getDeclaringClass().getName(), xProperty.getName(), StringHelper.join(matches, RENDERER)));
    }

    @Override
    public ConverterDescriptor findAutoApplyConverterForCollectionElement(XProperty property, MetadataBuildingContext context) {
        return this.locateMatchingConverter(property, ConversionSite.COLLECTION_ELEMENT, autoApplyDescriptor -> autoApplyDescriptor.getAutoAppliedConverterDescriptorForCollectionElement(property, context), context);
    }

    @Override
    public ConverterDescriptor findAutoApplyConverterForMapKey(XProperty property, MetadataBuildingContext context) {
        return this.locateMatchingConverter(property, ConversionSite.MAP_KEY, autoApplyDescriptor -> autoApplyDescriptor.getAutoAppliedConverterDescriptorForMapKey(property, context), context);
    }

    static enum ConversionSite {
        ATTRIBUTE("basic attribute"),
        COLLECTION_ELEMENT("collection attribute's element"),
        MAP_KEY("map attribute's key");

        private final String siteDescriptor;

        private ConversionSite(String siteDescriptor) {
            this.siteDescriptor = siteDescriptor;
        }

        public String getSiteDescriptor() {
            return this.siteDescriptor;
        }
    }
}

