/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.hibernate.Internal;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.metamodel.mapping.MappingModelCreationLogger;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MetaType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.SpecialOneToOneType;
import org.hibernate.type.Type;
import org.hibernate.usertype.ParameterizedType;

@Internal
public final class MappingHelper {
    private static final Properties EMPTY_PROPERTIES = new Properties();

    private MappingHelper() {
    }

    public static CollectionType customCollection(String typeName, Properties typeParameters, String role, String propertyRef, MetadataImplementor metadata) {
        ManagedBean customTypeBean;
        ClassLoaderService cls = metadata.getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
        Class typeImpl = cls.classForName(typeName);
        ManagedBeanRegistry beanRegistry = metadata.getMetadataBuildingOptions().getServiceRegistry().getService(ManagedBeanRegistry.class);
        if (typeParameters == null) {
            customTypeBean = beanRegistry.getBean(typeImpl);
        } else {
            customTypeBean = beanRegistry.getBean(role, typeImpl);
            MappingHelper.injectParameters(customTypeBean.getBeanInstance(), typeParameters);
        }
        return new CustomCollectionType(customTypeBean, role, propertyRef);
    }

    public static void injectParameters(Object type, Properties parameters) {
        if (type instanceof ParameterizedType) {
            ((ParameterizedType)type).setParameterValues(parameters == null ? EMPTY_PROPERTIES : parameters);
        } else if (parameters != null && !parameters.isEmpty()) {
            MappingModelCreationLogger.LOGGER.debugf("UserCollectionType impl does not implement ParameterizedType but parameters were present : `%s`", type.getClass().getName());
        }
    }

    public static void injectParameters(Object type, Supplier<Properties> parameterAccess) {
        MappingHelper.injectParameters(type, parameterAccess.get());
    }

    public static AnyType anyMapping(Type metaType, Type identifierType, Map<Object, String> metaValueToEntityNameMap, boolean lazy, MetadataBuildingContext buildingContext) {
        if (metaValueToEntityNameMap != null) {
            metaType = new MetaType(metaValueToEntityNameMap, metaType);
        }
        return new AnyType(buildingContext.getBootstrapContext().getTypeConfiguration(), metaType, identifierType, lazy);
    }

    public static ManyToOneType manyToOne(String referencedEntityName, boolean referenceToPrimaryKey, String referencedPropertyName, String propertyName, boolean isLogicalOneToOne, boolean lazy, boolean unwrapProxy, boolean ignoreNotFound, MetadataBuildingContext buildingContext) {
        return new ManyToOneType(buildingContext.getBootstrapContext().getTypeConfiguration(), referencedEntityName, referenceToPrimaryKey, referencedPropertyName, propertyName, lazy, unwrapProxy, ignoreNotFound, isLogicalOneToOne);
    }

    public static SpecialOneToOneType specialOneToOne(String referencedEntityName, ForeignKeyDirection foreignKeyType, boolean referenceToPrimaryKey, String referencedPropertyName, boolean lazy, boolean unwrapProxy, String owningEntityName, String owningEntityPropertyName, boolean constrained, MetadataBuildingContext buildingContext) {
        return new SpecialOneToOneType(buildingContext.getBootstrapContext().getTypeConfiguration(), referencedEntityName, foreignKeyType, referenceToPrimaryKey, referencedPropertyName, lazy, unwrapProxy, owningEntityName, owningEntityPropertyName, constrained);
    }

    public static OneToOneType oneToOne(String referencedEntityName, ForeignKeyDirection foreignKeyType, boolean referenceToPrimaryKey, String referencedPropertyName, boolean lazy, boolean unwrapProxy, String owningEntityName, String owningEntityPropertyName, boolean constrained, MetadataBuildingContext buildingContext) {
        return new OneToOneType(buildingContext.getBootstrapContext().getTypeConfiguration(), referencedEntityName, foreignKeyType, referenceToPrimaryKey, referencedPropertyName, lazy, unwrapProxy, owningEntityName, owningEntityPropertyName, constrained);
    }
}

